/*
 * Decompiled with CFR 0.152.
 */
package com.soli.permissions;

import android.annotation.TargetApi;
import android.os.Build;
import android.text.TextUtils;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.soli.permissions.Permission;
import com.soli.permissions.RxPermissionsFragment;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.annotations.NonNull;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;

public class RxPermissions
implements LifecycleEventObserver {
    private final Object TRIGGER = new Object();
    static final String TAG = "RxPermissions";
    private RxPermissionsFragment mRxPermissionsFragment;
    private FragmentManager manager;

    public RxPermissions(@NonNull AppCompatActivity activity) {
        this.addLifeCycleListener((LifecycleOwner)activity);
        this.mRxPermissionsFragment = this.getRxPermissionsFragment(activity.getSupportFragmentManager());
    }

    public RxPermissions(Fragment fragment) {
        this.addLifeCycleListener((LifecycleOwner)fragment);
        this.mRxPermissionsFragment = this.getRxPermissionsFragment(fragment.getChildFragmentManager());
    }

    private void addLifeCycleListener(LifecycleOwner source) {
        source.getLifecycle().addObserver((LifecycleObserver)this);
    }

    public void onStateChanged(@androidx.annotation.NonNull LifecycleOwner source, @androidx.annotation.NonNull Lifecycle.Event event) {
        if (event == Lifecycle.Event.ON_DESTROY) {
            source.getLifecycle().removeObserver((LifecycleObserver)this);
            this.manager = null;
            this.mRxPermissionsFragment = null;
        }
    }

    private RxPermissionsFragment getRxPermissionsFragment(FragmentManager mManger) {
        boolean isNewInstance;
        this.manager = mManger;
        RxPermissionsFragment rxPermissionsFragment = this.findRxPermissionsFragment(this.manager);
        boolean bl = isNewInstance = rxPermissionsFragment == null;
        if (isNewInstance) {
            rxPermissionsFragment = new RxPermissionsFragment();
            this.manager.beginTransaction().add((Fragment)rxPermissionsFragment, TAG).commitAllowingStateLoss();
            this.manager.executePendingTransactions();
        }
        return rxPermissionsFragment;
    }

    private RxPermissionsFragment findRxPermissionsFragment(FragmentManager manager) {
        return (RxPermissionsFragment)manager.findFragmentByTag(TAG);
    }

    public void setLogging(boolean logging) {
        this.mRxPermissionsFragment.setLogging(logging);
    }

    public <T> ObservableTransformer<T, Boolean> ensure(String ... permissions) {
        return upstream -> this.request(upstream, permissions).buffer(permissions.length).flatMap(permissions1 -> {
            if (permissions1.isEmpty()) {
                return Observable.empty();
            }
            for (Permission p : permissions1) {
                if (p.granted) continue;
                return Observable.just((Object)false);
            }
            return Observable.just((Object)true);
        });
    }

    public <T> ObservableTransformer<T, Permission> ensureEach(String ... permissions) {
        return o -> this.request(o, permissions);
    }

    public Observable<Boolean> request(String ... permissions) {
        return Observable.just((Object)this.TRIGGER).compose(this.ensure(permissions));
    }

    public Observable<Permission> requestEach(String ... permissions) {
        return Observable.just((Object)this.TRIGGER).compose(this.ensureEach(permissions));
    }

    private Observable<Permission> request(Observable<?> trigger, String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException("RxPermissions.request/requestEach requires at least one input permission");
        }
        return this.oneOf(trigger, this.pending(permissions)).flatMap(o -> this.requestImplementation(permissions));
    }

    private Observable<?> pending(String ... permissions) {
        for (String p : permissions) {
            if (this.mRxPermissionsFragment.containsByPermission(p)) continue;
            return Observable.empty();
        }
        return Observable.just((Object)this.TRIGGER);
    }

    private Observable<?> oneOf(Observable<?> trigger, Observable<?> pending) {
        if (trigger == null) {
            return Observable.just((Object)this.TRIGGER);
        }
        return Observable.merge(trigger, pending);
    }

    @TargetApi(value=23)
    private Observable<Permission> requestImplementation(String ... permissions) {
        ArrayList<Object> list = new ArrayList<Object>(permissions.length);
        ArrayList<String> unrequestedPermissions = new ArrayList<String>();
        for (String permission2 : permissions) {
            this.mRxPermissionsFragment.log("Requesting permission " + permission2);
            if (this.isGranted(permission2)) {
                list.add(Observable.just((Object)new Permission(permission2, true, false)));
                continue;
            }
            if (this.isRevoked(permission2)) {
                list.add(Observable.just((Object)new Permission(permission2, false, false)));
                continue;
            }
            PublishSubject subject = this.mRxPermissionsFragment.getSubjectByPermission(permission2);
            if (subject == null) {
                unrequestedPermissions.add(permission2);
                subject = PublishSubject.create();
                this.mRxPermissionsFragment.setSubjectForPermission(permission2, (PublishSubject<Permission>)subject);
            }
            list.add(subject);
        }
        if (!unrequestedPermissions.isEmpty()) {
            String[] unrequestedPermissionsArray = unrequestedPermissions.toArray(new String[unrequestedPermissions.size()]);
            this.requestPermissionsFromFragment(unrequestedPermissionsArray);
        }
        return Observable.concat((ObservableSource)Observable.fromIterable(list));
    }

    @TargetApi(value=23)
    private void requestPermissionsFromFragment(String[] permissions) {
        this.mRxPermissionsFragment.log("requestPermissionsFromFragment " + TextUtils.join((CharSequence)", ", (Object[])permissions));
        this.mRxPermissionsFragment.handleRequest(permissions);
    }

    public boolean isGranted(String permission2) {
        return !this.isMarshmallow() || this.mRxPermissionsFragment.isGranted(permission2);
    }

    public boolean isRevoked(String permission2) {
        return this.isMarshmallow() && this.mRxPermissionsFragment.isRevoked(permission2);
    }

    boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }
}

