/*
 * Decompiled with CFR 0.152.
 */
package com.soli.permissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import com.soli.permissions.Permission;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soli.permissions.R;

public class RxPermissionsFragment
extends Fragment {
    private final int DangerousPermissions_request_code = 32;
    private final int SystemAlerWindow_request_code = 33;
    private final int WriteSetting_request_code = 34;
    private ArrayList<String> specialpermissions;
    private ArrayList<String> permissions;
    private int[] specialGrantResult;
    private int[] grantResults;
    private int index = -1;
    private Map<String, PublishSubject<Permission>> mSubjects = new HashMap<String, PublishSubject<Permission>>();
    private boolean mLogging;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    private void initParams() {
        this.grantResults = null;
        this.specialGrantResult = null;
        this.permissions = null;
        this.specialpermissions = null;
        this.index = -1;
    }

    void handleRequest(@NonNull String[] requestPermissions) {
        this.initParams();
        if (requestPermissions != null) {
            for (int i = 0; i < requestPermissions.length; ++i) {
                String temp = requestPermissions[i];
                if (temp.equals("android.permission.SYSTEM_ALERT_WINDOW") || temp.equals("android.permission.WRITE_SETTINGS")) {
                    if (this.specialpermissions == null) {
                        this.specialpermissions = new ArrayList();
                    }
                    this.specialpermissions.add(temp);
                    continue;
                }
                if (this.permissions == null) {
                    this.permissions = new ArrayList();
                }
                this.permissions.add(temp);
            }
        }
        if (this.specialpermissions != null && this.specialpermissions.size() > 0) {
            this.specialGrantResult = new int[this.specialpermissions.size()];
            this.index = 0;
            this.startRequest(this.index);
        } else {
            this.requestPerm();
        }
    }

    private void requestPerm() {
        if (this.permissions != null && this.permissions.size() > 0) {
            this.requestPermissions(this.permissions.toArray(new String[this.permissions.size()]), 32);
        } else if (this.isHaveSpeicalGrant()) {
            this.onRequestPermissionsResult(32, this.specialpermissions.toArray(new String[this.specialpermissions.size()]), this.specialGrantResult, new boolean[this.specialGrantResult.length]);
        }
    }

    private boolean isHaveSpeicalGrant() {
        return this.index != -1;
    }

    private void startRequest(int position) {
        if (position < this.specialpermissions.size()) {
            if (this.specialpermissions.get(position).equals("android.permission.SYSTEM_ALERT_WINDOW")) {
                this.startSpecialGrant("android.settings.action.MANAGE_OVERLAY_PERMISSION", 33);
            } else if (this.specialpermissions.get(position).equals("android.permission.WRITE_SETTINGS")) {
                this.startSpecialGrant("android.settings.action.MANAGE_WRITE_SETTINGS", 34);
            }
        }
    }

    private void startSpecialGrant(String action, int requestCode) {
        Intent intent = new Intent(action, Uri.parse((String)("package:" + this.getActivity().getPackageName())));
        this.startActivityForResult(intent, requestCode);
    }

    private String getPermissionGroupKey(String permissions) {
        String key = "";
        switch (permissions) {
            case "android.permission.READ_CALENDAR": 
            case "android.permission.WRITE_CALENDAR": {
                key = "android.permission-group.CALENDAR";
                break;
            }
            case "android.permission.CAMERA": {
                key = "android.permission-group.CAMERA";
                break;
            }
            case "android.permission.READ_CONTACTS": 
            case "android.permission.WRITE_CONTACTS": 
            case "android.permission.GET_ACCOUNTS": {
                key = "android.permission-group.CONTACTS";
                break;
            }
            case "android.permission.ACCESS_FINE_LOCATION": 
            case "android.permission.ACCESS_COARSE_LOCATION": {
                key = "android.permission-group.LOCATION";
                break;
            }
            case "android.permission.RECORD_AUDIO": {
                key = "android.permission-group.MICROPHONE";
                break;
            }
            case "android.permission.READ_PHONE_STATE": 
            case "android.permission.CALL_PHONE": 
            case "android.permission.READ_CALL_LOG": 
            case "android.permission.WRITE_CALL_LOG": 
            case "android.permission.USE_SIP": 
            case "android.permission.PROCESS_OUTGOING_CALLS": {
                key = "android.permission-group.PHONE";
                break;
            }
            case "android.permission.BODY_SENSORS": {
                key = "android.permission-group.SENSORS";
                break;
            }
            case "android.permission.SEND_SMS": 
            case "android.permission.RECEIVE_SMS": 
            case "android.permission.READ_SMS": 
            case "android.permission.RECEIVE_WAP_PUSH": 
            case "android.permission.RECEIVE_MMS": {
                key = "android.permission-group.SMS";
                break;
            }
            case "android.permission.READ_EXTERNAL_STORAGE": 
            case "android.permission.WRITE_EXTERNAL_STORAGE": {
                key = "android.permission-group.STORAGE";
            }
        }
        return key.replace("-", "_");
    }

    private String getNotGrantedPermissionMsg(Context ctx, List<String> permissions) {
        StringBuffer buffer = new StringBuffer(ctx.getResources().getString(R.string.str_permission_grant_needed));
        if (permissions != null && permissions.size() > 0) {
            if (permissions.size() == 1) {
                int resouceid = ctx.getResources().getIdentifier("str_permission_" + this.getPermissionGroupKey(permissions.get(0)), "string", ctx.getPackageName());
                if (resouceid > 0) {
                    buffer.append(ctx.getResources().getString(resouceid));
                }
            } else {
                for (int i = 0; i < permissions.size(); ++i) {
                    int resouceid = ctx.getResources().getIdentifier("str_permission_multe_" + this.getPermissionGroupKey(permissions.get(i)), "string", ctx.getPackageName());
                    if (resouceid <= 0) continue;
                    buffer.append(ctx.getResources().getString(resouceid));
                    buffer.append("\u3001");
                }
                buffer.deleteCharAt(buffer.length() - 1);
                buffer.append("\u6743\u9650\u3002");
            }
        }
        return buffer.toString();
    }

    private void dealNotShowAgain() {
        if (this.permissions != null) {
            this.onRequestPermissionsResultFailure(32, (Activity)this.getActivity(), this.permissions.toArray(new String[this.permissions.size()]));
        }
    }

    private void dealResult() {
        int length = this.isHaveSpeicalGrant() ? this.permissions.size() + this.specialpermissions.size() : this.permissions.size();
        boolean[] shouldShowRequestPermissionRationale = new boolean[length];
        String[] requestPermissions = new String[length];
        int[] requestGrantResults = new int[length];
        try {
            for (int i = 0; i < shouldShowRequestPermissionRationale.length; ++i) {
                if (i >= this.permissions.size()) {
                    shouldShowRequestPermissionRationale[i] = false;
                    requestPermissions[i] = this.specialpermissions.get(i - this.permissions.size());
                    requestGrantResults[i] = this.specialGrantResult[i - this.permissions.size()];
                    continue;
                }
                shouldShowRequestPermissionRationale[i] = ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)this.permissions.get(i));
                requestPermissions[i] = this.permissions.get(i);
                requestGrantResults[i] = this.grantResults[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.onRequestPermissionsResult(32, requestPermissions, requestGrantResults, shouldShowRequestPermissionRationale);
    }

    private void showPermissionAlert(String content) {
        new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.str_permission_attetion).setMessage((CharSequence)content).setPositiveButton(R.string.str_permission_conform, (dialogInterface, i) -> {
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.addFlags(0x10000000);
            Uri uri = Uri.fromParts((String)"package", (String)this.getActivity().getPackageName(), null);
            intent.setData(uri);
            this.startActivity(intent);
            this.dealNotShowAgain();
        }).setNegativeButton(R.string.str_permission_cancle, (dialogInterface, i) -> this.dealResult()).setCancelable(false).create().show();
    }

    @TargetApi(value=23)
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 33) {
            this.specialGrantResult[this.index] = Settings.canDrawOverlays((Context)this.getActivity()) ? 0 : -1;
        } else if (requestCode == 34) {
            this.specialGrantResult[this.index] = Settings.System.canWrite((Context)this.getActivity()) ? 0 : -1;
        }
        ++this.index;
        if (this.index == this.specialpermissions.size()) {
            this.requestPerm();
        } else {
            this.startRequest(this.index);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] mGrantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, this.grantResults);
        this.grantResults = mGrantResults;
        if (requestCode == 32 && this.isAllCanShowRequestPermissionRationale(permissions)) {
            this.dealResult();
        }
    }

    private boolean isAllCanShowRequestPermissionRationale(String[] permissions) {
        ArrayList<String> notShowRequestPermission = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            if (this.isGranted(permissions[i]) || ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)permissions[i])) continue;
            notShowRequestPermission.add(permissions[i]);
        }
        if (notShowRequestPermission.size() > 0) {
            this.showPermissionAlert(this.getNotGrantedPermissionMsg((Context)this.getActivity(), notShowRequestPermission));
            return false;
        }
        return true;
    }

    void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults, boolean[] shouldShowRequestPermissionRationale) {
        try {
            int size = permissions.length;
            for (int i = 0; i < size; ++i) {
                this.log("onRequestPermissionsResult  " + permissions[i]);
                PublishSubject<Permission> subject = this.mSubjects.get(permissions[i]);
                if (subject == null) continue;
                this.mSubjects.remove(permissions[i]);
                boolean granted = grantResults[i] == 0;
                subject.onNext((Object)new Permission(permissions[i], granted, shouldShowRequestPermissionRationale[i]));
                subject.onComplete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void onRequestPermissionsResultFailure(int requestCode, Activity activity, String[] permissions) {
        int[] grantResults = new int[permissions.length];
        boolean[] shouldShowRequestPermissionRationale = new boolean[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            grantResults[i] = -1;
            shouldShowRequestPermissionRationale[i] = ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permissions[i]);
        }
        this.onRequestPermissionsResult(requestCode, permissions, grantResults, shouldShowRequestPermissionRationale);
    }

    @TargetApi(value=23)
    boolean isGranted(String permission2) {
        if ("android.permission.SYSTEM_ALERT_WINDOW".equals(permission2)) {
            return Settings.canDrawOverlays((Context)this.getActivity());
        }
        if ("android.permission.WRITE_SETTINGS".equals(permission2)) {
            return Settings.System.canWrite((Context)this.getActivity());
        }
        return this.getActivity().checkSelfPermission(permission2) == 0;
    }

    @TargetApi(value=23)
    boolean isRevoked(String permission2) {
        return this.getActivity().getPackageManager().isPermissionRevokedByPolicy(permission2, this.getActivity().getPackageName());
    }

    public void setLogging(boolean logging) {
        this.mLogging = logging;
    }

    public PublishSubject<Permission> getSubjectByPermission(@NonNull String permission2) {
        return this.mSubjects.get(permission2);
    }

    public boolean containsByPermission(@NonNull String permission2) {
        return this.mSubjects.containsKey(permission2);
    }

    public PublishSubject<Permission> setSubjectForPermission(@NonNull String permission2, @NonNull PublishSubject<Permission> subject) {
        return this.mSubjects.put(permission2, subject);
    }

    void log(String message) {
        if (this.mLogging) {
            Log.d((String)"RxPermissions", (String)message);
        }
    }
}

