/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.encoding;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.RawSMFMessage;
import com.solacesystems.jcsmp.SDTFormatException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.impl.sdt.Formatter;

public class StreamFormatter
implements Formatter {
    public static final Formatter OnlyInstance = new StreamFormatter();

    public Boolean getBoolean(Object value) throws SDTFormatException {
        if (value == null) {
            throw new NullPointerException("Cannot convert NULL value to boolean.");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf(value.toString());
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Boolean");
    }

    public Byte getByte(Object value) throws SDTFormatException {
        if (value == null) {
            throw new NullPointerException("Cannot convert NULL value to byte.");
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.valueOf(value.toString());
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Byte");
    }

    public byte[] getBytes(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof ByteArray) {
            return ((ByteArray)value).asBytes();
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to byte[]");
    }

    public ByteArray getByteArray(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof ByteArray) {
            return (ByteArray)value;
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to ByteArray");
    }

    public Character getCharacter(Object value) throws SDTFormatException {
        if (value == null) {
            throw new NullPointerException("Cannot convert NULL value to char.");
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Character");
    }

    public Destination getDestination(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Destination) {
            return (Destination)value;
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Destination");
    }

    public Double getDouble(Object value) throws SDTFormatException {
        if (value == null) {
            throw new NullPointerException("Cannot convert NULL value to double.");
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return new Double(((Float)value).floatValue());
        }
        if (value instanceof String) {
            return Double.valueOf(value.toString());
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Double");
    }

    public Float getFloat(Object value) throws SDTFormatException {
        if (value == null) {
            throw new NullPointerException("Cannot convert NULL value to float.");
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            return Float.valueOf(value.toString());
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Float");
    }

    public Integer getInteger(Object value) throws SDTFormatException {
        if (value == null) {
            throw new NullPointerException("Cannot convert NULL value to int.");
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Byte) {
            return new Integer(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new Integer(((Short)value).shortValue());
        }
        if (value instanceof String) {
            return Integer.valueOf(value.toString());
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Integer");
    }

    public Long getLong(Object value) throws SDTFormatException {
        if (value == null) {
            throw new NullPointerException("Cannot convert NULL value to long.");
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Byte) {
            return new Long(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new Long(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return new Long(((Integer)value).intValue());
        }
        if (value instanceof String) {
            return Long.valueOf(value.toString());
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Long");
    }

    public SDTMap getMap(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof SDTMap) {
            return (SDTMap)value;
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to SDTMap");
    }

    public RawSMFMessage getMessage(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof RawSMFMessage) {
            return (RawSMFMessage)value;
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to RawSMFMessage");
    }

    public Short getShort(Object value) throws SDTFormatException {
        if (value == null) {
            throw new NullPointerException("Cannot convert NULL value to short.");
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return new Short(((Byte)value).byteValue());
        }
        if (value instanceof String) {
            return Short.valueOf(value.toString());
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Short");
    }

    public SDTStream getStream(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof SDTStream) {
            return (SDTStream)value;
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to SDTStream");
    }

    public String getString(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean) {
            return String.valueOf((Boolean)value);
        }
        if (value instanceof Byte) {
            return String.valueOf((Byte)value);
        }
        if (value instanceof Short) {
            return String.valueOf((Short)value);
        }
        if (value instanceof Character) {
            return String.valueOf((Character)value);
        }
        if (value instanceof Integer) {
            return String.valueOf((Integer)value);
        }
        if (value instanceof Long) {
            return String.valueOf((Long)value);
        }
        if (value instanceof Float) {
            return String.valueOf((Float)value);
        }
        if (value instanceof Double) {
            return String.valueOf((Double)value);
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to String");
    }
}

