/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.WireMessageHandler;
import com.solacesystems.jcsmp.protocol.nio.IOReactor;
import com.solacesystems.jcsmp.protocol.smf.SimpleSmfClient;
import com.solacesystems.jcsmp.protocol.smf.SmfClientIOException;
import com.solacesystems.jcsmp.protocol.smf.ZSmfClient;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeParameters;
import com.solacesystems.jcsmp.secure.SecureProperties;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLSmfClient
extends ZSmfClient {
    private static final Log Trace = LogFactory.getLog(SSLSmfClient.class);
    private static final int BUFFER_INITIAL_SIZE = 4096;
    private boolean compressEnabled = false;
    private boolean mSslEngineClosed;
    private SecureProperties mProps;
    private SSLContext mSSLContext;
    private SSLEngine mSSLEngine;
    private boolean mSessionLogged;
    private JCSMPException mContextException;
    private Object mSSLEngineLock;
    private ByteBuffer[] mSMFWriteSideBuffers;
    public ByteBuffer mSMFReadSideBuffer;
    private ByteBuffer mSocketWriteSideBuffer;
    public ByteBuffer mSocketReadSideBuffer;
    private byte[] mInputBytes;

    protected SSLSmfClient(AuthenticationSchemeParameters authParams, JCSMPSessionStats sessionStats, IOReactor reactor, boolean usePubDirectIntermediateBuf, SecureProperties props, int zipLevel) {
        super(authParams, sessionStats, reactor, usePubDirectIntermediateBuf, zipLevel);
        this.mProps = props;
        this.mSessionLogged = false;
        this.mContextException = null;
        this.mSSLEngineLock = new Object();
        this.createSSLContext();
        this.mSslEngineClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws UnknownHostException, IOException, JCSMPException {
        if (this.mContextException != null) {
            throw this.mContextException;
        }
        Object object = this.mSSLEngineLock;
        synchronized (object) {
            this.createSSLEngine();
            super.open();
        }
    }

    public void setSslEngineClosed(boolean closed) {
        this.mSslEngineClosed = closed;
    }

    public void reset() {
        this.setSslEngineClosed(false);
        this.setCompressionMode(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SimpleSmfClient.SS acquireWritingState() throws SmfClientIOException, InterruptedException {
        SimpleSmfClient.SS return_to_state = null;
        Object object = this._stateLock;
        synchronized (object) {
            return_to_state = this._sharedSocketState;
            if (this._sharedSocketState == SimpleSmfClient.SS.READY_TO_WRITE) {
                this._sharedSocketState = SimpleSmfClient.SS.WRITING;
            } else {
                if (this._sharedSocketState != SimpleSmfClient.SS.WRITING) throw new SmfClientIOException("Closing connection", this._connCounter);
                this._stateLock.wait(1000L);
                if (this._sharedSocketState == SimpleSmfClient.SS.READY_TO_WRITE) {
                    this._sharedSocketState = SimpleSmfClient.SS.WRITING;
                } else {
                    if (this._sharedSocketState != SimpleSmfClient.SS.WRITING) throw new SmfClientIOException("Closing connection", this._connCounter);
                    throw new SmfClientIOException("Timed out closing connection gracefully", this._connCounter);
                }
            }
            this._clientException = null;
            return return_to_state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWritingState(SimpleSmfClient.SS return_to_state) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._sharedSocketState == SimpleSmfClient.SS.WRITING) {
                this._sharedSocketState = return_to_state;
                this._stateLock.notifyAll();
            }
        }
    }

    @Override
    public void close(boolean isReconn) throws IOException {
        if (this.mSSLEngine != null && this.mSocketWriteSideBuffer != null) {
            SimpleSmfClient.SS return_to_state = null;
            try {
                return_to_state = this.acquireWritingState();
                this._writeCompleteSem.drainPermits();
                this.closeOutbound();
                this.releaseWritingState(return_to_state);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.close(isReconn);
    }

    public void closeOutbound() {
        block6: {
            try {
                if (!this.mSSLEngine.isOutboundDone()) {
                    Trace.info((Object)("closeOutbound() : isSslDowngradeEnabled: " + this.mProps.isSslDowngradeEnabled() + ", mSslEngineClosed: " + this.mSslEngineClosed));
                    this.mSSLEngine.closeOutbound();
                    this.mSocketWriteSideBuffer.clear();
                    ProcessResult result = this.process(false);
                    if (result != null && result.wrapOperation && result.wrap_unwrapResult.getStatus() == SSLEngineResult.Status.CLOSED && result.wrap_unwrapResult.bytesProduced() > 0) {
                        this.mSocketWriteSideBuffer.flip();
                        int zeroWriteCount = 0;
                        while (this.mSocketWriteSideBuffer.hasRemaining()) {
                            long written = this.socket.getChannel().write(this.mSocketWriteSideBuffer);
                            if (written == 0L) {
                                if (++zeroWriteCount != 3) continue;
                                this.yield();
                                zeroWriteCount = 0;
                                continue;
                            }
                            zeroWriteCount = 0;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.isDebugEnabled()) break block6;
                Trace.debug((Object)"Exception closing outbound", (Throwable)e);
            }
        }
    }

    private void closeInbound() {
        int maxTries = 4;
        try {
            for (int trie = 0; !this.mSSLEngine.isInboundDone() && trie < 4; ++trie) {
                ProcessResult result = this.process(true);
                if (!result.wrap_unwrapResult.getStatus().equals((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW)) continue;
                Thread.sleep(50L);
            }
            this.mSSLEngine.closeInbound();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.debug((Object)("got exception: " + e.getMessage()));
        }
    }

    @Override
    public void doPostNoResponse(WireMessage request, boolean setAuth) throws JCSMPException, IOException {
        if (this.mSslEngineClosed) {
            super.doPostNoResponse(request, setAuth);
            return;
        }
        if (!this.connected()) {
            this.open();
        }
        if (setAuth) {
            this.setAuth(request);
        }
        ByteArrayOutputStream baos = null;
        if (this.isCompressionOn()) {
            baos = this.getCompressedOutput(request);
        } else {
            baos = new ByteArrayOutputStream();
            this.wirehandler.writeMessage(baos, request);
        }
        byte[] smfdata = baos.toByteArray();
        int bufSize = smfdata.length + 4096;
        this.mSMFWriteSideBuffers = new ByteBuffer[1];
        this.mSMFWriteSideBuffers[0] = ByteBuffer.allocate(bufSize);
        while (true) {
            try {
                this.mSMFWriteSideBuffers[0].put(smfdata);
            }
            catch (BufferOverflowException e) {
                this.mSMFWriteSideBuffers[0] = ByteBuffer.allocate(bufSize *= 2);
                continue;
            }
            break;
        }
        this.mSMFWriteSideBuffers[0].flip();
        this.mSMFReadSideBuffer = ByteBuffer.allocate(4096);
        this.mSocketWriteSideBuffer = ByteBuffer.allocate(4096);
        this.mSocketReadSideBuffer = ByteBuffer.allocate(4096);
        this.mSocketReadSideBuffer.flip();
        this.mInputBytes = new byte[this.mSocketReadSideBuffer.capacity()];
        boolean closed = false;
        do {
            ProcessResult result;
            if (!this.mSocketWriteSideBuffer.hasRemaining()) {
                this.mSocketWriteSideBuffer.clear();
            }
            if ((result = this.process(false)) == null) continue;
            if (result.wrapOperation && result.wrap_unwrapResult.getStatus() == SSLEngineResult.Status.OK) {
                this.mSocketWriteSideBuffer.flip();
                this.socket.getChannel().write(this.mSocketWriteSideBuffer);
            } else if (!result.wrapOperation && result.wrap_unwrapResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                if (!this.mSocketReadSideBuffer.hasRemaining()) {
                    this.mSocketReadSideBuffer.clear();
                }
                this.readBytes();
            }
            closed = result.wrap_unwrapResult.getStatus().equals((Object)SSLEngineResult.Status.CLOSED);
        } while (this.mSMFWriteSideBuffers[0].remaining() > 0 && !closed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer[] getOutputBufferForSend(ByteBuffer[] requestBB, WireMessage request, WireMessageHandler wirehandler) throws IOException {
        if (this.mSslEngineClosed || this.isCompressionOn()) {
            return super.getOutputBufferForSend(requestBB, request, wirehandler);
        }
        ByteBuffer[] outBufLocal = null;
        Object object = this._stateLock;
        synchronized (object) {
            byte[] outMessageData = null;
            if (request != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                wirehandler.writeMessage(baos, request);
                outMessageData = baos.toByteArray();
            } else if (requestBB != null) {
                outMessageData = new byte[SSLSmfClient.remainingBytes(requestBB)];
                int i = 0;
                for (ByteBuffer b : requestBB) {
                    int len = b.remaining();
                    b.get(outMessageData, i, len);
                    i += len;
                }
            } else {
                throw new IllegalArgumentException("No request.");
            }
            outBufLocal = new ByteBuffer[]{ByteBuffer.wrap(outMessageData, 0, outMessageData.length)};
        }
        return outBufLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int writeLoop(boolean allowReg, boolean dropOnWouldBlock) {
        if (this.mSslEngineClosed) {
            return super.writeLoop(allowReg, dropOnWouldBlock);
        }
        long out_data_remaining = 0L;
        long out_data_written = 0L;
        Object object = this._stateLock;
        synchronized (object) {
            block17: {
                if (this.outMessageBuf == null) {
                    return 0;
                }
                this.outMessageBuf.flip();
                this.mSMFWriteSideBuffers = new ByteBuffer[1];
                this.mSMFWriteSideBuffers[0] = this.outMessageBuf;
                out_data_remaining = SSLSmfClient.remainingBytes(this.mSMFWriteSideBuffers);
                if (out_data_remaining > 0L || this.mSocketWriteSideBuffer.remaining() > 0) {
                    try {
                        boolean closed = false;
                        do {
                            if (this.mSocketWriteSideBuffer.hasRemaining()) {
                                out_data_written += (long)this.socket.getChannel().write(this.mSocketWriteSideBuffer);
                                continue;
                            }
                            this.mSocketWriteSideBuffer.clear();
                            ProcessResult result = null;
                            result = this.process(false);
                            if (result == null) continue;
                            if (result.wrapOperation && result.wrap_unwrapResult.getStatus() == SSLEngineResult.Status.OK) {
                                this.mSocketWriteSideBuffer.flip();
                                out_data_written += (long)this.socket.getChannel().write(this.mSocketWriteSideBuffer);
                            }
                            closed = result.wrap_unwrapResult.getStatus().equals((Object)SSLEngineResult.Status.CLOSED);
                        } while (SSLSmfClient.remainingBytes(this.mSMFWriteSideBuffers) > 0 && !this.mSocketWriteSideBuffer.hasRemaining() && !closed);
                        this.m_bytesWrittenCtr.addAndGet(out_data_written);
                    }
                    catch (IOException ex) {
                        this._clientException = ex;
                    }
                    catch (NotYetConnectedException ex) {
                        if ($assertionsDisabled) break block17;
                        throw new AssertionError();
                    }
                }
            }
            boolean wrote_everything = this.outMessageBuf.remaining() == 0 && !this.mSocketWriteSideBuffer.hasRemaining();
            this.outMessageBuf.compact();
            if (this._clientException != null || wrote_everything) {
                if (!allowReg) {
                    this._reactor.deregisterHandler(this, 4);
                }
                this._writeCompleteSem.release();
            } else if (allowReg && !wrote_everything) {
                this._reactor.registerHandler(this, 4);
                if (dropOnWouldBlock) {
                    Trace.debug((Object)String.format("(smfclient %s) Buffering low-priority write request (would block), Thread=%s", this._smfClientId, Thread.currentThread().getName()));
                    this._writeCompleteSem.release();
                }
            }
        }
        return 0;
    }

    public void readCloseNotify() throws JCSMPTransportException {
        WireMessage response = new WireMessage();
        try {
            this.readMessage(this.socket.getInputStream(), response);
        }
        catch (IOException e) {
            throw new JCSMPTransportException("Transport error.", e);
        }
    }

    public boolean isSslEngineClosed() {
        return this.mSslEngineClosed;
    }

    public boolean isCompressionOn() {
        return this.isCompressionMode() && this.getCompressionMode();
    }

    public void setCompressionMode(boolean done) {
        this.compressEnabled = done;
    }

    public boolean getCompressionMode() {
        return this.compressEnabled;
    }

    @Override
    public void readMessage(InputStream istr, WireMessage msg) throws IOException {
        if (this.mSslEngineClosed) {
            super.readMessage(istr, msg);
            return;
        }
        this.mSocketReadSideBuffer.clear();
        boolean readMoreData = true;
        boolean closed = false;
        boolean stopReadData = false;
        while (!stopReadData && !closed) {
            do {
                if (readMoreData) {
                    this.readBytes();
                }
                ProcessResult result = this.process(true);
                readMoreData = result.wrap_unwrapResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW;
                closed = result.wrap_unwrapResult.getStatus().equals((Object)SSLEngineResult.Status.CLOSED);
            } while (this.mSocketReadSideBuffer.hasRemaining() && !closed);
            this.mSMFReadSideBuffer.flip();
            this.mSMFReadSideBuffer.mark();
            ByteArrayInputStream is = new ByteArrayInputStream(this.mSMFReadSideBuffer.array());
            this.wirehandler.readMessage(is, msg);
            if (msg.getMsgLen() <= this.mSMFReadSideBuffer.remaining()) {
                stopReadData = true;
                continue;
            }
            this.mSMFReadSideBuffer.reset();
            this.mSMFReadSideBuffer.compact();
        }
        if (closed) {
            if (!stopReadData && this.mProps.isSslDowngradeEnabled()) {
                Trace.info((Object)("readMessage() : SSL closed by the router for SSL downgrade, mSslEngineClosed: " + this.mSslEngineClosed));
                this.setSslEngineClosed(closed);
            } else {
                Trace.error((Object)"readMessage() : SSL closed during incomplete SMF message");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void yield() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public ProcessResult process(boolean read) throws IOException {
        ProcessResult result = null;
        SSLEngineResult.HandshakeStatus status = this.mSSLEngine.getHandshakeStatus();
        if (status == SSLEngineResult.HandshakeStatus.FINISHED || status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (Trace.isDebugEnabled()) {
                this.logSession();
            }
            status = read ? SSLEngineResult.HandshakeStatus.NEED_UNWRAP : SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        switch (status) {
            case NEED_WRAP: {
                result = new ProcessResult();
                result.wrapOperation = true;
                result.wrap_unwrapResult = this.wrap();
                break;
            }
            case NEED_TASK: {
                Runnable runnable;
                while ((runnable = this.mSSLEngine.getDelegatedTask()) != null) {
                    runnable.run();
                }
                break;
            }
            case NEED_UNWRAP: {
                result = new ProcessResult();
                result.wrapOperation = false;
                result.wrap_unwrapResult = this.unwrap();
                break;
            }
        }
        return result;
    }

    private int readBytes() throws IOException {
        int numRead;
        if (this.mSocketReadSideBuffer.limit() < this.mSocketReadSideBuffer.capacity()) {
            ByteBuffer newBuf = ByteBuffer.allocate(this.mSocketReadSideBuffer.capacity());
            newBuf.put(this.mSocketReadSideBuffer);
            this.mSocketReadSideBuffer = newBuf;
        }
        if ((numRead = this.socket.getInputStream().read(this.mInputBytes)) > 0) {
            this.mSocketReadSideBuffer.put(this.mInputBytes, 0, numRead);
        } else if (this.socket.getChannel().isBlocking()) {
            throw new SmfClientIOException("Connection closed by peer", this._smfClientId);
        }
        this.mSocketReadSideBuffer.flip();
        return numRead;
    }

    private SSLEngineResult wrap() throws IOException {
        SSLEngineResult result = this.mSSLEngine.wrap(this.mSMFWriteSideBuffers, this.mSocketWriteSideBuffer);
        switch (result.getStatus()) {
            case BUFFER_OVERFLOW: {
                ByteBuffer netBuf;
                int netSize = this.mSSLEngine.getSession().getPacketBufferSize();
                this.mSocketWriteSideBuffer = netBuf = ByteBuffer.allocate(netSize);
                break;
            }
            case BUFFER_UNDERFLOW: {
                break;
            }
            case CLOSED: 
            case OK: {
                this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_SENT, result.bytesConsumed());
                this.sessionStats.incStat(StatType.TOTAL_SOCKET_SSL_BYTES_SENT, result.bytesProduced());
            }
        }
        return result;
    }

    private SSLEngineResult unwrap() throws IOException {
        SSLEngineResult result = this.mSSLEngine.unwrap(this.mSocketReadSideBuffer, this.mSMFReadSideBuffer);
        switch (result.getStatus()) {
            case BUFFER_OVERFLOW: {
                int appSize = this.mSSLEngine.getSession().getApplicationBufferSize();
                ByteBuffer appBuf = ByteBuffer.allocate(appSize + this.mSMFReadSideBuffer.position());
                this.mSMFReadSideBuffer.flip();
                if (this.mSMFReadSideBuffer.remaining() > 0) {
                    appBuf.put(this.mSMFReadSideBuffer);
                }
                this.mSMFReadSideBuffer = appBuf;
                break;
            }
            case BUFFER_UNDERFLOW: {
                int netSize = this.mSSLEngine.getSession().getPacketBufferSize();
                if (netSize <= this.mSocketReadSideBuffer.capacity()) break;
                ByteBuffer netBuf = ByteBuffer.allocate(netSize);
                netBuf.put(this.mSocketReadSideBuffer);
                this.mSocketReadSideBuffer = netBuf;
                this.mInputBytes = new byte[this.mSocketReadSideBuffer.remaining()];
                break;
            }
            case CLOSED: 
            case OK: {
                this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_RECVED, result.bytesProduced());
                this.sessionStats.incStat(StatType.TOTAL_SOCKET_SSL_BYTES_RECVED, result.bytesConsumed());
            }
        }
        return result;
    }

    private void createSSLContext() {
        try {
            this.mSSLContext = SSLContext.getInstance("TLSv1");
            this.mSSLContext.init(this.mProps.getKeyManagers(), this.mProps.getTrustManagers(), null);
        }
        catch (Exception e) {
            this.mContextException = new JCSMPException("Error initializing context", e);
        }
    }

    private void createSSLEngine() throws JCSMPException {
        this.mSSLEngine = this.mSSLContext.createSSLEngine();
        this.mSSLEngine.setUseClientMode(true);
        if (Trace.isDebugEnabled()) {
            this.logProviders();
        }
        HashSet<String> supportedProtocolsSet = new HashSet<String>();
        ArrayList<String> supportedProtocols = new ArrayList<String>();
        ArrayList<String> unsupportedProtocols = new ArrayList<String>();
        this.getProtocolsToUse(supportedProtocolsSet, supportedProtocols, unsupportedProtocols);
        this.logProtocols(supportedProtocolsSet, supportedProtocols, unsupportedProtocols);
        if (supportedProtocols.size() == 0) {
            this.mSSLEngine = null;
            throw new JCSMPException("No supported protocols in protocol list");
        }
        String[] protocols = new String[supportedProtocols.size()];
        protocols = supportedProtocols.toArray(protocols);
        this.mSSLEngine.setEnabledProtocols(protocols);
        HashSet<String> supportedCiphersSet = new HashSet<String>();
        ArrayList<String> supportedCiphers = new ArrayList<String>();
        ArrayList<String> unsupportedCiphers = new ArrayList<String>();
        this.getCiphersToUse(supportedCiphersSet, supportedCiphers, unsupportedCiphers);
        this.logSuites(supportedCiphersSet, supportedCiphers, unsupportedCiphers);
        if (supportedCiphers.size() == 0) {
            this.mSSLEngine = null;
            throw new JCSMPException("No supported ciphers in cipher list");
        }
        String[] ciphers = new String[supportedCiphers.size()];
        ciphers = supportedCiphers.toArray(ciphers);
        this.mSSLEngine.setEnabledCipherSuites(ciphers);
    }

    private void logSession() {
        SSLSession session;
        if (!this.mSessionLogged && (session = this.mSSLEngine.getSession()) != null && session.isValid() && !session.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
            this.mSessionLogged = true;
            Trace.debug((Object)("Protocol = " + session.getProtocol()));
            Trace.debug((Object)("Cipher Suite = " + session.getCipherSuite()));
            try {
                Certificate[] peerCertificates = session.getPeerCertificates();
                if (peerCertificates != null) {
                    for (int i = 0; i < peerCertificates.length; ++i) {
                        Certificate certificate = peerCertificates[i];
                        Trace.debug((Object)("Peer Certificate (" + i + ") " + certificate));
                    }
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
    }

    public void logProviders() {
        ArrayList<String> providerList = new ArrayList<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            providerList.add(providers[i].getName());
        }
        Trace.debug((Object)("Supported Providers: " + providerList));
        Trace.debug((Object)("Selected Provider: " + this.mSSLContext.getProvider()));
    }

    public void logProtocols(HashSet<String> supportedProtocolsSet, ArrayList<String> protocolsToUseArray, ArrayList<String> protocolsNotSupportedArray) {
        if ((protocolsToUseArray.size() == 0 || protocolsNotSupportedArray.size() > 0) && Trace.isInfoEnabled()) {
            Trace.info((Object)("The following specified protocols are not supported: " + protocolsNotSupportedArray));
        }
        if (Trace.isInfoEnabled()) {
            Trace.info((Object)("SSLEngine Supported Protocols: " + supportedProtocolsSet));
            Trace.info((Object)("Application Specified Protocols: " + Arrays.toString(this.mProps.getProtocols())));
            Trace.info((Object)("Enabled Protocols: " + protocolsToUseArray));
        }
    }

    public void logSuites(HashSet<String> supportedCiphersSet, ArrayList<String> ciphersToUseArray, ArrayList<String> ciphersNotSupportedArray) {
        if ((ciphersToUseArray.size() == 0 || ciphersNotSupportedArray.size() > 0) && Trace.isInfoEnabled()) {
            Trace.info((Object)("The following specified cipher suites are not supported: " + ciphersNotSupportedArray));
        }
        if (Trace.isInfoEnabled()) {
            Trace.info((Object)("SSLEngine Supported Cipher Suites: " + supportedCiphersSet));
            Trace.info((Object)("Application Specified Cipher Suites: " + this.mProps.getCipherSuitesList()));
            Trace.info((Object)("Enabled Cipher Suites: " + ciphersToUseArray));
        }
    }

    public void getProtocolsToUse(HashSet<String> supportedProtocolsSet, ArrayList<String> protocolsToUseArray, ArrayList<String> protocolsNotSupportedArray) {
        String[] supportedProtocols = this.mSSLEngine.getSupportedProtocols();
        for (int i = 0; i < supportedProtocols.length; ++i) {
            for (int j = 0; j < SecureProperties.SupportedProtocols.length; ++j) {
                if (!supportedProtocols[i].toUpperCase().equals(SecureProperties.SupportedProtocols[j].toUpperCase())) continue;
                supportedProtocolsSet.add(supportedProtocols[i].toUpperCase());
            }
        }
        String[] specifiedProtocols = this.mProps.getProtocols();
        for (int i = 0; i < specifiedProtocols.length; ++i) {
            if (supportedProtocolsSet.contains(specifiedProtocols[i].toUpperCase())) {
                protocolsToUseArray.add(specifiedProtocols[i]);
                continue;
            }
            protocolsNotSupportedArray.add(specifiedProtocols[i]);
        }
    }

    public void getCiphersToUse(HashSet<String> supportedCiphersSet, ArrayList<String> ciphersToUseArray, ArrayList<String> ciphersNotSupportedArray) {
        String[] supportedCiphers = this.mSSLEngine.getSupportedCipherSuites();
        for (int i = 0; i < supportedCiphers.length; ++i) {
            if (SecureProperties.CipherMap.get(supportedCiphers[i].toUpperCase()) == null) continue;
            supportedCiphersSet.add(supportedCiphers[i].toUpperCase());
        }
        String[] specifiedCiphers = this.mProps.getCipherSuites();
        for (int i = 0; i < specifiedCiphers.length; ++i) {
            String cipher = specifiedCiphers[i];
            if (supportedCiphersSet.contains(cipher.toUpperCase())) {
                ciphersToUseArray.add(cipher);
                continue;
            }
            String[] aliases = SecureProperties.CipherAliasesMap.get(specifiedCiphers[i].toUpperCase());
            boolean supported = false;
            if (aliases != null) {
                for (int j = 0; j < aliases.length; ++j) {
                    if (!supportedCiphersSet.contains(aliases[j])) continue;
                    ciphersToUseArray.add(aliases[j]);
                    supported = true;
                    break;
                }
            }
            if (supported) continue;
            ciphersNotSupportedArray.add(cipher);
        }
    }

    public class ProcessResult {
        public boolean wrapOperation;
        public SSLEngineResult wrap_unwrapResult;
    }
}

