/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.AccessDeniedException;
import com.solacesystems.jcsmp.Browser;
import com.solacesystems.jcsmp.BrowserProperties;
import com.solacesystems.jcsmp.CacheSession;
import com.solacesystems.jcsmp.CacheSessionProperties;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.ClientName;
import com.solacesystems.jcsmp.Consumer;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPProducerEventHandler;
import com.solacesystems.jcsmp.JCSMPReconnectEventHandler;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.JndiMessage;
import com.solacesystems.jcsmp.OperationNotSupportedException;
import com.solacesystems.jcsmp.ProducerFlowProperties;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.Subscription;
import com.solacesystems.jcsmp.SubscriptionStateProvider;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.XMLMessageConsumer;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.AbstractDestination;
import com.solacesystems.jcsmp.impl.InputValidationUtil;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageConsumer;
import com.solacesystems.jcsmp.impl.PubSubMode;
import com.solacesystems.jcsmp.impl.QueueImpl;
import com.solacesystems.jcsmp.impl.SessionModeSupport;
import com.solacesystems.jcsmp.impl.SessionSubscriptionEvent;
import com.solacesystems.jcsmp.impl.SubscriptionCache;
import com.solacesystems.jcsmp.impl.TargetRouterMode;
import com.solacesystems.jcsmp.impl.TopicImpl;
import com.solacesystems.jcsmp.impl.client.ClientInfoUtil;
import com.solacesystems.jcsmp.impl.flow.SharedSubscriptionManager;
import com.solacesystems.jcsmp.impl.flow.SubFlowManagerImpl;
import com.solacesystems.jcsmp.impl.solcache.CacheSessionImpl;
import com.solacesystems.jcsmp.protocol.CSMPControllerChannel;
import com.solacesystems.jcsmp.protocol.CSMPPublisherChannel;
import com.solacesystems.jcsmp.protocol.CSMPSubscriberChannel;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerNotificationDispatcherFactory;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmpHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;
import com.solacesystems.jcsmp.transaction.TransactedSession;
import com.solacesystems.jcsmp.transaction.xa.XASession;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionModeSupportClient
extends SessionModeSupport {
    private static final Log Trace = LogFactory.getLog(SessionModeSupportClient.class);

    public SessionModeSupportClient(CSMPControllerChannel controlChannel, CSMPPublisherChannel publisherChannel, CSMPSubscriberChannel subscriberChannel, TcpClientChannel clientChannel, SubFlowManagerImpl flowMgr, JCSMPBasicSession session) {
        super(controlChannel, publisherChannel, subscriberChannel, clientChannel, flowMgr, session);
    }

    @Override
    public JndiMessage executeJndiQuery(JndiMessage request) throws JCSMPException {
        if (this.clientChannel == null) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        return this.clientChannel.executeJndiQuery(request);
    }

    @Override
    public void addSubscription(Subscription subscription) throws JCSMPException {
        this.addSubscription(subscription, true);
    }

    @Override
    public void addSubscription(Subscription subscription, boolean waitForConfirm) throws JCSMPException {
        this.addSubscription(subscription, waitForConfirm, true);
    }

    @Override
    public void addSubscription(Subscription subscription, boolean waitForConfirm, boolean notifySubCache) throws JCSMPException {
        TopicImpl curtopic = (TopicImpl)subscription;
        if (this.clientChannel == null) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        if (SharedSubscriptionManager.isSharedOrNoExportSubscription(curtopic.getName()) && !this.session.isCapable(CapabilityType.SHARED_SUBSCRIPTIONS)) {
            throw new InvalidOperationException("Capability mismatch: peer does not support SMF shared subscriptions and non-exported subscriptions.");
        }
        if (!waitForConfirm && !this.session.hasSessionEventHandler()) {
            String msg = String.format("%s - %s", ERROR_OPERATION_NOT_SUPPORTED, JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.operationNotSupportedNoEventHandler"));
            throw new OperationNotSupportedException(msg);
        }
        if (!(subscription instanceof Topic)) {
            throw new IllegalArgumentException("Subscription must be of type Topic.");
        }
        this.session.waitUntilSessionReconnectDone("addSubscription");
        ((AbstractDestination)curtopic).validate(TargetRouterMode.TRB, PubSubMode.SUB);
        SmpHeaderBean smprequest = SmpHeaderBean.createAddSubscriptionReq(curtopic);
        try {
            if (notifySubCache) {
                this.session.notifySubscriptionEvent(new SessionSubscriptionEvent(subscription, SessionSubscriptionEvent.SubscriptionEventType.ADD_EVENT, null));
            }
            this.clientChannel.doSmpRequest(smprequest, waitForConfirm);
        }
        catch (JCSMPException ex) {
            if (notifySubCache) {
                this.session.notifySubscriptionEvent(new SessionSubscriptionEvent(subscription, SessionSubscriptionEvent.SubscriptionEventType.ADD_FAILED, (Exception)((Object)ex)));
            }
            throw ex;
        }
    }

    @Override
    public Consumer addSubscription(Subscription subscription, XMLMessageListener listener, ConsumerNotificationDispatcherFactory dispatcherFactory) throws JCSMPException {
        if (!this.session.getJCSMPProperties().getBooleanProperty("topic_dispatch").booleanValue()) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        if (this.clientChannel == null) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        if (!(subscription instanceof Topic)) {
            throw new IllegalArgumentException("Subscription must be of type Topic.");
        }
        TopicImpl curtopic = (TopicImpl)subscription;
        if (SharedSubscriptionManager.isSharedOrNoExportSubscription(curtopic.getName()) && !this.session.isCapable(CapabilityType.SHARED_SUBSCRIPTIONS)) {
            throw new InvalidOperationException("Capability mismatch: peer does not support SMF shared subscriptions and non-exported subscriptions.");
        }
        ((AbstractDestination)curtopic).validate(TargetRouterMode.TRB, PubSubMode.SUB);
        return this.flowMgr.createReliableFlow((Topic)subscription, listener, dispatcherFactory);
    }

    @Override
    public void removeSubscription(Subscription subscription) throws JCSMPException {
        this.removeSubscription(subscription, true);
    }

    @Override
    public void removeSubscription(Subscription subscription, boolean waitForConfirm) throws JCSMPException {
        if (this.clientChannel == null) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        if (!waitForConfirm && !this.session.hasSessionEventHandler()) {
            String msg = String.format("%s - %s", ERROR_OPERATION_NOT_SUPPORTED, JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.operationNotSupportedNoEventHandler"));
            throw new OperationNotSupportedException(msg);
        }
        if (!(subscription instanceof Topic)) {
            throw new IllegalArgumentException("Subscription must be of type Topic.");
        }
        this.session.waitUntilSessionReconnectDone("removeSubscription");
        TopicImpl curtopic = (TopicImpl)subscription;
        ((AbstractDestination)curtopic).validate(TargetRouterMode.TRB, PubSubMode.SUB);
        this.session.notifySubscriptionEvent(new SessionSubscriptionEvent(subscription, SessionSubscriptionEvent.SubscriptionEventType.REM_EVENT, null));
        SmpHeaderBean smprequest = SmpHeaderBean.createRemoveSubscriptionReq(curtopic);
        this.clientChannel.doSmpRequest(smprequest, waitForConfirm);
    }

    @Override
    public void addSubscription(Endpoint endpoint, Subscription subscription, int subscribeFlags) throws JCSMPException {
        boolean waitForConfirm;
        TopicImpl curtopic = (TopicImpl)subscription;
        if (this.clientChannel == null) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        if (SharedSubscriptionManager.isSharedOrNoExportSubscription(curtopic.getName()) && !this.session.isCapable(CapabilityType.SHARED_SUBSCRIPTIONS)) {
            throw new InvalidOperationException("Capability mismatch: peer does not support SMF shared subscriptions and non-exported subscriptions.");
        }
        boolean bl = waitForConfirm = (subscribeFlags & 4) == 4;
        if (!waitForConfirm && !this.session.hasSessionEventHandler()) {
            String msg = String.format("%s - %s", ERROR_OPERATION_NOT_SUPPORTED, JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.operationNotSupportedNoEventHandler"));
            throw new OperationNotSupportedException(msg);
        }
        ((AbstractDestination)curtopic).validate(TargetRouterMode.TRB, PubSubMode.SUB);
        if (endpoint instanceof Queue) {
            QueueImpl queue = (QueueImpl)endpoint;
            this.session.notifySubscriptionEvent(new SessionSubscriptionEvent(endpoint, subscription, SessionSubscriptionEvent.SubscriptionEventType.ADD_EVENT, null));
            SmpHeaderBean smprequest = SmpHeaderBean.createAddQueueSubscriptionReq(curtopic, queue);
            boolean addFailed = false;
            try {
                this.performSmpReq(smprequest, waitForConfirm);
            }
            catch (JCSMPException e) {
                addFailed = true;
                throw e;
            }
            finally {
                if (addFailed) {
                    this.session.notifySubscriptionEvent(new SessionSubscriptionEvent(endpoint, subscription, SessionSubscriptionEvent.SubscriptionEventType.ADD_FAILED, null));
                }
            }
        } else if (endpoint instanceof ClientName) {
            ClientInfoUtil.validateClientName(endpoint.getName(), TargetRouterMode.TRB);
            SmpHeaderBean smprequest = SmpHeaderBean.createAddSubscriptionForClientNameReq(curtopic, endpoint.getName());
            this.performSmpReq(smprequest, waitForConfirm);
        }
    }

    private void performSmpReq(SmpHeaderBean smprequest, boolean waitForConfirm) throws JCSMPException {
        this.session.waitUntilSessionReconnectDone("performSmpReq");
        try {
            this.clientChannel.doSmpRequest(smprequest, waitForConfirm);
        }
        catch (JCSMPErrorResponseException e) {
            if (e.getResponseCode() == 400 && e.getSubcodeEx() == 13) {
                if (this.session.getJCSMPProperties().getBooleanProperty("IGNORE_DUPLICATE_SUBSCRIPTION_ERROR").booleanValue()) {
                    return;
                }
                throw e;
            }
            if (e.getResponseCode() == 400 && e.getSubcodeEx() == 14 && this.session.getJCSMPProperties().getBooleanProperty("IGNORE_SUBSCRIPTION_NOT_FOUND_ERROR").booleanValue()) {
                return;
            }
            if (e.getResponseCode() == 403 && e.getSubcodeEx() == 36) {
                throw new AccessDeniedException(e.getResponsePhrase(), (Throwable)((Object)e));
            }
            throw e;
        }
    }

    @Override
    public void removeSubscription(Endpoint endpoint, Subscription subscription, int unsubscribeFlags) throws JCSMPException {
        boolean waitForConfirm;
        TopicImpl curtopic = (TopicImpl)subscription;
        if (this.clientChannel == null) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        boolean bl = waitForConfirm = (unsubscribeFlags & 4) == 4;
        if (!waitForConfirm && !this.session.hasSessionEventHandler()) {
            String msg = String.format("%s - %s", ERROR_OPERATION_NOT_SUPPORTED, JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.operationNotSupportedNoEventHandler"));
            throw new OperationNotSupportedException(msg);
        }
        ((AbstractDestination)curtopic).validate(TargetRouterMode.TRB, PubSubMode.SUB);
        if (endpoint instanceof Queue) {
            QueueImpl queue = (QueueImpl)endpoint;
            this.session.notifySubscriptionEvent(new SessionSubscriptionEvent(endpoint, subscription, SessionSubscriptionEvent.SubscriptionEventType.REM_EVENT, null));
            SmpHeaderBean smprequest = SmpHeaderBean.createRemoveQueueSubscriptionReq(curtopic, queue);
            this.performSmpReq(smprequest, waitForConfirm);
        } else if (endpoint instanceof ClientName) {
            ClientInfoUtil.validateClientName(endpoint.getName(), TargetRouterMode.TRB);
            SmpHeaderBean smprequest = SmpHeaderBean.createRemSubscriptionForClientNameReq(curtopic, endpoint.getName());
            this.performSmpReq(smprequest, waitForConfirm);
        }
    }

    @Override
    public void setProperty(String property, Object value) throws JCSMPException {
        if (!modifiableProperties.contains(property)) {
            this.throwUnmodifiablePropertyError(property);
        }
        if (this.clientChannel == null) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        if ("application_description".equals(property)) {
            String str = (String)value;
            if (!InputValidationUtil.validateStringLengthAscii(str, 254)) {
                throw new IllegalArgumentException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.propertyTooLong", new Object[]{"application_description", 254}));
            }
            this.clientChannel.updateClientDescription((String)value);
        } else if ("client_name".equals(property)) {
            String str = (String)value;
            if (str != null && str.length() > 0) {
                ClientInfoUtil.validateClientName(str, TargetRouterMode.TRB);
            }
            String defaultClientName = ClientInfoUtil.constructClientName(String.format("%04x%04x", this.session.context.getContextId(), this.session.sessionCounterId), this.session.clientInfoProvider.getHostname(), this.session.clientInfoProvider.getPid());
            this.clientChannel.updateClientName((String)value, defaultClientName);
        } else {
            Trace.info((Object)String.format("Request to modify property '%s', ignored.", property));
        }
    }

    @Override
    public void addSubscriber() throws JCSMPException {
        throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void clearSubscriber() throws JCSMPException {
        throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
    }

    @Override
    protected XMLMessageConsumer doGetConsumer(SubscriptionStateProvider subStateProvider, JCSMPReconnectEventHandler reconHandler, XMLMessageListener listener) throws JCSMPException {
        if (this.clientChannel == null) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        if (this.consumer != null) {
            Trace.info((Object)"Closing existing XMLMessageConsumer, new instance requested.");
            this.consumer.close();
            this.consumer = null;
        }
        this.clientChannel.open(false);
        this.consumer = (JCSMPXMLMessageConsumer)this.flowMgr.createXMLMessageConsumer(listener, reconHandler, false);
        return this.consumer;
    }

    private boolean isStreamingCallback(JCSMPStreamingPublishEventHandler callback) {
        return callback != null;
    }

    @Override
    public XMLMessageProducer getMessageProducer(JCSMPStreamingPublishEventHandler callback) throws JCSMPException {
        return this.getMessageProducer(callback, null);
    }

    @Override
    public synchronized XMLMessageProducer getMessageProducer(JCSMPStreamingPublishEventHandler callback, JCSMPProducerEventHandler eventCallback) throws JCSMPException {
        if (this.clientChannel == null) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        if (!this.isStreamingCallback(callback)) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.callbackMandatoryInClientMode"));
        }
        if (this.producer != null && this.producer.isOpenInternal()) {
            return this.producer;
        }
        this.clientChannel.open(false);
        ProducerFlowProperties fprop = new ProducerFlowProperties();
        Integer pub_win_sz = this.session.getJCSMPProperties().getIntegerProperty("pub_ack_window_size");
        fprop.setWindowSize(pub_win_sz);
        fprop.setRtrWindowedAck(this.session.getJCSMPProperties().getBooleanProperty("ad_pub_router_windowed_ack"));
        fprop.setAckEventMode(this.session.getJCSMPProperties().getStringProperty("ACK_EVENT_MODE"));
        this.producer = this.session.pubFlowManager.createDefaultProducer(callback, eventCallback, fprop);
        return this.producer;
    }

    @Override
    public void applySubscriptions(Set<Subscription> subscriptions) throws JCSMPException {
        throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void deleteSubscriber() throws JCSMPException {
    }

    @Override
    public CacheSession createCacheSession(CacheSessionProperties properties) {
        return new CacheSessionImpl(properties);
    }

    @Override
    public void closeControlChannel() {
    }

    @Override
    public void validateSubscriberEndpointValidEndpoint() throws JCSMPException {
        throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED + " (SubscriberEndpoint disallowed on SolOS-TR)");
    }

    @Override
    public void validateBindTopicOrQueue(AbstractDestination dest) throws JCSMPException {
        dest.validate(TargetRouterMode.TRB, PubSubMode.SUB);
    }

    @Override
    public void reestablishSubCache() throws JCSMPException {
        Set<SubscriptionCache.SubscriptionCacheEntry> to_add = this.session.subscriptionCache.getShallowCopy();
        Trace.debug((Object)String.format("About to reestablish %s subscriptions...", to_add.size()));
        for (SubscriptionCache.SubscriptionCacheEntry s : to_add) {
            if (!(s.subscription instanceof TopicImpl)) continue;
            this.clientChannel.getSmpRespInterceptState().checkNoErrorResponse();
            SmpHeaderBean smp_req = null;
            if (s.endpoint == null) {
                smp_req = SmpHeaderBean.createAddSubscriptionReq((TopicImpl)s.subscription);
            } else {
                boolean skip_queue_subscriptions = true;
                if (skip_queue_subscriptions || !(s.endpoint instanceof QueueImpl)) continue;
                smp_req = SmpHeaderBean.createAddQueueSubscriptionReq((TopicImpl)s.subscription, (QueueImpl)s.endpoint);
            }
            smp_req.setSmpFlags(smp_req.getSmpFlags() & 0xFFFFFFF7);
            SMFHeaderBean smfHeader = new SMFHeaderBean();
            smfHeader.setProtocol(15).setTtl(1).setSmfVersion(3);
            WireMessage wmsg = WireMessageFactory.createWith(smfHeader, smp_req);
            wmsg.setFriendlyName("SMP-ReestablishSubCache");
            this.clientChannel.doSmfSubSingleShotRequest(wmsg, true, false, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, this.clientChannel.getConnCounterTag(), null);
        }
        Trace.debug((Object)String.format("Done sending %s subscriptions...", to_add.size()));
    }

    @Override
    public WireMessage performProvisionEndpointCommand(WireMessage provEpCommand) throws JCSMPException {
        WireMessage response = this.clientChannel.doSmfBlockingRequestNoRetry(provEpCommand);
        return response;
    }

    @Override
    public WireMessage performDeleteEndpointCommad(WireMessage delEpCommand) throws JCSMPException {
        WireMessage response = this.clientChannel.doSmfBlockingRequestNoRetry(delEpCommand);
        return response;
    }

    @Override
    public Browser createBrowser(BrowserProperties properties) throws JCSMPException {
        throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
    }

    @Override
    public TransactedSession createTransactedSession() throws JCSMPException {
        throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
    }

    @Override
    public XASession createXASession() throws JCSMPException {
        throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setJmsClientId(String clientId, boolean allowSharedClientId) throws JCSMPException {
        throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
    }

    @Override
    public Browser createBrowser(BrowserProperties properties, FlowEventHandler flowEventHandler) throws JCSMPException {
        throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
    }
}

