/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.Browser;
import com.solacesystems.jcsmp.BrowserProperties;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;

public class BrowserImpl
implements Browser {
    private BrowserProperties mProps;
    private FlowReceiver mReceiver;

    public BrowserImpl(BrowserProperties props, FlowReceiver receiver) {
        this.mProps = props;
        this.mReceiver = receiver;
    }

    public void close() {
        this.mReceiver.close();
    }

    public void setFlowReceiver(FlowReceiver receiver) {
        this.mReceiver = receiver;
    }

    public BytesXMLMessage getNext() throws JCSMPException {
        return this.mReceiver.receive(this.mProps.getWaitTimeout());
    }

    public BytesXMLMessage getNext(int timeoutInMillis) throws JCSMPException {
        return this.mReceiver.receive(timeoutInMillis);
    }

    public BytesXMLMessage getNextNoWait() throws JCSMPException {
        return this.mReceiver.receiveNoWait();
    }

    public boolean hasMore() throws JCSMPException {
        return ((FlowHandleImpl)this.mReceiver).getMessageQueueSize() > 0;
    }

    public void remove(BytesXMLMessage message) throws JCSMPException {
        try {
            message.ackMessage();
        }
        catch (IllegalStateException e) {
            if (this.mReceiver instanceof FlowHandleImpl) {
                FlowHandleImpl flow = (FlowHandleImpl)this.mReceiver;
                flow.throwClosedException(e.getMessage());
            }
            throw e;
        }
    }
}

