/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import com.solacesystems.common.util.DefaultGenericPoolFactory;
import com.solacesystems.common.util.GenericPoolFactory;
import com.solacesystems.common.util.TLinkable;
import com.solacesystems.common.util.TLinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPool<T> {
    private final TLinkedList _genericQueue = new TLinkedList();
    protected static final int defaultMaxPoolSize = 10000;
    private int _size = 0;
    private int _allocatedCnt = 0;
    private long waitCount = 0L;
    private GenericPoolFactory genericPoolFactory;

    public GenericPool(Class<?> clazz) {
        this.genericPoolFactory = new DefaultGenericPoolFactory(clazz);
        this.init(10000);
    }

    public GenericPool(Class<?> clazz, int size) {
        this.genericPoolFactory = new DefaultGenericPoolFactory(clazz);
        this.init(size);
    }

    public GenericPool(GenericPoolFactory genericPoolAllocator, int size) {
        this.genericPoolFactory = genericPoolAllocator;
        this.init(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int size) {
        TLinkedList tLinkedList = this._genericQueue;
        synchronized (tLinkedList) {
            this._size = size;
            this._allocatedCnt = this.genericPoolFactory.initial_fill(this._genericQueue, size);
        }
    }

    public long getWaitCount() {
        return this.waitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolEntry<T> borrowFromPool() {
        PoolEntry item = null;
        TLinkedList tLinkedList = this._genericQueue;
        synchronized (tLinkedList) {
            while (this._genericQueue.size() == 0) {
                if (this._allocatedCnt < this._size) {
                    this.genericPoolFactory.allocateOne(this._genericQueue);
                    ++this._allocatedCnt;
                    continue;
                }
                try {
                    ++this.waitCount;
                    this._genericQueue.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            item = (PoolEntry)this._genericQueue.removeFirst();
        }
        item.setIsBorrowed(true);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToPool(PoolEntry<T> item) {
        TLinkedList tLinkedList = this._genericQueue;
        synchronized (tLinkedList) {
            if (!item.isBorrowed()) {
                return;
            }
            item.setIsBorrowed(false);
            this._genericQueue.addFirst(item);
            if (this._genericQueue.size() == 1) {
                this._genericQueue.notifyAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PoolEntry<T>
    implements TLinkable {
        T item;
        TLinkable next;
        TLinkable previous;
        boolean isBorrowed = false;
        private static final long serialVersionUID = 1L;

        PoolEntry(T item) {
            this.item = item;
            this.isBorrowed = false;
        }

        public void setIsBorrowed(boolean isBorrowed) {
            this.isBorrowed = isBorrowed;
        }

        public T getEntry() {
            return this.item;
        }

        public boolean isBorrowed() {
            return this.isBorrowed;
        }

        public TLinkable getNext() {
            return this.next;
        }

        public TLinkable getPrevious() {
            return null;
        }

        public void setNext(TLinkable next) {
            this.next = next;
        }

        public void setPrevious(TLinkable previous) {
            this.previous = previous;
        }
    }
}

