/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jms.SolConnection;
import com.solacesystems.jms.SolQueueSession;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.property.JMSProperties;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolQueueConnection
extends SolConnection
implements QueueConnection {
    private static final Log log = LogFactory.getLog(SolQueueConnection.class);

    public SolQueueConnection(JMSProperties properties, boolean connectionTypeXA, String username, String password) throws JMSException {
        super(properties, connectionTypeXA, username, password);
        if (log.isDebugEnabled()) {
            log.debug((Object)"SolQueueConnection created.");
        }
    }

    public SolQueueConnection(JMSProperties properties, boolean connectionTypeXA) throws JMSException {
        super(properties, connectionTypeXA);
        if (log.isDebugEnabled()) {
            log.debug((Object)"SolQueueConnection created.");
        }
    }

    public synchronized ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("createConnectionConsumer() called.  Queue: " + (queue == null ? "null" : queue.getQueueName()) + "   Message selector: " + messageSelector));
        }
        return super.createConnectionConsumer((Destination)queue, messageSelector, sessionPool, maxMessages);
    }

    public synchronized QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        Validator.checkTransactedAndAckMode(transacted ? SessionTransactionType.LocalTransaction : SessionTransactionType.NoTransaction, acknowledgeMode, this.mConnectionProps.getPropertyBean().getDirectTransport());
        Validator.checkTransactedAndLargeMessaging(transacted ? SessionTransactionType.LocalTransaction : SessionTransactionType.NoTransaction, this.mJCSMPProperties.getBooleanProperty("large_messaging"));
        this.mHasBeenAccessed = true;
        SolQueueSession newSession = new SolQueueSession(this, transacted, acknowledgeMode, this.mState);
        this.mSessions.add(newSession);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createQueueSession() called.  Transacted: " + transacted + " acknowledgeMode: " + acknowledgeMode));
        }
        return newSession;
    }

    public synchronized ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.illegalstate", "createDurableConnectionConsumer()"), "soljms.error.illegalstate");
    }
}

