/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jms.SolConnectionFactory;
import com.solacesystems.jms.SolJmsUtility;
import com.solacesystems.jms.SolQueue;
import com.solacesystems.jms.SolReferenceableDelegate;
import com.solacesystems.jms.SolTopic;
import com.solacesystems.jms.SolXAConnectionFactory;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReferenceableDelegate
implements SolReferenceableDelegate,
ObjectFactory,
DirObjectFactory {
    public static final DefaultReferenceableDelegate onlyInstance = new DefaultReferenceableDelegate();
    public static final String TopicRefAddrType = "SolJMSTopic";
    public static final String QueueRefAddrType = "SolJMSQueue";
    protected static final String PoundReplacementChar = "_";

    @Override
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable<?, ?> table, Attributes attrs) throws Exception {
        if (!(obj instanceof Reference)) {
            throw new IllegalArgumentException("Not instance of Reference: " + obj.getClass());
        }
        Reference reference = (Reference)obj;
        Class<?> clazz = Class.forName(reference.getClassName());
        if (SolTopic.class.isAssignableFrom(clazz)) {
            String topicName = this.getRefAddr(reference, TopicRefAddrType);
            try {
                return SolJmsUtility.createTopic(topicName);
            }
            catch (Throwable t) {
                throw new NamingException("Error creating topic: " + t.getMessage());
            }
        }
        if (SolQueue.class.isAssignableFrom(clazz)) {
            String queueName = this.getRefAddr(reference, QueueRefAddrType);
            try {
                return SolJmsUtility.createQueue(queueName);
            }
            catch (Throwable t) {
                throw new NamingException("Error creating queue: " + t.getMessage());
            }
        }
        if (SolXAConnectionFactory.class.isAssignableFrom(clazz)) {
            try {
                SolXAConnectionFactory xacf = SolJmsUtility.createXAConnectionFactory(null);
                for (String propName : xacf.getPropertyNames()) {
                    String propValue = this.getRefAddr(reference, propName);
                    if (propValue == null) continue;
                    xacf.setProperty(propName, propValue);
                }
                return xacf;
            }
            catch (Throwable t) {
                throw new NamingException("Error creating XA connection factory: " + t.getMessage());
            }
        }
        if (SolConnectionFactory.class.isAssignableFrom(clazz)) {
            try {
                SolConnectionFactory cf = SolJmsUtility.createConnectionFactory(null);
                for (String propName : cf.getPropertyNames()) {
                    String propValue = this.getRefAddr(reference, propName);
                    if (propValue == null) continue;
                    cf.setProperty(propName, propValue);
                }
                return cf;
            }
            catch (Throwable t) {
                throw new NamingException("Error creating connection factory: " + t.getMessage());
            }
        }
        return null;
    }

    @Override
    public Object getObjectInstance(Object arg0, Name arg1, Context arg2, Hashtable<?, ?> arg3) throws Exception {
        return this.getObjectInstance(arg0, arg1, arg2, arg3, null);
    }

    @Override
    public Reference getReference(Referenceable referenceable) throws NamingException {
        try {
            if (referenceable instanceof SolTopic) {
                SolTopic topic = (SolTopic)referenceable;
                Reference ref = new Reference(topic.getClass().getName(), this.getClass().getName(), null);
                this.addRefAddr(ref, TopicRefAddrType, topic.getTopicName());
                return ref;
            }
            if (referenceable instanceof SolQueue) {
                SolQueue queue = (SolQueue)referenceable;
                Reference ref = new Reference(queue.getClass().getName(), this.getClass().getName(), null);
                this.addRefAddr(ref, QueueRefAddrType, queue.getQueueName());
                return ref;
            }
            if (referenceable instanceof SolXAConnectionFactory) {
                SolXAConnectionFactory xacf = (SolXAConnectionFactory)referenceable;
                Reference ref = new Reference(xacf.getClass().getName(), this.getClass().getName(), null);
                for (String name : xacf.getPropertyNames()) {
                    Object value = xacf.getProperty(name);
                    if (value == null) continue;
                    this.addRefAddr(ref, name, value.toString());
                }
                return ref;
            }
            if (referenceable instanceof SolConnectionFactory) {
                SolConnectionFactory cf = (SolConnectionFactory)referenceable;
                Reference ref = new Reference(cf.getClass().getName(), this.getClass().getName(), null);
                for (String name : cf.getPropertyNames()) {
                    Object value = cf.getProperty(name);
                    if (value == null) continue;
                    this.addRefAddr(ref, name, value.toString());
                }
                return ref;
            }
            return null;
        }
        catch (Exception e) {
            throw new NamingException("Error getting reference: " + e.getMessage());
        }
    }

    protected void addRefAddr(Reference ref, String name, String value) {
        if (value.length() > 0 && value.charAt(0) == '#') {
            ref.add(new StringRefAddr(name + PoundReplacementChar, PoundReplacementChar + value));
        } else {
            ref.add(new StringRefAddr(name, value));
        }
    }

    protected String getRefAddr(Reference ref, String name) {
        RefAddr refaddr = ref.get(name);
        if (refaddr == null) {
            refaddr = ref.get(name + PoundReplacementChar);
            if (refaddr == null) {
                return null;
            }
            String content = (String)refaddr.getContent();
            if (content.length() == 0) {
                return content;
            }
            return content.substring(1);
        }
        return (String)refaddr.getContent();
    }
}

