/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.message;

import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.MessageDumpFieldProvider;
import com.solacesystems.jcsmp.impl.MessageDumpStandardProvider;
import com.solacesystems.jcsmp.impl.MessageDumpUtil;
import com.solacesystems.jcsmp.impl.MessageImpl;
import com.solacesystems.jms.impl.SolQueueImpl;
import com.solacesystems.jms.impl.SolTopicImpl;
import com.solacesystems.jms.message.SolMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.jms.Destination;

public class SolMessageDump {
    public static Collection<MessageDumpFieldProvider<SolMessage>> getJmsFieldProviders() {
        ArrayList<MessageDumpFieldProvider<SolMessage>> providers = new ArrayList<MessageDumpFieldProvider<SolMessage>>();
        providers.add(new FPJmsCorrelationId());
        providers.add(new FPJmsDeliveryMode());
        providers.add(new FPJmsDestination());
        providers.add(new FPJmsExpiration());
        providers.add(new FPJmsMessageId());
        providers.add(new FPJmsPriority());
        providers.add(new FPJmsRedelivered());
        providers.add(new FPJmsDeliveryCount());
        providers.add(new FPJmsReplyTo());
        providers.add(new FPJmsTimestamp());
        providers.add(new FPJmsType());
        providers.add(new FPJmsProperties());
        return providers;
    }

    public static class FPJmsJcsmpContents
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            JCSMPGenericXMLMessage xmlMessage = null;
            StringBuilder c = new StringBuilder();
            if (msg.mMessage instanceof JCSMPGenericXMLMessage) {
                xmlMessage = (JCSMPGenericXMLMessage)msg.mMessage;
            } else if (msg.mMessage instanceof MessageImpl) {
                xmlMessage = (JCSMPGenericXMLMessage)((MessageImpl)msg.mMessage).getWrappedMessage();
            }
            if (xmlMessage != null) {
                ArrayList<MessageDumpFieldProvider<MessageDumpFieldProvider<JCSMPGenericXMLMessage>>> providers = new ArrayList<MessageDumpFieldProvider<MessageDumpFieldProvider<JCSMPGenericXMLMessage>>>();
                providers.add(new MessageDumpStandardProvider.FPXml());
                providers.add(new MessageDumpStandardProvider.FPBinaryAttachment());
                c.append("{");
                c.append(MessageDumpUtil.dump(providers, xmlMessage, ",", 0, 0));
                c.append("}");
            }
            return new Object[]{"SolPayload", xmlMessage != null, c.toString(), null};
        }
    }

    public static class FPJmsProperties
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            int numProps = 0;
            StringBuilder c = new StringBuilder("{");
            Enumeration<String> propertyNameEnum = msg.getPropertyNames();
            while (propertyNameEnum.hasMoreElements()) {
                String name = propertyNameEnum.nextElement();
                Object prop = msg.getObjectProperty(name);
                if (numProps > 0) {
                    c.append(",");
                }
                c.append(name);
                c.append(":");
                c.append(prop);
                ++numProps;
            }
            c.append("}");
            return new Object[]{"JMSProperties", numProps > 0, c.toString(), null};
        }
    }

    public static class FPJmsType
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            return new Object[]{"JMSType", msg.getJMSType() != null, msg.getJMSType(), null};
        }
    }

    public static class FPJmsTimestamp
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            return new Object[]{"JMSTimestamp", true, msg.getJMSTimestamp(), null};
        }
    }

    public static class FPJmsReplyTo
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            boolean present = null != msg.getJMSReplyTo();
            String shortValue = null;
            if (present) {
                Destination d = msg.getJMSReplyTo();
                shortValue = d instanceof SolTopicImpl ? "Topic " : (d instanceof SolQueueImpl ? "Queue " : "");
                shortValue = shortValue + "'" + d.toString() + "'";
            }
            return new Object[]{"ReplyTo", present, shortValue, null};
        }
    }

    public static class FPJmsDeliveryCount
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            return new Object[]{"JMSDeliveryCount", msg.getJMSXDeliveryCount() != null, msg.getJMSXDeliveryCount(), null};
        }
    }

    public static class FPJmsRedelivered
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            return new Object[]{"JMSRedelivered", msg.getJMSRedelivered(), "", null};
        }
    }

    public static class FPJmsPriority
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            return new Object[]{"JMSPriority", true, msg.getJMSPriority(), null};
        }
    }

    public static class FPJmsMessageId
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            return new Object[]{"JMSMessageID", msg.getJMSMessageID() != null, msg.getJMSMessageID(), null};
        }
    }

    public static class FPJmsExpiration
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            return new Object[]{"JMSExpiration", true, msg.getJMSExpiration(), null};
        }
    }

    public static class FPJmsDestination
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            Destination dest = msg.getJMSDestination();
            boolean isPresent = dest != null;
            String info = "";
            if (isPresent) {
                if (dest instanceof SolTopicImpl) {
                    info = String.format("Topic '%s'", dest);
                } else if (dest instanceof SolQueueImpl) {
                    info = String.format("Queue '%s'", dest);
                }
            }
            return new Object[]{"JMSDestination", isPresent, info, null};
        }
    }

    public static class FPJmsDeliveryMode
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            return new Object[]{"JMSDeliveryMode", true, msg.getJMSDeliveryMode(), null};
        }
    }

    public static class FPJmsCorrelationId
    implements MessageDumpFieldProvider<SolMessage> {
        @Override
        public Object[] getData(SolMessage msg, int flags) {
            return new Object[]{"JMSCorrelationID", msg.getJMSCorrelationID() != null, msg.getJMSCorrelationID(), null};
        }
    }
}

