/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPSession;

public class RouterCapabilities {
    private boolean mSupportsTemps = false;
    private boolean mCRMode = true;
    private boolean mSupportsPubFlows = false;
    private boolean mSupportsQueueBrowsers = false;
    private boolean mSupportsSelectors = false;

    public RouterCapabilities(JCSMPSession session) {
        try {
            this.mSupportsTemps = (Boolean)session.getCapability(CapabilityType.TEMP_ENDPOINT);
            this.mCRMode = (Boolean)session.getCapability(CapabilityType.SUPPORTS_XPE_SUBSCRIPTIONS);
            this.mSupportsPubFlows = (Boolean)session.getCapability(CapabilityType.PUB_FLOW_GUARANTEED);
            this.mSupportsQueueBrowsers = (Boolean)session.getCapability(CapabilityType.BROWSER);
            this.mSupportsSelectors = (Boolean)session.getCapability(CapabilityType.SELECTOR);
        }
        catch (JCSMPException jCSMPException) {
            // empty catch block
        }
    }

    public boolean supportsTemps() {
        return this.mSupportsTemps;
    }

    public boolean crMode() {
        return this.mCRMode;
    }

    public boolean supportsPubFlows() {
        return this.mSupportsPubFlows;
    }

    public boolean supportsQueueBrowser() {
        return this.mSupportsQueueBrowsers;
    }

    public boolean supportsSelectors() {
        return this.mSupportsSelectors;
    }
}

