/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.impl.ContentBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;

public class BufferCloningPool {
    ArrayBlockingQueue<ContentBuffer> _directQ = new ArrayBlockingQueue(1024);
    ArrayBlockingQueue<ContentBuffer> _nonDirectQ = new ArrayBlockingQueue(1024);
    final Stats _stats = new Stats();
    static final int QUEUE_SZ = 1024;

    public synchronized ContentBuffer acquireCopy(ContentBuffer buf) {
        boolean isDirect = buf.getByteBufferRefInternal().isDirect();
        boolean cache_hit = false;
        ContentBuffer acq = null;
        acq = isDirect ? this._directQ.poll() : this._nonDirectQ.poll();
        if (acq == null) {
            acq = new ContentBuffer(isDirect);
        } else {
            cache_hit = true;
        }
        if (acq.getByteBufferRefInternal().capacity() < buf.getLimit()) {
            ByteBuffer newbuf = isDirect ? ByteBuffer.allocateDirect(buf.getLimit()) : ByteBuffer.allocate(buf.getLimit());
            acq.setByteBufferRefInternal(newbuf);
        }
        ContentBuffer.cloneBufferTo(buf.getByteBufferRefInternal(), acq.getByteBufferRefInternal());
        acq.setLimit(buf.getLimit());
        return acq;
    }

    public synchronized void release(ContentBuffer buf) {
        if (buf == null) {
            return;
        }
        buf.reset();
        boolean isDirect = buf.getByteBufferRefInternal().isDirect();
        if (isDirect) {
            this._directQ.offer(buf);
        } else {
            this._nonDirectQ.offer(buf);
        }
    }

    private static class Stats {
        public int acquire_cache_hit = 0;
        public int acquire_cache_miss = 0;
        public int release_cached = 0;
        public int release_discarded = 0;

        private Stats() {
        }

        public String toString() {
            return String.format("[acquire_cache_hit %s/%s, release_cached %s/%s]", this.acquire_cache_hit, this.acquire_cache_hit + this.acquire_cache_miss, this.release_cached, this.release_cached + this.release_discarded);
        }
    }
}

