/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.jndi;

import com.solacesystems.common.jndi.JNDIObjectType;
import com.solacesystems.common.jndi.PropertyList;
import java.util.HashMap;

public class JNDIObject {
    public static final String GlobalPropertyListName = "___DEFAULT___";
    private String mJNDIName = null;
    private JNDIObjectType mType;
    private String mVpnName;
    private HashMap<String, PropertyList> mPropertyLists;

    public JNDIObject(JNDIObjectType type) {
        this.mType = type;
        this.mVpnName = null;
        this.mPropertyLists = new HashMap();
        this.mPropertyLists.put(GlobalPropertyListName, new PropertyList(GlobalPropertyListName));
    }

    public String getKey() {
        StringBuffer buf = new StringBuffer(this.mJNDIName);
        if (this.mVpnName != null && this.mVpnName.length() > 0) {
            buf.append("?").append(this.mVpnName);
        }
        return buf.toString();
    }

    public void setJNDIName(String name) {
        this.mJNDIName = name;
    }

    public String getJNDIName() {
        return this.mJNDIName;
    }

    public JNDIObjectType getType() {
        return this.mType;
    }

    public String getVpnName() {
        return this.mVpnName;
    }

    public void setVpnName(String vpnName) {
        this.mVpnName = vpnName;
    }

    public void addPropertyList(PropertyList propertyList) {
        this.mPropertyLists.put(propertyList.getName(), propertyList);
    }

    public PropertyList getGlobalPropertyList() {
        return this.mPropertyLists.get(GlobalPropertyListName);
    }

    public PropertyList getPropertyList(String name) {
        return this.mPropertyLists.get(name);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this.mType.toString());
        bldr.append("(");
        bldr.append(this.getKey());
        bldr.append(") {");
        for (String name : this.mPropertyLists.keySet()) {
            PropertyList list = this.mPropertyLists.get(name);
            bldr.append("\r\n");
            bldr.append(list.toString());
        }
        bldr.append("\r\n}\r\n");
        return bldr.toString();
    }
}

