/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.ClientCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmpHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;
import java.util.LinkedList;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class WireMessagePool {
    private final LinkedList<WireMessage> _wireMessageQueue = new LinkedList();
    private final LinkedList<SMFHeaderBean> _smfBeanQueue = new LinkedList();
    private final LinkedList<SmpHeaderBean> _smpBeanQueue = new LinkedList();
    private final LinkedList<AssuredCtrlHeaderBean> _adctrlBeanQueue = new LinkedList();
    private final LinkedList<ClientCtrlHeaderBean> _clientctrlBeanQueue = new LinkedList();
    private static final int POOL_SIZE = 10240;
    private static WireMessagePool _instance = new WireMessagePool();

    public static WireMessagePool getInstance() {
        return _instance;
    }

    private WireMessagePool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WireMessage getWireMessage() {
        WireMessage wm = null;
        LinkedList<WireMessage> linkedList = this._wireMessageQueue;
        synchronized (linkedList) {
            wm = this._wireMessageQueue.size() > 0 ? this._wireMessageQueue.removeFirst() : this.allocateWireMessage();
        }
        wm.reset();
        return wm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMFHeaderBean getSMFHeaderBean() {
        SMFHeaderBean header = null;
        LinkedList<SMFHeaderBean> linkedList = this._smfBeanQueue;
        synchronized (linkedList) {
            header = this._smfBeanQueue.size() > 0 ? this._smfBeanQueue.removeFirst() : this.allocateSMFHeaderBean();
        }
        header.reset();
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmpHeaderBean getSmpHeaderBean() {
        SmpHeaderBean header = null;
        LinkedList<SmpHeaderBean> linkedList = this._smpBeanQueue;
        synchronized (linkedList) {
            header = this._smpBeanQueue.size() > 0 ? this._smpBeanQueue.removeFirst() : this.allocateSmpHeaderBean();
        }
        header.reset();
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssuredCtrlHeaderBean getAdctrlHeaderBean() {
        AssuredCtrlHeaderBean header = null;
        LinkedList<AssuredCtrlHeaderBean> linkedList = this._adctrlBeanQueue;
        synchronized (linkedList) {
            header = this._adctrlBeanQueue.size() > 0 ? this._adctrlBeanQueue.removeFirst() : this.allocateAdctrlHeaderBean();
        }
        header.reset();
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientCtrlHeaderBean getClientCtrlHeaderBean() {
        ClientCtrlHeaderBean header = null;
        LinkedList<ClientCtrlHeaderBean> linkedList = this._clientctrlBeanQueue;
        synchronized (linkedList) {
            header = this._clientctrlBeanQueue.size() > 0 ? this._clientctrlBeanQueue.removeFirst() : this.allocateClientCtrlHeaderBean();
        }
        header.reset();
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnWireMessage(WireMessage wm) {
        HeaderDescriptionBean h = wm.getHeaderBean();
        if (h != null) {
            if (h instanceof SmpHeaderBean) {
                this.returnSmpHeaderBean((SmpHeaderBean)h);
            } else if (h instanceof AssuredCtrlHeaderBean) {
                this.returnAdctrlHeaderBean((AssuredCtrlHeaderBean)h);
            } else if (h instanceof ClientCtrlHeaderBean) {
                this.returnClientCtrlHeaderBean((ClientCtrlHeaderBean)h);
            }
        }
        this.returnSMFHeaderBean(wm.getSmfHeader());
        LinkedList<WireMessage> linkedList = this._wireMessageQueue;
        synchronized (linkedList) {
            if (this._wireMessageQueue.size() < 10240) {
                this._wireMessageQueue.addLast(wm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnSMFHeaderBean(SMFHeaderBean header) {
        LinkedList<SMFHeaderBean> linkedList = this._smfBeanQueue;
        synchronized (linkedList) {
            if (this._smfBeanQueue.size() < 10240) {
                this._smfBeanQueue.addLast(header);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnSmpHeaderBean(SmpHeaderBean header) {
        LinkedList<SmpHeaderBean> linkedList = this._smpBeanQueue;
        synchronized (linkedList) {
            if (this._smpBeanQueue.size() < 10240) {
                this._smpBeanQueue.addLast(header);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnAdctrlHeaderBean(AssuredCtrlHeaderBean header) {
        LinkedList<AssuredCtrlHeaderBean> linkedList = this._adctrlBeanQueue;
        synchronized (linkedList) {
            if (this._adctrlBeanQueue.size() < 10240) {
                this._adctrlBeanQueue.addLast(header);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnClientCtrlHeaderBean(ClientCtrlHeaderBean header) {
        LinkedList<ClientCtrlHeaderBean> linkedList = this._clientctrlBeanQueue;
        synchronized (linkedList) {
            if (this._clientctrlBeanQueue.size() < 10240) {
                this._clientctrlBeanQueue.addLast(header);
            }
        }
    }

    private WireMessage allocateWireMessage() {
        return WireMessageFactory.create();
    }

    private SMFHeaderBean allocateSMFHeaderBean() {
        return new SMFHeaderBean();
    }

    private SmpHeaderBean allocateSmpHeaderBean() {
        return new SmpHeaderBean();
    }

    private AssuredCtrlHeaderBean allocateAdctrlHeaderBean() {
        return new AssuredCtrlHeaderBean();
    }

    private ClientCtrlHeaderBean allocateClientCtrlHeaderBean() {
        return new ClientCtrlHeaderBean();
    }
}

