/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solace.transport.SolTransport;
import com.solace.transport.SolTransportBuilder;
import com.solace.transport.TransportCompressionConfiguration;
import com.solace.transport.TransportConfiguration;
import com.solace.transport.TransportEventExceptionHandler;
import com.solace.transport.TransportHttpProxyConfiguration;
import com.solace.transport.TransportSSLConfiguration;
import com.solace.transport.TransportSockProxyConfiguration;
import com.solace.transport.impl.netty.NettySolTransportBuilder;
import com.solacesystems.common.HostInfo;
import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.InvalidPropertiesException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPSecurityException;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.WireMessageEncoder;
import com.solacesystems.jcsmp.impl.client.ClientRequestResponse;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimer;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimerQueue;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.SeqNumAllocator;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.WireMessageHandler;
import com.solacesystems.jcsmp.protocol.impl.SeqNum63bAllocator;
import com.solacesystems.jcsmp.protocol.impl.SmfUhUtil;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.smf.SMFFrameHandler;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFWireMessageHandler;
import com.solacesystems.jcsmp.protocol.smf.SmfClientIOException;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.TransportWireMessageHandler;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeBasicParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeClientCertificateParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeKRBParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeOauth2Parameters;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactorySmf;
import com.solacesystems.jcsmp.secure.JCSMPSecureProtocolSocketFactory;
import com.solacesystems.jcsmp.secure.SecureProperties;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class SimpleSmfClient {
    public static final int WRCODE_OK = 0;
    public static final int WRCODE_DROPPED = 1;
    public static final int NOT_CONNECTED = 2;
    private final LogWrapper Trace = new LogWrapper(SimpleSmfClient.class);
    protected AuthenticationSchemeParameters authParams;
    protected int connTimeout;
    protected int sockTimeout;
    protected String remoteHost;
    protected int remotePort;
    protected volatile boolean isconnected;
    protected boolean tcpNoDelay;
    protected int so_sndbuf;
    protected int so_rcvbuf;
    protected InetAddress localAddress;
    protected TlvParameterFactorySmf smfParamFactory = TlvParameterFactorySmf.instance();
    protected SMFWireMessageHandler wirehandler = new SMFWireMessageHandler();
    protected JCSMPSessionStats sessionStats;
    private SeqNumAllocator ctrl_seqAlloc;
    protected final boolean useIntermediateDirectBuf;
    protected final AtomicLong m_bytesWrittenCtr = new AtomicLong();
    protected volatile SS _sharedSocketState;
    protected final ContextImpl context;
    protected final Object _stateLock = new Object();
    protected final Semaphore _writeCompleteSem = new Semaphore(0);
    protected volatile int _connCounter = 0;
    protected static int DEFAULT_SEND_BUF_SIZE = 4096;
    protected ByteBuffer _pubDirectSendBuf = null;
    protected PriorityData _priorityData = new PriorityData();
    protected PriorityDataTimerHandler _priorityDataTimerHandler = new PriorityDataTimerHandler(this._priorityData, this);
    private static final AtomicInteger smfclient_counter = new AtomicInteger();
    protected final int _smfClientId;
    protected JCSMPChannelProperties _cprops;
    private boolean enableRxTimestamps;
    private volatile SolTransport transport_adapter;
    private final Object adapter_update_lock = new Object();
    private int zip_level;
    private final TransportWireMessageHandler messageListener;
    private final TransportEventExceptionHandler event_exception_handler;
    private final SolTransportBuilder.SocketReadabilityListener socketReadabilityListener;
    private final SecureProperties secureProps;
    private ArrayBlockingQueue<Object> _responseQ = null;
    private final Object responseQueueLock = new Object();
    private final Semaphore _responseQSem = new Semaphore(0);
    private static final int WEBSOCKET_FRAME_MAX = 0x4000000;
    protected Exception _clientException;
    protected ByteBuffer outMessageBuf = null;
    private boolean isSecure;
    private boolean isWebSocketClient = false;
    public static final int C_CLOSED = 1;
    public static final int C_CONNECTING = 2;
    public static final int C_RECON_STARTED = 3;
    private static final Oid krb5Mechanism = SimpleSmfClient.createKRB5Mechanism();

    public String toString() {
        return String.format("SimpleSmfClient (%s) state=%s", new Object[]{this._smfClientId, this._sharedSocketState});
    }

    public ContextImpl getContext() {
        return this.context;
    }

    public int getLocalPort() throws JCSMPException {
        return this.getTransportAdapter().getLocalAddress().getPort();
    }

    public boolean isSecuredClient() {
        return this.isSecure;
    }

    public boolean isCompressionEnabled() {
        return this.zip_level > 0;
    }

    public void setLogContextInfo(String info) {
        this.Trace.setContextInfo(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNetworkInfoString() throws JCSMPException {
        Object object = this.adapter_update_lock;
        synchronized (object) {
            if (this.transport_adapter != null) {
                return this.getTransportAdapter().toString();
            }
            return "";
        }
    }

    protected SimpleSmfClient(AuthenticationSchemeParameters authParams, JCSMPProperties prop, JCSMPChannelProperties channelProp, SecureProperties secureProps, JCSMPSessionStats sessionStats, ContextImpl context, TransportWireMessageHandler messageListener, TransportEventExceptionHandler eventExceptionHandler, SolTransportBuilder.SocketReadabilityListener socketReadabilityListener) {
        this.context = context;
        this.authParams = authParams;
        this.sessionStats = sessionStats;
        this.ctrl_seqAlloc = new SeqNum63bAllocator("controlCorrelationSeqAllocator");
        this.useIntermediateDirectBuf = prop.getBooleanProperty("pub_use_intermediate_direct_buf");
        this.enableRxTimestamps = prop.getBooleanProperty("generate_rcv_timestamps");
        this._smfClientId = smfclient_counter.incrementAndGet();
        this.ctrl_seqAlloc.getNext63b();
        this._cprops = channelProp;
        this.zip_level = channelProp.getCompressionLevel();
        this.messageListener = messageListener;
        this.event_exception_handler = eventExceptionHandler;
        this.socketReadabilityListener = socketReadabilityListener;
        this.secureProps = secureProps;
        this.initState();
        this.outMessageBuf = this.useIntermediateDirectBuf ? ByteBuffer.allocateDirect(DEFAULT_SEND_BUF_SIZE) : ByteBuffer.allocate(DEFAULT_SEND_BUF_SIZE);
    }

    public final void initState() {
        this._sharedSocketState = SS.STARTSTATE;
    }

    public final void closeState() {
        this._writeCompleteSem.release();
        this._sharedSocketState = SS.CLOSED;
    }

    public boolean hasConnectedNotClosed() {
        return !this.isClosed() && this._responseQ == null;
    }

    public SeqNumAllocator getCtrl_seqAlloc() {
        return this.ctrl_seqAlloc;
    }

    public void setClientProps(JCSMPChannelProperties cprops) {
        this._cprops = cprops;
    }

    public void enqueuePriorityData(WireMessage wmsg) {
        this._priorityData.enqueue(wmsg, this);
    }

    protected void readMessage(InputStream istr, WireMessage msg) throws IOException {
        this.wirehandler.readMessage(istr, msg);
        int bytes_read = msg.getSmfHeader().getMsgTotalLenWithHeader();
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_RECVED, bytes_read);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notWaitingForLoginResponse(Object o) {
        Object object = this.responseQueueLock;
        synchronized (object) {
            if (this._responseQ == null || !this._responseQ.isEmpty()) {
                return true;
            }
            this._responseQ.add(o);
            this._responseQSem.release();
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("responseQ enqueue object " + o.toString());
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WireMessage sendLoginRequestAwaitForResponse(WireMessage request, boolean setAuth) throws Throwable {
        WireMessage response;
        block29: {
            HeaderDescriptionBean encap_hdr;
            int encap_param_uhcheck;
            long corrTag;
            block28: {
                corrTag = this.conditionalAddCorrelationTag(request);
                if (!this.connected()) {
                    this.open();
                }
                Object object = this.responseQueueLock;
                synchronized (object) {
                    this._responseQ = new ArrayBlockingQueue(1);
                    this._responseQSem.drainPermits();
                }
                this.doPostNoResponse(request, setAuth);
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("waiting for Login response");
                }
                response = null;
                try {
                    Object o = null;
                    if (!this._responseQSem.tryAcquire(this._cprops.getReadTimeoutInMillis(), TimeUnit.MILLISECONDS)) {
                        throw new JCSMPTransportException("Login request timeout");
                    }
                    Object object2 = this.responseQueueLock;
                    synchronized (object2) {
                        o = this._responseQ.poll();
                        this._responseQ = null;
                    }
                    if (o instanceof WireMessage) {
                        response = (WireMessage)o;
                        break block28;
                    }
                    if (o instanceof Throwable) {
                        throw (Throwable)o;
                    }
                    throw new JCSMPException("unexpected response " + o.toString());
                }
                catch (InterruptedException e) {
                    throw new JCSMPInterruptedException("waiting response nterrupted", e);
                }
                finally {
                    this._responseQ = null;
                }
            }
            response = SmfUhUtil.validateUH(response, this.sessionStats);
            if (response != null && response.getHeaderBean() != null && (encap_param_uhcheck = SmfUhUtil.testValidateUHParams(encap_hdr = response.getHeaderBean(), this.sessionStats)) == 2) {
                response = null;
            }
            if (response == null) {
                throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("SimpleSmfClient.droppedUnknownElement"));
            }
            SMFHeaderBean smfResponseHeader = response.getSmfHeader();
            if (smfResponseHeader.getPm_respcode() == -1) {
                throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("SimpleSmfClient.expectedResponseParameter"));
            }
            if (smfResponseHeader.getPm_corrtag() != -1 && corrTag != (long)smfResponseHeader.getPm_corrtag()) {
                throw new InvalidMessageReceivedException(String.format("Invalid message: expected CorrelationTag (%s), got (%s).", corrTag, smfResponseHeader.getPm_corrtag()));
            }
            if (this.authParams instanceof AuthenticationSchemeKRBParameters) {
                final AuthenticationSchemeKRBParameters krbAuthParams = (AuthenticationSchemeKRBParameters)this.authParams;
                if (krbAuthParams.useMutualAuthentication() && smfResponseHeader.getPm_gssapiToken() != null) {
                    final byte[] inToken = smfResponseHeader.getPm_gssapiToken();
                    Object serviceTicket = Subject.doAs(krbAuthParams.getLoginContext().getSubject(), new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                return krbAuthParams.getGSSContext().initSecContext(inToken, 0, inToken.length);
                            }
                            catch (Throwable t) {
                                return t;
                            }
                        }
                    });
                    if (serviceTicket instanceof Throwable) {
                        throw new JCSMPSecurityException("Error mutually authenticating", (Throwable)serviceTicket);
                    }
                    if (!krbAuthParams.getGSSContext().isEstablished()) {
                        throw new JCSMPSecurityException("Error initializing security context - not established");
                    }
                    if (serviceTicket != null) {
                        throw new JCSMPSecurityException("Error initializing security context - continuation");
                    }
                }
                if (krbAuthParams.getGSSContext() != null) {
                    try {
                        krbAuthParams.getGSSContext().dispose();
                    }
                    catch (GSSException e) {
                        if (!this.Trace.isWarnEnabled()) break block29;
                        this.Trace.warn("Error disposing of GSS context", e);
                    }
                }
            }
        }
        return response;
    }

    public void doPostNoResponse(WireMessage request, boolean setAuth) throws Throwable {
        if (setAuth) {
            this.setAuth(request);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.wirehandler.writeMessage(baos, request);
        this.getTransportAdapter().write(ByteBuffer.wrap(baos.toByteArray()));
    }

    public int beginReconnection() throws InterruptedException {
        int loops = 0;
        Object object = this._stateLock;
        synchronized (object) {
            String threadName = Thread.currentThread().getName();
            while (true) {
                if (this._sharedSocketState == SS.CONNECTING) {
                    this.Trace.debug(threadName + String.format(" (smfclient %s) =======>_sharedSocketState=%s; reconnect already started, abort", new Object[]{this._smfClientId, this._sharedSocketState}));
                    return 2;
                }
                if (this._sharedSocketState == SS.CLOSED) {
                    this.Trace.debug(threadName + String.format(" (smfclient %s) =======>_sharedSocketState=%s; reconnect abort", new Object[]{this._smfClientId, this._sharedSocketState}));
                    return 1;
                }
                if (this._sharedSocketState == SS.PRERECONNECT || this._sharedSocketState == SS.READY_TO_WRITE || loops > 10) {
                    this.Trace.debug(String.format("%s (smfclient %s) =======>_sharedSocketState=%s; change to CONNECTING; begin reconnect", new Object[]{threadName, this._smfClientId, this._sharedSocketState}));
                    this._sharedSocketState = SS.CONNECTING;
                    this._priorityData.clear();
                    this.outMessageBuf = null;
                    if (this._pubDirectSendBuf != null) {
                        this._pubDirectSendBuf.clear();
                    }
                    this._writeCompleteSem.release();
                    return 3;
                }
                this.Trace.debug(String.format("%s (smfclient %s) =======>_sharedSocketState=%s; begin reconnection (waiting...)", new Object[]{threadName, this._smfClientId, this._sharedSocketState}));
                ++loops;
                this._stateLock.wait(100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endReconnection(boolean success, SS stateOnSuccess, SS expectedState, int timeout) throws JCSMPTransportException {
        Object object = this._stateLock;
        synchronized (object) {
            if (success) {
                long endTime = System.currentTimeMillis() + (long)timeout;
                try {
                    while (expectedState != null && this._sharedSocketState != expectedState) {
                        this._stateLock.wait(100L);
                        if (System.currentTimeMillis() <= endTime) continue;
                        throw new JCSMPTransportException("endReconnection:Timeout setting state " + (Object)((Object)stateOnSuccess) + " (expected=" + (Object)((Object)expectedState) + " actual=" + (Object)((Object)this._sharedSocketState) + ") (smfclient " + this.getSmfClientId() + ")");
                    }
                }
                catch (InterruptedException e) {
                    throw new JCSMPTransportException("endReconnection:Interrupted setting state " + (Object)((Object)stateOnSuccess));
                }
                this._sharedSocketState = stateOnSuccess;
            } else {
                this._sharedSocketState = SS.CLOSED;
            }
            this.Trace.debug(String.format("%s (smfclient %s)====> notifyAll reconnect end success=%s newstate=%s", new Object[]{Thread.currentThread().getName(), this._smfClientId, success, this._sharedSocketState}));
            this._stateLock.notifyAll();
            this._writeCompleteSem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endPostReconnect() {
        Object object = this._stateLock;
        synchronized (object) {
            this.Trace.debug(String.format("%s (smfclient %s)====> notifyAll post reconnect end", Thread.currentThread().getName(), this._smfClientId));
            this._stateLock.notifyAll();
        }
    }

    public SS getSharedSocketState() {
        return this._sharedSocketState;
    }

    public int doSmfSharedWrite(WireMessage request, ByteBuffer[] requestBB, boolean setAuth, boolean setCorrTag, boolean isLowPriorityData, boolean allowOnStateSub, boolean blockForLowPriorityWrite, boolean stopOnNoconnection) throws JCSMPException, IOException, InterruptedException {
        return this.doSmfSharedWrite(request, requestBB, setAuth, setCorrTag, isLowPriorityData, allowOnStateSub, blockForLowPriorityWrite, null, null, null, null, stopOnNoconnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doSmfSharedWrite(WireMessage request, ByteBuffer[] requestBB, boolean setAuth, boolean setCorrTag, boolean isLowPriorityData, boolean allowOnStateSub, boolean blockForLowPriorityWrite, Integer idTag, TcpClientChannel channel, ClientRequestResponse req, Long corrId, boolean stopOnNoconnection) throws JCSMPException, IOException, InterruptedException {
        if (setAuth) {
            this.setAuth(request);
        }
        if (setCorrTag) {
            long corr;
            if (corrId != null) {
                this.conditionalAddCorrelationTag(request, corrId);
                corr = corrId;
            } else {
                corr = this.conditionalAddCorrelationTag(request);
            }
            req.setLastCorrelationTag((int)corr);
        }
        SS return_to_state = null;
        Object object = this._stateLock;
        synchronized (object) {
            while (this._sharedSocketState != SS.READY_TO_WRITE && this._sharedSocketState != SS.CLOSED) {
                if (stopOnNoconnection && (this._sharedSocketState == SS.CONNECTING || this._sharedSocketState == SS.STARTSTATE || this._sharedSocketState == SS.PRERECONNECT)) {
                    return 2;
                }
                if (allowOnStateSub && this._sharedSocketState == SS.SUB_ESTABLISH) break;
                if (isLowPriorityData && (!blockForLowPriorityWrite || this._sharedSocketState != SS.WRITING)) {
                    this.Trace.debug(String.format("(smfclient %s) doSmfSharedWrite: skipping low-priority write request (would block), caller will retry, state=%s", new Object[]{this._smfClientId, this._sharedSocketState}));
                    return 1;
                }
                this._stateLock.wait(200L);
            }
            if (this._sharedSocketState == SS.CLOSED) {
                throw new SmfClientIOException("Lost connection to the router.", this._connCounter);
            }
            return_to_state = this._sharedSocketState;
            this._sharedSocketState = SS.WRITING;
            this._writeCompleteSem.drainPermits();
        }
        int write_loop_return = 0;
        try {
            Object outBufLocal;
            if (this._priorityData.hasWork()) {
                this.servicePriorityQueuedData();
            }
            if (idTag != null && idTag.intValue() != this.getConnCounter()) {
                write_loop_return = 1;
                this.Trace.debug(String.format("doSmfSharedWrit discarded (Mismatched Connection IDs): %s/%s", idTag, this.getConnCounter()));
            } else {
                if (request != null && request.encoder != null && channel != null && req != null) {
                    WireMessageEncoder encoder = request.encoder;
                    request = request.encoder.encode();
                    request.encoder = encoder;
                    channel.setReqCorrelationTag(request, req.getLastCorrelationTag());
                }
                outBufLocal = this.getOutputBufferForSend(requestBB, request, this.wirehandler);
                this.getTransportAdapter().write((ByteBuffer)outBufLocal);
            }
            outBufLocal = this._stateLock;
            synchronized (outBufLocal) {
                if (this._sharedSocketState == SS.WRITING) {
                    this._sharedSocketState = return_to_state;
                    this._stateLock.notifyAll();
                }
            }
        }
        catch (Exception e) {
            if (this.Trace.isTraceEnabled()) {
                this.Trace.debug("caught exception", e);
            }
            Object object2 = this._stateLock;
            synchronized (object2) {
                if (this._sharedSocketState != SS.CONNECTING && this._sharedSocketState != SS.CLOSED) {
                    this._sharedSocketState = SS.PRERECONNECT;
                }
                this._stateLock.notifyAll();
            }
            throw new SmfClientIOException(this.getNetworkInfoString() + "Error occurred in write: " + this._clientException, this._connCounter);
        }
        return write_loop_return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueForNetOutput(ByteBuffer[] bufs) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this.outMessageBuf == null) {
                return;
            }
            int bytes_to_wr = SimpleSmfClient.remainingBytes(bufs);
            if (bytes_to_wr > this.outMessageBuf.remaining()) {
                int new_sz = (int)((double)(this.outMessageBuf.position() + bytes_to_wr) * 1.25);
                ByteBuffer b = this.useIntermediateDirectBuf ? ByteBuffer.allocateDirect(new_sz) : ByteBuffer.allocate(new_sz);
                this.outMessageBuf.flip();
                b.put(this.outMessageBuf);
                this.outMessageBuf = b;
            }
            for (ByteBuffer src : bufs) {
                this.outMessageBuf.put(src);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBuffer getOutputBufferForSend(ByteBuffer[] requestBB, WireMessage request, WireMessageHandler wirehandler) throws IOException {
        ByteBuffer outBufLocal = null;
        Object object = this._stateLock;
        synchronized (object) {
            byte[] outMessageData = null;
            if (request != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                wirehandler.writeMessage(baos, request);
                outMessageData = baos.toByteArray();
            } else if (requestBB != null) {
                outMessageData = new byte[SimpleSmfClient.remainingBytes(requestBB)];
                int i = 0;
                for (ByteBuffer b : requestBB) {
                    int len = b.remaining();
                    b.get(outMessageData, i, len);
                    i += len;
                }
            } else {
                throw new IllegalArgumentException("No request.");
            }
            outBufLocal = ByteBuffer.wrap(outMessageData, 0, outMessageData.length);
            this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_SENT, outMessageData.length);
        }
        return outBufLocal;
    }

    public static int remainingBytes(ByteBuffer[] buf_vector) {
        int rembytes = 0;
        for (ByteBuffer b : buf_vector) {
            rembytes += b.remaining();
        }
        return rembytes;
    }

    public static int limitBytes(ByteBuffer[] buf_vector) {
        int rembytes = 0;
        for (ByteBuffer b : buf_vector) {
            rembytes += b.limit();
        }
        return rembytes;
    }

    protected boolean servicePriorityQueuedData() {
        try {
            while (this._priorityData.hasWork()) {
                ByteBuffer b = this._priorityData.dequeue();
                ByteBuffer bba = this.getOutputBufferForSend(new ByteBuffer[]{b}, null, null);
                this.getTransportAdapter().write(bba);
            }
        }
        catch (Exception e) {
            this._clientException = e;
        }
        return true;
    }

    protected void setAuth(WireMessage msg) throws JCSMPException {
        SMFHeaderBean smfHeader = msg.getSmfHeader();
        if (this.authParams instanceof AuthenticationSchemeBasicParameters) {
            AuthenticationSchemeBasicParameters basicAuthParams = (AuthenticationSchemeBasicParameters)this.authParams;
            String username = basicAuthParams.getUsername();
            String password = basicAuthParams.getPassword();
            if (username == null || username.trim().length() == 0) {
                throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("SimpleSmfClient.usernameMustBeSet"));
            }
            this.conditionalAddCredentials(smfHeader, username, password);
        } else if (this.authParams instanceof AuthenticationSchemeClientCertificateParameters) {
            AuthenticationSchemeClientCertificateParameters clientCertificateAuthParameters = (AuthenticationSchemeClientCertificateParameters)this.authParams;
            if (clientCertificateAuthParameters.isUsernameSet()) {
                String username = clientCertificateAuthParameters.getUsername();
                this.conditionalAddCredentials(smfHeader, username, null);
            }
        } else if (this.authParams instanceof AuthenticationSchemeOauth2Parameters) {
            AuthenticationSchemeOauth2Parameters oAuthParams = (AuthenticationSchemeOauth2Parameters)this.authParams;
            String username = oAuthParams.getUsername();
            if (username != null) {
                this.conditionalAddCredentials(smfHeader, username, null);
            }
            this.conditionalAddOauth2Parameters(smfHeader, oAuthParams.getOidcIdToken(), oAuthParams.getOauthAccessToken(), oAuthParams.getIndentifier());
        } else if (this.authParams instanceof AuthenticationSchemeKRBParameters) {
            AuthenticationSchemeKRBParameters krbAuthParams = (AuthenticationSchemeKRBParameters)this.authParams;
            this.conditionalAddCredentials(smfHeader, krbAuthParams.getToken(), krbAuthParams.getUsername());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connected() {
        try {
            Object object = this.adapter_update_lock;
            synchronized (object) {
                if (this.transport_adapter != null) {
                    return this.getTransportAdapter().isOpen();
                }
                return false;
            }
        }
        catch (JCSMPException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClientConnected() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._sharedSocketState != SS.CLOSED && this._sharedSocketState != SS.STARTSTATE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Throwable {
        if (this.authParams instanceof AuthenticationSchemeKRBParameters) {
            AuthenticationSchemeKRBParameters krbAuthParams = (AuthenticationSchemeKRBParameters)this.authParams;
            this.getKRBToken(krbAuthParams, krbAuthParams.getServiceName() + "@" + this.remoteHost);
        }
        this._clientException = null;
        if (this.getRemoteHost() == null || this.getRemotePort() == 0) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("SimpleSmfClient.missingConnectionData"));
        }
        this.sessionStats.incStat(StatType.TOTAL_CONNECTION_ATTEMPTS);
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("(smfclient %s) Attempting to open socket, host=", this._smfClientId) + this.remoteHost + ", port=" + this.remotePort + " connection tag " + this.getConnCounter());
        }
        this.createOpenTransportAdapter();
        Object object = this._stateLock;
        synchronized (object) {
            if (this._sharedSocketState == SS.STARTSTATE) {
                this._sharedSocketState = SS.READY_TO_WRITE;
                this._stateLock.notifyAll();
            }
        }
        this.isconnected = true;
    }

    public int getConnCounter() {
        return this._connCounter;
    }

    public Integer getConnCounterTag() {
        return this._connCounter;
    }

    public synchronized void incrementConnCounterTag() {
        ++this._connCounter;
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("connection counter tag is updated: " + this._connCounter);
        }
    }

    public long getBytesWritten() {
        return this.m_bytesWrittenCtr.get();
    }

    public boolean isClosed() {
        return this._sharedSocketState == SS.CLOSED;
    }

    public void close() throws IOException, JCSMPException, InterruptedException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean isReconn) throws IOException, JCSMPException, InterruptedException {
        SolTransport adapter;
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(this.getNetworkInfoString() + String.format("(smfclient %s) Closing socket", this._smfClientId));
        }
        this._priorityData.clear();
        if (!isReconn) {
            Object object = this._stateLock;
            synchronized (object) {
                this._sharedSocketState = SS.CLOSED;
                this._stateLock.notifyAll();
            }
            this.outMessageBuf = null;
        }
        if ((adapter = this.getTransportAdapter()) != null) {
            this.sessionStats.updateSocketStats(adapter);
            adapter.close();
        }
        if (!isReconn) {
            this._writeCompleteSem.release();
        }
    }

    protected long conditionalAddCorrelationTag(WireMessage postMsg) throws JCSMPException {
        long corrId = this.ctrl_seqAlloc.getNext24b();
        return this.conditionalAddCorrelationTag(postMsg, corrId);
    }

    protected long conditionalAddCorrelationTag(WireMessage postMsg, long corrId) throws JCSMPException {
        SmfTLVParameter param;
        if (postMsg.getSmfHeader() == null) {
            return -1L;
        }
        SMFHeaderBean smfh = postMsg.getSmfHeader();
        if (postMsg.isSentFlag()) {
            smfh.deleteParameters(32);
            smfh.setPm_corrtag(-1);
        }
        if ((param = (SmfTLVParameter)smfh.findFirstParameter(32)) == null) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(this.getNetworkInfoString() + "Correlation tag not found in message, adding one: " + corrId);
            }
            smfh.addParam(TlvParameterFactorySmf.instance().getCorrelationId(corrId));
            return corrId;
        }
        return NetworkByteOrderNumberUtil.threeByteToUInt(param.value);
    }

    private void conditionalAddCredentials(SMFHeaderBean smfHeader, String username, String password) {
        if (smfHeader.findFirstParameter(6) == null) {
            smfHeader.addParam(this.smfParamFactory.getUsername(username));
        }
        if (password != null && !password.trim().equals("") && smfHeader.findFirstParameter(7) == null) {
            smfHeader.addParam(this.smfParamFactory.getPassword(password));
        }
    }

    private void conditionalAddCredentials(SMFHeaderBean smfHeader, byte[] token, String username) {
        if (smfHeader.findFirstParameter(40) == null) {
            smfHeader.addParam(this.smfParamFactory.getGSSAPIToken(token));
        }
        if (username != null && !username.trim().equals("") && smfHeader.findFirstParameter(6) == null) {
            smfHeader.addParam(this.smfParamFactory.getUsername(username));
        }
    }

    private void conditionalAddOauth2Parameters(SMFHeaderBean smfHeader, String oidc_id_token, String access_token, String identifier) {
        if (smfHeader.findFirstParameter(48) == null) {
            smfHeader.addParam(this.smfParamFactory.getOauthParameters(oidc_id_token, access_token, identifier));
        }
    }

    public void updateAuthenticationParameters(AuthenticationSchemeParameters newAuthParams) {
        if (newAuthParams instanceof AuthenticationSchemeOauth2Parameters && this.authParams instanceof AuthenticationSchemeOauth2Parameters) {
            AuthenticationSchemeOauth2Parameters updates = (AuthenticationSchemeOauth2Parameters)newAuthParams;
            if (updates.getOauthAccessToken() != null) {
                ((AuthenticationSchemeOauth2Parameters)this.authParams).setOauthAccessToken(updates.getOauthAccessToken());
            }
            if (updates.getOidcIdToken() != null) {
                ((AuthenticationSchemeOauth2Parameters)this.authParams).setOidcIdToken(updates.getOidcIdToken());
            }
        }
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress localAddr) {
        this.localAddress = localAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(HostInfo host) {
        this.remoteHost = host.getHost();
        this.isSecure = host.isSecure();
        this.isWebSocketClient = host.isWebSocketEnabled();
        if (host.getPort() == null) {
            if (host.isWebSocketEnabled()) {
                if (host.isSecure()) {
                    this.setRemotePort(443);
                } else {
                    this.setRemotePort(80);
                }
            } else if (host.isSecure()) {
                this.setRemotePort(55443);
            } else {
                this.setRemotePort(this._cprops.getSmfPort());
            }
        } else {
            this.setRemotePort(host.getPort());
        }
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getSockTimeout() {
        return this.sockTimeout;
    }

    public void setSockTimeout(int sockTimeout) {
        this.sockTimeout = sockTimeout;
    }

    public int getSO_sndbuf() {
        return this.so_sndbuf;
    }

    public void setSO_sndbuf(int so_sndbuf) {
        this.so_sndbuf = so_sndbuf;
    }

    public int getSO_rcvbuf() {
        return this.so_rcvbuf;
    }

    public void setSO_rcvbuf(int so_rcvbuf) {
        this.so_rcvbuf = so_rcvbuf;
    }

    @Deprecated
    public JCSMPSecureProtocolSocketFactory getJcsmpSecureProtocolSocketFactory() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setJcsmpSecureProtocolSocketFactory(JCSMPSecureProtocolSocketFactory jcsmpSecureProtocolSocketFactory) {
        throw new UnsupportedOperationException();
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSmfClientId() {
        return this._smfClientId;
    }

    private static Oid createKRB5Mechanism() {
        try {
            return new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void getKRBToken(AuthenticationSchemeKRBParameters krbAuthParams, String host) throws JCSMPSecurityException {
        LoginContext lc;
        try {
            if (krbAuthParams.reloadConfigFile()) {
                Configuration.getConfiguration().refresh();
            }
            lc = new LoginContext(krbAuthParams.getLoginContextName());
            lc.login();
        }
        catch (Throwable t) {
            throw new JCSMPSecurityException(String.format("Error performing login to LoginContext (%s)", t.getMessage()), t);
        }
        krbAuthParams.setLoginContext(lc);
        try {
            GSSManager manager = GSSManager.getInstance();
            GSSName serverName = manager.createName(host, GSSName.NT_HOSTBASED_SERVICE);
            final GSSContext context = manager.createContext(serverName, krb5Mechanism, null, 0);
            context.requestMutualAuth(krbAuthParams.useMutualAuthentication());
            context.requestCredDeleg(false);
            krbAuthParams.setGSSContext(context);
            final byte[] inToken = new byte[]{};
            Object serviceTicket = Subject.doAs(lc.getSubject(), new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        return context.initSecContext(inToken, 0, inToken.length);
                    }
                    catch (Throwable t) {
                        return t;
                    }
                }
            });
            if (serviceTicket instanceof Throwable) {
                throw (Throwable)serviceTicket;
            }
            if (this.Trace.isWarnEnabled() && !krbAuthParams.useMutualAuthentication() && !context.isEstablished()) {
                this.Trace.warn("Context not established with mutual authentication off");
            }
            krbAuthParams.setToken((byte[])serviceTicket);
        }
        catch (Throwable t) {
            throw new JCSMPSecurityException(String.format("Error initializing security context (%s)", t.getMessage()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCompression() throws JCSMPException {
        try {
            Object object = this.adapter_update_lock;
            synchronized (object) {
                if (this.transport_adapter != null) {
                    this.transport_adapter.enableCompression(this.zip_level);
                }
            }
        }
        catch (Exception e) {
            throw new JCSMPException("failed to enable compression", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownSSL() throws JCSMPException {
        try {
            Object object = this.adapter_update_lock;
            synchronized (object) {
                if (this.transport_adapter != null) {
                    this.transport_adapter.shutdownSSL();
                }
            }
        }
        catch (Exception e) {
            throw new JCSMPException("failed to shutdown SSL", e);
        }
    }

    private void logProviders(SSLContext context) {
        ArrayList<String> providerList = new ArrayList<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            providerList.add(providers[i].getName());
        }
        this.Trace.debug("Supported Providers: " + providerList);
        this.Trace.debug("Selected Provider: " + context.getProvider());
    }

    private SSLContext createSSLContext() throws JCSMPException {
        try {
            SSLContext context = SSLContext.getInstance("TLSv1");
            context.init(this.secureProps.getKeyManagers(), this.secureProps.getTrustManagers(), null);
            if (this.Trace.isDebugEnabled()) {
                this.logProviders(context);
            }
            return context;
        }
        catch (Exception e) {
            throw new JCSMPException("Error initializing context", e);
        }
    }

    private TransportSSLConfiguration getTransportSSLServiceAttributes() throws JCSMPException {
        TransportSSLConfiguration attrs = new TransportSSLConfiguration(this.createSSLContext());
        return attrs.setSpecifiedProtocols(this.secureProps.getProtocols()).setHostNameValidation(this.secureProps.isHostnameValidationEnabled() && this.secureProps.validateCertificate()).setApiSupportedProtocols(SecureProperties.SupportedProtocols).setSpecifiedCipherSuites(this.secureProps.getCipherSuites()).setApiCipherMap(SecureProperties.CipherMap).setApiCipherAliasesMap(SecureProperties.CipherAliasesMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolTransport getTransportAdapter() throws JCSMPException {
        Object object = this.adapter_update_lock;
        synchronized (object) {
            if (this.transport_adapter == null) {
                throw new JCSMPTransportException("netty channel not created");
            }
            return this.transport_adapter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOpenTransportAdapter() throws Throwable {
        TransportConfiguration transportOptions = new TransportConfiguration(this.remoteHost, this.remotePort).setConnectTimeoutInMillis(this.connTimeout).setTcpNoDelay(this.tcpNoDelay).setIdleReadTimeout(this.sockTimeout).setSoRcvBuf(this.so_rcvbuf > 0 ? Integer.valueOf(this.so_rcvbuf) : null).setSoSndBuf(this.so_sndbuf > 0 ? Integer.valueOf(this.so_sndbuf) : null).setLocalAddress(this.localAddress).setUseDirectBuf(this.useIntermediateDirectBuf);
        String host = System.getProperty("solace.proxy.host");
        if (host != null) {
            String port_str = System.getProperty("solace.proxy.port");
            String username = System.getProperty("solace.proxy.username");
            String passwd = System.getProperty("solace.proxy.password");
            String proxyType = System.getProperty("solace.proxy.type");
            if (username != null && passwd == null) {
                throw new InvalidPropertiesException("proxy username '" + username + "' does not have a password!");
            }
            if (proxyType == null || "http".equalsIgnoreCase(proxyType) || "httpc".equalsIgnoreCase(proxyType)) {
                if (username != null) {
                    if (port_str != null) {
                        transportOptions.setHttpProxyConfig(new TransportHttpProxyConfiguration(host).withUsernamePassword(username, passwd).withPort(Integer.parseInt(port_str)));
                    } else {
                        transportOptions.setHttpProxyConfig(new TransportHttpProxyConfiguration(host).withUsernamePassword(username, passwd));
                    }
                } else if (port_str != null) {
                    transportOptions.setHttpProxyConfig(new TransportHttpProxyConfiguration(host).withPort(Integer.parseInt(port_str)));
                } else {
                    transportOptions.setHttpProxyConfig(new TransportHttpProxyConfiguration(host));
                }
            } else if ("socks5".equalsIgnoreCase(proxyType)) {
                if (username != null) {
                    if (port_str != null) {
                        transportOptions.setSockProxyConfig(new TransportSockProxyConfiguration(host).withUsernamePassword(username, passwd).withPort(Integer.parseInt(port_str)));
                    } else {
                        transportOptions.setSockProxyConfig(new TransportSockProxyConfiguration(host).withUsernamePassword(username, passwd));
                    }
                } else if (port_str != null) {
                    transportOptions.setSockProxyConfig(new TransportSockProxyConfiguration(host).withPort(Integer.parseInt(port_str)));
                } else {
                    transportOptions.setSockProxyConfig(new TransportSockProxyConfiguration(host));
                }
            } else {
                throw new InvalidPropertiesException("invalid proxy server type (only 'http' and 'socks5' allowed): " + proxyType);
            }
        }
        if (this.isSecuredClient()) {
            transportOptions.setSSLConfig(this.getTransportSSLServiceAttributes());
        } else if (this.isCompressionEnabled()) {
            transportOptions.setCompressionConfig(new TransportCompressionConfiguration(this.zip_level));
        }
        if (this.isWebSocketClient) {
            transportOptions.setWebsocket(true);
            transportOptions.setWebsocketFrameSize(0x4000000);
        }
        NettySolTransportBuilder builder = new NettySolTransportBuilder(this.context.getIOReactor(), this.event_exception_handler, this.getConnCounter());
        builder.withConfiguration(transportOptions).withSocketReadabilityListener(this.socketReadabilityListener).withFrameDecoder(new SMFFrameHandler(this.enableRxTimestamps, this.messageListener));
        SolTransport adapter = builder.build();
        adapter.open(this.sessionStats.getSocketStats());
        Object object = this.adapter_update_lock;
        synchronized (object) {
            this.transport_adapter = adapter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSocketStat(StatType t) {
        long stat = 0L;
        Object object = this.adapter_update_lock;
        synchronized (object) {
            if (this.transport_adapter != null) {
                if (t.equals(StatType.TOTAL_SOCKET_BYTES_RECVED)) {
                    stat = this.transport_adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_BYTES_RECVED);
                } else if (t.equals(StatType.TOTAL_SOCKET_BYTES_SENT)) {
                    stat = this.transport_adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_BYTES_SENT);
                } else if (t.equals(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_RECVED)) {
                    stat = this.transport_adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_COMPRESSED_BYTES_RECVED);
                } else if (t.equals(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_SENT)) {
                    stat = this.transport_adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_COMPRESSED_BYTES_SENT);
                } else if (t.equals(StatType.TOTAL_SOCKET_SSL_BYTES_RECVED)) {
                    stat = this.transport_adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_SSL_BYTES_RECVED);
                } else if (t.equals(StatType.TOTAL_SOCKET_SSL_BYTES_SENT)) {
                    stat = this.transport_adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_SSL_BYTES_SENT);
                } else if (t.equals(StatType.TOTAL_SOCKET_WEBSOCKET_BYTES_RECVED)) {
                    stat = this.transport_adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_WEBSOCKET_BYTES_RECVED);
                } else if (t.equals(StatType.TOTAL_SOCKET_WEBSOCKET_BYTES_SENT)) {
                    stat = this.transport_adapter.getTransportStats(SolTransport.Stats.TOTAL_SOCKET_WEBSOCKET_BYTES_SENT);
                }
            }
        }
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("getSocketStat " + t + ":" + stat);
        }
        return stat;
    }

    public static class PriorityData {
        protected final AtomicBoolean HasWork = new AtomicBoolean(false);
        protected LinkedList<ByteBuffer> mBuffers = new LinkedList();
        protected JCSMPTimer mTimer = null;

        public final boolean hasWork() {
            return this.HasWork.get();
        }

        public synchronized void enqueue(ByteBuffer buf, SimpleSmfClient parentSmfClient) {
            this.mBuffers.add(buf);
            this.HasWork.set(true);
            parentSmfClient._priorityDataTimerHandler.schedule();
        }

        public synchronized ByteBuffer dequeue() {
            ByteBuffer o = this.mBuffers.remove();
            if (this.mBuffers.isEmpty()) {
                this.HasWork.set(false);
            }
            return o;
        }

        public void enqueue(WireMessage request, SimpleSmfClient parentSmfClient) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SMFWireMessageHandler wirehandler = new SMFWireMessageHandler();
            try {
                wirehandler.writeMessage(baos, request);
                ByteBuffer buf = ByteBuffer.wrap(baos.toByteArray());
                this.enqueue(buf, parentSmfClient);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public synchronized ByteBuffer peek() {
            return this.mBuffers.peek();
        }

        public synchronized void clear() {
            this.mBuffers.clear();
            this.HasWork.set(false);
        }

        public synchronized String toString() {
            return "[HasWork: " + this.hasWork() + ", QueueDepth: " + this.mBuffers.size() + "]";
        }
    }

    protected static class PriorityDataTimerHandler
    implements JCSMPTimeoutHandler {
        private final PriorityData mPrioData;
        private final SimpleSmfClient mSmfClient;

        public PriorityDataTimerHandler(PriorityData pData, SimpleSmfClient smfClient) {
            this.mPrioData = pData;
            this.mSmfClient = smfClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule() {
            PriorityData priorityData = this.mPrioData;
            synchronized (priorityData) {
                JCSMPTimer timerObj;
                JCSMPTimer existingTimer = this.mPrioData.mTimer;
                if (existingTimer != null && existingTimer.isActive()) {
                    return;
                }
                JCSMPTimerQueue tq = this.mSmfClient.getContext().getTimeService();
                this.mPrioData.mTimer = timerObj = tq.schedule_relative(10L, this);
            }
        }

        @Override
        public void handleTimeout() {
            if (this.mPrioData == null || !this.mPrioData.hasWork()) {
                return;
            }
            ByteBuffer[] dummyBuf = new ByteBuffer[]{ByteBuffer.allocate(0)};
            try {
                int ret = this.mSmfClient.doSmfSharedWrite(null, dummyBuf, false, false, true, true, false, false);
                if (ret == 0) {
                    return;
                }
                this.schedule();
            }
            catch (Exception e) {
                this.schedule();
            }
        }
    }

    public static enum SS {
        WRITING,
        READY_TO_WRITE,
        CONNECTING,
        CLOSED,
        STARTSTATE,
        PRERECONNECT,
        SUB_ESTABLISH;

    }
}

