/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jms.SolQueueConnection;
import com.solacesystems.jms.SolXAQueueSession;
import com.solacesystems.jms.SolXASession;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.property.JMSProperties;
import javax.jms.JMSException;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;

public class SolXAQueueConnection
extends SolQueueConnection
implements XAQueueConnection {
    private final LogWrapper log = new LogWrapper(SolXAQueueConnection.class);

    public SolXAQueueConnection(JMSProperties properties) throws JMSException {
        super(properties, true);
        this.log.setContextInfo(this.getLogContextInfo());
    }

    public SolXAQueueConnection(JMSProperties properties, String userName, String password) throws JMSException {
        super(properties, true, userName, password);
        this.log.setContextInfo(this.getLogContextInfo());
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering createXAQueueSession()");
        }
        this.checkClosed();
        Validator.checkTransactedAndAckMode(SessionTransactionType.XATransaction, 0, this.mConnectionProps.getPropertyBean().getDirectTransport());
        Validator.checkTransactedAndLargeMessaging(SessionTransactionType.XATransaction, this.mJCSMPProperties.getBooleanProperty("large_messaging"));
        this.mHasBeenAccessed = true;
        SolXAQueueSession newSession = new SolXAQueueSession(this, this.mState);
        this.mSessions.add(newSession);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving createXAQueueSession()");
        }
        return newSession;
    }

    public XASession createXASession() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering createXASession()");
        }
        this.checkClosed();
        Validator.checkTransactedAndAckMode(SessionTransactionType.XATransaction, 0, this.mConnectionProps.getPropertyBean().getDirectTransport());
        Validator.checkTransactedAndLargeMessaging(SessionTransactionType.XATransaction, this.mJCSMPProperties.getBooleanProperty("large_messaging"));
        this.mHasBeenAccessed = true;
        SolXASession newSession = new SolXASession(this, this.mState);
        this.mSessions.add(newSession);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving createXASession()");
        }
        return newSession;
    }
}

