/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jms.impl.AckHandler;
import com.solacesystems.jms.impl.ConnectionProperties;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.SessionUserProperty;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionProperties {
    private ConnectionProperties mConnectionProps;
    private SessionTransactionType mTransactionType;
    private int mAcknowledgeMode;
    private AckHandler mAckHandler;
    private Map<String, SessionUserProperty> mUserProps;

    public SessionProperties(ConnectionProperties connectionProps, SessionTransactionType transactionType, int acknowledgeMode, AckHandler ackHandler) {
        this.mConnectionProps = connectionProps;
        this.mTransactionType = transactionType;
        this.mAcknowledgeMode = this.mTransactionType != SessionTransactionType.NoTransaction ? 0 : acknowledgeMode;
        this.mAckHandler = ackHandler;
        this.mUserProps = new HashMap<String, SessionUserProperty>();
    }

    public void enableXA() {
        this.mTransactionType = SessionTransactionType.XATransaction;
        this.mAcknowledgeMode = 0;
    }

    public ConnectionProperties getConnectionProperties() {
        return this.mConnectionProps;
    }

    public SessionTransactionType getTransactionType() {
        return this.mTransactionType;
    }

    public int getAcknowledgeMode() {
        return this.mAcknowledgeMode;
    }

    public AckHandler getAckHandler() {
        return this.mAckHandler;
    }

    public Map<String, SessionUserProperty> getUserProperties() {
        return this.mUserProps;
    }

    public String toString() {
        String fmt = String.format("SessionProperties(TransactionType:%s AcknowledgeMode:%s ConnectionProperties:%s)", new Object[]{this.mTransactionType, this.mAcknowledgeMode, this.mConnectionProps});
        return fmt;
    }
}

