/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.queues;

import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.impl.flow.FlowHandle;
import com.solacesystems.jcsmp.impl.queues.AbstractUnackedMessageList;
import com.solacesystems.jcsmp.impl.queues.AppAckRangeCache;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WindowAckMessageList
extends AbstractUnackedMessageList {
    private static final Log Trace = LogFactory.getLog(AbstractUnackedMessageList.class);
    private final int m_sz;
    private final LinkedList<AbstractUnackedMessageList.MessageAckInfo> m_list;
    private volatile transient long m_highestAppAcked = 0L;
    private volatile transient long m_lastInOrderTpMsgId = 0L;
    private final int m_queueSize;

    public WindowAckMessageList(int size, FlowHandle flow) {
        super(flow);
        this.m_sz = size;
        this.m_list = new LinkedList();
        this.m_queueSize = 1024;
    }

    public WindowAckMessageList(int size, FlowHandle flow, int queueSize) {
        super(flow);
        this.m_sz = size;
        this.m_list = new LinkedList();
        this.m_queueSize = queueSize;
    }

    @Override
    public void clear() {
        this.rLock.lock();
        try {
            this.m_list.clear();
            this.m_highestAppAcked = 0L;
            this.m_lastInOrderTpMsgId = 0L;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractUnackedMessageList.EAddResult add(long msgId) {
        this.rLock.lock();
        try {
            if (this.m_list.size() > 0 && this.m_list.getLast().msgId >= msgId) {
                AbstractUnackedMessageList.EAddResult eAddResult = AbstractUnackedMessageList.EAddResult.DUPLICATE;
                return eAddResult;
            }
            this.m_list.add(new AbstractUnackedMessageList.MessageAckInfo(msgId));
            this.m_lastInOrderTpMsgId = msgId;
            AbstractUnackedMessageList.EAddResult eAddResult = AbstractUnackedMessageList.EAddResult.OK;
            return eAddResult;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractUnackedMessageList.EAppAckResult applicationAck(long msgId, boolean forceSend) {
        boolean advanced_window = false;
        this.rLock.lock();
        try {
            Iterator it_ackinfo = this.m_list.iterator();
            while (it_ackinfo.hasNext()) {
                AbstractUnackedMessageList.MessageAckInfo mai = (AbstractUnackedMessageList.MessageAckInfo)it_ackinfo.next();
                if (mai.msgId <= msgId) {
                    it_ackinfo.remove();
                    mai.appAcked = true;
                    mai.ackSent = true;
                    if (mai.msgId <= this.m_highestAppAcked) continue;
                    this.m_highestAppAcked = mai.msgId;
                    advanced_window = true;
                    continue;
                }
                break;
            }
        }
        finally {
            this.rLock.unlock();
        }
        if (advanced_window) {
            this.sendAcks("WindowAck-AckExplicitAlways", false);
        }
        return AbstractUnackedMessageList.EAppAckResult.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractUnackedMessageList.EAppAckResult settleMsg(long msgId, XMLMessage.Outcome out) {
        boolean advanced_window = false;
        this.rLock.lock();
        try {
            Iterator it_ackinfo = this.m_list.iterator();
            while (it_ackinfo.hasNext()) {
                AbstractUnackedMessageList.MessageAckInfo mai = (AbstractUnackedMessageList.MessageAckInfo)it_ackinfo.next();
                if (mai.msgId <= msgId) {
                    it_ackinfo.remove();
                    mai.appAcked = true;
                    mai.ackSent = true;
                    if (mai.msgId <= this.m_highestAppAcked) continue;
                    this.m_highestAppAcked = mai.msgId;
                    advanced_window = true;
                    continue;
                }
                break;
            }
        }
        finally {
            this.rLock.unlock();
        }
        if (advanced_window) {
            this.sendAcks("WindowAck-AckExplicitAlways", false, out);
        }
        return AbstractUnackedMessageList.EAppAckResult.OK;
    }

    @Override
    public boolean hasUnsentAcks() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAcks(String reason, boolean allowReactorComplete) {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)String.format("WindowAck>> highestAck=%s (%s)", this.m_highestAppAcked, reason));
        }
        this.flowHandle.setNumUnackedTpMsgs(0);
        WireMessage ackMsg = null;
        Object object = this.flowHandle.getAckCreateSendLock();
        synchronized (object) {
            ackMsg = this.flowHandle.tpCreateAck();
            AppAckRangeCache rangecache = null;
            if (this.m_highestAppAcked > 0L) {
                rangecache = new AppAckRangeCache();
                rangecache.addTmp(1L, this.m_highestAppAcked);
                this.tpAddApplicationAcks((AssuredCtrlHeaderBean)ackMsg.getHeaderBean(), rangecache);
            } else {
                Trace.debug((Object)String.format("No need to add app ack!", new Object[0]));
            }
        }
        boolean locked = true;
        try {
            if (this.flowHandle.isReactorThread()) {
                locked = this.flowHandle.getAckSendingLock().tryLock();
                if (!locked) {
                    this.flowHandle.getTcpChannel().enqueuePriorityData(ackMsg);
                    return;
                }
            } else {
                this.flowHandle.getAckSendingLock().lock();
            }
            this.flowHandle.tpSendAck(ackMsg, false, allowReactorComplete);
        }
        finally {
            if (locked) {
                this.flowHandle.getAckSendingLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAcks(String reason, boolean allowReactorComplete, XMLMessage.Outcome out) {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)String.format("WindowAck>> highestAck=%s (%s)", this.m_highestAppAcked, reason));
        }
        this.flowHandle.setNumUnackedTpMsgs(0);
        WireMessage ackMsg = null;
        Object object = this.flowHandle.getAckCreateSendLock();
        synchronized (object) {
            ackMsg = this.flowHandle.tpCreateAck();
            AppAckRangeCache rangecache = null;
            if (this.m_highestAppAcked > 0L) {
                rangecache = new AppAckRangeCache();
                rangecache.addTmp(1L, this.m_highestAppAcked);
                this.tpAddApplicationAcks((AssuredCtrlHeaderBean)ackMsg.getHeaderBean(), rangecache, out);
            } else {
                Trace.debug((Object)String.format("No need to add app ack!", new Object[0]));
            }
        }
        boolean locked = true;
        try {
            if (this.flowHandle.isReactorThread()) {
                locked = this.flowHandle.getAckSendingLock().tryLock();
                if (!locked) {
                    this.flowHandle.getTcpChannel().enqueuePriorityData(ackMsg);
                    return;
                }
            } else {
                this.flowHandle.getAckSendingLock().lock();
            }
            this.flowHandle.tpSendAck(ackMsg, false, allowReactorComplete);
        }
        finally {
            if (locked) {
                this.flowHandle.getAckSendingLock().unlock();
            }
        }
    }

    @Override
    public int getWindowSize() {
        return this.getCurrentUnackedMessageListInfo().getWindowSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractUnackedMessageList.UnackedMessageListInfo getCurrentUnackedMessageListInfo() {
        this.rLock.lock();
        try {
            AbstractUnackedMessageList.UnackedMessageListInfo umli = new AbstractUnackedMessageList.UnackedMessageListInfo();
            umli.setLastInOrderTpMsgId(this.m_lastInOrderTpMsgId);
            int cur_list_sz = this.m_list.size();
            if (cur_list_sz >= this.m_queueSize) {
                umli.setWindowSize(0);
            } else {
                int rv = Math.min(this.m_sz, this.m_queueSize - cur_list_sz);
                umli.setWindowSize(rv);
            }
            AbstractUnackedMessageList.UnackedMessageListInfo unackedMessageListInfo = umli;
            return unackedMessageListInfo;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public boolean isKnownAppAcked(long msgId) {
        return false;
    }

    @Override
    public void sendCloseAcks(String reason, boolean allowReactorComplete) {
    }
}

