/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.flow;

import com.solacesystems.common.HostInfo;
import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.BrowserProperties;
import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.FlowEvent;
import com.solacesystems.jcsmp.FlowEventArgs;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.InvalidPropertiesException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFlowTransportUnsolicitedUnbindException;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPReconnectEventHandler;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.XMLMessageConsumer;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.BrowserImpl;
import com.solacesystems.jcsmp.impl.DefaultFlowQueueHookImpl;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageConsumer;
import com.solacesystems.jcsmp.impl.QueueImpl;
import com.solacesystems.jcsmp.impl.SubscriptionMap;
import com.solacesystems.jcsmp.impl.SubscriptionMatchEntry;
import com.solacesystems.jcsmp.impl.SubscriptionRemoveResult;
import com.solacesystems.jcsmp.impl.flow.BindRequestTask;
import com.solacesystems.jcsmp.impl.flow.DirectFlowHandleImpl;
import com.solacesystems.jcsmp.impl.flow.FlowEventArgsImpl;
import com.solacesystems.jcsmp.impl.flow.FlowHandle;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.flow.FlowTask;
import com.solacesystems.jcsmp.impl.flow.SharedSubscriptionManager;
import com.solacesystems.jcsmp.impl.flow.TaskSessionRefs;
import com.solacesystems.jcsmp.impl.flow.UnbindRequestTask;
import com.solacesystems.jcsmp.impl.flow.UnsubscribeRequestTask;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionImpl;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerNotificationDispatcherFactory;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterParser;
import com.solacesystems.jcsmp.statistics.StatType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

public class SubFlowManagerImpl {
    private final LogWrapper Trace = new LogWrapper(SubFlowManagerImpl.class);
    private static final int AD_DISABLED_CODE = 503;
    private static final String AD_DISABLED_PHRASE = "Service Unavailable";
    final Map<Long, FlowTask> waitingFlows;
    final Map<Long, FlowHandleImpl> activeFlows;
    final HashSet<FlowHandleImpl> managedFlows;
    TcpClientChannel subChannel;
    final JCSMPBasicSession session;
    JCSMPChannelProperties channel_props;
    final JCSMPSessionStats session_stats;
    FlowHandleImpl classicFlow;
    SubscriptionMap<FlowHandleImpl> mSubscriptionMap;
    ArrayList<SubscriptionMatchEntry<FlowHandleImpl>> match_entries;
    ArrayList<FlowHandleImpl> activeReliableFlows;
    volatile DirectFlowHandleImpl topic_demux_flow;
    final boolean topic_dispatch_opt_single_direct;
    ReentrantLock unbindLock = new ReentrantLock();
    SharedSubscriptionManager mSharedSubscriptionMgr;
    String last_host_str = "";

    public SubFlowManagerImpl(JCSMPBasicSession session) {
        this.waitingFlows = new HashMap<Long, FlowTask>();
        this.activeFlows = new HashMap<Long, FlowHandleImpl>();
        this.managedFlows = new HashSet();
        this.session = session;
        this.session_stats = session.getSessionStats();
        this.classicFlow = null;
        this.mSharedSubscriptionMgr = new SharedSubscriptionManager(session);
        if (session.getJCSMPProperties().getBooleanProperty("topic_dispatch").booleanValue()) {
            this.mSubscriptionMap = new SubscriptionMap();
            this.match_entries = new ArrayList();
            this.activeReliableFlows = new ArrayList();
            this.topic_dispatch_opt_single_direct = session.getJCSMPProperties().getBooleanProperty("topic_dispatch_optimize_direct");
        } else {
            this.mSubscriptionMap = null;
            this.match_entries = null;
            this.activeReliableFlows = null;
            this.topic_dispatch_opt_single_direct = false;
        }
        this.topic_demux_flow = null;
        this.Trace.setContextInfo(session.getLogContextInfo());
    }

    public void setSubChannel(TcpClientChannel channel) {
        this.subChannel = channel;
        if (channel != null) {
            channel.setSubFlowManager(this);
            this.channel_props = this.subChannel.getChannelProperties();
        }
    }

    public void setLastHostSpec(String hostspec) {
        this.last_host_str = hostspec;
    }

    public Map<Long, FlowHandleImpl> getActiveFlows() {
        return this.activeFlows;
    }

    private FlowHandleImpl doBind(ConsumerFlowProperties f_prop, EndpointProperties e_prop, XMLMessageListener listener, BrowserProperties b_prop, JCSMPBasicSession.InternalBindProperties internalBindProp, FlowEventHandler flowEventHander) throws JCSMPException {
        if (!this.subChannel.connected()) {
            this.subChannel.open();
        }
        TaskSessionRefs tsr = new TaskSessionRefs(this.session, this.subChannel, this);
        BindRequestTask brt = null;
        if (f_prop != null) {
            if (!this.session.isRequiredSettlementCapable(f_prop.getRequiredSettlementOutcomes())) {
                throw new InvalidPropertiesException("The broker does not support required settlement outcomes");
            }
            brt = f_prop.isConsumerRedeliveryFlowTypeRequired() ? new BindRequestTask(tsr, f_prop, e_prop, listener, null, AssuredCtrlEnums.FlowType.CONSUMER_REDELIVERY_FLOW, internalBindProp, flowEventHander) : new BindRequestTask(tsr, f_prop, e_prop, listener, null, AssuredCtrlEnums.FlowType.CONSUMER, internalBindProp, flowEventHander);
        } else if (b_prop != null) {
            ConsumerFlowProperties tmp_fprop = new ConsumerFlowProperties();
            tmp_fprop.setEndpoint(b_prop.getEndpoint());
            tmp_fprop.setSelector(b_prop.getSelector());
            tmp_fprop.setTransportWindowSize(b_prop.getTransportWindowSize());
            tmp_fprop.setReconnectRetryIntervalInMsecs(b_prop.getReconnectRetryIntervalInMsecs());
            tmp_fprop.setReconnectTries(b_prop.getReconnectTries());
            brt = new BindRequestTask(tsr, tmp_fprop, e_prop, null, null, AssuredCtrlEnums.FlowType.BROWSER, internalBindProp, flowEventHander);
        } else {
            throw new IllegalArgumentException("doBind() requires either ConsumerFlowProperties or BrowserProperties");
        }
        FlowHandleImpl fh = this.doBindBlocking(brt, false, TcpChannel.WriteBlockPolicy.DEFAULT);
        return fh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlowHandleImpl doBindBlocking(BindRequestTask brt, boolean allowOnStateSub, TcpChannel.WriteBlockPolicy write_policy) throws JCSMPException {
        int corrtag = this.getCorrelationTag();
        Map<Long, FlowTask> map = this.waitingFlows;
        synchronized (map) {
            if (this.session.isSessionReconnectAborted()) {
                throw this.session.getSessionAbortException();
            }
            this.waitingFlows.put(Long.valueOf(corrtag), brt);
        }
        brt.submit(corrtag, allowOnStateSub, write_policy);
        FlowHandleImpl fh = brt.getFlowHandler();
        return fh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBindNonblocking(BindRequestTask brt, boolean allowOnStateSub, TcpChannel.WriteBlockPolicy write_policy) throws JCSMPException {
        int corrtag = this.getCorrelationTag();
        Map<Long, FlowTask> map = this.waitingFlows;
        synchronized (map) {
            this.waitingFlows.put(Long.valueOf(corrtag), brt);
        }
        brt.submit(corrtag, allowOnStateSub, write_policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedFlow(FlowHandleImpl fh) {
        this.Trace.debug("addManagedFlow Flowid=" + fh.getFlowId());
        Map<Long, FlowHandleImpl> map = this.activeFlows;
        synchronized (map) {
            this.managedFlows.add(fh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedFlow(FlowHandleImpl fh) {
        Map<Long, FlowHandleImpl> map = this.activeFlows;
        synchronized (map) {
            this.managedFlows.remove(fh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regActiveFlow(FlowHandle fh) {
        this.Trace.debug("regActiveFlow id=" + fh.getFlowId());
        Map<Long, FlowHandleImpl> map = this.activeFlows;
        synchronized (map) {
            this.activeFlows.put(fh.getFlowId(), (FlowHandleImpl)fh);
        }
    }

    public FlowHandleImpl createSubscriberEndpointFlow(ConsumerFlowProperties f_prop, XMLMessageListener listener, JCSMPBasicSession.InternalBindProperties bindProps) throws JCSMPException {
        FlowHandleImpl fh = this.doBind(f_prop, null, listener, null, bindProps, null);
        return fh;
    }

    public FlowHandleImpl createQueueReceiver(ConsumerFlowProperties f_prop, EndpointProperties e_prop, XMLMessageListener listener, JCSMPBasicSession.InternalBindProperties bindProps, FlowEventHandler flowEventHandler) throws JCSMPException {
        FlowHandleImpl fh = this.doBind(f_prop, e_prop, listener, null, bindProps, flowEventHandler);
        return fh;
    }

    public FlowHandleImpl createBrowser(BrowserProperties b_prop, FlowEventHandler flowEventHandler, BrowserImpl browser) throws JCSMPException {
        FlowHandleImpl fh = this.doBind(null, null, null, b_prop, null, flowEventHandler);
        fh.setBrowserFlow(browser);
        return fh;
    }

    public FlowHandleImpl createDurTopicEndpointReceiver(ConsumerFlowProperties f_prop, EndpointProperties e_prop, XMLMessageListener listener, JCSMPBasicSession.InternalBindProperties bindProps, FlowEventHandler flowEventHandler) throws JCSMPException {
        FlowHandleImpl fh = this.doBind(f_prop, e_prop, listener, null, bindProps, flowEventHandler);
        return fh;
    }

    private final int getCorrelationTag() {
        return this.subChannel.getGeneralSeqAllocator().getNext24b();
    }

    private SubscriptionMap<FlowHandleImpl> getSubscriptionMap(String subscription) {
        if (SharedSubscriptionManager.isSharedOrNoExportSubscription(subscription)) {
            return this.mSharedSubscriptionMgr.getSubscriptionMap(subscription);
        }
        return this.mSubscriptionMap;
    }

    private String getSubscription(String subscription) {
        if (SharedSubscriptionManager.isSharedOrNoExportSubscription(subscription)) {
            return this.mSharedSubscriptionMgr.getShareOrNoExportSubscription(subscription);
        }
        return subscription;
    }

    private boolean isSubscriptionMapEmpty() {
        return this.mSubscriptionMap == null && this.mSharedSubscriptionMgr.isSharedOrNoExportSubscriptionEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowHandleImpl createReliableFlow(Topic topic, XMLMessageListener listener, ConsumerNotificationDispatcherFactory dispatcherFactory) throws JCSMPException {
        if (this.classicFlow != null) {
            DirectFlowHandleImpl fh = new DirectFlowHandleImpl(listener, this.session, this.subChannel, topic, dispatcherFactory);
            fh.setSubQueueHooks(new DefaultFlowQueueHookImpl(fh));
            if (this.topic_dispatch_opt_single_direct) {
                if (this.topic_demux_flow != null) {
                    throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("SubFlowManagerImpl.demuxFlowExist"));
                }
                this.topic_demux_flow = fh;
            }
            SubscriptionMap<FlowHandleImpl> subscription_db = this.getSubscriptionMap(topic.getName());
            String subscription = this.getSubscription(topic.getName());
            try {
                subscription_db.startTransaction();
                subscription_db.put(subscription, fh);
            }
            finally {
                subscription_db.commit();
            }
            boolean added = false;
            try {
                this.session.addSubscription(topic);
                added = true;
                DirectFlowHandleImpl directFlowHandleImpl = fh;
                return directFlowHandleImpl;
            }
            catch (JCSMPException e) {
                if (e instanceof JCSMPErrorResponseException && ((JCSMPErrorResponseException)e).getSubcodeEx() == 13) {
                    added = true;
                    DirectFlowHandleImpl directFlowHandleImpl = fh;
                    return directFlowHandleImpl;
                }
                try {
                    subscription_db.startTransaction();
                    subscription_db.remove(subscription, fh);
                }
                finally {
                    subscription_db.commit();
                }
                throw e;
            }
            finally {
                if (added) {
                    ArrayList<FlowHandleImpl> arrayList = this.activeReliableFlows;
                    synchronized (arrayList) {
                        this.activeReliableFlows.add(fh);
                    }
                }
            }
        }
        throw new InvalidOperationException("JCSMPSession.getMessageConsumer() must be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReliableFlow(FlowHandleImpl fh) throws JCSMPException {
        if (this.topic_dispatch_opt_single_direct && this.topic_demux_flow != null) {
            assert (fh == this.topic_demux_flow);
            this.topic_demux_flow = null;
        }
        String subscription = this.getSubscription(fh.getCachedTopic().getName());
        SubscriptionMap<FlowHandleImpl> subscription_db = this.getSubscriptionMap(fh.getCachedTopic().getName());
        try {
            subscription_db.startTransaction();
            SubscriptionRemoveResult result = subscription_db.remove(subscription, fh);
            if (result.isFound() && result.numEntriesFound() == 1) {
                this.session.removeSubscription(fh.getCachedTopic(), false);
            }
        }
        finally {
            ArrayList<FlowHandleImpl> arrayList = this.activeReliableFlows;
            synchronized (arrayList) {
                this.activeReliableFlows.remove(fh);
            }
            subscription_db.commit();
        }
    }

    public XMLMessageConsumer createXMLMessageConsumer(XMLMessageListener listener, JCSMPReconnectEventHandler reconnHandler, boolean bindDefaultQueue) throws JCSMPException {
        String subname = this.session.getJCSMPProperties().getStringProperty("username");
        this.subChannel.setReconnectEventHandler(reconnHandler);
        if (bindDefaultQueue) {
            Queue qClassic = QueueImpl.createWithInit("#sol/" + subname, true);
            this.classicFlow = this.createDefaultFlowBindDefQueue(qClassic, listener);
        } else {
            this.classicFlow = this.createDefaultFlowNoBindDefQueue(null, listener);
        }
        JCSMPXMLMessageConsumer cons = new JCSMPXMLMessageConsumer(this.classicFlow, this.session);
        return cons;
    }

    private FlowHandleImpl createDefaultFlowBindDefQueue(Queue qClassic, XMLMessageListener listener) throws JCSMPException {
        FlowHandleImpl flow = null;
        try {
            ConsumerFlowProperties f_prop = new ConsumerFlowProperties().setEndpoint(qClassic);
            flow = this.createQueueReceiver(f_prop, null, listener, null, null);
        }
        catch (JCSMPErrorResponseException ex) {
            if (ex.getResponseCode() == 503 && ex.getResponsePhrase().compareToIgnoreCase(AD_DISABLED_PHRASE) == 0) {
                this.Trace.info("[" + this.session.getSessionName() + "] AD not available on router, forcing binding for default message flow.");
                flow = new FlowHandleImpl(qClassic, null, listener, this.subChannel, this.session, false, null, AssuredCtrlEnums.FlowType.CONSUMER, null, null, null, null, null, null);
            }
            throw ex;
        }
        return flow;
    }

    private FlowHandleImpl createDefaultFlowNoBindDefQueue(Queue qClassic, XMLMessageListener listener) throws JCSMPException {
        return new FlowHandleImpl(qClassic, null, listener, this.subChannel, this.session, false, null, AssuredCtrlEnums.FlowType.CONSUMER, null, null, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindFlowHandle(FlowHandleImpl fh, boolean linger, TcpChannel.WriteBlockPolicy wpol) throws JCSMPException {
        block29: {
            try {
                FlowHandleImpl fObj = null;
                try {
                    this.unbindLock.lock();
                    Map<Long, FlowHandleImpl> map = this.activeFlows;
                    synchronized (map) {
                        fObj = this.activeFlows.remove(fh.getFlowId());
                        this.removeManagedFlow(fh);
                    }
                }
                finally {
                    this.unbindLock.unlock();
                }
                if (fObj == null) {
                    return;
                }
                if (this.session.isClosed()) {
                    throw new ClosedFacilityException("Session is closed.");
                }
                int corrtag = this.getCorrelationTag();
                TaskSessionRefs tsr = new TaskSessionRefs(this.session, this.subChannel, this);
                UnbindRequestTask t = fh.getTransactedSession() instanceof XASessionImpl ? new UnbindRequestTask(tsr, fh.getBoundResource(), fh.getFlowId(), false, linger, fh.getLastMsgIdAcked()) : new UnbindRequestTask(tsr, fh.getBoundResource(), fh.getFlowId(), false, linger);
                boolean blocking = false;
                switch (wpol) {
                    case DEFAULT: {
                        blocking = true;
                        break;
                    }
                    case DROP_AND_IGNORE: 
                    case DROP_AND_THROW: 
                    case RESCHED_OK_BUT_NO_BLOCK_ON_STATE: {
                        blocking = false;
                    }
                }
                if (blocking) {
                    Map<Long, FlowTask> map = this.waitingFlows;
                    synchronized (map) {
                        this.waitingFlows.put(Long.valueOf(corrtag), t);
                    }
                }
                while (true) {
                    if (this.session.isClosed()) {
                        throw new ClosedFacilityException("Session is closed.");
                    }
                    if (!fh.isBoundToResource()) {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug("flow=" + fh.getFlowId() + " already UNBOUND");
                        }
                        blocking = false;
                    } else if (!t.submit(corrtag, false, wpol)) {
                        blocking = false;
                    }
                    if (!blocking) break;
                    try {
                        t.waitResponse();
                        break block29;
                    }
                    catch (TimeoutException e) {
                        if (!this.Trace.isDebugEnabled()) continue;
                        this.Trace.debug("Timeout performing unbind flow=" + fh.getFlowId());
                        continue;
                    }
                    break;
                }
                t.cancelTimer();
            }
            finally {
                fh.resetResourceBoundStateToUnbound(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeDTE(String dteName) throws JCSMPException {
        if (!this.subChannel.connected()) {
            this.subChannel.open();
        }
        int corrtag = this.getCorrelationTag();
        TaskSessionRefs tsr = new TaskSessionRefs(this.session, this.subChannel, this);
        UnsubscribeRequestTask t = new UnsubscribeRequestTask(dteName, tsr);
        Map<Long, FlowTask> map = this.waitingFlows;
        synchronized (map) {
            this.waitingFlows.put(Long.valueOf(corrtag), t);
        }
        t.submit(corrtag, false, TcpChannel.WriteBlockPolicy.DEFAULT);
        t.waitResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAssuredFlowChangeUpdateMessage(WireMessage wmsg) {
        AssuredCtrlHeaderBean assctrlHdr = (AssuredCtrlHeaderBean)wmsg.getHeaderBean();
        SmfTLVParameter tlv = (SmfTLVParameter)assctrlHdr.findFirstParameter(6);
        if (tlv != null) {
            long flowId = TlvParameterParser.getAssuredFlowId(tlv);
            tlv = (SmfTLVParameter)assctrlHdr.findFirstParameter(32);
            boolean flowActive = TlvParameterParser.getAssuredActiveFlowIndication(tlv);
            FlowHandleImpl fh = null;
            Map<Long, FlowHandleImpl> map = this.activeFlows;
            synchronized (map) {
                fh = this.activeFlows.get(flowId);
            }
            if (fh != null) {
                if (!this.subChannel.connected()) {
                    return;
                }
                if (fh.getFlowEventHandler() == null) {
                    this.subChannel.sendFlowChangeUpdateResponse(flowId, flowActive, 400, "Unexpected Update");
                } else {
                    this.subChannel.sendFlowChangeUpdateResponse(flowId, flowActive, 200, "OK");
                    this.generateFlowEvent(fh, flowActive, null);
                }
            } else {
                this.subChannel.sendFlowChangeUpdateResponse(flowId, flowActive, 400, "Unknown Flow Id");
            }
        }
    }

    public void generateFlowEvent(FlowHandleImpl fh, boolean flowActive, String reason) {
        if (fh.isOpened()) {
            if (fh.explictlyActive && !flowActive) {
                fh.explictlyActive = false;
                this.Trace.debug("Send out flow inactive event for an active flow, flowId=" + fh.getFlowId());
                fh.notifyFlowEventHandler(new FlowEventArgsImpl(FlowEvent.FLOW_INACTIVE, reason == null || reason.length() == 0 ? "Flow becomes inactive" : reason, null, 0));
            } else if (!fh.explictlyActive && flowActive) {
                fh.explictlyActive = true;
                this.Trace.debug("Send out flow active event for an inactive flow, flowId=" + fh.getFlowId());
                fh.notifyFlowEventHandler(new FlowEventArgsImpl(FlowEvent.FLOW_ACTIVE, reason == null || reason.length() == 0 ? "Flow becomes active" : reason, null, 0));
            }
        }
    }

    public void generateFlowEvent(FlowHandleImpl fh, FlowEventArgs event) {
        this.Trace.debug("Send out flow event= " + (Object)((Object)event.getEvent()) + "; flowId=" + fh.getFlowId());
        fh.notifyFlowEventHandler(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAssuredCtrlMessage(WireMessage wmsg) {
        block45: {
            int corrtag = wmsg.getSmfHeader().getPm_corrtag();
            if (corrtag != -1) {
                FlowTask waiting;
                this.Trace.debug("Received AdCtrlMes, corrtag: " + corrtag);
                Map<Long, FlowTask> map = this.waitingFlows;
                synchronized (map) {
                    waiting = this.waitingFlows.remove(corrtag);
                }
                boolean unbindFlowRequired = false;
                if (waiting != null && !waiting.isFlowCreationInterrupted()) {
                    waiting.execute(wmsg);
                    if (waiting.getOpEx() != null && waiting instanceof BindRequestTask) {
                        BindRequestTask task = (BindRequestTask)waiting;
                        FlowHandleImpl fh = task.getExistingFlowHandler();
                        if (fh != null) {
                            this.generateFlowEvent(fh, new FlowEventArgsImpl(FlowEvent.FLOW_DOWN, waiting.getOpEx().toString(), waiting.getOpEx(), 0));
                        }
                    } else {
                        unbindFlowRequired = waiting.isFlowCreationInterrupted();
                    }
                } else {
                    unbindFlowRequired = true;
                }
                if (unbindFlowRequired) {
                    SMFHeaderBean smfHeader;
                    this.Trace.debug("Received uncorrelated response " + corrtag + ", ignoring: " + wmsg.toString());
                    AssuredCtrlHeaderBean assBean = (AssuredCtrlHeaderBean)wmsg.getHeaderBean();
                    if (assBean.getMsgType() == 4 && (smfHeader = wmsg.getSmfHeader()).getPm_respcode() == 200) {
                        SmfTLVParameter tlv = (SmfTLVParameter)assBean.findFirstParameter(6);
                        long respFlowId = TlvParameterParser.getAssuredFlowId(tlv);
                        this.Trace.debug("Send unbind request for the received uncorrelated OK bind response, flowId: " + respFlowId);
                        TaskSessionRefs tsr = new TaskSessionRefs(this.session, this.subChannel, this);
                        UnbindRequestTask urt = new UnbindRequestTask(tsr, null, respFlowId, false, false, null);
                        try {
                            urt.submit(this.getCorrelationTag(), false, TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE);
                        }
                        catch (JCSMPException e) {
                            if (this.Trace.isDebugEnabled()) {
                                this.Trace.debug("caught exception: " + e.toString());
                            }
                        }
                    }
                }
            } else {
                AssuredCtrlHeaderBean assctrlHdr = (AssuredCtrlHeaderBean)wmsg.getHeaderBean();
                if (assctrlHdr.getMsgType() == 5) {
                    TaskSessionRefs tsr = new TaskSessionRefs(this.session, this.subChannel, this);
                    UnbindRequestTask urt = new UnbindRequestTask(tsr, null, 0L, true, false);
                    urt.execute(wmsg);
                    try {
                        FlowEventArgsImpl event;
                        FlowHandleImpl f;
                        long flowId = urt.waitResponseGetFlowId();
                        Long errorId = urt.getEndpointErrorId();
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug("Got unsolicited unbind flowId= " + flowId + "; EndpointErrorId= " + errorId);
                        }
                        JCSMPErrorResponseException resposeEx = null;
                        boolean invalidFlowIdResponse = false;
                        Object e = this.activeFlows;
                        synchronized (e) {
                            f = this.activeFlows.remove(flowId);
                        }
                        if (urt.getOpEx() instanceof JCSMPErrorResponseException && (resposeEx = (JCSMPErrorResponseException)urt.getOpEx()).getSubcodeEx() == 85) {
                            invalidFlowIdResponse = true;
                        }
                        if (f != null) {
                            if (errorId != null) {
                                f.setEndpointErrorId(errorId);
                            }
                            f.resetResourceBoundStateToUnbound(true);
                            event = null;
                            if (resposeEx != null) {
                                if (resposeEx.getSubcodeEx() == 78) {
                                    if (f.isTransacted()) {
                                        f.getTransactedSession().setRollbackOnly(f);
                                    }
                                    f.resetAdState();
                                    f.tryToTriggerAutoRebind(true);
                                    if (!f.isAutoRebindEnabled().booleanValue()) {
                                        event = new FlowEventArgsImpl(FlowEvent.FLOW_DOWN, urt.getOpEx() == null ? "" : urt.getOpEx().toString(), urt.getOpEx(), 0);
                                        this.generateFlowEvent(f, event);
                                    }
                                } else if (resposeEx.getSubcodeEx() == 50) {
                                    f.tryToTriggerAutoRebind(true);
                                    if (!f.isAutoRebindEnabled().booleanValue()) {
                                        event = new FlowEventArgsImpl(FlowEvent.FLOW_DOWN, urt.getOpEx() == null ? "" : urt.getOpEx().toString(), urt.getOpEx(), 0);
                                        this.generateFlowEvent(f, event);
                                    }
                                } else {
                                    event = new FlowEventArgsImpl(FlowEvent.FLOW_DOWN, resposeEx.getResponsePhrase(), resposeEx, resposeEx.getResponseCode());
                                    this.generateFlowEvent(f, event);
                                    this.removeManagedFlow(f);
                                }
                            } else {
                                event = new FlowEventArgsImpl(FlowEvent.FLOW_DOWN, urt.getOpEx() == null ? "" : urt.getOpEx().toString(), urt.getOpEx(), 0);
                                this.generateFlowEvent(f, event);
                            }
                        }
                        if (f != null) {
                            if (errorId != null && !invalidFlowIdResponse) {
                                urt = f.getTransactedSession() instanceof XASessionImpl ? new UnbindRequestTask(tsr, f.getBoundResource(), flowId, false, false, f.getLastMsgIdAcked(), f.getEndpointErrorId()) : new UnbindRequestTask(tsr, f.getBoundResource(), flowId, false, false, null, f.getEndpointErrorId());
                                try {
                                    urt.submit(null, false, TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE);
                                }
                                catch (JCSMPException e2) {
                                    if (this.Trace.isDebugEnabled()) {
                                        this.Trace.debug("caught exception: " + e2.toString());
                                    }
                                    throw e2;
                                }
                            }
                            if (f.tryToStartAutoRebind().booleanValue()) {
                                event = new FlowEventArgsImpl(FlowEvent.FLOW_RECONNECTING, resposeEx.getResponsePhrase(), resposeEx, resposeEx.getResponseCode());
                                this.generateFlowEvent(f, event);
                                ConsumerFlowProperties tmpFlowProp = new ConsumerFlowProperties();
                                tmpFlowProp.setEndpoint(f.getBoundResource());
                                tmpFlowProp.setNewSubscription(f.getCachedTopic());
                                tmpFlowProp.setSelector(f.getCachedSelector());
                                tmpFlowProp.setTransportWindowSize(f.getWindowSize());
                                tmpFlowProp.setNoLocal(f.isNoLocal());
                                tmpFlowProp.setActiveFlowIndication(f.getFlowEventHandler() != null);
                                JCSMPBasicSession.InternalBindProperties internalBindProp = JCSMPBasicSession.InternalBindProperties.create().with(f.getTransactedSession());
                                BindRequestTask rebindTask = new BindRequestTask(tsr, tmpFlowProp, f.getEndpointProperties(), f.getMessageListener(), f, f.getFlowType(), internalBindProp, f.getFlowEventHandler());
                                this.doBindNonblocking(rebindTask, true, TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE);
                                this.Trace.debug("flow auto reconnect BIND request sent, flowName=" + f.getFlowName());
                            } else {
                                this.generateFlowEvent(f, false, "Flow becomes inactive due to receiving unsolicited unbind from the appliance");
                                e = new JCSMPFlowTransportUnsolicitedUnbindException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageConsumer.flowInactiveDueToUnbind"), urt.getOpEx());
                                f.handleException((JCSMPException)e);
                            }
                            break block45;
                        }
                        if (errorId == null || invalidFlowIdResponse) break block45;
                        urt = new UnbindRequestTask(tsr, null, flowId, false, false, null, errorId);
                        try {
                            urt.submit(null, false, TcpChannel.WriteBlockPolicy.DROP_AND_THROW);
                        }
                        catch (JCSMPException e3) {
                            if (this.Trace.isDebugEnabled()) {
                                this.Trace.debug("caught exception: " + e3.toString());
                            }
                            throw e3;
                        }
                    }
                    catch (JCSMPException jCSMPException) {}
                } else {
                    this.Trace.debug("Received uncorrelated response, ignoring: " + wmsg.toString());
                }
            }
        }
    }

    public void handlePubMessage(JCSMPXMLMessage msg) {
        long flowId;
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Demux pub msg:" + msg);
        }
        if ((flowId = msg.getFlowId()) == -1L) {
            if (this.isSubscriptionMapEmpty()) {
                this.handleClassicFlow(msg);
            } else {
                this.handleTopicDemux(msg);
            }
        } else {
            this.handleADFlow(msg, flowId);
        }
    }

    private void handlePubMessage(FlowHandleImpl fh, JCSMPXMLMessage msg, long flowId) {
        if (fh == null) {
            this.Trace.debug(String.format("Received incoming message with no active flow found for flowId=%s, ignoring.", flowId));
            this.session_stats.incStat(StatType.RELIABLE_MSGS_DISCARDED_NO_MATCHING_FLOW);
            return;
        }
        msg.setReadOnly();
        boolean res = fh.processMessage(msg);
        if (!res) {
            this.Trace.info("FlowHandle received incoming message (flow stopped or duplicate received), ignoring.");
            this.session_stats.incStat(StatType.MESSAGES_DISCARDED_INTERNAL);
        }
    }

    private void handleClassicFlow(JCSMPXMLMessage msg) {
        if (this.classicFlow != null && this.classicFlow.opened) {
            this.handlePubMessage(this.classicFlow, msg, -1L);
        } else {
            this.handlePubMessage(null, msg, -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleADFlow(JCSMPXMLMessage msg, long flowId) {
        FlowHandleImpl fh = null;
        Map<Long, FlowHandleImpl> map = this.activeFlows;
        synchronized (map) {
            fh = this.activeFlows.get(flowId);
        }
        if (fh != null && !fh.notifyAdMessage(msg)) {
            return;
        }
        this.handlePubMessage(fh, msg, flowId);
    }

    private void handleTopicDemux(JCSMPXMLMessage msg) {
        if (this.topic_demux_flow != null) {
            this.handlePubMessage(this.topic_demux_flow, msg, -1L);
        } else {
            boolean found = false;
            this.match_entries.clear();
            this.mSubscriptionMap.get(msg.getDestinationReceivedBytes(), this.match_entries);
            if (this.match_entries.size() != 0) {
                found = true;
                for (int i = 0; i < this.match_entries.size(); ++i) {
                    SubscriptionMatchEntry<FlowHandleImpl> entry = this.match_entries.get(i);
                    Iterator<FlowHandleImpl> it = entry.getEntries().iterator();
                    while (it.hasNext()) {
                        this.handlePubMessage(it.next(), msg, -1L);
                    }
                }
            }
            if (!(found |= this.mSharedSubscriptionMgr.processMessage(msg))) {
                this.handleClassicFlow(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyActiveFlows(JCSMPException e) {
        this.Trace.debug("Notify active flows when flow becomes inactive", e);
        ArrayList<FlowHandleImpl> activeFlowList = new ArrayList<FlowHandleImpl>();
        Map<Long, FlowHandleImpl> map = this.activeFlows;
        synchronized (map) {
            Iterator<Map.Entry<Long, FlowHandleImpl>> itActiveFlows = this.activeFlows.entrySet().iterator();
            while (itActiveFlows.hasNext()) {
                FlowHandleImpl f = itActiveFlows.next().getValue();
                activeFlowList.add(f);
            }
        }
        for (FlowHandleImpl f : activeFlowList) {
            f.resetResourceBoundStateToUnbound(true);
            this.generateFlowEvent(f, false, "Flow becomes inactive due to: " + e.getMessage());
            this.generateFlowEvent(f, new FlowEventArgsImpl(FlowEvent.FLOW_DOWN, e.getMessage(), e, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildDispatchChannelLists(List<FlowTask> waitingFlowList, List<FlowHandleImpl> activeFlowList) {
        Map<Long, FlowTask> map = this.waitingFlows;
        synchronized (map) {
            Map<Long, FlowHandleImpl> map2 = this.activeFlows;
            synchronized (map2) {
                Iterator<Map.Entry<Long, FlowTask>> it = this.waitingFlows.entrySet().iterator();
                while (it.hasNext()) {
                    waitingFlowList.add(it.next().getValue());
                    it.remove();
                }
                Iterator<Map.Entry<Long, FlowHandleImpl>> itActiveFlows = this.activeFlows.entrySet().iterator();
                while (itActiveFlows.hasNext()) {
                    FlowHandleImpl f = itActiveFlows.next().getValue();
                    itActiveFlows.remove();
                    activeFlowList.add(f);
                }
                this.managedFlows.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchChannelException(JCSMPException e, List<FlowTask> waitingFlowList, List<FlowHandleImpl> activeFlowList) {
        this.Trace.info(String.format("SubChannel %s threw exception, non-recoverable. ", this.subChannel.getDbgId()), e);
        if (this.activeReliableFlows != null) {
            Iterator<FlowHandleImpl> iterator = this.activeReliableFlows;
            synchronized (iterator) {
                for (int i = 0; i < this.activeReliableFlows.size(); ++i) {
                    activeFlowList.add(this.activeReliableFlows.get(i));
                }
            }
        }
        for (FlowTask ft : waitingFlowList) {
            ft.cancel(e);
        }
        if (this.classicFlow != null) {
            activeFlowList.add(this.classicFlow);
        }
        for (FlowHandleImpl f : activeFlowList) {
            f.resetResourceBoundStateToUnbound(true);
            this.generateFlowEvent(f, false, "Flow becomes inactive due to: " + e.getMessage());
            f.closeImpl(false, false, TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE, e);
        }
        for (FlowHandleImpl f : activeFlowList) {
            f.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWaitingTask(FlowTask f) {
        Map<Long, FlowTask> map = this.waitingFlows;
        synchronized (map) {
            Iterator<Map.Entry<Long, FlowTask>> it = this.waitingFlows.entrySet().iterator();
            while (it.hasNext()) {
                FlowTask ft = it.next().getValue();
                if (ft != f) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReconnectAborted(JCSMPException e) {
        this.Trace.debug("notifyReconnectAborted: " + this.waitingFlows.toString());
        Map<Long, FlowTask> map = this.waitingFlows;
        synchronized (map) {
            Map<Long, FlowHandleImpl> map2 = this.activeFlows;
            synchronized (map2) {
                Iterator<Map.Entry<Long, FlowTask>> it = this.waitingFlows.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Long, FlowTask> entry = it.next();
                    FlowTask ft = entry.getValue();
                    Long flowId = entry.getKey();
                    it.remove();
                    FlowHandleImpl fh = this.activeFlows.get(flowId);
                    if (fh != null) {
                        this.Trace.debug("notifyReconnectAborted - active flow " + flowId + " UNBOUND ");
                        fh.notifyReconnectAborted();
                    }
                    if (ft instanceof UnbindRequestTask) {
                        this.Trace.debug("flowid: " + flowId + "; notifyReconnectAborted - About to cancel waiting UnbindRequestTask: " + ft);
                        ft.cancel(e);
                        continue;
                    }
                    this.Trace.debug("About to cancel waiting FlowTask(notifyReconnectAborted): Key=" + flowId + ";brt=" + ft.toString());
                    ft.cancel(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTcpClientClosed(boolean isReconn) {
        if (!isReconn) {
            Map<Long, FlowTask> map = this.waitingFlows;
            synchronized (map) {
                Map<Long, FlowHandleImpl> map2 = this.activeFlows;
                synchronized (map2) {
                    Iterator<Map.Entry<Long, FlowTask>> it = this.waitingFlows.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Long, FlowTask> entry = it.next();
                        FlowTask ft = entry.getValue();
                        Long flowId = entry.getKey();
                        it.remove();
                        FlowHandleImpl fh = this.activeFlows.get(flowId);
                        if (fh != null) {
                            this.Trace.debug("notifyTcpClientClosed - active flow " + flowId + " UNBOUND ");
                            fh.resetResourceBoundStateToUnbound(false);
                        }
                        if (ft instanceof UnbindRequestTask) {
                            this.Trace.debug("notifyTcpClientClosed - About to cancel waiting UnbindRequestTask: " + ft);
                            ft.cancel(null);
                            continue;
                        }
                        this.Trace.debug("notifyTcpClientClosed - About to cancel waiting FlowTask: " + ft);
                        ft.cancel(null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyVridChange() {
        ArrayList<FlowHandleImpl> flowsCpy = new ArrayList<FlowHandleImpl>();
        Map<Long, FlowHandleImpl> map = this.activeFlows;
        synchronized (map) {
            flowsCpy.addAll(this.managedFlows);
        }
        for (FlowHandleImpl fh : flowsCpy) {
            fh.resetAdState();
            fh.setEndpointErrorId(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPostReconnect(JCSMPException e, HostInfo hostSpec) throws JCSMPException {
        try {
            this.unbindLock.lock();
            ArrayList<FlowTask> waitTasks = new ArrayList<FlowTask>();
            ArrayList<FlowHandleImpl> activeFlowsCpy = new ArrayList<FlowHandleImpl>();
            Iterator iterator = this.waitingFlows;
            synchronized (iterator) {
                Map<Long, FlowHandleImpl> map = this.activeFlows;
                synchronized (map) {
                    Iterator<Map.Entry<Long, FlowTask>> it = this.waitingFlows.entrySet().iterator();
                    while (it.hasNext()) {
                        FlowTask ft = it.next().getValue();
                        it.remove();
                        if (ft instanceof BindRequestTask) {
                            BindRequestTask brt = (BindRequestTask)ft;
                            if (brt.existingFlowHandle == null) {
                                waitTasks.add(ft);
                                continue;
                            }
                            this.Trace.debug("cancel bindRequestTask timer for flow:  " + brt.existingFlowHandle.getFlowName());
                            ft.cancelTimer();
                            continue;
                        }
                        waitTasks.add(ft);
                    }
                    this.activeFlows.clear();
                    activeFlowsCpy.addAll(this.managedFlows);
                    assert (this.waitingFlows.size() == 0);
                    assert (this.activeFlows.size() == 0);
                }
            }
            this.setLastHostSpec(hostSpec.getHost());
            for (FlowTask t : waitTasks) {
                if (t instanceof UnbindRequestTask) {
                    this.Trace.debug("About to cancel waiting UnbindRequestTask: " + t);
                    t.cancel(null);
                    continue;
                }
                t.cancelTimer();
                t.resend(true, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, false);
            }
            for (FlowHandleImpl fh : activeFlowsCpy) {
                fh.notifyPostReconnect();
            }
            this.rebindFlows(activeFlowsCpy);
        }
        finally {
            this.unbindLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resubmitTask(FlowTask t, boolean allowOnStateSub, TcpChannel.WriteBlockPolicy wpolicy, boolean isReactorResend) {
        Map<Long, FlowTask> map;
        BindRequestTask bindTask;
        FlowHandleImpl fh;
        if (t instanceof BindRequestTask && (fh = (bindTask = (BindRequestTask)t).getExistingFlowHandler()) != null) {
            if (this.activeFlows.get(fh.getFlowId()) != null) {
                this.Trace.debug("flow is bound, skip resubmitTask: flowName=" + fh.getFlowName() + "; flowId=" + fh.getFlowId());
                return;
            }
            if (fh.isClosed()) {
                this.Trace.debug("existing flow was closed, skip resubmitTask: flowName=" + fh.getFlowName() + "; flowId=" + fh.getFlowId());
                return;
            }
            map = this.waitingFlows;
            synchronized (map) {
                Iterator<Map.Entry<Long, FlowTask>> it = this.waitingFlows.entrySet().iterator();
                while (it.hasNext()) {
                    FlowHandleImpl flow;
                    FlowTask ft = it.next().getValue();
                    if (!(ft instanceof BindRequestTask) || (flow = ((BindRequestTask)ft).getExistingFlowHandler()) == null || !flow.equals(fh)) continue;
                    this.Trace.debug("waiting for bind response, skip resubmitTask: flowName=" + fh.getFlowName());
                    return;
                }
            }
        }
        long locReqCounter = this.getCorrelationTag();
        map = this.waitingFlows;
        synchronized (map) {
            this.waitingFlows.put(locReqCounter, t);
            try {
                t.submit((int)locReqCounter, allowOnStateSub, wpolicy);
            }
            catch (JCSMPException e) {
                if (isReactorResend && wpolicy == TcpChannel.WriteBlockPolicy.DROP_AND_THROW) {
                    t.scheduleResubmit(e);
                    this.waitingFlows.remove(locReqCounter);
                }
                t.cancel(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebindFlows(List<FlowHandleImpl> lsActiveFlows) throws JCSMPException {
        this.Trace.debug(String.format("About to initiate rebind of all flows Channel:%s.", this.subChannel.getDbgId()));
        ArrayList<BindRequestTask> toRebindList = new ArrayList<BindRequestTask>();
        Map<Long, FlowHandleImpl> map = this.activeFlows;
        synchronized (map) {
            for (FlowHandleImpl f : lsActiveFlows) {
                if (!f.isRequiredSettlementCapable()) {
                    if (this.Trace.isWarnEnabled()) {
                        this.Trace.warn("the broker does not support required settlement outcomes");
                    }
                    this.generateFlowEvent(f, new FlowEventArgsImpl(FlowEvent.FLOW_DOWN, "the broker does not support required settlement outcomes", null, 0));
                    continue;
                }
                TaskSessionRefs tsr = new TaskSessionRefs(this.session, this.subChannel, this);
                ConsumerFlowProperties tmpFlowProp = new ConsumerFlowProperties();
                tmpFlowProp.setEndpoint(f.getBoundResource());
                tmpFlowProp.setNewSubscription(f.getCachedTopic());
                tmpFlowProp.setSelector(f.getCachedSelector());
                tmpFlowProp.setTransportWindowSize(f.getWindowSize());
                tmpFlowProp.setNoLocal(f.isNoLocal());
                tmpFlowProp.setActiveFlowIndication(f.getFlowEventHandler() != null);
                JCSMPBasicSession.InternalBindProperties internalBindProp = JCSMPBasicSession.InternalBindProperties.create().with(f.getTransactedSession());
                BindRequestTask rebindTask = new BindRequestTask(tsr, tmpFlowProp, f.getEndpointProperties(), f.getMessageListener(), f, f.getFlowType(), internalBindProp, f.getFlowEventHandler());
                toRebindList.add(rebindTask);
                this.Trace.debug("About to submit rebind: " + rebindTask);
            }
        }
        for (BindRequestTask brt : toRebindList) {
            try {
                FlowHandleImpl fh = this.doBindBlocking(brt, true, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE);
                if (fh == null) continue;
                fh.notifyReconnected();
            }
            catch (JCSMPErrorResponseException e) {
                this.Trace.debug("Failed BindRequestTask: " + brt);
                if (e.getResponseCode() == 503 && e.getSubcodeEx() == 31) {
                    this.Trace.debug("Ignoring Failed BindRequestTask: " + brt + " as it was due to " + e);
                    continue;
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<FlowHandleImpl> flowsToCloseList = new ArrayList<FlowHandleImpl>();
        ArrayList<FlowHandleImpl> arrayList = this.activeFlows;
        synchronized (arrayList) {
            this.Trace.debug(String.format("SubFlowManagerImpl closing... close %s flows", this.activeFlows.size()));
            Iterator<Map.Entry<Long, FlowHandleImpl>> it2 = this.activeFlows.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry<Long, FlowHandleImpl> e = it2.next();
                flowsToCloseList.add(e.getValue());
                it2.remove();
            }
            this.managedFlows.clear();
        }
        if (this.activeReliableFlows != null) {
            arrayList = this.activeReliableFlows;
            synchronized (arrayList) {
                for (int i = 0; i < this.activeReliableFlows.size(); ++i) {
                    flowsToCloseList.add(this.activeReliableFlows.get(i));
                }
            }
        }
        for (FlowHandleImpl fh : flowsToCloseList) {
            fh.closeImpl(true, false, TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE);
        }
        if (this.classicFlow != null) {
            this.classicFlow.close();
        }
    }

    public JCSMPProperties getSessionProperties() {
        return this.session.getJCSMPProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogFlowInfoString() {
        StringBuilder sb = new StringBuilder();
        if (this.classicFlow != null) {
            sb.append(this.classicFlow.getLogFlowInfoString()).append("\n");
        }
        Map<Long, FlowHandleImpl> map = this.activeFlows;
        synchronized (map) {
            for (Map.Entry<Long, FlowHandleImpl> e : this.activeFlows.entrySet()) {
                if (e.getValue() == this.classicFlow) continue;
                sb.append(e.getValue().getLogFlowInfoString()).append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleControllerException(JCSMPException e) {
        if (this.classicFlow != null) {
            this.classicFlow.handleControllerException(e);
        }
        Map<Long, FlowHandleImpl> map = this.activeFlows;
        synchronized (map) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(String.format("SubFlowManagerImpl handleControllerException for %s active flows", this.activeFlows.size()));
            }
            Iterator<Map.Entry<Long, FlowHandleImpl>> it2 = this.activeFlows.entrySet().iterator();
            while (it2.hasNext()) {
                FlowHandleImpl flow = it2.next().getValue();
                flow.resetResourceBoundStateToUnbound(true);
            }
        }
    }
}

