/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.compression.BufferUtil;
import com.solacesystems.jcsmp.impl.compression.SolZlibCallResult;
import com.solacesystems.jcsmp.impl.compression.SolZlibDeflatePipe;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.WireMessageHandler;
import com.solacesystems.jcsmp.protocol.nio.IOReactor;
import com.solacesystems.jcsmp.protocol.nio.impl.NioSmfUtil;
import com.solacesystems.jcsmp.protocol.smf.SimpleSmfClient;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeParameters;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class ZSmfClient
extends SimpleSmfClient {
    public SolZlibDeflatePipe z_in;
    public SolZlibDeflatePipe z_out;
    private final int solCompressionLevel;

    protected ZSmfClient(AuthenticationSchemeParameters authParams, JCSMPSessionStats sessionStats, IOReactor reactor, int zipLevel) {
        super(authParams, sessionStats, reactor, false);
        this.solCompressionLevel = zipLevel;
    }

    protected ZSmfClient(AuthenticationSchemeParameters authParams, JCSMPSessionStats sessionStats, IOReactor reactor, boolean usePubDirectIntermediateBuf, int zipLevel) {
        super(authParams, sessionStats, reactor, usePubDirectIntermediateBuf);
        this.solCompressionLevel = zipLevel;
    }

    private int getSafeZlibOutputLen(int input) {
        return (int)Math.ceil((double)input * 1.14) + 256;
    }

    protected boolean isCompressionMode() {
        return this.solCompressionLevel > 0;
    }

    @Override
    public void open() throws UnknownHostException, JCSMPException, IOException {
        super.open();
        if (this.isCompressionMode()) {
            this.z_in = new SolZlibDeflatePipe(this.solCompressionLevel);
            this.z_out = new SolZlibDeflatePipe(this.solCompressionLevel);
        }
    }

    @Override
    public void doPostNoResponse(WireMessage request, boolean setAuth) throws JCSMPException, IOException {
        if (!this.isCompressionMode()) {
            super.doPostNoResponse(request, setAuth);
            return;
        }
        if (!this.connected()) {
            this.open();
        }
        if (setAuth) {
            this.setAuth(request);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.wirehandler.writeMessage(baos, request);
        byte[] smfdata = baos.toByteArray();
        int outLen = this.getSafeZlibOutputLen(smfdata.length);
        byte[] zlibdata = new byte[outLen];
        int compressed_output = (int)this.z_out.deflateAndFlush(smfdata, 0, smfdata.length, zlibdata, 0, zlibdata.length);
        OutputStream ostr = this.socket.getOutputStream();
        ostr.write(zlibdata, 0, compressed_output);
        ostr.flush();
        this.m_bytesWrittenCtr.addAndGet(compressed_output);
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_SENT, smfdata.length);
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_SENT, compressed_output);
    }

    protected ByteArrayOutputStream getCompressedOutput(WireMessage request) throws JCSMPException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.wirehandler.writeMessage(baos, request);
        byte[] smfdata = baos.toByteArray();
        int outLen = this.getSafeZlibOutputLen(smfdata.length);
        byte[] zlibdata = new byte[outLen];
        int compressed_output = (int)this.z_out.deflateAndFlush(smfdata, 0, smfdata.length, zlibdata, 0, zlibdata.length);
        this.m_bytesWrittenCtr.addAndGet(compressed_output);
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_SENT, smfdata.length);
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_SENT, compressed_output);
        ByteArrayOutputStream compressedMsg = new ByteArrayOutputStream();
        compressedMsg.write(zlibdata, 0, compressed_output);
        return compressedMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer[] getOutputBufferForSend(ByteBuffer[] requestBB, WireMessage request, WireMessageHandler wirehandler) throws IOException {
        ByteBuffer[] outBufLocal = null;
        byte[] outMessageData = null;
        if (!this.isCompressionMode()) {
            return super.getOutputBufferForSend(requestBB, request, wirehandler);
        }
        Object object = this._stateLock;
        synchronized (object) {
            if (request != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                wirehandler.writeMessage(baos, request);
                outMessageData = baos.toByteArray();
            } else if (requestBB != null) {
                outMessageData = new byte[ZSmfClient.remainingBytes(requestBB)];
                int i = 0;
                for (ByteBuffer b : requestBB) {
                    int len = b.remaining();
                    b.get(outMessageData, i, len);
                    i += len;
                }
            } else {
                throw new IllegalArgumentException("No request.");
            }
            int outLen = this.getSafeZlibOutputLen(outMessageData.length);
            byte[] zlibdata = new byte[outLen];
            int compressed_output = (int)this.z_out.deflateAndFlush(outMessageData, 0, outMessageData.length, zlibdata, 0, zlibdata.length);
            outBufLocal = new ByteBuffer[]{ByteBuffer.wrap(zlibdata, 0, compressed_output)};
            this.sessionStats.incStat(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_SENT, compressed_output);
            this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_SENT, outMessageData.length);
        }
        return outBufLocal;
    }

    @Override
    public void readMessage(InputStream istr, WireMessage msg) throws IOException {
        byte[] zlibdata = new byte[4096];
        byte[] inflateddata = new byte[4096];
        int decompressed = 0;
        int compressed = 0;
        int consumed = 0;
        if (!this.isCompressionMode()) {
            super.readMessage(istr, msg);
            return;
        }
        while (!NioSmfUtil.isSmfMessageAvailableAtCurrentPos(this.bbWrapTmp(inflateddata, 0, decompressed))) {
            int cnt_read;
            if ((compressed += (cnt_read = istr.read(zlibdata, compressed, 1))) == zlibdata.length) {
                zlibdata = BufferUtil.growBuffer(zlibdata, zlibdata.length, zlibdata.length * 2);
            }
            int dec_pass = 0;
            boolean done = false;
            do {
                SolZlibCallResult ret = this.z_in.inflateChunks(zlibdata, consumed, compressed, inflateddata, decompressed, inflateddata.length);
                if (ret.bytes_output == -1) {
                    throw new IOException(JCSMPRB.BUNDLE.getStringSafely("Zlib.streamError"));
                }
                dec_pass = ret.bytes_output;
                consumed += ret.bytes_consumed;
                if ((decompressed += dec_pass) == inflateddata.length) {
                    inflateddata = BufferUtil.growBuffer(inflateddata, inflateddata.length, inflateddata.length * 2);
                    continue;
                }
                if (ret.bytes_consumed != 0 || ret.bytes_output != 0) continue;
                done = true;
            } while (!done);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(inflateddata, 0, decompressed);
        this.wirehandler.readMessage(is, msg);
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_RECVED, decompressed);
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_RECVED, compressed);
    }

    private ByteBuffer bbWrapTmp(byte[] data, int offset, int length) {
        ByteBuffer buf = ByteBuffer.wrap(data, offset, length);
        return buf;
    }
}

