/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.SDTEOFException;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.StreamMessage;
import com.solacesystems.jcsmp.impl.ContentBuffer;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.MessageImpl;
import com.solacesystems.jcsmp.impl.sdt.StreamImpl;
import com.solacesystems.jcsmp.impl.sdt.TLVBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamMessageImpl
extends MessageImpl
implements StreamMessage {
    private static final Log Trace = LogFactory.getLog(StreamMessageImpl.class);
    protected SDTStream mStream;
    protected boolean mInitialized;

    public StreamMessageImpl(BytesXMLMessage message) {
        super(message);
        ((JCSMPXMLMessage)((Object)message)).setStructuredMsg(true);
        ((JCSMPXMLMessage)((Object)message)).setStructuredMsgType((byte)11);
        this.mStream = null;
        this.mInitialized = false;
    }

    @Override
    public synchronized SDTStream getStream() {
        block7: {
            if (!this.mInitialized) {
                this.mInitialized = true;
                ContentBuffer cb = ((JCSMPXMLMessage)((Object)this.mMessage)).attachmentCB;
                if (cb != null && cb.getLimit() > 0) {
                    ByteArray ba = new ByteArray(cb.getBufferRefInternal(), 0, cb.getLimit());
                    TLVBuffer buf = new TLVBuffer(ba);
                    try {
                        Object obj = buf.read();
                        if (obj instanceof SDTStream) {
                            this.mStream = (SDTStream)obj;
                        } else if (Trace.isWarnEnabled()) {
                            Trace.warn((Object)"Message payload does not contain a map");
                        }
                    }
                    catch (SDTEOFException e) {
                        if (!Trace.isWarnEnabled()) break block7;
                        Trace.warn((Object)"Message payload does not contain a map", (Throwable)((Object)e));
                    }
                }
            }
        }
        return this.mStream;
    }

    @Override
    public synchronized void setStream(SDTStream stream) {
        if (stream != null) {
            ByteArray ba = ((StreamImpl)stream).asByteArray();
            this.mMessage.writeAttachment(ba.getBuffer(), ba.getOffset(), ba.getLength());
        }
        this.mStream = stream;
        this.mInitialized = true;
    }

    @Override
    public void reset() {
        super.reset();
        this.setStream(null);
    }
}

