/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireDecoder;
import com.solacesystems.jcsmp.protocol.nio.impl.NioSmfUtil;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.NetworkIOUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFHeaderFieldConstants;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFNumericConstants;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMFHeaderDecoder
implements SMFHeaderFieldConstants,
SMFNumericConstants,
WireDecoder {
    private static final Log Trace = LogFactory.getLog(SMFHeaderDecoder.class);
    private static final boolean[] KNOWN_RECEIVABLE_PROTO = new boolean[256];
    private byte[] _tmpParamBuf = new byte[4096];
    public static final String SMF_HEADER_OPTIONAL_PARAM_PARSE_ERROR = "Unable to decode SMF header optional parameters";

    @Override
    public void decodeHeader(InputStream in, HeaderDescriptionBean headerBean) throws IOException {
        if (!(headerBean instanceof SMFHeaderBean)) {
            throw new IllegalArgumentException();
        }
        SMFHeaderBean h = (SMFHeaderBean)headerBean;
        byte[] twowords = new byte[8];
        NetworkIOUtil.readDataSafely(in, twowords, 0, 8);
        long wordLong1 = NetworkByteOrderNumberUtil.fourByteToUInt(twowords, 0);
        long wordLong2 = NetworkByteOrderNumberUtil.fourByteToUInt(twowords, 4);
        int di = (int)BitTwiddleUtil.extractBits(wordLong1, 1L, 31L);
        int smfVersion = (int)BitTwiddleUtil.extractBits(wordLong1, 3L, 24L);
        h.setDi(di);
        h.setSmfVersion(smfVersion);
        h.setUh((int)BitTwiddleUtil.extractBits(wordLong1, 2L, 22L));
        h.setProtocol((int)BitTwiddleUtil.extractBits(wordLong1, 6L, 16L));
        h.setMsgPri((int)BitTwiddleUtil.extractBits(wordLong1, 4L, 12L));
        NioSmfUtil.validateSmfVersion(smfVersion);
        int hdrLenBytes = 0;
        int bytesRead = 0;
        int reportedMsgLen = 0;
        switch (smfVersion) {
            case 2: {
                int hdrLenWords = (int)BitTwiddleUtil.extractBits(wordLong1, 12L, 0L);
                hdrLenBytes = hdrLenWords * 4;
                h.setTtl((int)BitTwiddleUtil.extractBits(wordLong2, 8L, 24L));
                reportedMsgLen = (int)BitTwiddleUtil.extractBits(wordLong2, 24L, 0L);
                h.setMsgTotalLenWithHeader(reportedMsgLen);
                bytesRead = 8;
                break;
            }
            case 3: {
                h.setElidingEligible((int)BitTwiddleUtil.extractBits(wordLong1, 1L, 30L));
                h.setDto((int)BitTwiddleUtil.extractBits(wordLong1, 1L, 29L));
                h.setAdf((int)BitTwiddleUtil.extractBits(wordLong1, 1L, 28L));
                h.setDmqEligible((int)BitTwiddleUtil.extractBits(wordLong1, 1L, 27L));
                h.setTtl((int)BitTwiddleUtil.extractBits(wordLong1, 8L, 0L));
                hdrLenBytes = (int)wordLong2;
                NetworkIOUtil.readDataSafely(in, twowords, 0, 4);
                long wordLong3 = NetworkByteOrderNumberUtil.fourByteToUInt(twowords, 0);
                reportedMsgLen = (int)wordLong3;
                h.setMsgTotalLenWithHeader(reportedMsgLen);
                bytesRead = 12;
            }
        }
        NioSmfUtil.validateSmfDeclaredLengthLegal(smfVersion, reportedMsgLen);
        NioSmfUtil.validateSmfHeaderLengthSane(smfVersion, hdrLenBytes, reportedMsgLen);
        if (!KNOWN_RECEIVABLE_PROTO[h.getProtocol()]) {
            h.setUnknownProtocolFlag(true);
            h.setMsgLen(reportedMsgLen - bytesRead);
        } else {
            h.setMsgLen(reportedMsgLen - hdrLenBytes);
            this.validateSmfHeader(h);
            int paramBytes = hdrLenBytes - bytesRead;
            if (paramBytes > 0) {
                this.growParamBufferTo(paramBytes);
                NetworkIOUtil.readDataSafely(in, this._tmpParamBuf, 0, paramBytes);
                this.readTLVsFast(h, this._tmpParamBuf, 0, paramBytes);
            }
        }
    }

    public void decodeHeader(ByteBuffer in, HeaderDescriptionBean headerBean) throws IOException {
        if (!(headerBean instanceof SMFHeaderBean)) {
            throw new IllegalArgumentException();
        }
        SMFHeaderBean h = (SMFHeaderBean)headerBean;
        if (!in.hasArray()) {
            throw new AssertionError((Object)"Fatal (debug): Buffer does not have backing array");
        }
        byte[] data_array = in.array();
        int off = in.arrayOffset() + in.position();
        long wordLong1 = NetworkByteOrderNumberUtil.fourByteToUInt(data_array, off);
        long wordLong2 = NetworkByteOrderNumberUtil.fourByteToUInt(data_array, off += 4);
        off += 4;
        int di = (int)BitTwiddleUtil.extractBits(wordLong1, 1L, 31L);
        int smfVersion = (int)BitTwiddleUtil.extractBits(wordLong1, 3L, 24L);
        h.setDi(di);
        h.setSmfVersion(smfVersion);
        h.setUh((int)BitTwiddleUtil.extractBits(wordLong1, 2L, 22L));
        h.setProtocol((int)BitTwiddleUtil.extractBits(wordLong1, 6L, 16L));
        h.setMsgPri((int)BitTwiddleUtil.extractBits(wordLong1, 4L, 12L));
        NioSmfUtil.validateSmfVersion(smfVersion);
        int hdrLenBytes = 0;
        int bytesRead = 0;
        int reportedMsgLen = 0;
        switch (smfVersion) {
            case 2: {
                int hdrLenWords = (int)BitTwiddleUtil.extractBits(wordLong1, 12L, 0L);
                hdrLenBytes = hdrLenWords * 4;
                h.setTtl((int)BitTwiddleUtil.extractBits(wordLong2, 8L, 24L));
                reportedMsgLen = (int)BitTwiddleUtil.extractBits(wordLong2, 24L, 0L);
                h.setMsgTotalLenWithHeader(reportedMsgLen);
                bytesRead = 8;
                break;
            }
            case 3: {
                h.setElidingEligible((int)BitTwiddleUtil.extractBits(wordLong1, 1L, 30L));
                h.setDto((int)BitTwiddleUtil.extractBits(wordLong1, 1L, 29L));
                h.setAdf((int)BitTwiddleUtil.extractBits(wordLong1, 1L, 28L));
                h.setDmqEligible((int)BitTwiddleUtil.extractBits(wordLong1, 1L, 27L));
                h.setTtl((int)BitTwiddleUtil.extractBits(wordLong1, 8L, 0L));
                hdrLenBytes = (int)wordLong2;
                long wordLong3 = NetworkByteOrderNumberUtil.fourByteToUInt(data_array, off);
                off += 4;
                reportedMsgLen = (int)wordLong3;
                h.setMsgTotalLenWithHeader(reportedMsgLen);
                bytesRead = 12;
                break;
            }
        }
        NioSmfUtil.validateSmfDeclaredLengthLegal(smfVersion, reportedMsgLen);
        NioSmfUtil.validateSmfHeaderLengthSane(smfVersion, hdrLenBytes, reportedMsgLen);
        if (!KNOWN_RECEIVABLE_PROTO[h.getProtocol()]) {
            h.setUnknownProtocolFlag(true);
            h.setMsgLen(reportedMsgLen - bytesRead);
        } else {
            h.setMsgLen(reportedMsgLen - hdrLenBytes);
            this.validateSmfHeader(h);
            int paramBytes = hdrLenBytes - bytesRead;
            if (paramBytes > 0) {
                try {
                    this.readTLVsFast(h, data_array, off, paramBytes);
                }
                catch (IOException e) {
                    off += paramBytes;
                    in.position((off += reportedMsgLen - hdrLenBytes) - in.arrayOffset());
                    throw e;
                }
            }
            off += paramBytes;
        }
        in.position(off - in.arrayOffset());
    }

    private void growParamBufferTo(int paramBytes) {
        if (paramBytes > this._tmpParamBuf.length) {
            this._tmpParamBuf = new byte[paramBytes];
        }
    }

    private void readTLVsFast(SMFHeaderBean h, byte[] parambuf, int offset, int bytesToRead) throws IOException {
        int off = offset;
        int end_of_hdr = offset + bytesToRead;
        while (off - offset < bytesToRead) {
            long oneByteLong = NetworkByteOrderNumberUtil.oneByteToUInt(parambuf[off]);
            ++off;
            int uh = (int)BitTwiddleUtil.extractBits(oneByteLong, 2L, 6L);
            int isLightWeight = (int)BitTwiddleUtil.extractBits(oneByteLong, 1L, 5L);
            switch (isLightWeight) {
                case 0: {
                    int value_len;
                    int type = (int)BitTwiddleUtil.extractBits(oneByteLong, 5L, 0L);
                    if (type == 0) {
                        return;
                    }
                    int length = (int)NetworkByteOrderNumberUtil.oneByteToUInt(parambuf[off]);
                    ++off;
                    if (length == 0) {
                        if (off + 4 > end_of_hdr) {
                            this.invalidSmfParameterLen(length);
                        }
                        length = (int)NetworkByteOrderNumberUtil.fourByteToUInt(parambuf, off);
                        off += 4;
                        value_len = length - 6;
                    } else {
                        value_len = length - 2;
                    }
                    if (value_len < 0 || value_len + off > end_of_hdr) {
                        this.invalidSmfParameterLen(value_len);
                    }
                    if (!SMFHeaderParameters.KNOWN_PARAMS[type]) {
                        h.setParamAction(uh);
                        h.setUnkParamFlag(true);
                    } else {
                        switch (type) {
                            case 17: {
                                h.setPm_ad_msgid(TlvParameterParser.getSmfAssuredMsgId(parambuf, off));
                                break;
                            }
                            case 18: {
                                h.setPm_ad_prevmsgid(TlvParameterParser.getSmfAssuredMsgId(parambuf, off));
                                break;
                            }
                            case 19: {
                                h.setPm_ad_redelflag(true);
                                break;
                            }
                            case 20: {
                                break;
                            }
                            case 16: {
                                h.setPm_deliverymode(TlvParameterParser.getSmfDeliveryMode(parambuf, off));
                                break;
                            }
                            case 22: {
                                byte[] tmp = new byte[value_len];
                                System.arraycopy(parambuf, off, tmp, 0, value_len);
                                h.setPm_content_summ(tmp);
                                break;
                            }
                            case 3: {
                                h.setPm_msg_priority(TlvParameterParser.getMessagePriority(parambuf, off));
                                break;
                            }
                            case 8: {
                                h.setPm_respcode((int)TlvParameterParser.getResponseCode(parambuf, off));
                                h.setPm_respstr(TlvParameterParser.getResponseString(parambuf, off, value_len));
                                break;
                            }
                            case 4: {
                                byte[] tmp = new byte[value_len];
                                System.arraycopy(parambuf, off, tmp, 0, value_len);
                                h.setPm_userdata(tmp);
                                break;
                            }
                            case 6: {
                                break;
                            }
                            case 7: {
                                break;
                            }
                            case 23: {
                                h.setPm_ad_flowid((int)TlvParameterParser.getSmfAssuredFlowId(parambuf, off));
                                break;
                            }
                            case 24: {
                                h.setPm_tr_topicname_bytes(TlvParameterParser.getTrTopicNameBytes(parambuf, off, value_len));
                                break;
                            }
                            case 25: {
                                h.setPm_ad_flowredelflag(true);
                                break;
                            }
                            case 28: {
                                h.setPm_ad_ttl(TlvParameterParser.getAssuredTtlTime(parambuf, off));
                                break;
                            }
                            case 30: {
                                h.setPm_topicseqnum(TlvParameterParser.getTopicSeqNum(parambuf, off));
                                break;
                            }
                            case 31: {
                                this.handleExtendedStream(h, parambuf, off, value_len);
                                break;
                            }
                            default: {
                                Trace.debug((Object)("SMF parser skipped unhandled header parameter: t_enum=" + type));
                            }
                        }
                    }
                    off += value_len;
                    break;
                }
                case 1: {
                    int type = (int)BitTwiddleUtil.extractBits(oneByteLong, 3L, 2L);
                    int length = (int)BitTwiddleUtil.extractBits(oneByteLong, 2L, 0L) + 1;
                    int value_len = length - 1;
                    if (value_len < 0 || value_len + off > end_of_hdr) {
                        this.invalidSmfParameterLen(value_len);
                    }
                    if (!SMFHeaderParameters.KNOWN_PARAMS[0x20 | type]) {
                        h.setParamAction(uh);
                        h.setUnkParamFlag(true);
                    } else {
                        switch (type) {
                            case 0: {
                                h.setPm_corrtag(TlvParameterParser.getSmfCorrelationId(parambuf, off));
                                break;
                            }
                            case 2: {
                                int[] queueOffsetParse = TlvParameterParser.getTopicQueueNameOffset(parambuf, off);
                                h.setPm_queue_offset(queueOffsetParse[0]);
                                h.setPm_queue_len(queueOffsetParse[1]);
                                break;
                            }
                            case 1: {
                                int[] topicOffsetParse = TlvParameterParser.getTopicQueueNameOffset(parambuf, off);
                                h.setPm_topic_offset(topicOffsetParse[0]);
                                h.setPm_topic_len(topicOffsetParse[1]);
                                break;
                            }
                            case 3: {
                                h.setPm_ad_ackImmediateFlag(true);
                            }
                        }
                    }
                    off += value_len;
                }
            }
        }
    }

    private void handleExtendedStream(SMFHeaderBean h, byte[] buf, int off, int len) {
        int offset = off;
        while (off - offset < len) {
            long twoByteLong = NetworkByteOrderNumberUtil.twoByteToUInt(buf, off);
            off += 2;
            int uh = (int)BitTwiddleUtil.extractBits(twoByteLong, 1L, 15L);
            int extType = (int)BitTwiddleUtil.extractBits(twoByteLong, 3L, 12L);
            int paramType = (int)BitTwiddleUtil.extractBits(twoByteLong, 12L, 0L);
            long valueLen = 0L;
            switch (extType) {
                case 0: {
                    valueLen = 0L;
                    break;
                }
                case 1: {
                    valueLen = 1L;
                    break;
                }
                case 2: {
                    valueLen = 2L;
                    break;
                }
                case 3: {
                    valueLen = 4L;
                    break;
                }
                case 4: {
                    valueLen = 8L;
                    break;
                }
                case 5: {
                    valueLen = NetworkByteOrderNumberUtil.oneByteToUInt(buf[off]);
                    ++off;
                    break;
                }
                case 6: {
                    valueLen = NetworkByteOrderNumberUtil.twoByteToUInt(buf, off);
                    off += 2;
                    break;
                }
                default: {
                    return;
                }
            }
            if (!SMFHeaderParameters.KNOWN_PARAMS[paramType]) {
                h.setParamAction(uh);
                h.setUnkParamFlag(true);
            } else {
                switch (paramType) {
                    case 40: {
                        byte[] token = new byte[(int)valueLen];
                        System.arraycopy(buf, off, token, 0, (int)valueLen);
                        h.setPm_gssapiToken(token);
                        break;
                    }
                    case 41: {
                        if (valueLen == 8L) {
                            h.setPm_ad_ackMsgId(NetworkByteOrderNumberUtil.eightByteToUInt(buf, off));
                            break;
                        }
                        Trace.error((Object)("SMF parser skipped unexpected size of header parameter: PARAM_AD_ACK_MESSAGE_ID, " + valueLen + ", offset=" + off));
                        break;
                    }
                    case 46: {
                        if (valueLen == 4L) {
                            h.setPm_ad_redelivery_count(TlvParameterParser.getSmfAssuredRedeliveryCount(buf, off));
                            break;
                        }
                        Trace.error((Object)("SMF parser skipped unexpected size of header parameter: PARAM_AD_REDELIVERY_COUNT, " + valueLen + ", offset=" + off));
                    }
                }
            }
            off = (int)((long)off + valueLen);
        }
    }

    private void invalidSmfParameterLen(int len) throws IOException {
        throw new IOException(String.format("%s: invalid SMF parameter len (%s)", SMF_HEADER_OPTIONAL_PARAM_PARSE_ERROR, len));
    }

    private void validateSmfHeader(SMFHeaderBean h) throws IOException {
        NioSmfUtil.validateSmfVersion(h.getSmfVersion());
    }

    static {
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[2] = true;
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[3] = true;
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[7] = true;
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[8] = true;
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[9] = true;
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[10] = true;
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[11] = true;
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[14] = true;
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[12] = true;
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[13] = true;
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[15] = true;
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[19] = true;
        SMFHeaderDecoder.KNOWN_RECEIVABLE_PROTO[20] = true;
    }
}

