/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction.xa;

import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPProducerEventHandler;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.ProducerFlowProperties;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.Closeable;
import com.solacesystems.jcsmp.impl.ContextBlockingOpCheck;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.MessageImpl;
import com.solacesystems.jcsmp.impl.PubADManager;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactionSteps;
import com.solacesystems.jcsmp.impl.transaction.xa.XAResourceImpl;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionManager;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactorySmf;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;
import com.solacesystems.jcsmp.transaction.xa.XASession;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XASessionImpl
extends BaseTransactedSessionImpl
implements XASession {
    private final Log Trace = LogFactory.getLog(XASessionImpl.class);
    private XAResourceImpl _xaResource;
    private XASessionManager _xaSessionMgr;
    private int _responseTimeout;
    private volatile XASessionImpl _parent;
    private ContextImpl _context;
    private final Set<FlowHandleImpl> _inputFlows = new HashSet<FlowHandleImpl>();
    private final Set<JCSMPXMLMessageProducer> _outputFlows = new HashSet<JCSMPXMLMessageProducer>();
    private final ContextBlockingOpCheck _contextOpCheck;
    private final AtomicBoolean _closed = new AtomicBoolean(false);
    private final AtomicBoolean _isReady = new AtomicBoolean(false);

    public XASessionImpl(XASessionManager mgr, JCSMPChannelProperties channelProperties) {
        super(true);
        this._xaSessionMgr = mgr;
        this._context = mgr._context;
        this._contextOpCheck = new ContextBlockingOpCheck(this._context, mgr.getJCSMPSession().getJCSMPProperties());
        this._responseTimeout = channelProperties.getReadTimeoutInMillis();
        this._parent = null;
        this._xaResource = new XAResourceImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCSMPXMLMessageProducer getMessageProducer() {
        Set<JCSMPXMLMessageProducer> set = this._outputFlows;
        synchronized (set) {
            if (this._outputFlows.size() > 0) {
                Iterator<JCSMPXMLMessageProducer> it = this._outputFlows.iterator();
                return it.next();
            }
        }
        return null;
    }

    public void setParent(XASessionImpl parent) {
        this._parent = parent;
    }

    public boolean hasUnboundSubFlows() {
        for (FlowHandleImpl fh : this.getTransactionSteps().getInputSteps().keySet()) {
            if (fh.isBoundToResource()) continue;
            return true;
        }
        return false;
    }

    public void messageIdRenumbering(PubADManager adMgr) {
        JCSMPXMLMessageProducer producer;
        Map<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> outputSteps = this.getTransactionOutputStepsCopy();
        TransactionSteps.OutputFlowExtendedInfo info = (TransactionSteps.OutputFlowExtendedInfo)outputSteps.get(producer = adMgr.getMessageProducer());
        if (info != null && info.msgs != null) {
            for (int i = 0; i < info.msgs.size(); ++i) {
                JCSMPXMLMessage msg = info.msgs.get(i);
                long msgId_64bit = adMgr.setMessageIdParamsOnPubMessage(msg);
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug((Object)String.format("XA pub flow message renumbering: flowId=" + adMgr.flow_Id + "; msgId=" + msgId_64bit + "; prevMsgId=" + adMgr.lastMessageIdSent, new Object[0]));
                }
                adMgr.lastMessageIdSent = msgId_64bit;
            }
        }
    }

    public XASessionImpl getParent() {
        return this._parent;
    }

    public boolean isReady() {
        return this._isReady.get();
    }

    public void setIsReady(boolean isReady) {
        if (!isReady) {
            this._xaResource.setRebuildRequestMsgRequired(true);
        } else if (this._xaResource.noOutStandingRequest()) {
            this._xaResource.setRebuildRequestMsgRequired(false);
        }
        this._isReady.getAndSet(isReady);
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)("Set XA session is ready or not (" + isReady + "): isReady=" + this.isReady()));
        }
    }

    public void checkClosed() throws ClosedFacilityException {
        if (this._closed.get()) {
            throw new ClosedFacilityException("XASession closed");
        }
    }

    public void checkClosedXA() throws XAException {
        if (this._closed.get()) {
            ClosedFacilityException e = new ClosedFacilityException("XASession closed");
            XAException ex = new XAException(-3);
            ex.initCause((Throwable)((Object)e));
            throw ex;
        }
    }

    public void checkContext() throws XAException {
        try {
            this._contextOpCheck.check();
        }
        catch (InvalidOperationException e) {
            XAException ex = new XAException(-3);
            ex.initCause((Throwable)((Object)e));
            throw ex;
        }
    }

    @Override
    public XAResource getXAResource() throws JCSMPException {
        return this._xaResource;
    }

    public XASessionManager getXASessionManager() {
        return this._xaSessionMgr;
    }

    public int getResponseTimeout() {
        return this._responseTimeout;
    }

    @Override
    public boolean beforeEnqueue(FlowHandleImpl fh, XMLMessage deliver) {
        TransactionSteps.InputFlowExtendedInfo info = (TransactionSteps.InputFlowExtendedInfo)this.getTransactionSteps().getInputSteps().get(fh);
        if (info != null && info.exists(deliver.getAckMessageId())) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug((Object)("Dropping duplicate message with ack message id of " + deliver.getAckMessageId()));
            }
            return false;
        }
        return super.beforeEnqueue(fh, deliver);
    }

    @Override
    public void notifyPostReconnect(FlowHandleImpl fh) {
        super.notifyPostReconnect(fh);
        fh.rollback();
    }

    public void trackMessage(BytesXMLMessage message) throws JCSMPException {
        this.checkClosed();
        if (this._inputFlows.size() > 0 || this._outputFlows.size() > 0) {
            throw new IllegalStateException("Cannot track messages on XASessions that have input or output flows");
        }
        this.addInputStep((FlowHandleImpl)((JCSMPXMLMessage)((Object)((MessageImpl)message).getWrappedMessage())).getMessageConsumer(), message.getMessageIdLong(), message.getAckMessageId());
    }

    @Override
    public FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties flowProps, EndpointProperties endpointProps) throws JCSMPException {
        return this.createFlow(listener, flowProps, endpointProps, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties flowProps, EndpointProperties endpointProps, FlowEventHandler flowEventHandler) throws JCSMPException {
        this.checkClosed();
        this._contextOpCheck.check();
        JCSMPBasicSession.InternalBindProperties bindprops = JCSMPBasicSession.InternalBindProperties.create().with(this);
        FlowReceiver fr = this._xaSessionMgr.getJCSMPSession().createFlow(listener, flowProps, endpointProps, bindprops, flowEventHandler);
        Set<FlowHandleImpl> set = this._inputFlows;
        synchronized (set) {
            this._inputFlows.add((FlowHandleImpl)fr);
        }
        return fr;
    }

    @Override
    public void closeFlow(Closeable flow) {
        if (flow instanceof FlowHandleImpl) {
            ((FlowHandleImpl)flow).closeImpl(true, false, TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE);
        } else if (flow instanceof JCSMPXMLMessageProducer) {
            ((JCSMPXMLMessageProducer)flow).closeImpl(false);
        } else {
            throw new IllegalArgumentException("flow must be instance of FlowHandleImpl or JCSMPXMLMessageProducer");
        }
    }

    @Override
    public boolean getExpectsAcks() {
        return !this._xaResource.hasAssociatedXid();
    }

    void waitUntilAckComplete() throws InterruptedException {
        for (JCSMPXMLMessageProducer producer : this._outputFlows) {
            producer.getPubADManager().waitUntilQueueEmpty();
        }
    }

    @Override
    public XMLMessageProducer createProducer(ProducerFlowProperties fprop, JCSMPStreamingPublishEventHandler callback) throws JCSMPException {
        return this.createProducer(fprop, callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLMessageProducer createProducer(ProducerFlowProperties fprop, JCSMPStreamingPublishEventHandler callback, JCSMPProducerEventHandler eventCallback) throws JCSMPException {
        this.checkClosed();
        this._contextOpCheck.check();
        JCSMPBasicSession.InternalBindProperties bindprops = JCSMPBasicSession.InternalBindProperties.create().with(this, this._xaSessionMgr.getSubChannel().getConnCounterTag());
        JCSMPXMLMessageProducer prod = (JCSMPXMLMessageProducer)this._xaSessionMgr.getJCSMPSession().createProducer(fprop, callback, eventCallback, bindprops);
        Set<JCSMPXMLMessageProducer> set = this._outputFlows;
        synchronized (set) {
            this._outputFlows.add(prod);
        }
        return prod;
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(JCSMPException e) {
        if (this._closed.getAndSet(true)) {
            return;
        }
        if (e == null) {
            this.Trace.debug((Object)String.format("Closing XASession (%s).", this.toString()));
        } else {
            this.Trace.info((Object)String.format("Closing XASession (%s), handling unrecoverable exception: %s", new Object[]{this.toString(), e}), (Throwable)((Object)e));
        }
        this._xaSessionMgr.removeManagedTransactedSession(this);
        LinkedList<Closeable> to_close = new LinkedList<Closeable>();
        Object object = this._inputFlows;
        synchronized (object) {
            to_close.addAll(this._inputFlows);
        }
        object = this._outputFlows;
        synchronized (object) {
            to_close.addAll(this._outputFlows);
        }
        this.Trace.debug((Object)String.format("XA session (%s) closing; closing %s managed guaranteed delivery flows.", this.getName(), to_close.size()));
        for (Closeable obj : to_close) {
            try {
                obj.close();
            }
            catch (Throwable t) {
                this.Trace.info((Object)"Error closing GD flow", t);
            }
        }
        this.resetTransactionSteps();
        this._xaResource.close((Exception)((Object)e));
        try {
            this.doCloseXASession(e);
        }
        catch (JCSMPException ex) {
            this.Trace.info((Object)"Error closing XA session", (Throwable)((Object)ex));
        }
    }

    @Override
    public void resetTransactionSteps() {
        if (this._parent != null) {
            this._parent.resetTransactionSteps(this.getTransactionSteps());
        }
        super.resetTransactionSteps();
    }

    public String toString() {
        return String.format("(XASessionId:%s, Name:%s)", this.getTransactedSessionId(), this.getName());
    }

    @Override
    public void notifyVridChange() {
    }

    @Override
    public void notifyUnknownName() {
        this._xaResource.notifyUnknownSessionName();
        this.setName(null);
    }

    public void handleUnrecoverableException(JCSMPException e) {
        this.close(e);
    }

    public void notifyFlowRebindFinished() throws JCSMPException {
        Map<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> outputSteps = this.getTransactionOutputStepsCopy();
        for (Map.Entry<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> entry : outputSteps.entrySet()) {
            JCSMPXMLMessageProducer producer = entry.getKey();
            TransactionSteps.OutputFlowExtendedInfo info = (TransactionSteps.OutputFlowExtendedInfo)entry.getValue();
            Integer channelTag = ((TcpClientChannel)producer.channel).getConnCounterTag();
            if (info.msgs == null) continue;
            for (int i = 0; i < info.msgs.size(); ++i) {
                JCSMPXMLMessage msg = info.msgs.get(i);
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug((Object)String.format("Resend Message: " + msg.toString(), new Object[0]));
                }
                producer.sendMsgOnce(new JCSMPXMLMessage[]{msg}, 0, 1, false, false, false, false, channelTag, true, true, null);
            }
        }
    }

    public void triggerRequestRetransmit() throws JCSMPException {
        this._xaResource.triggerRequestRetransmit();
    }

    public long doOpenXASession(boolean onReconnect) throws JCSMPException {
        JCSMPBasicSession session = this._xaSessionMgr.getJCSMPSession();
        TcpClientChannel subChannel = this._xaSessionMgr.getSubChannel();
        WireMessage response = null;
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
        long corrId = this._xaSessionMgr.getSubChannel().getGeneralSeqAllocator().getNext24b();
        smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(corrId));
        AssuredCtrlHeaderBean assBean = session.getAssuredCtrlFactory().createOpenXASession((byte)session.getNegotiatedMaxXAVersion());
        WireMessage msgReq = WireMessageFactory.createWith(smfHeader, assBean);
        msgReq.setFriendlyName("ADCTRL-Open XA Session");
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)String.format("Created ADCTRL TransactionCtrl OpenXASession Handshake Request", new Object[0]));
        }
        if (!onReconnect) {
            response = subChannel.doSmfSharedRequestRetryForever(msgReq, null, corrId, false);
        } else {
            while (true) {
                try {
                    response = subChannel.doSmfSubSingleShotRequest(msgReq, true, true, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, subChannel.getConnCounterTag(), corrId);
                }
                catch (JCSMPException e) {
                    if (e instanceof JCSMPTransportException && e.getMessage() != null && e.getMessage().startsWith("ClientRequestResponse Timeout")) continue;
                    throw e;
                }
                break;
            }
        }
        SMFHeaderBean smfh = response.getSmfHeader();
        int resp_code = smfh.getPm_respcode();
        if (resp_code != 200) {
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info((Object)(this.getNetworkInfoString() + "Error Response (" + resp_code + ") - " + smfh.getPm_respstr()));
            }
            throw new JCSMPErrorResponseException(resp_code, smfh.getPm_respstr(), "", this.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
        }
        smfHeader = response.getSmfHeader();
        if (smfHeader.getProtocol() != 9) {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedAssuredCtrlResponseGotWrongType"));
        }
        if (!(response.getHeaderBean() instanceof AssuredCtrlHeaderBean)) {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedAssredCtrlResponseBlockNotFound"));
        }
        AssuredCtrlHeaderBean adctrl_response = (AssuredCtrlHeaderBean)response.getHeaderBean();
        this.processOpenXASessionResponse(adctrl_response);
        boolean isReadyAfterOpen = !onReconnect;
        this.setIsReady(isReadyAfterOpen);
        return this.getTransactedSessionId();
    }

    public void processOpenXASessionResponse(AssuredCtrlHeaderBean adctrl) throws JCSMPException {
        SmfTLVParameter param = (SmfTLVParameter)adctrl.findFirstParameter(43);
        byte[] value = param.value;
        byte xaMsgType = value[0];
        if (xaMsgType == AssuredCtrlEnums.XACtrlMessageType.OPEN_XA_SESSION_RESPONSE.smfEnc()) {
            long txSessionId = NetworkByteOrderNumberUtil.fourByteToUInt(value, 1);
            this.setTransactedSessionId(txSessionId);
            byte txSessionNameLen = value[5];
            String str = "";
            try {
                str = new String(value, 6, txSessionNameLen - 2, "ASCII");
                this.setName(str);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.Trace.error((Object)"error");
        }
        this._xaSessionMgr.addManagedTransactedSession(this);
    }

    public long doResumeXASession() throws JCSMPException {
        JCSMPBasicSession session = this._xaSessionMgr.getJCSMPSession();
        TcpClientChannel subChannel = this._xaSessionMgr.getSubChannel();
        WireMessage response = null;
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
        long corrId = this._xaSessionMgr.getSubChannel().getGeneralSeqAllocator().getNext24b();
        smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(corrId));
        AssuredCtrlHeaderBean assBean = session.getAssuredCtrlFactory().createResumeXASession((byte)session.getNegotiatedMaxXAVersion(), this.getName());
        WireMessage msgReq = WireMessageFactory.createWith(smfHeader, assBean);
        msgReq.setFriendlyName("ADCTRL-Resume XA Session");
        while (true) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug((Object)String.format("Created ADCTRL TransactionCtrl ResumeXASession Handshake Request", new Object[0]));
            }
            try {
                response = subChannel.doSmfSubSingleShotRequest(msgReq, true, true, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, subChannel.getConnCounterTag(), corrId);
            }
            catch (JCSMPException e) {
                if (e instanceof JCSMPTransportException && e.getMessage() != null && e.getMessage().startsWith("ClientRequestResponse Timeout")) continue;
                throw e;
            }
            break;
        }
        SMFHeaderBean smfh = response.getSmfHeader();
        int resp_code = smfh.getPm_respcode();
        if (resp_code != 200) {
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info((Object)(this.getNetworkInfoString() + "Error Response (" + resp_code + ") - " + smfh.getPm_respstr()));
            }
            JCSMPErrorResponseException e = new JCSMPErrorResponseException(resp_code, smfh.getPm_respstr() + " (" + this.getName() + ")", "", this.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            throw e;
        }
        smfHeader = response.getSmfHeader();
        if (smfHeader.getProtocol() != 9) {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedAssuredCtrlResponseGotWrongType"));
        }
        if (!(response.getHeaderBean() instanceof AssuredCtrlHeaderBean)) {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedAssredCtrlResponseBlockNotFound"));
        }
        AssuredCtrlHeaderBean adctrl_response = (AssuredCtrlHeaderBean)response.getHeaderBean();
        this.processResumeXASessionResponse(adctrl_response);
        return this.getTransactedSessionId();
    }

    public void processResumeXASessionResponse(AssuredCtrlHeaderBean adctrl) throws JCSMPException {
        SmfTLVParameter param = (SmfTLVParameter)adctrl.findFirstParameter(43);
        byte[] value = param.value;
        byte xaMsgType = value[0];
        if (xaMsgType == AssuredCtrlEnums.XACtrlMessageType.RESUME_XA_SESSION_RESPONSE.smfEnc()) {
            long txSessionId = NetworkByteOrderNumberUtil.fourByteToUInt(value, 1);
            this.setTransactedSessionId(txSessionId);
        } else if (this.Trace.isErrorEnabled()) {
            this.Trace.error((Object)("Expected Resume XA session response got " + xaMsgType));
        }
    }

    public void doCloseXASession(JCSMPException ex) throws JCSMPException {
        JCSMPBasicSession session = this._xaSessionMgr.getJCSMPSession();
        TcpClientChannel subChannel = this._xaSessionMgr.getSubChannel();
        WireMessage msgReq = null;
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(9).setTtl(1);
        long corrId = this._xaSessionMgr.getSubChannel().getGeneralSeqAllocator().getNext24b();
        smfHeader.addParam(TlvParameterFactorySmf.instance().getCorrelationId(corrId));
        AssuredCtrlHeaderBean assBean = session.getAssuredCtrlFactory().createCloseXASession(this.getName());
        msgReq = WireMessageFactory.createWith(smfHeader, assBean);
        msgReq.setFriendlyName("ADCTRL-Close XA Session");
        if (ex == null) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug((Object)String.format("Created ADCTRL TransactionCtrl CloseXASession Request", new Object[0]));
            }
            subChannel.doSmfSharedRequestRetryForever(msgReq, null, corrId);
        } else {
            while (true) {
                try {
                    subChannel.doSmfSubSingleShotRequest(msgReq, true, true, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, subChannel.getConnCounterTag(), corrId);
                }
                catch (JCSMPException e) {
                    if (e instanceof JCSMPTransportException && e.getMessage() != null && e.getMessage().startsWith("ClientRequestResponse Timeout")) continue;
                }
                break;
            }
        }
    }

    public String getNetworkInfoString() {
        String networkInfo = "";
        if (this._xaSessionMgr.getSubChannel() != null) {
            networkInfo = this._xaSessionMgr.getSubChannel().getNetworkInfoString();
        }
        return networkInfo;
    }

    @Override
    public boolean isXA() {
        return true;
    }
}

