/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.nio.impl;

import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.protocol.nio.SubscriberWireMessageHandler;
import com.solacesystems.jcsmp.protocol.nio.impl.SubscriberMessageReader;
import com.solacesystems.jcsmp.protocol.smf.SSLSmfClient;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import javax.net.ssl.SSLEngineResult;

public class SSLSubscriberMessageReader
extends SubscriberMessageReader {
    private SSLSmfClient mSMFClient;
    private boolean readMoreData = false;

    public SSLSubscriberMessageReader(ByteChannel byteChannel, SubscriberWireMessageHandler callbackHandler, SSLSmfClient smfClient, boolean genRxTimestamps, JCSMPSessionStats sessionstats) {
        super(byteChannel, callbackHandler, genRxTimestamps, sessionstats);
        this.mSMFClient = smfClient;
    }

    protected void drainSocketData() throws IOException {
        this._bytesLastDrain = 0;
        int totalDecompressed = 0;
        int cnt = 0;
        ByteChannel s = (ByteChannel)((Object)this.getChannel());
        if (this.readMoreData) {
            if (this.mSMFClient.mSocketReadSideBuffer.position() < this.mSMFClient.mSocketReadSideBuffer.limit()) {
                ByteBuffer newBuf = ByteBuffer.allocate(this.mSMFClient.mSocketReadSideBuffer.capacity());
                newBuf.put(this.mSMFClient.mSocketReadSideBuffer);
                this.mSMFClient.mSocketReadSideBuffer = newBuf;
            }
        } else {
            this.mSMFClient.mSocketReadSideBuffer.clear();
        }
        this.mSMFClient.mSMFReadSideBuffer.clear();
        boolean closed = false;
        cnt = s.read(this.mSMFClient.mSocketReadSideBuffer);
        if (cnt > 0) {
            this._bytesLastDrain += cnt;
            this.mSMFClient.mSocketReadSideBuffer.flip();
            do {
                SSLSmfClient.ProcessResult result = this.mSMFClient.process(true);
                this.readMoreData = result.wrap_unwrapResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW;
                boolean bl = closed = result.wrap_unwrapResult.getStatus() == SSLEngineResult.Status.CLOSED;
            } while (this.mSMFClient.mSocketReadSideBuffer.hasRemaining() && !this.readMoreData && !closed);
            if (this.mSMFClient.mSMFReadSideBuffer.remaining() > 0 && !closed) {
                int room = this._inputBuf.remaining();
                this.mSMFClient.mSMFReadSideBuffer.flip();
                int size = this.mSMFClient.mSMFReadSideBuffer.remaining();
                if (size > room) {
                    int newSize = size - room + this._inputBuf.capacity();
                    this._inputBuf.flip();
                    this.resizeBuffer(newSize);
                }
                this._inputBuf.put(this.mSMFClient.mSMFReadSideBuffer);
            }
        }
        if (cnt < 0 || closed) {
            this.closeChannel();
        }
        this._sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_RECVED, totalDecompressed);
        this._sessionStats.incStat(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_RECVED, this._bytesLastDrain);
    }
}

