/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction;

import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.impl.Closeable;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.InternalConnectEvent;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionManagerSmf;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderParameters;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactedSessionManager
implements Closeable {
    private static final Log Trace = LogFactory.getLog(TransactedSessionManager.class);
    JCSMPBasicSession _session = null;
    TcpClientChannel subChannel = null;
    TransactedSessionManagerSmf transactionSmf = null;
    Set<TransactedSessionImpl> managedTransactions = null;
    Map<Long, TransactedSessionImpl> activeTransactions = null;
    ContextImpl context;
    private final AtomicBoolean _checkUnboundFlows = new AtomicBoolean(true);

    public TransactedSessionManager(JCSMPBasicSession session, ContextImpl context) {
        this._session = session;
        this.managedTransactions = new HashSet<TransactedSessionImpl>();
        this.activeTransactions = new HashMap<Long, TransactedSessionImpl>();
        this.transactionSmf = new TransactedSessionManagerSmf(this);
        this.context = context;
    }

    public String getNetworkInfoString() {
        String networkInfo = "";
        if (this.subChannel != null) {
            networkInfo = this.subChannel.getNetworkInfoString();
        }
        return networkInfo;
    }

    public void setSubChannel(TcpClientChannel channel) {
        this.subChannel = channel;
        if (channel != null) {
            channel.setTransactedSessionMgr(this);
        }
    }

    public TcpClientChannel getSubChannel() {
        return this.subChannel;
    }

    public JCSMPBasicSession getSession() {
        return this._session;
    }

    public TransactedSessionImpl createTransactedSession() throws JCSMPException {
        TransactedSessionImpl ts = new TransactedSessionImpl(this, this.getSubChannel().getChannelProperties());
        this._session.waitUntilSessionReconnectDone("createTransactedSession");
        this.transactionSmf.doOpenTxSession(ts, true);
        return ts;
    }

    public void closeTransactedSession(TransactedSessionImpl ts, boolean graceful) {
        this.transactionSmf.doCloseTransactedSession(ts, graceful);
    }

    public void handleAsyncAssuredCtrlMessage(WireMessage wmsg) {
        try {
            this.transactionSmf.handleAsyncAssuredCtrlMessage(wmsg);
        }
        catch (JCSMPException e) {
            Trace.info((Object)"Error handling async assuredctrl message, dropped.", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchAssuredCtrlMessage(AssuredCtrlEnums.TransactionCtrlMessageType mtype, long transactedSessionId, AssuredCtrlHeaderBean adctrl, JCSMPErrorResponseException err_resp) {
        TransactedSessionImpl dispatch_target;
        Map<Long, TransactedSessionImpl> map = this.activeTransactions;
        synchronized (map) {
            dispatch_target = this.activeTransactions.get(transactedSessionId);
        }
        if (dispatch_target != null) {
            dispatch_target.handleControlMessage(mtype, adctrl, err_resp);
        } else {
            switch (mtype) {
                case CLOSE_TRANSACTED_SESSION: {
                    break;
                }
                default: {
                    Trace.info((Object)"Ignored assuredctrl message, no associated TransactedSession.");
                }
            }
        }
    }

    public void sendCommitRequest(long transactedSessionId, AssuredCtrlHeaderParameters.ParamTransactionId tid, AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify pubnotify, AssuredCtrlHeaderParameters.ParamTransactionFDSubAck suback, boolean dropOnAppThread, Integer connIdx) throws JCSMPException {
        this.transactionSmf.doSendCommit(transactedSessionId, tid, pubnotify, suback, dropOnAppThread, connIdx);
    }

    public void sendRollbackRequest(long transactedSessionId, AssuredCtrlHeaderParameters.ParamTransactionId tid, AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify pubnotify, AssuredCtrlHeaderParameters.ParamTransactionFDSubAck suback, boolean dropOnAppThread, Integer connIdx) throws JCSMPException {
        this.transactionSmf.doSendRollback(transactedSessionId, tid, pubnotify, suback, dropOnAppThread, connIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addManagedTransactedSession(TransactedSessionImpl ts) {
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            Map<Long, TransactedSessionImpl> map = this.activeTransactions;
            synchronized (map) {
                this.managedTransactions.add(ts);
                this.activeTransactions.put(ts.getTransactedSessionId(), ts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeManagedTransactedSession(TransactedSessionImpl ts) {
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            Map<Long, TransactedSessionImpl> map = this.activeTransactions;
            synchronized (map) {
                this.managedTransactions.remove(ts);
                TransactedSessionManager.removeEntries(this.activeTransactions, ts);
            }
        }
    }

    private static void removeEntries(Map<Long, TransactedSessionImpl> map, TransactedSessionImpl e) {
        Set<Map.Entry<Long, TransactedSessionImpl>> entries = map.entrySet();
        Iterator<Map.Entry<Long, TransactedSessionImpl>> x = entries.iterator();
        while (x.hasNext()) {
            Map.Entry<Long, TransactedSessionImpl> next = x.next();
            if (!next.getValue().equals(e)) continue;
            x.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildDispatchTransactionsList(List<TransactedSessionImpl> to_close) {
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            to_close.addAll(this.managedTransactions);
        }
    }

    public void dispatchChannelException(JCSMPException ex, List<TransactedSessionImpl> to_close) {
        for (TransactedSessionImpl s : to_close) {
            s.handleUnrecoverableException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LinkedList<TransactedSessionImpl> to_close = new LinkedList<TransactedSessionImpl>();
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            to_close.addAll(this.managedTransactions);
        }
        for (TransactedSessionImpl s : to_close) {
            s.close();
        }
    }

    private static <E> Set<E> copySet(Collection<E> s) {
        HashSet<E> newset = new HashSet<E>();
        newset.addAll(s);
        return newset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUnknownName() {
        Set<TransactedSessionImpl> managedCpy;
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            managedCpy = TransactedSessionManager.copySet(this.managedTransactions);
        }
        for (TransactedSessionImpl ts : managedCpy) {
            ts.notifyUnknownName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyVridChange() {
        Set<TransactedSessionImpl> managedCpy;
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            managedCpy = TransactedSessionManager.copySet(this.managedTransactions);
        }
        for (TransactedSessionImpl ts : managedCpy) {
            ts.notifyVridChange();
        }
    }

    public boolean reconnectInProgress() {
        return this._session.reconnectInProgress();
    }

    public boolean checkUnboundFlows() {
        return this._checkUnboundFlows.get();
    }

    public void checkUnboundFlows(boolean check) {
        Trace.debug((Object)("Turn on (true) /off (false) unbound flow checking: " + check));
        this._checkUnboundFlows.getAndSet(check);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConnectEvent(InternalConnectEvent ev) throws JCSMPException {
        Trace.debug((Object)String.format("Got connect event: %s", ev));
        switch (ev.type) {
            case PRE_RECONNECT: {
                Set<TransactedSessionImpl> managedCpy;
                Set<TransactedSessionImpl> set = this.managedTransactions;
                synchronized (set) {
                    managedCpy = TransactedSessionManager.copySet(this.managedTransactions);
                }
                this.checkUnboundFlows(false);
                for (TransactedSessionImpl ts : managedCpy) {
                    ts.responseTimerSetter.stopTimer();
                }
                break;
            }
            case POST_RECONNECT: {
                Set<TransactedSessionImpl> sessionsToRebind;
                Set<TransactedSessionImpl> ts = this.managedTransactions;
                synchronized (ts) {
                    Map<Long, TransactedSessionImpl> map = this.activeTransactions;
                    synchronized (map) {
                        this.activeTransactions.clear();
                        sessionsToRebind = TransactedSessionManager.copySet(this.managedTransactions);
                    }
                }
                for (TransactedSessionImpl ts2 : sessionsToRebind) {
                    this.transactionSmf.doOpenTxSession(ts2, false);
                    this.addManagedTransactedSession(ts2);
                }
                break;
            }
            case FLOW_REBIND_FINISHED: {
                Set<TransactedSessionImpl> activeCpy;
                Map<Long, TransactedSessionImpl> map = this.activeTransactions;
                synchronized (map) {
                    activeCpy = TransactedSessionManager.copySet(this.activeTransactions.values());
                }
                this.checkUnboundFlows(true);
                for (TransactedSessionImpl ts : activeCpy) {
                    ts.notifyFlowRebindFinished();
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<TransactedSessionImpl> set = this.managedTransactions;
        synchronized (set) {
            sb.append(String.format("%s transacted sessions:%n", this.managedTransactions.size()));
            for (TransactedSessionImpl ts : this.managedTransactions) {
                sb.append("    ").append(ts.toString()).append("%n");
            }
        }
        return sb.toString();
    }
}

