/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.property.impl;

import com.solacesystems.common.property.PropertyConversionException;
import com.solacesystems.common.property.PropertyConverter;
import com.solacesystems.common.property.PropertySource;
import com.solacesystems.common.property.PropertyVetoException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPropertySource<T>
extends PropertySource<T>
implements Cloneable {
    private Object mKey;
    private Map<?, ?> mMap;

    public MapPropertySource(MapPropertySource<T> source) {
        super(source);
        this.mKey = source.mKey;
        this.mMap = source.mMap;
    }

    public MapPropertySource(String name, Object key, Map<?, ?> map) {
        this(name, key, map, 1);
    }

    public MapPropertySource(String name, Object key, Map<?, ?> map, int priority) {
        this(name, key, map, priority, DEFAULT_NULL_VALID);
    }

    public MapPropertySource(String name, Object key, Map<?, ?> map, boolean nullValid) {
        this(name, key, map, 1, nullValid);
    }

    public MapPropertySource(String name, Object key, Map<?, ?> map, PropertyConverter converter) {
        this(name, key, map, 1, converter);
    }

    public MapPropertySource(String name, Object key, Map<?, ?> map, int priority, boolean nullValid) {
        this(name, key, map, priority, nullValid, null);
    }

    public MapPropertySource(String name, Object key, Map<?, ?> map, int priority, PropertyConverter converter) {
        this(name, key, map, priority, DEFAULT_NULL_VALID, converter);
    }

    public MapPropertySource(String name, Object key, Map<?, ?> map, int priority, boolean nullValid, PropertyConverter converter) {
        super(name, priority, nullValid, converter);
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.mKey = key;
        this.mMap = map;
    }

    public Object getKey() {
        return this.mKey;
    }

    public Map<?, ?> getMap() {
        return this.mMap;
    }

    @Override
    public void initialize() throws PropertyVetoException, PropertyConversionException {
        if (this.mMap != null && this.mMap.containsKey(this.mKey)) {
            this.setObjectValue(this.mMap.get(this.mKey));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new MapPropertySource<T>(this);
    }
}

