/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import com.solacesystems.common.util.InvalidStateException;
import com.solacesystems.common.util.JMXClient;
import java.util.Random;

public class CPUUsage {
    private static final String HOST = "localhost";
    private static final String LOGIN = "";
    private static final String PASS = "";
    private static final String BEANNAME = "java.lang:type=OperatingSystem";
    private static final String COMMAND = "ProcessCpuTime";
    private static final int DEFAULTPORT = 9999;
    private long m_startResetInterval = 0L;
    private long m_startResetCpu = 0L;
    private long m_InitialCpu = 0L;
    private int m_defaultPort = 9999;
    private static CPUUsage m_defaultInstance = null;

    public static synchronized CPUUsage getDefaultInstance() throws InvalidStateException {
        if (m_defaultInstance == null) {
            m_defaultInstance = CPUUsage.newInstance(9999);
        }
        return m_defaultInstance;
    }

    public static synchronized CPUUsage newInstance(int port) throws InvalidStateException {
        return new CPUUsage(port);
    }

    private CPUUsage(int port) throws InvalidStateException {
        this.m_defaultPort = port;
        this.m_startResetInterval = System.nanoTime();
        try {
            this.m_InitialCpu = this.m_startResetCpu = CPUUsage.getProcessCpuTime(port);
        }
        catch (Exception ex) {
            throw new InvalidStateException("Unable to get CPU process time", ex);
        }
        if (this.m_InitialCpu <= 0L) {
            throw new InvalidStateException("Unable to get CPU process time");
        }
    }

    public synchronized void resetInterval() {
        long p;
        long l = System.nanoTime();
        this.m_startResetCpu = p = CPUUsage.getProcessCpuTime(this.m_defaultPort);
        this.m_startResetInterval = l;
    }

    public synchronized double resetIntervalAndGetCpuUsage() {
        long l = System.nanoTime();
        long p = CPUUsage.getProcessCpuTime(this.m_defaultPort);
        long deltaCPU = p - this.m_startResetCpu;
        long deltaTime = l - this.m_startResetInterval;
        double f = Math.min((double)deltaCPU / (double)deltaTime, 1.0) * 100.0;
        this.m_startResetCpu = p;
        this.m_startResetInterval = l;
        return f;
    }

    public synchronized double getCpuUsageSofar() {
        long deltaCPU = CPUUsage.getProcessCpuTime(this.m_defaultPort) - this.m_startResetCpu;
        long deltaTime = System.nanoTime() - this.m_startResetInterval;
        double f = Math.min((double)deltaCPU / (double)deltaTime, 1.0) * 100.0;
        return f;
    }

    public static long getProcessCpuTime(int port) {
        JMXClient jmxClient = new JMXClient();
        try {
            Object[] results = jmxClient.execute("localhost:" + port, "", "", BEANNAME, new String[]{COMMAND}, true);
            if (results.length != 1) {
                return -1L;
            }
            long l = (Long)results[0];
            return l;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static synchronized long getCPU() {
        return CPUUsage.getProcessCpuTime(9999);
    }

    public static void main(String[] args) throws Exception {
        CPUUsage usage = CPUUsage.getDefaultInstance();
        for (int i = 0; i < 12; ++i) {
            try {
                for (int j = 0; j < 10000000; ++j) {
                    System.currentTimeMillis();
                }
                Thread.yield();
                Random r = new Random();
                r.nextInt(1500);
                Thread.sleep(r.nextInt(1500));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println(usage.resetIntervalAndGetCpuUsage());
        }
        System.out.println(usage.getCpuUsageSofar());
    }
}

