/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.sdt;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.MapMessage;
import com.solacesystems.jcsmp.Producer;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.StreamMessage;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.XMLContentMessage;
import com.solacesystems.jcsmp.impl.TopicImpl;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import com.solacesystems.jcsmp.impl.sdt.StreamImpl;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteropTest {
    public static boolean IgnoreGeneratedSendTimestamps = false;
    public static final int MIN_INTEROP_ID = 1;
    public static final int MAX_INTEROP_ID = 21;
    public static final Map<Integer, InteropTest> Tests = InteropTest.initTests();
    public int testNo;
    public String appMsgID;
    public String appMsgType;
    public String correlationID;
    public SDTMap props;
    public Destination replyTo;
    public String senderID;
    public Long sendTs;
    public Long seqNo;
    public Long expiration;
    public boolean isStructMsg;
    public byte structMsgType;
    public Object payload;
    public PayloadLocation location;

    private static Map<Integer, InteropTest> initTests() {
        String methodPrefix = "interopTest";
        int methodPrefixLength = "interopTest".length();
        TreeMap<Integer, InteropTest> tests = new TreeMap<Integer, InteropTest>();
        try {
            Method[] methods = InteropTest.class.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().startsWith("interopTest")) continue;
                InteropTest test = (InteropTest)methods[i].invoke(null, (Object[])null);
                test.testNo = Integer.valueOf(methods[i].getName().substring(methodPrefixLength));
                tests.put(test.testNo, test);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tests;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int validateRecvMsg(BytesXMLMessage msg) {
        InteropTest test = null;
        byte[] userData = msg.getUserData();
        if (userData == null) throw new IllegalArgumentException("no test number specified in user data");
        if (userData.length == 0) {
            throw new IllegalArgumentException("no test number specified in user data");
        }
        test = Tests.get(userData[0]);
        if (test == null) {
            throw new IllegalArgumentException("unknown test number specified - " + userData[0]);
        }
        InteropTest.testValues(test.appMsgID, msg.getAppMessageID(), test.testNo, "App Message IDs don't match");
        InteropTest.testValues(test.appMsgType, msg.getAppMessageType(), test.testNo, "App Message Types don't match");
        InteropTest.testValues(test.correlationID, msg.getCorrelationId(), test.testNo, "Correlation IDs don't match");
        InteropTest.testValues(test.props, msg.getProperties(), test.testNo, "User Properties don't match");
        InteropTest.testValues(test.replyTo, msg.getReplyTo(), test.testNo, "ReplyTos don't match");
        InteropTest.testValues(test.senderID, msg.getSenderID(), test.testNo, "Sender IDs don't match");
        InteropTest.testSendTimestamps(test.sendTs, msg.getSendTimestamp(), test.testNo, "Send Timestamps don't match");
        InteropTest.testExpiration(test.expiration, msg.getExpiration(), test.testNo, "Expiration don't match");
        InteropTest.testValues(test.seqNo, msg.getSequenceNumber(), test.testNo, "Sequence Numbers don't match");
        InteropTest.testValues(test.isStructMsg, msg.isStructuredMsg(), test.testNo, "Are Structured Messages don't match");
        InteropTest.testValues(test.structMsgType, msg.getStructuredMsgType(), test.testNo, "Message Types don't match");
        boolean isStructMsg = msg.isStructuredMsg();
        byte structMsgType = msg.getStructuredMsgType();
        if (isStructMsg) {
            if (structMsgType == 10) {
                MapMessage mapMsg = (MapMessage)msg;
                InteropTest.testMapValues((SDTMap)test.payload, mapMsg.getMap(), test.testNo, "Map Payloads don't match");
                return test.testNo;
            }
            if (structMsgType == 11) {
                StreamMessage streamMsg = (StreamMessage)msg;
                InteropTest.testStreamValues((SDTStream)test.payload, streamMsg.getStream(), test.testNo, "Stream Payloads don't match");
                return test.testNo;
            }
            if (structMsgType != 7) throw new IllegalArgumentException(InteropTest.getErrorStr(test.testNo, "Unknown structured message type"));
            TextMessage textMsg = (TextMessage)msg;
            InteropTest.testValues(test.payload, textMsg.getText(), test.testNo, "Text Payloads don't match");
            return test.testNo;
        }
        if (structMsgType == 2) {
            byte[] payload = new byte[msg.getAttachmentContentLength()];
            msg.readAttachmentBytes(payload);
            InteropTest.testByteArrayValues(test.payload, payload, test.testNo, "JMS Bytes Payloads don't match");
            return test.testNo;
        }
        if (structMsgType == 3) {
            byte[] payload = new byte[msg.getAttachmentContentLength()];
            msg.readAttachmentBytes(payload);
            InteropTest.testByteArrayValues(test.payload, payload, test.testNo, "JMS Object Payloads don't match");
            return test.testNo;
        }
        if (structMsgType == 4) {
            byte[] payload = new byte[msg.getAttachmentContentLength()];
            msg.readAttachmentBytes(payload);
            InteropTest.testByteArrayValues(test.payload, payload, test.testNo, "JMS Properties Payloads don't match");
            return test.testNo;
        }
        if (structMsgType == 0) {
            if (msg.getContentLength() > 0) {
                byte[] payload = new byte[msg.getContentLength()];
                msg.readBytes(payload);
                InteropTest.testByteArrayValues(test.payload, payload, test.testNo, "Unstructured Payloads don't match");
                return test.testNo;
            }
            if (msg.getAttachmentContentLength() > 0) {
                byte[] payload = new byte[msg.getAttachmentContentLength()];
                msg.readAttachmentBytes(payload);
                InteropTest.testByteArrayValues(test.payload, payload, test.testNo, "Unstructured Payloads don't match");
                return test.testNo;
            }
            if (test.payload == null) return test.testNo;
            throw new IllegalArgumentException(InteropTest.getErrorStr(test.testNo, "Unstructured Payloads don't match"));
        }
        if (structMsgType != 1) throw new IllegalArgumentException(InteropTest.getErrorStr(test.testNo, "Unknown structured message type"));
        if (msg.getContentLength() == 0) {
            if (test.payload == null) return test.testNo;
            throw new IllegalArgumentException(InteropTest.getErrorStr(test.testNo, "Unstructured Payloads don't match"));
        }
        byte[] payload = new byte[msg.getContentLength()];
        msg.readBytes(payload);
        InteropTest.testByteArrayValues(test.payload, payload, test.testNo, "XML Payloads don't match");
        return test.testNo;
    }

    public static BytesXMLMessage createMessageByNumber(Producer producer, Integer msgId) throws JCSMPException {
        InteropTest interopTest = null;
        switch (msgId) {
            case 1: {
                interopTest = InteropTest.interopTest1();
                break;
            }
            case 2: {
                interopTest = InteropTest.interopTest2();
                break;
            }
            case 3: {
                interopTest = InteropTest.interopTest3();
                break;
            }
            case 4: {
                interopTest = InteropTest.interopTest4();
                break;
            }
            case 5: {
                interopTest = InteropTest.interopTest5();
                break;
            }
            case 6: {
                interopTest = InteropTest.interopTest6();
                break;
            }
            case 7: {
                interopTest = InteropTest.interopTest7();
                break;
            }
            case 8: {
                interopTest = InteropTest.interopTest8();
                break;
            }
            case 9: {
                interopTest = InteropTest.interopTest9();
                break;
            }
            case 10: {
                interopTest = InteropTest.interopTest10();
                break;
            }
            case 11: {
                interopTest = InteropTest.interopTest11();
                break;
            }
            case 12: {
                interopTest = InteropTest.interopTest12();
                break;
            }
            case 13: {
                interopTest = InteropTest.interopTest13();
                break;
            }
            case 14: {
                interopTest = InteropTest.interopTest14();
                break;
            }
            case 15: {
                interopTest = InteropTest.interopTest15();
                break;
            }
            case 16: {
                interopTest = InteropTest.interopTest16();
                break;
            }
            case 17: {
                interopTest = InteropTest.interopTest17();
                break;
            }
            case 18: {
                interopTest = InteropTest.interopTest18();
                break;
            }
            case 19: {
                interopTest = InteropTest.interopTest19();
                break;
            }
            case 20: {
                interopTest = InteropTest.interopTest20();
                break;
            }
            case 21: {
                interopTest = InteropTest.interopTest21();
                break;
            }
            case 23: {
                interopTest = InteropTest.interopTest23();
                break;
            }
            default: {
                throw new JCSMPException("Unexpected msgId: " + msgId);
            }
        }
        interopTest.testNo = msgId;
        return InteropTest.createMessage(producer, interopTest);
    }

    public static BytesXMLMessage createMessage(Producer producer, InteropTest test) throws JCSMPException {
        BytesXMLMessage msg;
        if (test.isStructMsg) {
            if (test.structMsgType == 10) {
                msg = producer.createMapMessage();
                msg.setMap((SDTMap)test.payload);
            } else if (test.structMsgType == 11) {
                msg = producer.createStreamMessage();
                ((StreamMessage)msg).setStream((SDTStream)test.payload);
            } else if (test.structMsgType == 7) {
                msg = producer.createTextMessage();
                ((TextMessage)msg).setText((String)test.payload);
            } else {
                msg = producer.createBytesMessage();
                msg.setStructuredMsg(true);
                msg.setStructuredMsgType(test.structMsgType);
                if (test.payload != null) {
                    if (test.location == PayloadLocation.XMLContent) {
                        msg.writeBytes((byte[])test.payload);
                    } else {
                        ((BytesMessage)msg).setData((byte[])test.payload);
                    }
                }
            }
        } else if (test.structMsgType == 1) {
            msg = producer.createXMLContentMessage();
            ((XMLContentMessage)msg).setXMLContent((String)test.payload);
        } else if (test.structMsgType == 0) {
            msg = producer.createBytesXMLMessage();
            if (test.payload != null) {
                if (test.location == PayloadLocation.XMLContent) {
                    msg.writeBytes((byte[])test.payload);
                } else {
                    msg.writeAttachment((byte[])test.payload);
                }
            }
        } else {
            msg = producer.createBytesMessage();
            msg.setStructuredMsg(false);
            msg.setStructuredMsgType(test.structMsgType);
            if (test.payload != null) {
                if (test.location == PayloadLocation.XMLContent) {
                    msg.writeBytes((byte[])test.payload);
                } else {
                    ((BytesMessage)msg).setData((byte[])test.payload);
                }
            }
        }
        msg.setUserData(new byte[]{(byte)test.testNo});
        msg.setDeliveryMode(DeliveryMode.PERSISTENT);
        msg.setAppMessageID(test.appMsgID);
        msg.setAppMessageType(test.appMsgType);
        msg.setCorrelationId(test.correlationID);
        msg.setProperties(test.props);
        msg.setReplyTo(test.replyTo);
        msg.setSenderID(test.senderID);
        if (test.sendTs != null) {
            msg.setSendTimestamp(test.sendTs);
        }
        if (test.seqNo != null) {
            msg.setSequenceNumber(test.seqNo);
        }
        if (test.expiration != null) {
            msg.setExpiration(test.expiration);
        }
        return msg;
    }

    public static void testValues(Object expected, Object received, Integer testNumber, String errorStr) {
        if (expected == null) {
            if (received != null) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
            }
        } else {
            if (received == null) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
            }
            if (!expected.equals(received)) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
            }
        }
    }

    public static void testSendTimestamps(Long expected, Long received, Integer testNumber, String errorStr) {
        long maxDiff = 259200000L;
        if (expected == null) {
            if (!IgnoreGeneratedSendTimestamps) {
                if (received == null) {
                    throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=GENERATED, Received=null)"));
                }
                long currentTime = System.currentTimeMillis();
                if (Math.abs(currentTime - received) > 259200000L) {
                    throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Current=" + currentTime + ", Received=" + received + ")"));
                }
            }
        } else {
            if (received == null) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
            }
            if (!expected.equals(received)) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
            }
        }
    }

    public static void testExpiration(Long expected, long received, Integer testNumber, String errorStr) {
        if (expected == null) {
            if (received != 0L) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
            }
        } else {
            if (received == 0L) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
            }
            if (!expected.equals(received)) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
            }
        }
    }

    public static void testMapValues(SDTMap expected, SDTMap received, Integer testNumber, String errorStr) {
        if (expected == null) {
            if (received == null || received.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
        }
        if (received == null) {
            throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
        }
        if (!InteropTest.equiv(expected, received)) {
            throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
        }
    }

    public static void testStreamValues(SDTStream expected, SDTStream received, Integer testNumber, String errorStr) {
        if (expected == null) {
            if (received != null) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
            }
        } else {
            if (received == null) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
            }
            if (!InteropTest.equiv(expected, received)) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + received + ")"));
            }
        }
    }

    public static void testByteArrayValues(Object expected, byte[] value2, Integer testNumber, String errorStr) {
        if (expected == null) {
            if (value2 != null) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + Arrays.toString(value2) + ")"));
            }
        } else {
            if (value2 == null) {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + Arrays.toString(value2) + ")"));
            }
            if (expected instanceof byte[]) {
                InteropTest.testBytes((byte[])expected, value2, testNumber, errorStr);
            } else if (expected instanceof String) {
                InteropTest.testBytes(((String)expected).getBytes(), value2, testNumber, errorStr);
            } else {
                throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expected + ", Received=" + Arrays.toString(value2) + ")"));
            }
        }
    }

    public static void testBytes(byte[] expected, byte[] value2, Integer testNumber, String errorStr) {
        ByteArray expBA = new ByteArray(expected);
        ByteArray recBA = new ByteArray(value2);
        if (expected.length != value2.length) {
            throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expBA + ", Received=" + recBA + ")"));
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == value2[i]) continue;
            throw new IllegalArgumentException(InteropTest.getErrorStr(testNumber, errorStr + " (Expected=" + expBA + ", Received=" + recBA + ")"));
        }
    }

    public static String getErrorStr(Integer testNumber, String errorStr) {
        return "Test " + testNumber + " - " + errorStr;
    }

    public static boolean equiv(SDTMap map1, SDTMap map2) {
        if (map1 == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        Iterator<String> it = map1.keySet().iterator();
        try {
            while (it.hasNext()) {
                String key = it.next();
                if (!map2.containsKey(key)) {
                    return false;
                }
                Object value = map1.get(key);
                Object otherValue = map2.get(key);
                if (value == null) {
                    if (otherValue == null) continue;
                    return false;
                }
                if (!value.getClass().equals(otherValue.getClass())) {
                    return false;
                }
                if (!(value instanceof SDTMap ? !InteropTest.equiv((SDTMap)value, (SDTMap)otherValue) : (value instanceof SDTStream ? !InteropTest.equiv((SDTStream)value, (SDTStream)otherValue) : !value.equals(otherValue)))) continue;
                return false;
            }
            return true;
        }
        catch (SDTException sDTException) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equiv(SDTStream stream1, SDTStream stream2) {
        if (stream1 == null) {
            if (stream2 != null) return false;
            return true;
        }
        if (stream2 == null) {
            return false;
        }
        stream1.rewind();
        stream2.rewind();
        try {
            while (stream1.hasRemaining()) {
                Object value = stream1.read();
                Object otherValue = stream2.read();
                if (value == null) {
                    if (otherValue == null) continue;
                    boolean bl = false;
                    return bl;
                }
                if (!value.getClass().equals(otherValue.getClass())) {
                    boolean bl = false;
                    return bl;
                }
                if (value instanceof SDTMap) {
                    if (InteropTest.equiv((SDTMap)value, (SDTMap)otherValue)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (value instanceof SDTStream) {
                    if (InteropTest.equiv((SDTStream)value, (SDTStream)otherValue)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (value.equals(otherValue)) continue;
                boolean bl = false;
                return bl;
            }
            boolean value = !stream2.hasRemaining();
            return value;
        }
        catch (SDTException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            stream1.rewind();
            stream2.rewind();
        }
    }

    public static InteropTest interopTest1() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = null;
        test.appMsgType = null;
        test.correlationID = null;
        test.props = null;
        test.replyTo = null;
        test.senderID = null;
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)10;
        test.payload = null;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest2() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = null;
        test.appMsgType = null;
        test.correlationID = null;
        test.props = null;
        test.replyTo = null;
        test.senderID = null;
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)11;
        test.payload = null;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest3() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = null;
        test.appMsgType = null;
        test.correlationID = null;
        test.props = null;
        test.replyTo = null;
        test.senderID = null;
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)7;
        test.payload = null;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest4() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = null;
        test.appMsgType = null;
        test.correlationID = null;
        test.props = null;
        test.replyTo = null;
        test.senderID = null;
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1981, 11, 2, 0, 0, 0);
        test.sendTs = cal.getTimeInMillis() / 1000L * 1000L;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = false;
        test.structMsgType = 0;
        test.payload = null;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest5() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = null;
        test.appMsgType = null;
        test.correlationID = null;
        test.props = null;
        test.replyTo = null;
        test.senderID = null;
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = false;
        test.structMsgType = 1;
        test.payload = null;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest6() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = "";
        test.appMsgType = "";
        test.correlationID = "";
        test.props = new MapImpl();
        test.replyTo = null;
        test.senderID = "";
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)10;
        test.payload = new MapImpl();
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest7() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = "";
        test.appMsgType = "";
        test.correlationID = "";
        test.props = new MapImpl();
        test.replyTo = null;
        test.senderID = "";
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)11;
        test.payload = new StreamImpl();
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest8() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = "";
        test.appMsgType = "";
        test.correlationID = "";
        test.props = new MapImpl();
        test.replyTo = null;
        test.senderID = "";
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)7;
        test.payload = "";
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest9() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = "";
        test.appMsgType = "";
        test.correlationID = "";
        test.props = new MapImpl();
        test.replyTo = null;
        test.senderID = "";
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = false;
        test.structMsgType = 0;
        test.payload = null;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest10() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = "";
        test.appMsgType = "";
        test.correlationID = "";
        test.props = new MapImpl();
        test.replyTo = null;
        test.senderID = "";
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = false;
        test.structMsgType = 1;
        test.payload = null;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest11() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = "myAppMsgID";
        test.appMsgType = "myAppMsgType";
        test.correlationID = "myCorrelationID";
        test.props = new MapImpl();
        test.replyTo = TopicImpl.createFastNoValidation("mytopic");
        test.senderID = "mySenderID";
        test.sendTs = 123456789L;
        test.seqNo = 7777777L;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)10;
        test.payload = new MapImpl();
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest12() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = "myAppMsgID";
        test.appMsgType = "myAppMsgType";
        test.correlationID = "myCorrelationID";
        MapImpl props = new MapImpl();
        props.putShort("propfield", (short)255);
        test.props = props;
        test.replyTo = TopicImpl.createFastNoValidation("mytopic");
        test.senderID = "mySenderID";
        test.sendTs = 123456789L;
        test.seqNo = 7777777L;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)10;
        MapImpl payload = new MapImpl();
        payload.putCharacter("payloadfield", Character.valueOf('X'));
        test.payload = payload;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest13() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = "myAppMsgID";
        test.appMsgType = "myAppMsgType";
        test.correlationID = "myCorrelationID";
        MapImpl props = new MapImpl();
        props.putShort("propfield", null);
        test.props = props;
        test.replyTo = TopicImpl.createFastNoValidation("mytopic");
        test.senderID = "mySenderID";
        test.sendTs = 123456789L;
        test.seqNo = 7777777L;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)11;
        StreamImpl payload = new StreamImpl();
        payload.writeBytes(new byte[0]);
        payload.writeBoolean(null);
        test.payload = payload;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest14() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = "myAppMsgID";
        test.appMsgType = "myAppMsgType";
        test.correlationID = "myCorrelationID";
        MapImpl props = new MapImpl();
        props.putLong("propfield", 123L);
        test.props = props;
        test.replyTo = TopicImpl.createFastNoValidation("mytopic");
        test.senderID = "mySenderID";
        test.sendTs = 123456789L;
        test.seqNo = 7777777L;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)7;
        StringBuilder bldr = new StringBuilder();
        for (int i = 1; i < 128; ++i) {
            bldr.append((char)i);
        }
        test.payload = bldr.toString();
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest15() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = "myAppMsgID";
        test.appMsgType = "myAppMsgType";
        test.correlationID = "myCorrelationID";
        test.props = new MapImpl();
        test.replyTo = TopicImpl.createFastNoValidation("mytopic");
        test.senderID = "mySenderID";
        test.sendTs = 123456789L;
        test.seqNo = 7777777L;
        test.expiration = null;
        test.isStructMsg = false;
        test.structMsgType = 0;
        test.payload = new byte[]{1, 2, 3};
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest16() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = "myAppMsgID";
        test.appMsgType = "myAppMsgType";
        test.correlationID = "myCorrelationID";
        test.props = new MapImpl();
        test.replyTo = TopicImpl.createFastNoValidation("mytopic");
        test.senderID = "mySenderID";
        test.sendTs = 123456789L;
        test.seqNo = 7777777L;
        test.expiration = null;
        test.isStructMsg = false;
        test.structMsgType = 1;
        test.payload = "<test></test>";
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest17() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = "myAppMsgID";
        test.appMsgType = "myAppMsgType";
        test.correlationID = "myCorrelationID";
        test.props = new MapImpl();
        test.replyTo = TopicImpl.createFastNoValidation("mytopic");
        test.senderID = "mySenderID";
        test.sendTs = 123456789L;
        test.seqNo = 7777777L;
        test.expiration = null;
        test.isStructMsg = false;
        test.structMsgType = (byte)3;
        test.payload = new byte[]{1, 2, 3};
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest18() throws SDTException {
        boolean b1 = Boolean.FALSE;
        boolean b2 = Boolean.TRUE;
        short s1 = 42;
        short s2 = 142;
        byte s3 = 42;
        byte s4 = -42;
        int i1 = 42;
        short i2 = -42;
        int i3 = 1042;
        short i4 = -142;
        int i5 = 65535;
        short i6 = Short.MIN_VALUE;
        long l1 = 255L;
        int i7 = -80;
        long l2 = 65535L;
        int i8 = Short.MIN_VALUE;
        long l3 = 0xFFFFFFFFL;
        int i9 = Integer.MIN_VALUE;
        BigInteger bi1 = new BigInteger("255");
        long l4 = -80L;
        BigInteger bi2 = new BigInteger("65535");
        long l5 = -32768L;
        BigInteger bi3 = new BigInteger("4294967295");
        long l6 = Integer.MIN_VALUE;
        BigInteger bi4 = new BigInteger("9223372036854775807");
        long l7 = Long.MIN_VALUE;
        long l8 = 43112609L;
        char c1 = 'R';
        char c2 = 'R';
        byte[] ba1 = new byte[]{-64, -34, -66, -83, -83, -34, -17, -66, 35, 68, 85, 119};
        float f1 = 3.14159f;
        double d1 = 3.14159;
        String str1 = "A short quick fox";
        String str2 = "43112609";
        String str3 = "3.14159";
        String str4 = "true";
        String str5 = "0";
        String str6 = "-43112609";
        Topic dest1 = TopicImpl.createFastNoValidation("level1/level2");
        MapImpl map1 = new MapImpl();
        map1.putBoolean("field_0", b1);
        map1.putBoolean("field_1", b2);
        map1.putShort("field_2", s1);
        map1.putShort("field_3", s2);
        map1.putByte("field_4", s3);
        map1.putByte("field_5", s4);
        map1.putInteger("field_6", i1);
        map1.putShort("field_7", i2);
        map1.putInteger("field_8", i3);
        map1.putShort("field_9", i4);
        map1.putInteger("field_10", i5);
        map1.putShort("field_11", i6);
        map1.putLong("field_12", l1);
        map1.putInteger("field_13", i7);
        map1.putLong("field_14", l2);
        map1.putInteger("field_15", i8);
        map1.putLong("field_16", l3);
        map1.putInteger("field_17", i9);
        map1.putObject("field_18", bi1);
        map1.putLong("field_19", l4);
        map1.putObject("field_20", bi2);
        map1.putLong("field_21", l5);
        map1.putObject("field_22", bi3);
        map1.putLong("field_23", l6);
        map1.putObject("field_24", bi4);
        map1.putLong("field_25", l7);
        map1.putLong("field_26", l8);
        map1.putCharacter("field_27", Character.valueOf(c1));
        map1.putCharacter("field_28", Character.valueOf(c2));
        map1.putBytes("field_29", ba1);
        map1.putFloat("field_30", Float.valueOf(f1));
        map1.putDouble("field_31", d1);
        map1.putString("field_32", str1);
        map1.putString("field_33", str2);
        map1.putString("field_34", str3);
        map1.putString("field_35", str4);
        map1.putString("field_36", str5);
        map1.putString("field_37", str6);
        map1.putDestination("field_38", dest1);
        map1.putDestination("field_39", null);
        StreamImpl payload = new StreamImpl();
        payload.writeBoolean(b1);
        payload.writeBoolean(b2);
        payload.writeShort(s1);
        payload.writeShort(s2);
        payload.writeByte(s3);
        payload.writeByte(s4);
        payload.writeInteger(i1);
        payload.writeShort(i2);
        payload.writeInteger(i3);
        payload.writeShort(i4);
        payload.writeInteger(i5);
        payload.writeShort(i6);
        payload.writeLong(l1);
        payload.writeInteger(i7);
        payload.writeLong(l2);
        payload.writeInteger(i8);
        payload.writeLong(l3);
        payload.writeInteger(i9);
        payload.writeObject(bi1);
        payload.writeLong(l4);
        payload.writeObject(bi2);
        payload.writeLong(l5);
        payload.writeObject(bi3);
        payload.writeLong(l6);
        payload.writeObject(bi4);
        payload.writeLong(l7);
        payload.writeLong(l8);
        payload.writeCharacter(Character.valueOf(c1));
        payload.writeCharacter(Character.valueOf(c2));
        payload.writeBytes(ba1);
        payload.writeFloat(Float.valueOf(f1));
        payload.writeDouble(d1);
        payload.writeString(str1);
        payload.writeString(str2);
        payload.writeString(str3);
        payload.writeString(str4);
        payload.writeString(str5);
        payload.writeString(str6);
        payload.writeDestination(dest1);
        payload.writeDestination(null);
        payload.writeMap(map1);
        InteropTest test = new InteropTest();
        test.appMsgID = null;
        test.appMsgType = null;
        test.correlationID = null;
        test.props = null;
        test.replyTo = null;
        test.senderID = null;
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)11;
        test.payload = payload;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest19() throws SDTException {
        boolean b1 = Boolean.FALSE;
        boolean b2 = Boolean.TRUE;
        short s1 = 42;
        short s2 = 142;
        byte s3 = 42;
        byte s4 = -42;
        int i1 = 42;
        short i2 = -42;
        int i3 = 1042;
        short i4 = -142;
        int i5 = 65535;
        short i6 = Short.MIN_VALUE;
        long l1 = 255L;
        int i7 = -80;
        long l2 = 65535L;
        int i8 = Short.MIN_VALUE;
        long l3 = 0xFFFFFFFFL;
        int i9 = Integer.MIN_VALUE;
        BigInteger bi1 = new BigInteger("255");
        long l4 = -80L;
        BigInteger bi2 = new BigInteger("65535");
        long l5 = -32768L;
        BigInteger bi3 = new BigInteger("4294967295");
        long l6 = Integer.MIN_VALUE;
        BigInteger bi4 = new BigInteger("9223372036854775807");
        long l7 = Long.MIN_VALUE;
        long l8 = 43112609L;
        char c1 = 'R';
        char c2 = 'R';
        byte[] ba1 = new byte[]{-64, -34, -66, -83, -83, -34, -17, -66, 35, 68, 85, 119};
        float f1 = 3.14159f;
        double d1 = 3.14159;
        String str1 = "A short quick fox";
        String str2 = "43112609";
        String str3 = "3.14159";
        String str4 = "true";
        String str5 = "0";
        String str6 = "-43112609";
        Topic dest1 = TopicImpl.createFastNoValidation("level1/level2");
        MapImpl payload = new MapImpl();
        payload.putBoolean("field_0", b1);
        payload.putBoolean("field_1", b2);
        payload.putShort("field_2", s1);
        payload.putShort("field_3", s2);
        payload.putByte("field_4", s3);
        payload.putByte("field_5", s4);
        payload.putInteger("field_6", i1);
        payload.putShort("field_7", i2);
        payload.putInteger("field_8", i3);
        payload.putShort("field_9", i4);
        payload.putInteger("field_10", i5);
        payload.putShort("field_11", i6);
        payload.putLong("field_12", l1);
        payload.putInteger("field_13", i7);
        payload.putLong("field_14", l2);
        payload.putInteger("field_15", i8);
        payload.putLong("field_16", l3);
        payload.putInteger("field_17", i9);
        payload.putObject("field_18", bi1);
        payload.putLong("field_19", l4);
        payload.putObject("field_20", bi2);
        payload.putLong("field_21", l5);
        payload.putObject("field_22", bi3);
        payload.putLong("field_23", l6);
        payload.putObject("field_24", bi4);
        payload.putLong("field_25", l7);
        payload.putLong("field_26", l8);
        payload.putCharacter("field_27", Character.valueOf(c1));
        payload.putCharacter("field_28", Character.valueOf(c2));
        payload.putBytes("field_29", ba1);
        payload.putFloat("field_30", Float.valueOf(f1));
        payload.putDouble("field_31", d1);
        payload.putString("field_32", str1);
        payload.putString("field_33", str2);
        payload.putString("field_34", str3);
        payload.putString("field_35", str4);
        payload.putString("field_36", str5);
        payload.putString("field_37", str6);
        payload.putDestination("field_38", dest1);
        payload.putDestination("field_39", null);
        StreamImpl stream = new StreamImpl();
        payload.putStream("field_40", stream);
        stream.writeBoolean(b1);
        stream.writeBoolean(b2);
        stream.writeShort(s1);
        stream.writeShort(s2);
        stream.writeByte(s3);
        stream.writeByte(s4);
        stream.writeInteger(i1);
        stream.writeShort(i2);
        stream.writeInteger(i3);
        stream.writeShort(i4);
        stream.writeInteger(i5);
        stream.writeShort(i6);
        stream.writeLong(l1);
        stream.writeInteger(i7);
        stream.writeLong(l2);
        stream.writeInteger(i8);
        stream.writeLong(l3);
        stream.writeInteger(i9);
        stream.writeObject(bi1);
        stream.writeLong(l4);
        stream.writeObject(bi2);
        stream.writeLong(l5);
        stream.writeObject(bi3);
        stream.writeLong(l6);
        stream.writeObject(bi4);
        stream.writeLong(l7);
        stream.writeLong(l8);
        stream.writeCharacter(Character.valueOf(c1));
        stream.writeCharacter(Character.valueOf(c2));
        stream.writeBytes(ba1);
        stream.writeFloat(Float.valueOf(f1));
        stream.writeDouble(d1);
        stream.writeString(str1);
        stream.writeString(str2);
        stream.writeString(str3);
        stream.writeString(str4);
        stream.writeString(str5);
        stream.writeString(str6);
        stream.writeDestination(dest1);
        stream.writeDestination(null);
        InteropTest test = new InteropTest();
        test.appMsgID = null;
        test.appMsgType = null;
        test.correlationID = null;
        test.props = null;
        test.replyTo = null;
        test.senderID = null;
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)10;
        test.payload = payload;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest20() throws SDTException {
        MapImpl payload = new MapImpl();
        payload.putObject("field_1", new BigInteger("18446744073709551615"));
        InteropTest test = new InteropTest();
        test.appMsgID = null;
        test.appMsgType = null;
        test.correlationID = null;
        test.props = null;
        test.replyTo = null;
        test.senderID = null;
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)10;
        test.payload = payload;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest21() throws SDTException {
        StreamImpl payload = new StreamImpl();
        payload.writeObject(new BigInteger("18446744073709551615"));
        InteropTest test = new InteropTest();
        test.appMsgID = null;
        test.appMsgType = null;
        test.correlationID = null;
        test.props = null;
        test.replyTo = null;
        test.senderID = null;
        test.sendTs = null;
        test.seqNo = null;
        test.expiration = null;
        test.isStructMsg = true;
        test.structMsgType = (byte)11;
        test.payload = payload;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    public static InteropTest interopTest23() throws SDTException {
        InteropTest test = new InteropTest();
        test.appMsgID = null;
        test.appMsgType = null;
        test.correlationID = null;
        test.props = null;
        test.replyTo = null;
        test.senderID = null;
        test.sendTs = null;
        test.seqNo = null;
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1981, 11, 2, 0, 0, 0);
        test.expiration = cal.getTimeInMillis() / 1000L * 1000L;
        test.isStructMsg = false;
        test.structMsgType = 0;
        test.payload = null;
        test.location = PayloadLocation.BinaryAttachment;
        return test;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PayloadLocation {
        XMLContent,
        BinaryAttachment;

    }
}

