/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.Pair;
import com.solacesystems.jcsmp.impl.InternalCapabilityType;
import com.solacesystems.jcsmp.protocol.smf.AbstractTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterCapabilityParser {
    static final String UNKNOWN = "Unknown";
    static final String PORT_TYPE_ETHER = "Ethernet";

    public static Pair<Map<CapabilityType, Object>, Map<InternalCapabilityType, Boolean>> parseCapabilitiesFromHeader(AbstractTLVParameter cap, AbstractTLVParameter cap_ext, AbstractTLVParameter softwareVersion, AbstractTLVParameter softwareDate, AbstractTLVParameter platform, AbstractTLVParameter physicalName, boolean isTr) {
        HashMap<CapabilityType, Object> map = new HashMap<CapabilityType, Object>();
        EnumMap<InternalCapabilityType, Boolean> internal_cap_map = new EnumMap<InternalCapabilityType, Boolean>(InternalCapabilityType.class);
        RouterCapabilityParser.loadDefaults(map);
        if (softwareVersion != null) {
            String str_ver = TlvCoderUtil.nullTermUtf8ToString(softwareVersion.value);
            map.put(CapabilityType.PEER_SOFTWARE_VERSION, str_ver);
        } else {
            map.put(CapabilityType.PEER_SOFTWARE_VERSION, UNKNOWN);
        }
        if (softwareDate != null) {
            String str_date = TlvCoderUtil.nullTermUtf8ToString(softwareDate.value);
            map.put(CapabilityType.PEER_SOFTWARE_DATE, str_date);
        } else {
            map.put(CapabilityType.PEER_SOFTWARE_DATE, UNKNOWN);
        }
        if (platform != null) {
            String str_platform = TlvCoderUtil.nullTermUtf8ToString(platform.value);
            map.put(CapabilityType.PEER_PLATFORM, str_platform);
        } else {
            map.put(CapabilityType.PEER_PLATFORM, UNKNOWN);
        }
        if (physicalName != null) {
            String str_physical_name = TlvCoderUtil.nullTermUtf8ToString(physicalName.value);
            map.put(CapabilityType.PEER_ROUTER_NAME, str_physical_name);
        } else {
            map.put(CapabilityType.PEER_ROUTER_NAME, UNKNOWN);
        }
        map.put(CapabilityType.SUPPORTS_XPE_SUBSCRIPTIONS, !isTr);
        if (cap == null) {
            internal_cap_map.put(InternalCapabilityType.ACCEPT_DIRECT_QUEUE_PUBLISH, Boolean.FALSE);
            if (isTr) {
                RouterCapabilityParser.loadD19Tr(map);
            } else {
                RouterCapabilityParser.loadD19Cr(map);
            }
        } else {
            RouterCapabilityParser.parseCapParameter(cap, map);
            internal_cap_map.put(InternalCapabilityType.ACCEPT_DIRECT_QUEUE_PUBLISH, isTr);
        }
        if (cap_ext != null) {
            RouterCapabilityParser.parseCapExtParameter(cap_ext, map);
        }
        Pair<Map<CapabilityType, Object>, Map<InternalCapabilityType, Boolean>> mappair = new Pair<Map<CapabilityType, Object>, Map<InternalCapabilityType, Boolean>>(map, internal_cap_map);
        return mappair;
    }

    private static void parseCapParameter(AbstractTLVParameter cap, Map<CapabilityType, Object> map) {
        byte onebyte;
        int count_boolcaps = (int)NetworkByteOrderNumberUtil.oneByteToUInt(cap.value[0]);
        int bytes_boolcaps = (count_boolcaps - 1) / 8 + 1;
        if (bytes_boolcaps >= 1) {
            onebyte = cap.value[1];
            map.put(CapabilityType.JNDI, (onebyte & 0x80) != 0);
            map.put(CapabilityType.COMPRESSION, (onebyte & 0x40) != 0);
            map.put(CapabilityType.SUB_FLOW_GUARANTEED, (onebyte & 0x20) != 0);
            map.put(CapabilityType.TEMP_ENDPOINT, (onebyte & 0x10) != 0);
            map.put(CapabilityType.PUB_FLOW_GUARANTEED, (onebyte & 8) != 0);
            map.put(CapabilityType.BROWSER, (onebyte & 4) != 0);
            map.put(CapabilityType.ENDPOINT_MANAGEMENT, (onebyte & 2) != 0);
            map.put(CapabilityType.SELECTOR, (onebyte & 1) != 0);
        }
        if (bytes_boolcaps >= 2) {
            onebyte = cap.value[2];
            map.put(CapabilityType.ENDPOINT_MESSAGE_TTL, (onebyte & 0x80) != 0);
            map.put(CapabilityType.QUEUE_SUBSCRIPTIONS, (onebyte & 0x40) != 0);
            map.put(CapabilityType.FLOW_RECOVER, (onebyte & 0x20) != 0);
            map.put(CapabilityType.SUBSCRIPTION_MANAGER, (onebyte & 0x10) != 0);
            map.put(CapabilityType.MESSAGE_ELIDING, (onebyte & 8) != 0);
            map.put(CapabilityType.TRANSACTED_SESSIONS, (onebyte & 4) != 0);
            map.put(CapabilityType.NO_LOCAL, (onebyte & 2) != 0);
            map.put(CapabilityType.FLOW_CHANGE_UPDATES, (onebyte & 1) != 0);
            map.put(CapabilityType.ACTIVE_FLOW_INDICATION, (onebyte & 1) != 0);
        }
        if (bytes_boolcaps >= 3) {
            onebyte = cap.value[3];
            map.put(CapabilityType.PER_TOPIC_SEQUENCE_NUMBERING, (onebyte & 0x80) != 0);
            map.put(CapabilityType.ENDPOINT_DISCARD_BEHAVIOR, (onebyte & 0x40) != 0);
            map.put(CapabilityType.CUT_THROUGH, (onebyte & 0x20) != 0);
            map.put(CapabilityType.OPEN_MAMA, (onebyte & 0x10) != 0);
            map.put(CapabilityType.MESSAGE_REPLAY, (onebyte & 8) != 0);
            map.put(CapabilityType.COMPRESSED_SSL, (onebyte & 4) != 0);
            map.put(CapabilityType.LONG_SELECTORS, (onebyte & 2) != 0);
        }
        int off = bytes_boolcaps + 1;
        while (off < cap.value.length) {
            int type_enum = (int)NetworkByteOrderNumberUtil.oneByteToUInt(cap.value[off]);
            int len = (int)NetworkByteOrderNumberUtil.fourByteToUInt(cap.value, ++off);
            int cap_val_len = len - 5;
            byte[] cap_value = new byte[cap_val_len];
            System.arraycopy(cap.value, off += 4, cap_value, 0, cap_val_len);
            off += cap_val_len;
            switch (type_enum) {
                case 0: {
                    int portspeed = (int)NetworkByteOrderNumberUtil.fourByteToUInt(cap_value);
                    map.put(CapabilityType.PEER_PORT_SPEED, portspeed);
                    break;
                }
                case 1: {
                    int porttype = (int)NetworkByteOrderNumberUtil.oneByteToUInt(cap_value[0]);
                    map.put(CapabilityType.PEER_PORT_TYPE, RouterCapabilityParser.parsePortType(porttype));
                    break;
                }
                case 2: {
                    int mx_g_msgsize = (int)NetworkByteOrderNumberUtil.fourByteToUInt(cap_value);
                    map.put(CapabilityType.MAX_GUARANTEED_MSG_SIZE, mx_g_msgsize);
                    break;
                }
                case 3: {
                    int mx_d_msgsize = (int)NetworkByteOrderNumberUtil.fourByteToUInt(cap_value);
                    map.put(CapabilityType.MAX_DIRECT_MSG_SIZE, mx_d_msgsize);
                }
            }
        }
        map.put(CapabilityType.PUB_GUARANTEED, map.get((Object)CapabilityType.PUB_FLOW_GUARANTEED));
    }

    private static void parseCapExtParameter(AbstractTLVParameter cap_ext, Map<CapabilityType, Object> map) {
        int cap_val_len;
        int count_boolcaps = (int)NetworkByteOrderNumberUtil.oneByteToUInt(cap_ext.value[0]);
        block4: for (int off = count_boolcaps + 1; off < cap_ext.value.length; off += cap_val_len) {
            int type_enum = (int)NetworkByteOrderNumberUtil.oneByteToUInt(cap_ext.value[off++]);
            int len = (int)NetworkByteOrderNumberUtil.fourByteToUInt(cap_ext.value, off);
            cap_val_len = len - 5;
            off += 4;
            switch (type_enum) {
                case 4: {
                    ArrayList<Integer> ad_ctrl_vers = new ArrayList<Integer>(2);
                    ad_ctrl_vers.add(0, Integer.valueOf(cap_ext.value[off]));
                    ad_ctrl_vers.add(1, Integer.valueOf(cap_ext.value[off + 1]));
                    map.put(CapabilityType.SUPPORTED_ADCTRL_VERSIONS, ad_ctrl_vers);
                    continue block4;
                }
                case 5: {
                    ArrayList<Integer> xa_ctrl_vers = new ArrayList<Integer>(2);
                    xa_ctrl_vers.add(0, Integer.valueOf(cap_ext.value[off]));
                    xa_ctrl_vers.add(1, Integer.valueOf(cap_ext.value[off + 1]));
                    map.put(CapabilityType.SUPPORTED_XACTRL_VERSIONS, xa_ctrl_vers);
                }
            }
        }
    }

    private static String parsePortType(int port_type_enum) {
        switch (port_type_enum) {
            case 0: {
                return PORT_TYPE_ETHER;
            }
        }
        return UNKNOWN;
    }

    private static void loadDefaults(Map<CapabilityType, Object> map) {
        for (CapabilityType ct : CapabilityType.values()) {
            if (ct.getValueType().equals(Boolean.class)) {
                map.put(ct, Boolean.FALSE);
            }
            if (ct.getValueType().equals(Integer.class)) {
                map.put(ct, 0);
            }
            if (!ct.getValueType().equals(String.class)) continue;
            map.put(ct, UNKNOWN);
        }
    }

    private static void loadD19Cr(Map<CapabilityType, Object> map) {
        map.put(CapabilityType.PUB_FLOW_GUARANTEED, Boolean.FALSE);
        map.put(CapabilityType.PUB_GUARANTEED, Boolean.TRUE);
        map.put(CapabilityType.TEMP_ENDPOINT, Boolean.FALSE);
        map.put(CapabilityType.SUB_FLOW_GUARANTEED, Boolean.TRUE);
        map.put(CapabilityType.COMPRESSION, Boolean.FALSE);
        map.put(CapabilityType.JNDI, Boolean.TRUE);
        map.put(CapabilityType.MAX_DIRECT_MSG_SIZE, 0);
        map.put(CapabilityType.MAX_GUARANTEED_MSG_SIZE, 0);
        map.put(CapabilityType.PEER_PORT_TYPE, PORT_TYPE_ETHER);
        map.put(CapabilityType.PEER_PORT_SPEED, 0);
        map.put(CapabilityType.PEER_SOFTWARE_VERSION, UNKNOWN);
        map.put(CapabilityType.PEER_SOFTWARE_DATE, UNKNOWN);
        map.put(CapabilityType.PEER_PLATFORM, UNKNOWN);
        map.put(CapabilityType.PEER_ROUTER_NAME, UNKNOWN);
        map.put(CapabilityType.SUPPORTS_XPE_SUBSCRIPTIONS, Boolean.TRUE);
    }

    private static void loadD19Tr(Map<CapabilityType, Object> map) {
        map.put(CapabilityType.PUB_FLOW_GUARANTEED, Boolean.FALSE);
        map.put(CapabilityType.PUB_GUARANTEED, Boolean.FALSE);
        map.put(CapabilityType.TEMP_ENDPOINT, Boolean.FALSE);
        map.put(CapabilityType.SUB_FLOW_GUARANTEED, Boolean.FALSE);
        map.put(CapabilityType.COMPRESSION, Boolean.FALSE);
        map.put(CapabilityType.JNDI, Boolean.FALSE);
        map.put(CapabilityType.MAX_DIRECT_MSG_SIZE, 0);
        map.put(CapabilityType.MAX_GUARANTEED_MSG_SIZE, 0);
        map.put(CapabilityType.PEER_PORT_TYPE, PORT_TYPE_ETHER);
        map.put(CapabilityType.PEER_PORT_SPEED, 0);
        map.put(CapabilityType.PEER_SOFTWARE_VERSION, UNKNOWN);
        map.put(CapabilityType.PEER_SOFTWARE_DATE, UNKNOWN);
        map.put(CapabilityType.PEER_PLATFORM, UNKNOWN);
        map.put(CapabilityType.PEER_ROUTER_NAME, UNKNOWN);
        map.put(CapabilityType.SUPPORTS_XPE_SUBSCRIPTIONS, Boolean.FALSE);
    }
}

