/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

public class UTF8Util {
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final byte[] numbers = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static int toUTF8(byte[] outputBuffer, short number) {
        return UTF8Util.toUTF8(outputBuffer, (long)number);
    }

    public static int toUTF8(byte[] outputBuffer, int number) {
        return UTF8Util.toUTF8(outputBuffer, (long)number);
    }

    public static int toUTF8(byte[] outputBuffer, long number) {
        int q2;
        int r;
        int charPos = outputBuffer.length;
        int sign = 0;
        if (number < 0L) {
            sign = 45;
            number = -number;
        }
        while (number > Integer.MAX_VALUE) {
            long q = number / 100L;
            r = (int)(number - ((q << 6) + (q << 5) + (q << 2)));
            number = q;
            outputBuffer[--charPos] = (byte)DigitOnes[r];
            outputBuffer[--charPos] = (byte)DigitTens[r];
        }
        int i2 = (int)number;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            outputBuffer[--charPos] = (byte)DigitOnes[r];
            outputBuffer[--charPos] = (byte)DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            outputBuffer[--charPos] = (byte)digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            outputBuffer[--charPos] = (byte)sign;
        }
        return charPos;
    }

    public static int toUTF8FromLatin1(byte[] outputBuffer, String string) {
        if (string == null) {
            return 0;
        }
        int len = string.length();
        for (int i = 0; i < string.length(); ++i) {
            outputBuffer[i] = (byte)string.charAt(i);
        }
        return len;
    }

    public static byte[] toUTF8(String string) {
        int c;
        if (string == null) {
            return null;
        }
        int strlen = string.length();
        int count = 0;
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            c = string.codePointAt(i);
            if (c > 0 && c <= 127) {
                ++utflen;
                ++i;
                continue;
            }
            if (c <= 2047) {
                utflen += 2;
                ++i;
                continue;
            }
            if (c <= 65535) {
                utflen += 3;
                ++i;
                continue;
            }
            if (c <= 0x1FFFFF) {
                utflen += 4;
                i += 2;
                continue;
            }
            if (c <= 0x3FFFFFF) {
                utflen += 5;
                i += 2;
                continue;
            }
            utflen += 6;
            i += 2;
        }
        count = 0;
        byte[] bytearr = new byte[utflen];
        i = 0;
        while (i < strlen) {
            c = string.codePointAt(i);
            if (c > 0 && c <= 127) {
                bytearr[count++] = (byte)c;
                ++i;
                continue;
            }
            if (c <= 2047) {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                ++i;
                continue;
            }
            if (c < 65535) {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                ++i;
                continue;
            }
            if (c <= 0x1FFFFF) {
                bytearr[count++] = (byte)(0xF0 | c >> 18 & 3);
                bytearr[count++] = (byte)(0x80 | c >> 12 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                i += 2;
                continue;
            }
            if (c <= 0x3FFFFFF) {
                bytearr[count++] = (byte)(0xF8 | c >> 24 & 2);
                bytearr[count++] = (byte)(0x80 | c >> 18 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 12 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                i += 2;
                continue;
            }
            if (c > Integer.MAX_VALUE) continue;
            bytearr[count++] = (byte)(0xFC | c >> 30 & 1);
            bytearr[count++] = (byte)(0x80 | c >> 24 & 0x3F);
            bytearr[count++] = (byte)(0x80 | c >> 18 & 0x3F);
            bytearr[count++] = (byte)(0x80 | c >> 12 & 0x3F);
            bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            i += 2;
        }
        return bytearr;
    }

    public static String getStringFromUTF8(byte[] bytearr, int offset, int utflen) {
        if (utflen < 0) {
            return null;
        }
        StringBuffer str = new StringBuffer(utflen);
        int index = offset;
        int end = offset + utflen;
        while (index < end) {
            int char5;
            int char4;
            int char1;
            int char3;
            int char2;
            byte c = bytearr[index];
            if (c >= 0 && c <= 127) {
                ++index;
                str.append((char)c);
                continue;
            }
            if ((c & 0xE0) == 192) {
                char2 = bytearr[(index += 2) - 1];
                str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                continue;
            }
            if ((c & 0xF0) == 224) {
                char2 = bytearr[(index += 3) - 2];
                char3 = bytearr[index - 1];
                str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                continue;
            }
            if ((c & 0xF8) == 240) {
                char1 = c & 0xFF;
                char2 = bytearr[(index += 4) - 3] & 0xFF;
                char3 = bytearr[index - 2] & 0xFF;
                char4 = bytearr[index - 1] & 0xFF;
                str.appendCodePoint((char1 & 3) << 18 | (char2 & 0x3F) << 12 | (char3 & 0x3F) << 6 | (char4 & 0x3F) << 0);
                continue;
            }
            if ((c & 0xFC) == 248) {
                char1 = c & 0xFF;
                char2 = bytearr[(index += 5) - 4] & 0xFF;
                char3 = bytearr[index - 3] & 0xFF;
                char4 = bytearr[index - 2] & 0xFF;
                char5 = bytearr[index - 1] & 0xFF;
                str.appendCodePoint((c & 2) << 24 | (char2 & 0x3F) << 18 | (char3 & 0x3F) << 12 | (char4 & 0x3F) << 6 | (char5 & 0x3F) << 0);
                continue;
            }
            if ((c & 0xFE) == 252) {
                char1 = c & 0xFF;
                char2 = bytearr[(index += 6) - 5] & 0xFF;
                char3 = bytearr[index - 4] & 0xFF;
                char4 = bytearr[index - 3] & 0xFF;
                char5 = bytearr[index - 2] & 0xFF;
                int char6 = bytearr[index - 1] & 0xFF;
                str.appendCodePoint((c & 1) << 30 | (char2 & 0x3F) << 24 | (char3 & 0x3F) << 18 | (char4 & 0x3F) << 12 | (char5 & 0x3F) << 6 | (char6 & 0x3F) << 0);
                continue;
            }
            throw new RuntimeException("UTF-8 format error");
        }
        return new String(str);
    }
}

