/*
 * Decompiled with CFR 0.152.
 */
package com.solace.transport;

import io.netty.handler.codec.socksx.v5.Socks5ClientEncoder;

public class TransportSockProxyConfiguration {
    private final String proxyHost;
    private int proxyPort;
    private String username;
    private String passwd;
    private byte privateAuthMethod;
    private byte[] privateAuthContent;
    private Socks5ClientEncoder privateAuthEncoder;

    public TransportSockProxyConfiguration(String address) {
        this.proxyHost = address;
        this.proxyPort = 1080;
        this.username = null;
        this.passwd = null;
        this.privateAuthMethod = 0;
        this.privateAuthContent = null;
        this.privateAuthEncoder = null;
    }

    public TransportSockProxyConfiguration withUsernamePassword(String user, String password) {
        this.username = user;
        this.passwd = password;
        return this;
    }

    public TransportSockProxyConfiguration withPort(int port) {
        this.proxyPort = port;
        return this;
    }

    public TransportSockProxyConfiguration withPrivateAuthContent(byte authMethod, byte[] content) {
        this.privateAuthMethod = authMethod;
        this.privateAuthContent = content;
        return this;
    }

    public TransportSockProxyConfiguration withPrivateAuthEncoder(String customEncoderClassName) {
        try {
            Class<?> encoderClass = Class.forName(customEncoderClassName);
            this.privateAuthEncoder = (Socks5ClientEncoder)encoderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to instantiate Socks5ClientEncoder: " + customEncoderClassName, e);
        }
        return this;
    }

    public String getHost() {
        return this.proxyHost;
    }

    public int getPort() {
        return this.proxyPort;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.passwd;
    }

    public byte getPrivateAuthMethod() {
        return this.privateAuthMethod;
    }

    public byte[] getPrivateAuthContent() {
        return this.privateAuthContent;
    }

    public Socks5ClientEncoder getPrivateAuthEncoder() {
        return this.privateAuthEncoder;
    }

    public String toString() {
        if (this.privateAuthContent != null) {
            String authInfo = String.format("privateAuth[method=0x%02X, contentLength=%d]", this.privateAuthMethod, this.privateAuthContent.length);
            return "via SOCKS5 proxy(" + authInfo + "@" + this.proxyHost + "/" + this.proxyPort + ")";
        }
        if (this.username != null) {
            return "via SOCKS5 proxy(" + this.username + "@" + this.proxyHost + "/" + this.proxyPort + ")";
        }
        return "via SOCKS5 proxy(" + this.proxyHost + "/" + this.proxyPort + ")";
    }
}

