/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.SolReserved;
import java.util.HashMap;
import java.util.Map;

public final class JCSMPErrorResponseSubcodeEx {
    public static final int UNKNOWN = 0;
    public static final int LOGIN_FAILURE = 1;
    public static final int INVALID_VIRTUAL_ADDRESS = 2;
    public static final int MSG_VPN_NOT_ALLOWED = 3;
    public static final int CLIENT_USERNAME_IS_SHUTDOWN = 4;
    public static final int DYNAMIC_CLIENTS_NOT_ALLOWED = 5;
    public static final int CLIENT_NAME_ALREADY_IN_USE = 6;
    public static final int CLIENT_DELETE_IN_PROGRESS = 7;
    public static final int TOO_MANY_CLIENTS = 8;
    public static final int MSG_VPN_UNAVAILABLE = 9;
    public static final int XML_PARSE_ERROR = 10;
    public static final int MESSAGE_TOO_LARGE = 11;
    public static final int INVALID_TOPIC_SYNTAX = 12;
    public static final int SUBSCRIPTION_ALREADY_PRESENT = 13;
    public static final int SUBSCRIPTION_NOT_FOUND = 14;
    public static final int SUBSCRIPTION_INVALID = 15;
    public static final int SUBSCRIPTION_TOO_MANY = 16;
    public static final int OUT_OF_RESOURCES = 17;
    public static final int CANNOT_BIND_TO_QUEUE = 18;
    public static final int INVALID_TOPIC_NAME_FOR_TE = 19;
    public static final int UNKNOWN_QUEUE_NAME = 20;
    public static final int UNKNOWN_TE_NAME = 21;
    public static final int MAX_CLIENTS_FOR_QUEUE = 22;
    public static final int MAX_CLIENTS_FOR_TE = 23;
    public static final int QUEUE_NOT_FOUND = 24;
    public static final int CLIENT_NAME_INVALID = 25;
    public static final int CLIENT_ACL_DENIED = 26;
    public static final int SUBSCRIPTION_ACL_DENIED = 27;
    public static final int PUBLISH_ACL_DENIED = 28;
    public static final int NO_MORE_NON_DURABLE_QUEUE_OR_TE = 29;
    public static final int SPOOL_OVER_QUOTA = 30;
    public static final int QUEUE_SHUTDOWN = 31;
    public static final int TE_SHUTDOWN = 32;
    public static final int ENDPOINT_ALREADY_EXISTS = 33;
    public static final int QUOTA_OUT_OF_RANGE = 34;
    public static final int DELETE_IN_PROGRESS = 35;
    public static final int PERMISSION_NOT_ALLOWED = 36;
    public static final int INVALID_PARAMETER_COMBINATION = 37;
    public static final int PUBLISH_NO_VALID_CLOSED_USER_GROUP = 38;
    public static final int MAX_MESSAGE_USAGE_EXCEEDED = 39;
    public static final int ENDPOINT_PROPERTY_MISMATCH = 40;
    public static final int UNKNOWN_CLIENT_NAME = 41;
    public static final int SUBSCRIPTION_MANAGER_DENIED = 42;
    public static final int NOT_READY = 43;
    public static final int SUBSCRIPTION_ATTRIBUTES_CONFLICT = 44;
    public static final int UNSUBSCRIBE_NOT_ALLOWED_CLIENTS_BOUND = 45;
    public static final int TRANSACTED_SESSION_NAME_IN_USE = 46;
    public static final int MAX_TRANSACTED_SESSIONS_EXCEEDED = 47;
    public static final int TRANSACTION_MESSAGE_CONSUME_FAILURE = 48;
    @SolReserved
    public static final int TRANSACTION_OVERFLOW = 49;
    public static final int SERVICE_UNAVAILABLE = 50;
    public static final int MESSAGE_PUBLISH_FAILURE = 51;
    public static final int INVALID_TRANSACTION_ID = 52;
    public static final int ENDPOINT_MODIFIED = 53;
    public static final int IN_PROGRESS = 54;
    public static final int UNKNOWN_FLOW_NAME = 55;
    public static final int REPLICATION_IS_STANDBY = 56;
    public static final int LOW_PRIORITY_MSG_CONGESTION = 57;
    public static final int BASIC_AUTHENTICATION_IS_SHUTDOWN = 58;
    public static final int CLIENT_CERTIFICATE_AUTHENTICATION_IS_SHUTDOWN = 59;
    public static final int KERBEROS_AUTHENTICATION_IS_SHUTDOWN = 60;
    public static final int UNTRUSTED_CLIENT_CERTIFICATE = 61;
    public static final int CLIENT_CERTIFICATE_DATE_INVALID = 62;
    public static final int TRANSACTION_FAILURE = 63;
    public static final int UNKNOWN_TRANSACTED_SESSION_NAME = 64;
    public static final int MAX_TRANSACTIONS_EXCEEDED = 65;
    @SolReserved
    public static final int XASESSION_TO_LVQ_BIND_ERROR = 66;
    @SolReserved
    public static final int NON_XASESSION_TO_XAENDPOINT_BIND_ERROR = 67;
    @SolReserved
    public static final int XASESSION_TO_NON_XAENDPOINT_BIND_ERROR = 68;
    public static final int FLOW_UNBOUND = 69;
    public static final int NO_SUBSCRIPTION_MATCH = 70;
    public static final int SUBSCRIPTION_MATCH_ERROR = 71;
    public static final int SELECTOR_MATCH_ERROR = 72;
    public static final int CLIENT_INITIATED_REPLAY_BROWSER_FLOW_NOT_ALLOWED = 73;
    public static final int REPLAY_DISABLED = 74;
    public static final int CLIENT_INITIATED_REPLAY_NON_EXCLUSIVE_NOT_ALLOWED = 75;
    public static final int CLIENT_INITIATED_REPLAY_INACTIVE_FLOW_NOT_ALLOWED = 76;
    public static final int REPLAY_TEMPORARY_NOT_SUPPORTED = 77;
    public static final int REPLAY_STARTED = 78;
    public static final int REPLAY_CANCELLED = 79;
    public static final int REPLAY_MESSAGE_UNAVAILABLE = 80;
    public static final int REPLAY_START_TIME_NOT_AVAILABLE = 81;
    public static final int REPLAYED_MESSAGE_REJECTED = 82;
    public static final int REPLAY_LOG_MODIFIED = 83;
    public static final int REPLAY_FAILED = 84;
    public static final int INVALID_FLOWID = 85;
    public static final int SELECTOR_INVALID = 86;
    public static final int UNKNOWN_START_LOCATION_TYPE = 87;
    public static final int MISMATCHED_ENDPOINT_ERROR_ID = 88;
    public static final int OUT_OF_REPLAY_RESOURCES = 89;
    public static final int TOPIC_OR_SELECTOR_MODIFIED_ON_DTE = 90;
    public static final int SHARED_SUBSCRIPTION_NOT_SUPPORTED = 91;
    public static final int REPLAY_START_MESSAGE_UNAVAILABLE = 92;
    public static final int UNAUTHORIZED = 93;
    public static final int REPLAY_ANONYMOUS_QUEUE_NOT_SUPPORTED = 94;
    public static final int REDELIVERY_DELAY_NOT_SUPPORT = 95;
    public static final int ONLY_LOCAL_TRANSACTED_SESSION_CAN_BIND_ENDPOINT = 96;
    public static final int PARTITIONED_QUEUE_NOT_SUPPRTED = 97;
    public static final int BROWSING_NOT_SUPPORTED_ON_PARTITIONED_QUEUE = 98;
    public static final int SELECTORS_NOT_SUPPORTED_ON_PARTITIONED_QUEUE = 99;
    public static final int XA_TRANSACTED_SESSION_CANNOT_BIND_PARTITIONED_QUEUE = 100;
    public static final int SYNC_REPLICATION_INELIGIBLE = 101;
    private static final String[][] descriptionTable;

    private JCSMPErrorResponseSubcodeEx() {
    }

    @Deprecated
    public static String getDescription(int subcode) {
        if (subcode > descriptionTable.length - 1) {
            throw new IllegalArgumentException("Subcode out of range.");
        }
        return descriptionTable[subcode][1];
    }

    public static String getSubcodeAsString(int subcode) {
        if (subcode > descriptionTable.length - 1) {
            throw new IllegalArgumentException("Subcode out of range.");
        }
        return descriptionTable[subcode][0];
    }

    static {
        HashMap<Integer, String[]> descs = new HashMap<Integer, String[]>();
        descs.put(0, new String[]{"UNKNOWN", "Unknown"});
        descs.put(1, new String[]{"LOGIN_FAILURE", "Client could not login to router."});
        descs.put(2, new String[]{"INVALID_VIRTUAL_ADDRESS", "Attempt to connect to wrong IP address on router (must use CVRID ifconfigured)."});
        descs.put(3, new String[]{"MSG_VPN_NOT_ALLOWED", "The VPN name set for the session is not allowed for the session's username."});
        descs.put(4, new String[]{"CLIENT_USERNAME_IS_SHUTDOWN", "The username for the client is administratively shutdown on the router."});
        descs.put(5, new String[]{"DYNAMIC_CLIENTS_NOT_ALLOWED", "The username for the session has not been set, and dynamic clients are not allowed."});
        descs.put(6, new String[]{"CLIENT_NAME_ALREADY_IN_USE", "The session is attempting to use a client name that is in use by another client in the message VPN, and the router is configured to reject the new session."});
        descs.put(7, new String[]{"CLIENT_DELETE_IN_PROGRESS", "Client login is not currently possible because a previous instance of same client still being deleted."});
        descs.put(8, new String[]{"TOO_MANY_CLIENTS", "Client login is not currently possible because the maximum number of active clients on router has been reached."});
        descs.put(9, new String[]{"MSG_VPN_UNAVAILABLE", "The VPN name set for the session (or the default VPN if none was set) is currently shutdown on the router."});
        descs.put(10, new String[]{"XML_PARSE_ERROR", "The router could not parse an XML message."});
        descs.put(11, new String[]{"MESSAGE_TOO_LARGE", "Client attempted to send a message larger than that supported by the router."});
        descs.put(12, new String[]{"INVALID_TOPIC_SYNTAX", "Attempt to use a topic that uses a syntax that is not supported."});
        descs.put(13, new String[]{"SUBSCRIPTION_ALREADY_PRESENT", "Client attempted to add a subscription that already exists."});
        descs.put(14, new String[]{"SUBSCRIPTION_NOT_FOUND", "Client attempted to remove a subscription that did not exist."});
        descs.put(15, new String[]{"SUBSCRIPTION_INVALID", "Client attempted to add or remove a subscription that is not valid."});
        descs.put(16, new String[]{"SUBSCRIPTION_TOO_MANY", "Client attempted to add a subscription when the maximum number of allowed has been reached."});
        descs.put(17, new String[]{"OUT_OF_RESOURCES", "Call failed due to lack of resources."});
        descs.put(18, new String[]{"CANNOT_BIND_TO_QUEUE", "Already bound to the Guaranteed Delivery queue or not authorized to bind to the Guaranteed Delivery queue."});
        descs.put(19, new String[]{"INVALID_TOPIC_NAME_FOR_TE", "Attempt to bind to a Topic Endpoint (TE) with an invalid topic."});
        descs.put(20, new String[]{"UNKNOWN_QUEUE_NAME", "Attempt to bind to, or deprovision an unknown Guaranteed Delivery queue name (e.g., the queue name is not configured on the router)."});
        descs.put(21, new String[]{"UNKNOWN_TE_NAME", "Attempt to bind to, or deprovision an unknown Topic Endpoint (TE) name (e.g. not configured on router)."});
        descs.put(22, new String[]{"MAX_CLIENTS_FOR_QUEUE", "Attempt to bind to a Guaranteed Delivery queue that already has already reached its maximum number of clients."});
        descs.put(23, new String[]{"MAX_CLIENTS_FOR_TE", "Attempt to bind to a Topic Endpoint (TE) that has already reached its maximum number of clients."});
        descs.put(24, new String[]{"QUEUE_NOT_FOUND", "The specified Guaranteed Delivery queue was not found when publishing a message."});
        descs.put(25, new String[]{"CLIENT_NAME_INVALID", "Attempted to set CLIENT_NAME property to an invalid value."});
        descs.put(26, new String[]{"CLIENT_ACL_DENIED", "Client denied login to router due to matching a client ACL (Access Control List)."});
        descs.put(27, new String[]{"SUBSCRIPTION_ACL_DENIED", "Adding of subscription denied to due a subscription ACL (Access Control List)."});
        descs.put(28, new String[]{"PUBLISH_ACL_DENIED", "Publishing of message denied to due topic matching a publish ACL (Access Control List)."});
        descs.put(29, new String[]{"NO_MORE_NON_DURABLE_QUEUE_OR_TE", "Reached the maximum possible number of non-durable endpoints on the router; no more non-durable endpoints can be created."});
        descs.put(30, new String[]{"SPOOL_OVER_QUOTA", "Spool is over its allotted space quota."});
        descs.put(31, new String[]{"QUEUE_SHUTDOWN", "An attempt was made to bind to a shutdown Guaranteed Delivery queue."});
        descs.put(32, new String[]{"TE_SHUTDOWN", "An attempt was made to bind to a shutdown Guaranteed Delivery Topic Endpoint (TE)."});
        descs.put(33, new String[]{"ENDPOINT_ALREADY_EXISTS", "An attempt was made to provision an endpoint that already exists."});
        descs.put(34, new String[]{"QUOTA_OUT_OF_RANGE", "An attempt was made to bind to, or provision an endpoint with a quota that is out of range."});
        descs.put(35, new String[]{"DELETE_IN_PROGRESS", "An attempt was made to bind to, or provision an endpoint that is being deleted."});
        descs.put(36, new String[]{"PERMISSION_NOT_ALLOWED", "An attempt was made to bind to, deprovision, or consume a message from an endpoint without permission."});
        descs.put(37, new String[]{"INVALID_PARAMETER_COMBINATION", "An attempt was made to provision a #DEAD_MESSAGE_QUEUE with respectTTL set to true."});
        descs.put(38, new String[]{"PUBLISH_NO_VALID_CLOSED_USER_GROUP", "Publishing of message denied due to the publisher having no valid Closed User Group."});
        descs.put(39, new String[]{"MAX_MESSAGE_USAGE_EXCEEDED", "MAX_MESSAGE_USAGE_EXCEEDED"});
        descs.put(40, new String[]{"ENDPOINT_PROPERTY_MISMATCH", "An attempt was made to provision an endpoint that already exists and has mismatched properties."});
        descs.put(41, new String[]{"UNKNOWN_CLIENT_NAME", ""});
        descs.put(42, new String[]{"SUBSCRIPTION_MANAGER_DENIED", ""});
        descs.put(43, new String[]{"NOT_READY", ""});
        descs.put(44, new String[]{"SUBSCRIPTION_ATTRIBUTES_CONFLICT", "Client attempted to add a subscription that already exists with different properties."});
        descs.put(45, new String[]{"UNSUBSCRIBE_NOT_ALLOWED_CLIENTS_BOUND", "Client attempted to unsubscribe (delete the topic from a Topic Endpoint) while it had at least one bound client."});
        descs.put(50, new String[]{"SERVICE_UNAVAILABLE", "A control operation failed due to Service Unavailable."});
        descs.put(46, new String[]{"TRANSACTED_SESSION_NAME_IN_USE", "The Transacted Session Name is being used by another opened session."});
        descs.put(47, new String[]{"MAX_TRANSACTED_SESSIONS_EXCEEDED", "The router cannot accept any more transacted sessions. This error is returned while attempting to open a transacted session."});
        descs.put(48, new String[]{"TRANSACTION_MESSAGE_CONSUME_FAILURE", "Failure to consume a message during a transaction. Message deleted or queue not found or shutdown."});
        descs.put(49, new String[]{"TRANSACTION_OVERFLOW", "The Transaction has too many messages. It is deprecated"});
        descs.put(51, new String[]{"MESSAGE_PUBLISH_FAILURE", "A transaction failed due to an error publishing message(s)."});
        descs.put(52, new String[]{"INVALID_TRANSACTION_ID", "A transaction failed due to attempting to commit with an invalid or expired Transaction ID."});
        descs.put(53, new String[]{"ENDPOINT_MODIFIED", "A transaction failed due to attempting to commit on an endpoint that changed state."});
        descs.put(54, new String[]{"IN_PROGRESS", "An operation is in progress."});
        descs.put(55, new String[]{"UNKNOWN_FLOW_NAME", "An attempt to re-establish a flow failed due to loss of state."});
        descs.put(56, new String[]{"REPLICATION_IS_STANDBY", "An attempt was made to use a VPN configured to be standby for replication"});
        descs.put(57, new String[]{"LOW_PRIORITY_MSG_CONGESTION", "The message was rejected by the router if one or more matching endpoints reject-low-priority-msg-limit is exceeded."});
        descs.put(58, new String[]{"BASIC_AUTHENTICATION_IS_SHUTDOWN", "The client attempted to connect to an appliance that has the basic authentication shutdown."});
        descs.put(59, new String[]{"CLIENT_CERTIFICATE_AUTHENTICATION_IS_SHUTDOWN", "The client attempted to connect to an appliance that has the client certificate authentication shutdown."});
        descs.put(60, new String[]{"KERBEROS_AUTHENTICATION_IS_SHUTDOWN", "The client attempted to connect to an appliance that has the Kerberos authentication shutdown."});
        descs.put(61, new String[]{"UNTRUSTED_CLIENT_CERTIFICATE", "The client failed to connect to an appliance as it has a suspect client certificate."});
        descs.put(62, new String[]{"CLIENT_CERTIFICATE_DATE_INVALID", "The client failed to connect to an appliance as it does not have a valid client certificate date."});
        descs.put(63, new String[]{"TRANSACTION_FAILURE", "The client attemped to commit a transaction with too many messages."});
        descs.put(64, new String[]{"UNKNOWN_TRANSACTED_SESSION_NAME", "An attempt to re-establish a transacted session failed."});
        descs.put(65, new String[]{"MAX_TRANSACTIONS_EXCEEDED", "The router cannot accept any more transactions. This error is returned while attempting to start a new transaction."});
        descs.put(66, new String[]{"XASESSION_TO_LVQ_BIND_ERROR", "It is not allowed to bind a consumer within an XASession to a queue configured as a last value queue."});
        descs.put(67, new String[]{"NON_XASESSION_TO_XAENDPOINT_BIND_ERROR", "It is not allowed for a consumer from a non-XASession to bind to and endpoint involved in an XA transaction."});
        descs.put(68, new String[]{"XASESSION_TO_NON_XAENDPOINT_BIND_ERROR", "It is not allowed for a consumer from a XASession to bind to and a non-XA endpoint."});
        descs.put(69, new String[]{"FLOW_UNBOUND", "The client operation failed due to UNBOUND consumer flows."});
        descs.put(70, new String[]{"NO_SUBSCRIPTION_MATCH", "The client attempted to publish a guaranteed message to a topic that did not have any guaranteed subscription matches or only matched a replicated topic."});
        descs.put(71, new String[]{"SUBSCRIPTION_MATCH_ERROR", "The client attempted to bind to a non-exclusive topic endpoint that is already bound with a different subscription."});
        descs.put(72, new String[]{"SELECTOR_MATCH_ERROR", "The client attempted to bind to a non-exclusive topic endpoint that is already bound with a different ingress selector."});
        descs.put(80, new String[]{"REPLAY_MESSAGE_UNAVAILABLE", "The flow was replaying messages as requested by an earlier bind request, but the replay failed because messages to be replayed were trimmed from the replay log."});
        descs.put(78, new String[]{"REPLAY_STARTED", "A replay was started on the queue or DTE, either by another client or by the router."});
        descs.put(79, new String[]{"REPLAY_CANCELLED", "The flow was replaying messages as requested by an earlier bind request, but the replay was administratively cancelled."});
        descs.put(81, new String[]{"REPLAY_START_TIME_NOT_AVAILABLE", "A replay was requested, but the requested start time is not available in the replay log."});
        descs.put(82, new String[]{"REPLAYED_MESSAGE_REJECTED", "The router attempted to replay a message, but the queue or topic endpoint rejected the message to sender. "});
        descs.put(92, new String[]{"REPLAY_START_MESSAGE_UNAVAILABLE", "The message upon which a replay start was based is not available."});
        descs.put(83, new String[]{"REPLAY_LOG_MODIFIED", "A replay was ongoing on the queue or DTE and the replay log was modified."});
        descs.put(84, new String[]{"REPLAY_FAILED", "An unexpected error has happened during message replay on the queue or DTE."});
        descs.put(75, new String[]{"CLIENT_INITIATED_REPLAY_NON_EXCLUSIVE_NOT_ALLOWED", "The request attempted to start replay on a non-exclusive queue, which is not permitted. Replay on non-exclusive queues must be started administratively via the router\u2019s management interface."});
        descs.put(76, new String[]{"CLIENT_INITIATED_REPLAY_INACTIVE_FLOW_NOT_ALLOWED", "The request attempted to start replay as an inactive flow, which is not permitted. Only active consumers can start request replays."});
        descs.put(73, new String[]{"CLIENT_INITIATED_REPLAY_BROWSER_FLOW_NOT_ALLOWED", "The request attempted to start replay as a browser flow, which is not permitted. Only active consumers can start request replays."});
        descs.put(77, new String[]{"REPLAY_TEMPORARY_NOT_SUPPORTED", "The request attempted to start replay on a temporary queue or topic endpoint, which is not supported."});
        descs.put(74, new String[]{"REPLAY_DISABLED", "Replay is not enabled in the queue or DTE\u2019s message VPN."});
        descs.put(85, new String[]{"INVALID_FLOWID", "The client has attempted to unbind from a FlowId which the client is not bound to"});
        descs.put(86, new String[]{"SELECTOR_INVALID", "The client attempted to bind to a topic endpoint with an improperly formatted selector."});
        descs.put(87, new String[]{"UNKNOWN_START_LOCATION_TYPE", "The request attempted to start a replay but provided an unknown start location type."});
        descs.put(88, new String[]{"MISMATCHED_ENDPOINT_ERROR_ID", "Endpoint error ID in the bind request does not match the endpoint's error ID."});
        descs.put(89, new String[]{"OUT_OF_REPLAY_RESOURCES", "A replay was requested, but the router does not have sufficient resources to fulfill the request, due to too many active replays."});
        descs.put(90, new String[]{"TOPIC_OR_SELECTOR_MODIFIED_ON_DTE", "A replay was in progress on a Durable Topic Endpoint (DTE) when its topic or selector was modified, causing the replay to fail."});
        descs.put(91, new String[]{"SHARED_SUBSCRIPTION_NOT_SUPPORTED", "The client has attempted to use a shared subscription on a queue or topic endpoint, which is not supported.  Shared subscriptions are only supported for direct messaging."});
        descs.put(93, new String[]{"UNAUTHORIZED", "Authentication of the client has failed due to bad credentials."});
        descs.put(94, new String[]{"REPLAY_ANONYMOUS_QUEUE_NOT_SUPPORTED", "The request attempted to start replay on an anonymous queue, which is not supported."});
        descs.put(95, new String[]{"The client did not provide the RD_LT ClientCapability and has tried to bind to the endpoint with configured delayed redelivery."});
        descs.put(96, new String[]{"The client tried to bind to an endpoint which has delayed redelivery enabled, but did not use a local transacted session. Only local transacted sessions can bind to this type of endpoint."});
        descs.put(97, new String[]{"The client did not provide the PQ ClientCapability and has tried to bind to a Partitioned Queue."});
        descs.put(98, new String[]{"Browser flows to Partitioned Queues are not permitted."});
        descs.put(99, new String[]{"The client did not provide the RD_LT ClientCapability and has tried to bind to the endpoint with configured delayed redelivery."});
        descs.put(100, new String[]{"XA transactions do not support Partitioned Queues. XA transacted sessions cannot bind to this type of endpoint."});
        descs.put(101, new String[]{"The message was rejected because the appliance has been configured to reject messages when sync replication mode is ineligible, or the transaction was started as a synchronous replicated transaction, but replication became ineligible during the transaction."});
        descriptionTable = new String[descs.size()][2];
        for (Map.Entry e : descs.entrySet()) {
            JCSMPErrorResponseSubcodeEx.descriptionTable[((Integer)e.getKey()).intValue()] = (String[])e.getValue();
        }
    }
}

