/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.Arrays;
import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.EventMessage;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPProducerEventHandler;
import com.solacesystems.jcsmp.JCSMPSendMultipleEntry;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.JCSMPStreamingPublishCorrelatingEventHandler;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.MapMessage;
import com.solacesystems.jcsmp.ProducerFlowProperties;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.StaleSessionException;
import com.solacesystems.jcsmp.StreamMessage;
import com.solacesystems.jcsmp.StreamXMLMessage;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.TextXMLMessage;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.XMLContentMessage;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.AbstractDestination;
import com.solacesystems.jcsmp.impl.BufferCloningPool;
import com.solacesystems.jcsmp.impl.BytesMessageImpl;
import com.solacesystems.jcsmp.impl.BytesXMLMessageWrapper;
import com.solacesystems.jcsmp.impl.Closeable;
import com.solacesystems.jcsmp.impl.ContextBlockingOpCheck;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.InternalCapabilityType;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPUtils;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessagePool;
import com.solacesystems.jcsmp.impl.MapMessageImpl;
import com.solacesystems.jcsmp.impl.MsgIdInfo;
import com.solacesystems.jcsmp.impl.PubADManager;
import com.solacesystems.jcsmp.impl.PubSubMode;
import com.solacesystems.jcsmp.impl.SendMultipleEntry;
import com.solacesystems.jcsmp.impl.StreamMessageImpl;
import com.solacesystems.jcsmp.impl.TargetRouterMode;
import com.solacesystems.jcsmp.impl.TextMessageImpl;
import com.solacesystems.jcsmp.impl.XMLContentMessageImpl;
import com.solacesystems.jcsmp.impl.flow.PubFlowManager;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import com.solacesystems.jcsmp.impl.sdt.StreamImpl;
import com.solacesystems.jcsmp.impl.transaction.AdCtrlV4TransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionImpl;
import com.solacesystems.jcsmp.management.SolJmxSupport;
import com.solacesystems.jcsmp.protocol.CSMPPublisherChannel;
import com.solacesystems.jcsmp.protocol.CSMPPublisherChannelObserver;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.nio.Notification;
import com.solacesystems.jcsmp.protocol.nio.impl.ProducerErrorNotification;
import com.solacesystems.jcsmp.protocol.nio.impl.ProducerNotificationDispatcher;
import com.solacesystems.jcsmp.protocol.nio.impl.ProducerResponseNotification;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class JCSMPXMLMessageProducer
implements XMLMessageProducer,
CSMPPublisherChannelObserver,
Closeable,
JCSMPStreamingPublishCorrelatingEventHandler {
    private static final long ID_UNSET = -1L;
    private final LogWrapper Trace = new LogWrapper(JCSMPXMLMessageProducer.class);
    private static final int MESSAGE_POOL_SIZE = 51;
    private String sessionId;
    private JCSMPBasicSession session;
    private final boolean includeClientName;
    private final boolean generateTimestamp;
    private final boolean generateSeqNo;
    private final boolean calculateExpiration;
    private long seqNo;
    public CSMPPublisherChannel channel;
    private JCSMPStreamingPublishEventHandler streamCallback;
    private JCSMPProducerEventHandler eventCallback;
    private JCSMPSessionStats sessionStats;
    private JCSMPXMLMessagePool pool;
    private JCSMPException lastException = null;
    private long _producerId;
    private static long producerIdCounter = 0L;
    private int readTimeout = 0;
    private volatile boolean opened = false;
    private boolean reconnectFailed = false;
    private final ContextImpl context;
    private ProducerNotificationDispatcher prdNotifDsp = null;
    private Boolean acceptDirectQueue = null;
    private boolean directPermitted = true;
    private int priority = 4;
    private PubADManager _admgr;
    private PubFlowManager _pubFlowManager;
    private volatile List<Future<Object>> resendFutures = null;
    private BufferCloningPool _bufCloningPool = new BufferCloningPool();
    private WaitLock waitLock = new WaitLock();
    private volatile boolean sendBlocked = false;
    private AtomicInteger sendBlockedTickets = new AtomicInteger(0);
    private Object sendWaitLock = new Object();
    private final ReentrantLock mPubLock;
    private final BaseTransactedSessionImpl transactedSession;
    private final ContextBlockingOpCheck contextOpCheck;
    private TransactedSessionImpl largeMsgTxSession = null;
    private JCSMPXMLMessageProducer largeMsgTxProducer = null;
    private volatile int maxAdBrokerSupportedMessageSize;
    private boolean largeMessaging = false;
    private int largeMessageSegmentSize = 0;
    private int largeMessageMaxSize = 0;
    private JCSMPStreamingPublishEventHandler appStreamCallback;
    private LinkedList<ControlPubMsgInfo> pubMsgInfoList;
    private Object pubMsgInfoLock = new Object();
    private Object largeMsgSendLock = new Object();

    public JCSMPXMLMessageProducer(JCSMPBasicSession session, CSMPPublisherChannel channel, JCSMPStreamingPublishEventHandler callback, JCSMPProducerEventHandler eventHandler, PubFlowManager pubFlowMgr, ProducerFlowProperties fprop, JCSMPBasicSession.InternalBindProperties internalBindProp) {
        this.sessionId = session.getLogContextInfo();
        this.includeClientName = fprop != null && fprop.isGenerateSenderId() != null ? fprop.isGenerateSenderId() : (Boolean)session.getJCSMPProperties().getProperty("generate_sender_id");
        this.generateTimestamp = fprop != null && fprop.isGenerateSendTimeStamp() != null ? fprop.isGenerateSendTimeStamp() : (Boolean)session.getJCSMPProperties().getProperty("generate_send_timestamps");
        this.generateSeqNo = fprop != null && fprop.isGenerateSequenceNumber() != null ? fprop.isGenerateSequenceNumber() : (Boolean)session.getJCSMPProperties().getProperty("generate_sequence_numbers");
        this.calculateExpiration = fprop != null && fprop.isCalculateMessageExpiration() != null ? fprop.isCalculateMessageExpiration() : (Boolean)session.getJCSMPProperties().getProperty("calculate_message_expiration");
        this.largeMessaging = session.getJCSMPProperties().getBooleanProperty("large_messaging");
        this.largeMessageSegmentSize = session.getJCSMPProperties().getIntegerProperty("large_message_segment_size");
        this.largeMessageMaxSize = session.getJCSMPProperties().getIntegerProperty("large_message_max_size");
        this.seqNo = 1L;
        this.session = session;
        this.channel = channel;
        this.sessionStats = session.getSessionStats();
        this.streamCallback = callback;
        this.eventCallback = eventHandler;
        this.context = session.getContext();
        this.contextOpCheck = new ContextBlockingOpCheck(this.context, session.getJCSMPProperties());
        this.readTimeout = ((JCSMPChannelProperties)session.getJCSMPProperties().getProperty("publisher_data_channel")).getReadTimeoutInMillis();
        this._pubFlowManager = pubFlowMgr;
        this.resendFutures = new ArrayList<Future<Object>>();
        boolean pubMultiThread = fprop != null && fprop.isPubMultiThreaded() != null ? fprop.isPubMultiThreaded() : (Boolean)session.getJCSMPProperties().getProperty("pub_multi_thread");
        this.mPubLock = pubMultiThread ? new ReentrantLock() : null;
        if (fprop == null) {
            fprop = new ProducerFlowProperties();
            fprop.setWindowSize(session.getJCSMPProperties().getIntegerProperty("pub_ack_window_size"));
            fprop.setRtrWindowedAck(session.getJCSMPProperties().getBooleanProperty("ad_pub_router_windowed_ack"));
            fprop.setAckEventMode(session.getJCSMPProperties().getStringProperty("ACK_EVENT_MODE"));
        }
        this.transactedSession = internalBindProp != null ? internalBindProp.transactedSession : null;
        this.largeMsgTxSession = null;
        this.largeMsgTxProducer = null;
        if (this.transactedSession == null && this.largeMessaging) {
            this.pubMsgInfoList = new LinkedList();
            if (callback != null) {
                this.appStreamCallback = callback;
                this.streamCallback = this;
            }
        }
        this._admgr = PubADManager.getNewADManager(this, session.getJCSMPProperties(), session.getContext(), fprop);
        this.channel.setADSettings(this._admgr);
        if (internalBindProp != null && internalBindProp.transactedSession != null) {
            this.pool = new JCSMPXMLMessagePool(true, this.transactedSession);
            this.pool.init(256);
        } else {
            this.pool = new JCSMPXMLMessagePool();
            int msgPoolSize = Math.max(this._admgr.configured_Pub_Ack_Window_Size, 51);
            this.pool.init(msgPoolSize);
        }
        this.Trace.setContextInfo(this.getLogContextInfo());
        SolJmxSupport.instance().register(this, session);
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("Created XMLMessageProducer for session [%s]", this.sessionId));
        }
    }

    public void resetMessageRetransmitQueue() {
        this.stopMsgRetransmit();
        this._admgr.clearMessageQueue(false);
    }

    public void updateLogCntextInfo() {
        this.Trace.setContextInfo(this.getLogContextInfo());
    }

    public String getLogContextInfo() {
        if (this.transactedSession != null && this.transactedSession instanceof AdCtrlV4TransactedSessionImpl) {
            if (this._admgr.getFlowId() != -1L) {
                return ((AdCtrlV4TransactedSessionImpl)this.transactedSession).getLogContextInfo() + ":Flow-" + this._admgr.getFlowId();
            }
            return ((AdCtrlV4TransactedSessionImpl)this.transactedSession).getLogContextInfo();
        }
        if (this._admgr.getFlowId() != -1L) {
            return this.sessionId + ":Flow-" + this._admgr.getFlowId();
        }
        return this.sessionId;
    }

    public ReentrantLock getLock() {
        return this.mPubLock;
    }

    public PubADManager getPubADManager() {
        return this._admgr;
    }

    public JCSMPStreamingPublishEventHandler getStreamEventHandler() {
        return this.streamCallback;
    }

    public JCSMPProducerEventHandler getProducerEventHandler() {
        return this.eventCallback;
    }

    public boolean isOpenInternal() {
        return this.opened;
    }

    public void open() throws JCSMPException {
        this.open(false);
    }

    protected boolean hasStreamingCallback() {
        return this.streamCallback != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(boolean reconn) throws JCSMPException {
        int reconMax;
        if (!reconn && this.opened) {
            return;
        }
        this._admgr.reInit();
        this._producerId = ++producerIdCounter;
        this.channel.setProducerId(this._producerId);
        this.maxAdBrokerSupportedMessageSize = (Integer)this.session.getCapability(CapabilityType.MAX_GUARANTEED_MSG_SIZE);
        if (!this.hasStreamingCallback() && !this.channel.isExplicitAckEnabled()) {
            if (this._pubFlowManager.countAll() > 0) {
                throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.invalidBlockingSessionHasPubs"));
            }
            this.channel.close();
            this.channel.setExplicitAckEnabled(true);
        }
        JCSMPChannelProperties pubChannelProps = this.channel.getChannelProperties();
        if (!reconn) {
            reconMax = 1;
        } else {
            reconMax = pubChannelProps.getReconnectRetries() == -1 ? Integer.MAX_VALUE : pubChannelProps.getReconnectRetries();
            reconMax = Math.max(reconMax, 1);
        }
        int reconWait = pubChannelProps.getReconnectRetryWaitInMillis();
        int reconTries = 0;
        JCSMPException lastError = null;
        if (!this.channel.connected() || reconn) {
            while (reconTries < reconMax) {
                try {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug("About to open publisher channel, attempt " + reconTries);
                    }
                    this.channel.close();
                    this.channel.open(reconn);
                    lastError = null;
                    break;
                }
                catch (JCSMPException jcsmpEx) {
                    lastError = jcsmpEx;
                    this.Trace.warn(String.format("Producer [%s] hit exception in open(), ex=%s, reconTries=%s, reconMax=%s", this.sessionId, jcsmpEx, reconTries, reconMax));
                    if (!(jcsmpEx instanceof JCSMPTransportException)) break;
                    if (++reconTries >= reconMax) continue;
                    try {
                        Thread.sleep(reconWait);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (lastError != null) {
            String exhaustedMsg = String.format("[%s] %s", this.sessionId, JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.exhaustedReconnectRetries"));
            this.Trace.warn(exhaustedMsg);
            throw lastError;
        }
        if (!reconn) {
            if (this.transactedSession != null && this.transactedSession.isXA()) {
                this.pool.init(256);
            } else {
                int msgPoolSize = Math.max(this._admgr.configured_Pub_Ack_Window_Size, 51);
                this.pool.init(msgPoolSize);
            }
        } else if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Producer is in reconnecting state, do not initialize message pool");
        }
        this._admgr.handleFlowOpenResponse();
        WaitLock waitLock = this.waitLock;
        synchronized (waitLock) {
            this.waitLock.setRespReceived(false);
        }
        this.opened = true;
    }

    private void close(JCSMPException cause) {
        this.lastException = cause;
        this.close();
    }

    protected int getAdCtrlVersion() {
        return this.session.getAssuredCtrlFactory().getVersion();
    }

    public void notifyReconnectAborted() {
        this._admgr.notifyReconnectAborted();
    }

    @Override
    public void close() {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Client closes producer");
        }
        if (this.transactedSession != null) {
            if (!this.opened) {
                return;
            }
            this.transactedSession.closeFlow(this);
        } else {
            this.closeImpl(false);
        }
    }

    @Override
    public boolean isClosed() {
        return !this.opened;
    }

    private void closeImpl(JCSMPException cause) {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("closeImpl: " + cause);
        }
        this.lastException = cause;
        this.closeImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMsgRetransmit() {
        List<Future<Object>> list = this.resendFutures;
        synchronized (list) {
            try {
                this._admgr.clearADTimer();
                for (Future<Object> f : this.resendFutures) {
                    f.cancel(false);
                }
            }
            catch (Throwable e) {
                this.Trace.info("got unexpected exception: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResendTask(Future<Object> task) {
        List<Future<Object>> list = this.resendFutures;
        synchronized (list) {
            this.resendFutures.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpResendTasks() {
        List<Future<Object>> list = this.resendFutures;
        synchronized (list) {
            this.resendFutures.removeIf(Future::isDone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeImpl(boolean reconn) {
        if (!this.opened) {
            return;
        }
        this._admgr.getState().notifyProducerClosed();
        this.reconnectFailed = false;
        if (!reconn) {
            this.opened = false;
            this._pubFlowManager.closeFlow(this, true);
        }
        this.stopMsgRetransmit();
        if (this.hasStreamingCallback()) {
            ArrayList<JCSMPXMLMessage> msgsToReturn = new ArrayList<JCSMPXMLMessage>();
            this.channel.drainOutstandingNonADMsgsTo(msgsToReturn);
            this.returnMessagesToPool(msgsToReturn);
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(String.format("Return %s non-AD messages to pool", msgsToReturn.size()));
            }
        }
        if (this.channel.isUserCloseable()) {
            this.channel.close();
        }
        if (!reconn) {
            this._admgr.clearMessageQueue();
            this.resume();
        } else if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Producer is in reconnecting state, do not purge notification");
        }
        if (!reconn) {
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.setRespReceived(true);
                this.waitLock.notifyAll();
            }
            object = this.pubMsgInfoLock;
            synchronized (object) {
                if (this.pubMsgInfoList != null) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug(String.format("Clear pubMsgInfoList for session [%s]", this.sessionId));
                    }
                    this.pubMsgInfoList.clear();
                }
            }
            SolJmxSupport.instance().deregister(this);
        }
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("Closed XMLMessageProducer for session [%s].", this.sessionId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void send(XMLMessage message, Destination destination) throws JCSMPException {
        if (this.largeMessaging && JCSMPUtils.isAdMessage(message)) {
            if (this.largeMsgTxSession == null) {
                ProducerFlowProperties prodFlowProps = new ProducerFlowProperties();
                prodFlowProps.setWindowSize(255);
                this.largeMsgTxSession = (TransactedSessionImpl)this.session.createTransactedSessionInternal();
                this.largeMsgTxProducer = (JCSMPXMLMessageProducer)this.largeMsgTxSession.createProducer(prodFlowProps, this);
            }
            JCSMPXMLMessage jcsmpMessage = null;
            jcsmpMessage = message instanceof JCSMPXMLMessage ? (JCSMPXMLMessage)message : this.unwrapMessage(message);
            JCSMPSendMultipleEntry[] messages = null;
            PubMsgInfo[] pubMsgInfos = null;
            int totalSize = jcsmpMessage.getContentLength() + jcsmpMessage.getAttachmentContentLength();
            if (destination != null && !destination.isTemporary() && (destination instanceof Queue || destination instanceof Topic) && totalSize > this.largeMessageSegmentSize) {
                Object object;
                double numMessagesFactor = (double)totalSize / (double)this.largeMessageSegmentSize;
                int numMsgs = Math.max((int)Math.ceil(numMessagesFactor), 1);
                if (totalSize > this.largeMessageMaxSize) {
                    throw new IllegalArgumentException("The maximum large message size exceeded");
                }
                messages = new JCSMPSendMultipleEntry[numMsgs + 1];
                pubMsgInfos = new PubMsgInfo[numMsgs + 1];
                this.constructChunks(jcsmpMessage, numMsgs, totalSize, destination, messages, pubMsgInfos);
                if (this.transactedSession == null) {
                    object = this.pubMsgInfoLock;
                    synchronized (object) {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug("add control message to pubMsgInfoList " + pubMsgInfos[numMsgs]);
                        }
                        this.pubMsgInfoList.add((ControlPubMsgInfo)pubMsgInfos[numMsgs]);
                    }
                }
                try {
                    if (this.transactedSession == null && this.largeMsgTxProducer != null) {
                        object = this.largeMsgSendLock;
                        synchronized (object) {
                            this.largeMsgTxProducer.sendToDestination(messages, pubMsgInfos);
                            this.largeMsgTxSession.commit();
                        }
                        this.responseReceivedEx(pubMsgInfos[numMsgs]);
                        return;
                    }
                    this.sendToDestination(messages, pubMsgInfos);
                    return;
                }
                finally {
                    messages = null;
                    pubMsgInfos = null;
                    this.sessionStats.incStat(StatType.TOTAL_SEND_METHOD_CALLED);
                }
            }
            messages = new JCSMPSendMultipleEntry[]{new SendMultipleEntry()};
            messages[0].setDestination(destination);
            messages[0].setMessage(jcsmpMessage);
            pubMsgInfos = new PubMsgInfo[1];
            ControlPubMsgInfo info = new ControlPubMsgInfo(null);
            info.setCorrelationKey(jcsmpMessage.getCorrelationKey());
            pubMsgInfos[0] = info;
            if (this.transactedSession == null) {
                Object object = this.pubMsgInfoLock;
                synchronized (object) {
                    this.pubMsgInfoList.add((ControlPubMsgInfo)pubMsgInfos[0]);
                }
            }
            try {
                this.sendToDestination(messages, pubMsgInfos);
                return;
            }
            finally {
                this.sessionStats.incStat(StatType.TOTAL_SEND_METHOD_CALLED);
            }
        }
        JCSMPSendMultipleEntry[] vec = new JCSMPSendMultipleEntry[]{new SendMultipleEntry()};
        vec[0].setDestination(destination);
        vec[0].setMessage(message);
        try {
            this.sendToDestination(vec);
            return;
        }
        finally {
            this.sessionStats.incStat(StatType.TOTAL_SEND_METHOD_CALLED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructChunks(JCSMPXMLMessage largeMsg, int numSegs, int totalSize, Destination destination, JCSMPSendMultipleEntry[] messages, PubMsgInfo[] pubMsgInfos) throws JCSMPException {
        try {
            AbstractDestination segmentDest = null;
            segmentDest = destination instanceof Queue ? JCSMPFactory.onlyInstance().createQueue("#LGM/" + destination.getName()) : JCSMPFactory.onlyInstance().createTopic("#LGM/" + destination.getName());
            String uuid = UUID.randomUUID().toString();
            byte[] xmlContent = largeMsg.getContent();
            int xmlContentLen = largeMsg.getContentLength();
            int xmlOffset = 0;
            byte[] attContent = largeMsg.getAttachmentContent();
            int attContentLen = largeMsg.getAttachmentContentLength();
            int attOffset = 0;
            for (int i = 1; i <= numSegs; ++i) {
                BytesXMLMessage segMsg = JCSMPFactory.onlyInstance().createMessage(BytesXMLMessage.class);
                segMsg.setDeliveryMode(largeMsg.getDeliveryMode());
                segMsg.setDMQEligible(largeMsg.isDMQEligible());
                segMsg.setExpiration(largeMsg.getExpiration());
                segMsg.setTimeToLive(largeMsg.getTimeToLive());
                segMsg.setAckImmediately(largeMsg.isAckImmediately());
                int totalBytesToWrite = 0;
                if (xmlContentLen > 0 && (totalBytesToWrite = Math.min(this.largeMessageSegmentSize, xmlContentLen - xmlOffset)) > 0) {
                    segMsg.writeBytes(xmlContent, xmlOffset, totalBytesToWrite);
                    xmlOffset += totalBytesToWrite;
                }
                if (attContentLen > 0) {
                    if ((totalBytesToWrite = Math.min(this.largeMessageSegmentSize - totalBytesToWrite, attContentLen - attOffset)) > 0) {
                        segMsg.writeAttachment(attContent, attOffset, totalBytesToWrite);
                        attOffset += totalBytesToWrite;
                    } else {
                        if (!this.Trace.isInfoEnabled()) break;
                        this.Trace.info("************should never reach here is numMsgs calculation is correct");
                        break;
                    }
                }
                SDTMap cpMap = this.createMap();
                cpMap.putString("JMS_Solace_lgm_guid", uuid);
                cpMap.putInteger("JMS_Solace_lgm_segId", i);
                segMsg.setProperties(cpMap);
                PubMsgInfo info = new PubMsgInfo(uuid);
                info.setSegId(i);
                info.setNumSegments(numSegs);
                if (this.transactedSession == null) {
                    info.setCorrelationKey(largeMsg.getCorrelationKey());
                    segMsg.setCorrelationKey(info);
                }
                messages[i - 1] = SendMultipleEntry.create(segMsg, segmentDest);
                pubMsgInfos[i - 1] = info;
            }
            BytesXMLMessage controlMsg = JCSMPFactory.onlyInstance().createMessage(BytesXMLMessage.class);
            controlMsg.setAckImmediately(largeMsg.isAckImmediately());
            controlMsg.setApplicationMessageId(largeMsg.getApplicationMessageId());
            controlMsg.setApplicationMessageType(largeMsg.getApplicationMessageType());
            controlMsg.setAsReplyMessage(largeMsg.isReplyMessage());
            controlMsg.setCorrelationId(largeMsg.getCorrelationId());
            controlMsg.setCos(largeMsg.getCos());
            controlMsg.setDeliverToOne(largeMsg.getDeliverToOne());
            controlMsg.setDeliveryMode(largeMsg.getDeliveryMode());
            controlMsg.setDMQEligible(largeMsg.isDMQEligible());
            controlMsg.setElidingEligible(largeMsg.isElidingEligible());
            if (largeMsg.isReadOnly()) {
                controlMsg.setReadOnly();
            }
            controlMsg.setExpiration(largeMsg.getExpiration());
            if (largeMsg.getPriority() != -1) {
                controlMsg.setPriority(largeMsg.getPriority());
            }
            controlMsg.setReplyTo(largeMsg.getReplyTo());
            controlMsg.setReplyToSuffix(largeMsg.getReplyToSuffix());
            controlMsg.setSenderId(largeMsg.getSenderId());
            if (largeMsg.getSenderTimestamp() != null) {
                controlMsg.setSenderTimestamp(largeMsg.getSenderTimestamp());
            }
            if (largeMsg.getSequenceNumber() != null) {
                controlMsg.setSequenceNumber(largeMsg.getSequenceNumber());
            }
            controlMsg.setTimeToLive(largeMsg.getTimeToLive());
            controlMsg.setUserData(largeMsg.getUserData() == null ? null : Arrays.copyOf(largeMsg.getUserData()));
            controlMsg.setStructuredMsgType(largeMsg.getStructuredMsgType());
            controlMsg.setStructuredMsg(largeMsg.isStructuredMsg());
            SDTMap cpMap = this.createMap();
            if (largeMsg.getProperties() != null) {
                cpMap.putAll(largeMsg.getProperties());
            }
            cpMap.putString("JMS_Solace_lgm_guid", uuid);
            cpMap.putInteger("JMS_Solace_lgm_numSegs", numSegs);
            cpMap.putInteger("JMS_Solace_lgm_size", totalSize);
            controlMsg.setProperties(cpMap);
            ControlPubMsgInfo info = new ControlPubMsgInfo(uuid);
            info.setNumSegments(numSegs);
            if (this.transactedSession == null) {
                info.setCorrelationKey(largeMsg.getCorrelationKey());
                controlMsg.setCorrelationKey(info);
            }
            messages[numSegs] = SendMultipleEntry.create(controlMsg, destination);
            pubMsgInfos[numSegs] = info;
        }
        finally {
            largeMsg.returnMessageToPool();
        }
    }

    @Override
    public int sendMultiple(JCSMPSendMultipleEntry[] entries, int offset, int length, int sendFlags) throws JCSMPException {
        this.checkClosed(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
        if (this.largeMessaging) {
            throw new InvalidOperationException("Vector send is not supported when Large Messaging is enabled");
        }
        if (length != entries.length) {
            JCSMPSendMultipleEntry[] newArray = new JCSMPSendMultipleEntry[length];
            System.arraycopy(entries, offset, newArray, 0, length);
            entries = newArray;
        }
        this.sendToDestination(entries);
        return length;
    }

    @Override
    public void sendReply(XMLMessage requestMessage, XMLMessage replyMessage) throws JCSMPException {
        if (!this.opened) {
            if (replyMessage != null) {
                ((JCSMPXMLMessage)replyMessage).returnMessageToPool();
            }
            this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
        }
        replyMessage.setAsReplyMessage(true);
        if (requestMessage.getCorrelationId() != null) {
            replyMessage.setCorrelationId(requestMessage.getCorrelationId());
        }
        if (requestMessage.getReplyTo() == null) {
            throw new IllegalArgumentException("ReplyTo destination may not be null.");
        }
        this.send(replyMessage, requestMessage.getReplyTo());
    }

    private void sendToDestination(JCSMPSendMultipleEntry[] messages) throws JCSMPException {
        this.sendToDestination(messages, null);
    }

    private void sendToDestination(JCSMPSendMultipleEntry[] messages, PubMsgInfo[] pubMsgInfos) throws JCSMPException {
        this.contextOpCheck.check();
        JCSMPXMLMessage[] send_vec = new JCSMPXMLMessage[messages.length];
        int send_vec_count = 0;
        DeliveryMode vec_del_mode = null;
        boolean foundAd = false;
        if (pubMsgInfos == null && messages.length > 50) {
            throw new IllegalArgumentException("Exceeded maximum length of send vector: 50");
        }
        if (this.session.isSessionReconnectAborted()) {
            throw this.session.getSessionAbortException();
        }
        for (JCSMPSendMultipleEntry send_e : messages) {
            if (!(send_e.getMessage() instanceof JCSMPXMLMessage) && !(send_e.getMessage() instanceof BytesXMLMessageWrapper)) {
                throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.invalidMsgPassedIn"));
            }
            JCSMPXMLMessage jcsmpMessage = null;
            jcsmpMessage = send_e.getMessage() instanceof JCSMPXMLMessage ? (JCSMPXMLMessage)send_e.getMessage() : this.unwrapMessage(send_e.getMessage());
            if (jcsmpMessage.getPriority() == -1) {
                jcsmpMessage.setPriority(this.priority);
            }
            Destination destination = send_e.getDestination();
            if (messages.length > 1 && jcsmpMessage.getMsgPool() != null) {
                throw new IllegalArgumentException("Vectored message transmission requires session-independent messages.");
            }
            if (vec_del_mode == null) {
                vec_del_mode = jcsmpMessage.getDeliveryMode();
            } else if (vec_del_mode != jcsmpMessage.getDeliveryMode()) {
                throw new IllegalArgumentException("All messages in send vector must have the same delivery mode.");
            }
            this.prep_single_send_message_for_publish(jcsmpMessage, destination);
            send_vec[send_vec_count] = jcsmpMessage;
            if (JCSMPUtils.isAdMessage(send_vec[send_vec_count])) {
                foundAd = true;
                this.sendImpl(send_vec, send_vec_count, 1, pubMsgInfos);
            }
            ++send_vec_count;
        }
        if (!foundAd) {
            this.sendImpl(send_vec, 0, messages.length, null);
        }
    }

    private void prep_single_send_message_for_publish(JCSMPXMLMessage message, Destination destination) throws JCSMPException {
        block27: {
            message.setDestinationSent(destination);
            if (this.includeClientName && (message.getSenderID() == null || !message.isSenderIDSetByUser())) {
                message.setSenderId_internal((String)this.session.getJCSMPProperties().getProperty("client_name"));
            }
            if (this.generateTimestamp && (message.getSendTimestamp() == null || !message.isSendTimestampSetByUser())) {
                message.setSendTimestamp_internal(System.currentTimeMillis());
            }
            if (this.generateSeqNo && (message.getSequenceNumber() == null || !message.isSequenceNumberSetByUser())) {
                message.setSequenceNumber_internal(this.seqNo++);
            }
            message.injectCreationContextInHeaderStore();
            message.injectBaggageInHeaderStore();
            long ttl = message.getTimeToLive();
            if (ttl > 0L) {
                if (this.calculateExpiration) {
                    message.setExpiration(ttl + System.currentTimeMillis());
                } else {
                    message.setExpiration(0L);
                }
                message.resetExpirationBinaryMeta();
            } else if (message.getExpiration() > 0L) {
                message.setExpirationBinaryMeta(message.getExpiration());
            } else {
                message.resetExpirationBinaryMeta();
            }
            TargetRouterMode routerMode = this.session.getRouterMode();
            try {
                if (destination != null) {
                    AbstractDestination aDest = (AbstractDestination)destination;
                    aDest.validate(routerMode, PubSubMode.PUB);
                    if (this.acceptDirectQueue == null) {
                        Map mInternal = (Map)this.session.getTransientData(JCSMPBasicSession.TransientData.INTERNAL_CAP);
                        this.acceptDirectQueue = (Boolean)mInternal.get((Object)InternalCapabilityType.ACCEPT_DIRECT_QUEUE_PUBLISH);
                    }
                    aDest.validateModeForPublish(message.getDeliveryMode(), routerMode, this.acceptDirectQueue);
                    aDest.initIfRequired();
                    if (routerMode != TargetRouterMode.TRB) break block27;
                }
                if (routerMode == TargetRouterMode.TRB) {
                    throw new IllegalArgumentException("Argument destination may not be null in client mode.");
                }
            }
            catch (RuntimeException re) {
                message.returnMessageToPool();
                throw re;
            }
        }
        if (!this.opened) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
            }
            message.returnMessageToPool();
            this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
        }
        if (message.getMsgPool() != null) {
            if (message.getMsgPool() != this.pool) {
                throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.msgPassedInFromOtherSession"));
            }
            message.setReadOnly();
            if (message.getSendCount() > 0) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.cannotSendMoreThanOnce"));
                }
                message.returnMessageToPool();
                throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.cannotSendMoreThanOnce"));
            }
        } else {
            message.resetSendCount();
            message.setSendAttemptedOnce(false);
        }
        if (!this.hasStreamingCallback() && this._admgr.getPub_Ack_Window_Size() > 1) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.cannotPerformBlockingPublishIfWindowSizeSet"));
            }
            message.returnMessageToPool();
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.cannotPerformBlockingPublishIfWindowSizeSet"));
        }
        boolean isAdMessage = JCSMPUtils.isAdMessage(message);
        if (!isAdMessage && !this.directPermitted) {
            message.returnMessageToPool();
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.invalidMsgPassedInMustBeAd"));
        }
        message.checkHdrStoreInBinMeta();
        if (isAdMessage) {
            int totalMessageSize = message.getContentLength() + message.getAttachmentContentLength();
            int binaryMetaSize = message.getBinaryMetadataContentLength(0);
            if (binaryMetaSize > 0) {
                totalMessageSize += binaryMetaSize + 5;
            }
            if (this.maxAdBrokerSupportedMessageSize < totalMessageSize) {
                this.Trace.error(String.format("The message size (%s bytes) exceeds the maximum allowed size of a guaranteed message (%s bytes)", totalMessageSize, this.maxAdBrokerSupportedMessageSize));
                throw new IllegalArgumentException("The maximum large message size exceeded");
            }
        }
    }

    @Override
    public void send(XMLMessage message) throws JCSMPException {
        this.send(message, null);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        SolJmxSupport.instance().deregister(this);
    }

    public void sendImpl(JCSMPXMLMessage[] messages, int offset, int length, PubMsgInfo[] pubMsgInfos) throws JCSMPException {
        this.session.waitUntilSessionReconnectDone("sendImpl");
        this.waitOnSpinlockSendBlockedWithThrow();
        if (this.isTransacted()) {
            this.getTransactedSession().waitForActiveStateAfterInterruption();
            this.getTransactedSession().allowOperation(BaseTransactedSessionImpl.AllowedOperation.SEND);
        }
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("About to send message");
        }
        try {
            if (this.mPubLock != null) {
                this.mPubLock.lock();
            }
            Integer channelConnTag = ((TcpClientChannel)this.channel).getConnCounterTag();
            this.sendMsgOnce(messages, offset, length, true, true, true, true, channelConnTag, false, false, pubMsgInfos);
        }
        catch (JCSMPInterruptedException ex) {
            throw ex;
        }
        catch (JCSMPException e) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("MessageProducer::send() exception from sendMsgOnce(): " + e);
            }
            for (JCSMPXMLMessage jcsmpMsg : messages) {
                if (jcsmpMsg == null) continue;
                jcsmpMsg.returnMessageToPool();
            }
            if (!(e instanceof JCSMPErrorResponseException)) {
                this.closeImpl(e);
            }
            throw e;
        }
        finally {
            if (this.mPubLock != null) {
                this.mPubLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sendMsgOnce(JCSMPXMLMessage[] messages, int offset, int length, boolean newMsgIdRequired, boolean newMsg, boolean notify, boolean allowBlock, Integer expectedChannelTag, boolean isLowPriorityData, boolean allowStateSub, PubMsgInfo[] pubMsgInfos) throws JCSMPException {
        if (!this.hasStreamingCallback()) {
            this.waitLock.clearBlockingException();
        }
        if ((isAdMsg = JCSMPUtils.isAdMessage(messages[offset])) && length > 1) {
            throw new AssertionError((Object)"Attempted sendMsgOnce() with a vector of AD.");
        }
        for (i = offset; i < offset + length; ++i) {
            jcsmpMsgOrig = jcsmpMsg = messages[i];
            p2pinbox = (Topic)this.session.getProperty("p2pinbox_in_use");
            jcsmpMsg.setNewMsgIdRequired(newMsgIdRequired);
            jcsmpMsg.setInternalP2pTopicDescriptionBase(p2pinbox.getName());
            if (newMsgIdRequired && (this.isTransacted() && !this.getTransactedSession().isTransportAckExpected() || !isAdMsg)) {
                this._admgr.setMessageIdParamsOnPubMessage(jcsmpMsg);
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug(String.format("Set message ID: " + jcsmpMsg.toString(), new Object[0]));
                }
            }
            if (isAdMsg) {
                if (this._admgr.getPub_Ack_Window_Size() == 0) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.cannotSendAssuredMessageNotEnabled"));
                    }
                    jcsmpMsg.returnMessageToPool();
                    throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.cannotSendAssuredMessageNotEnabled"));
                }
                if (!this.session.getSessionStats().hasPublishedAD()) {
                    this.session.getSessionStats().setPublishedAD(true);
                }
                if (newMsgIdRequired) {
                    try {
                        if (jcsmpMsg.getMsgPool() == null) {
                            if (pubMsgInfos == null || pubMsgInfos[i].getLgmMsgId() == null) {
                                jcsmpMsg = new JCSMPGenericXMLMessage((JCSMPGenericXMLMessage)jcsmpMsg, this._bufCloningPool);
                                if (pubMsgInfos != null && pubMsgInfos[i].getLgmMsgId() == null && this.transactedSession == null) {
                                    jcsmpMsg.setCorrelationKey(pubMsgInfos[i]);
                                }
                            }
                            messages[i] = jcsmpMsg;
                        } else if (pubMsgInfos != null && pubMsgInfos[i].getLgmMsgId() == null && this.transactedSession == null) {
                            jcsmpMsg.setCorrelationKey(pubMsgInfos[i]);
                        }
                        jcsmpMsg.set_ad_release_expect(2);
                        if (this.isTransacted() && this.getTransactedSession().isTransportAckExpected() || !this.isTransacted()) {
                            try {
                                if (this.transactedSession != null && !this.getTransactedSession().getExpectsAcks()) {
                                    jcsmpMsg.setTransacted(true);
                                }
                                this.updateAdMsgIDandEnqueueToWindow(jcsmpMsg);
                                if (pubMsgInfos != null) {
                                    pubMsgInfos[i].setMsgId(jcsmpMsg.getMessageIdLong());
                                }
                                jcsmpMsgOrig.setMessageIdLong(jcsmpMsg.getMessageIdLong());
                            }
                            catch (JCSMPInterruptedException e) {
                                this.Trace.warn("Message enqueue interrupted: " + jcsmpMsg.toString() + "; queue size: " + this._admgr.getQueueUsedSize() + "; lastMessageIdSent: " + this._admgr.getLastMessageIdSent() + "; lastMessageIdAcked: " + this._admgr.getLastMessageIdAcked());
                                jcsmpMsg.returnMessageToPool();
                                throw e;
                            }
                        }
                        if (this.transactedSession == null || this.transactedSession.getExpectsAcks()) ** GOTO lbl73
                        this.transactedSession.addOutputStep(this, jcsmpMsg);
                    }
                    catch (InvalidOperationException e) {
                        jcsmpMsg.returnMessageToPool();
                        throw e;
                    }
                } else if (!this.checkADMsgResendAllowed(jcsmpMsg)) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug(String.format("Ack is already received for message %s, no need to resend", new Object[]{jcsmpMsg.getMessageId()}));
                    }
                    if (this._admgr.ack_Event_Mode.equals("SUPPORTED_ACK_EVENT_MODE_WINDOWED")) {
                        if (jcsmpMsg.getMessageIdLong() == this._admgr.getLastMessageIdAcked()) {
                            this._admgr.processWindowedAck(jcsmpMsg.getMessageIdLong());
                        }
                    } else {
                        this._admgr.processWindowedAck(jcsmpMsg.getMessageIdLong());
                    }
                    var17_19 = this.waitLock;
                    synchronized (var17_19) {
                        this.waitLock.setRespReceived(true);
                        this.waitLock.notifyAll();
                    }
                    return;
                }
            }
lbl73:
            // 6 sources

            if (newMsg) {
                this.waitOnSpinlockSendBlockedWithThrow();
                if (isAdMsg && this._admgr.isAckImmediatelyRequired() && !jcsmpMsg.isAckImmediately()) {
                    jcsmpMsg.clearReadOnly();
                    jcsmpMsg.setAckImmediately(true);
                }
            }
            if (!this.opened) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
                }
                jcsmpMsg.returnMessageToPool();
                this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
            }
            if (this.hasStreamingCallback()) continue;
            var17_19 = this.waitLock;
            synchronized (var17_19) {
                this.waitLock.setRespReceived(false);
                continue;
            }
        }
        retval = 0;
        do {
            try {
                retval = this.channel.send(messages, offset, length, newMsg, this, allowBlock, expectedChannelTag, isLowPriorityData, allowStateSub);
            }
            catch (JCSMPException e) {
                if (isAdMsg) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug("skip the exception after the message is enqueued for retransmit: " + e.getMessage() + ": " + messages[offset].toString() + "; queue size: " + this._admgr.getQueueUsedSize() + "; lastMessageIdSent: " + this._admgr.getLastMessageIdSent() + "; lastMessageIdAcked: " + this._admgr.getLastMessageIdAcked());
                    }
                    this._admgr.startADTimer();
                }
                throw e;
            }
            if (!newMsg && retval == 1) {
                throw new JCSMPTransportException("Connection failure during AD retransmission, abort + retry AD retransmission.");
            }
            if (retval != 1) continue;
            expectedChannelTag = ((TcpClientChannel)this.channel).getConnCounterTag();
        } while (retval != 0);
        if (isAdMsg && newMsgIdRequired) {
            messages[offset].callout_ad_release_opportunity();
        }
        if (!this.hasStreamingCallback() && notify) {
            var14_14 = this.waitLock;
            synchronized (var14_14) {
                if (this.waitLock.isRespReceived()) {
                    this.waitLock.setRespReceived(false);
                } else {
                    try {
                        this.waitLock.wait(this.readTimeout);
                        if (this.waitLock.isRespReceived()) {
                            this.waitLock.setRespReceived(false);
                            if (this.waitLock.getBlockingException() == null) {
                                messages[offset].returnMessageToPool();
                            }
                        } else {
                            this.waitLock.setBlockingException(new JCSMPTransportException("Read timeout occurred while waiting for response"));
                        }
                    }
                    catch (InterruptedException e) {
                        this.Trace.warn("interrupted exception", e);
                        throw new JCSMPInterruptedException("Interrupted", e);
                    }
                }
                blockingEx = this.waitLock.getBlockingException();
                if (blockingEx != null) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug("Blocking publish received exception for message " + messages[offset].getMessageId());
                    }
                    this.checkErrorResponseForNoCug(blockingEx);
                    throw blockingEx;
                }
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("Blocking publish received response for message " + messages[offset].getMessageId());
                }
            }
        }
    }

    private boolean checkADMsgResendAllowed(JCSMPXMLMessage message) {
        if (message.getMessageId() == null) {
            return true;
        }
        long msgId = message.getMessageIdLong();
        return msgId > this._admgr.getLastMessageIdAcked();
    }

    private void updateAdMsgIDandEnqueueToWindow(JCSMPXMLMessage message) throws JCSMPException {
        PubADManager admgr = this._admgr;
        if (admgr.isQueueFull()) {
            this.sessionStats.incStat(StatType.PUBLISHER_WINDOW_CLOSED);
        }
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("adding AD message to the queue: " + message);
        }
        admgr.enqueueMsgWithIdUpdateWithThrows(message);
    }

    private boolean getAndProcessResponse(WireMessage respMsg) throws JCSMPException, InterruptedException {
        if (respMsg == null) {
            return true;
        }
        SMFHeaderBean smfHeader = respMsg.getSmfHeader();
        if (smfHeader.getProtocol() != 3 && smfHeader.getProtocol() != 13 && smfHeader.getProtocol() != 9 && smfHeader.getProtocol() != 19) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Expect PUBMSG|TRMSG protocol, but get " + smfHeader.toString());
            }
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedPubMsgResponse"));
        }
        JCSMPErrorResponseException errorResponse = null;
        if (smfHeader.getPm_respcode() == -1) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Expect PUBMSG response, but get " + smfHeader.toString());
            }
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedResponseFailedToFindResponseParam"));
        }
        long respCode = smfHeader.getPm_respcode();
        if (respCode != 200L) {
            String respString = smfHeader.getPm_respstr();
            if (smfHeader.getPm_tr_topicname_bytes() != null) {
                respString = respString + " - Topic '" + new String(smfHeader.getPm_tr_topicname_bytes(), Charset.forName("UTF-8")) + "'";
            }
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info("Error Response (" + respCode + ") - " + respString);
            }
            errorResponse = new JCSMPErrorResponseException((int)respCode, respString, "", this.channel instanceof TcpClientChannel ? ((TcpClientChannel)this.channel).getNetworkInfoString() : "", JCSMPErrorResponseSubcodeMapper.ErrorContext.DATA);
            this.sessionStats.incStat(StatType.MESSAGES_REJECTED_BY_APPLIANCE);
        }
        if (smfHeader.getPm_ad_msgid() != -1L) {
            boolean isRollbackOnly = false;
            if (this.isTransacted()) {
                boolean bl = isRollbackOnly = this.getTransactedSession().isMarkedAsRollback() || this.getTransactedSession().isRollbackOnlySet(this);
            }
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(String.format("Got response for AD msg=%s, retransmitRequired=%s, isRollbackOnly=%s", smfHeader.getPm_ad_msgid(), smfHeader.getRetransmitRequired(), isRollbackOnly));
            }
            return this._admgr.handleClientAck(smfHeader.getPm_ad_msgid(), errorResponse, smfHeader.getRetransmitRequired(), isRollbackOnly);
        }
        long msgID = -1L;
        if (this.hasStreamingCallback()) {
            if (!this.opened) {
                return true;
            }
            msgID = 0L;
        }
        return this.handleAckDirect(msgID, errorResponse);
    }

    protected void checkErrorResponseForNoCug(Exception err) {
        if (err instanceof JCSMPErrorResponseException && ((JCSMPErrorResponseException)err).getSubcodeEx() == 38) {
            this.Trace.error("Closing JCSMPXMLMessageProducer (No Valid Closed User Group).");
            this.close();
        }
    }

    private void throwClosedException(String message) throws InvalidOperationException {
        if (this.lastException != null) {
            throw new StaleSessionException(message, this.lastException);
        }
        throw new ClosedFacilityException(message);
    }

    private void checkClosed(String message) throws InvalidOperationException {
        if (!this.opened) {
            this.throwClosedException(message);
        }
    }

    public long getLastMsgIdSent() {
        return this._admgr.getLastMessageIdSent();
    }

    public boolean handleCommitResponse(long msgID, JCSMPErrorResponseException err) throws JCSMPException {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("Got response for AD msg=%s %s", msgID, err == null ? "" : "ex=" + err.getMessage()));
        }
        boolean acked = true;
        this._admgr.clearADTimer();
        this._admgr.setLastMessageIdAcked(msgID);
        if (err == null) {
            acked = this._admgr.processWindowedAck(msgID) > 0;
        } else {
            acked = this._admgr.transactedProcessWindowedAckError(msgID, err);
            this._admgr.setLastMessageIdSent(msgID);
        }
        if (!this._admgr.isQueueEmpty()) {
            this._admgr.startADTimer();
        }
        if (this.hasStreamingCallback()) {
            this.checkErrorResponseForNoCug(err);
        }
        return acked;
    }

    public void handlePostXaEndRequest(long lastMsgIdSend) throws JCSMPException {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("handlePostXaEndRequest: lastMsgIdSend=%s lastMsgIdAcked%s", this._admgr.getLastMessageIdSent(), this._admgr.getLastMessageIdAcked()));
        }
        this._admgr.clearADTimer();
        this._admgr.setLastMessageIdAcked(lastMsgIdSend);
        this._admgr.processWindowedAck(lastMsgIdSend);
    }

    private boolean handleAckDirect(long msgID, JCSMPErrorResponseException err) throws JCSMPException {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Got response for non-AD msg");
        }
        this.sessionStats.incStat(StatType.RELIABLE_MSGS_SENT_CONFIRMED);
        if (err == null) {
            if (this.hasStreamingCallback()) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug(String.format("Using streaming pub: responseReceived id=%s", msgID));
                }
                assert (msgID != -1L);
                ProducerResponseNotification notif = new ProducerResponseNotification(this.streamCallback, this);
                notif.addMsgInfo(new MsgIdInfo(msgID, null));
                this.getProducerNotifDsp().enqueueNotification(notif);
            } else {
                assert (msgID == -1L);
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("Using blocking pub: success");
                }
            }
        } else if (this.hasStreamingCallback()) {
            assert (msgID != -1L);
            this.getProducerNotifDsp().enqueueNotification(new ProducerErrorNotification(this.streamCallback, new MsgIdInfo(msgID, null), err, System.currentTimeMillis(), this, true));
            this.checkErrorResponseForNoCug(err);
        } else {
            assert (msgID == -1L);
            throw err;
        }
        return true;
    }

    public synchronized void suspend() {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Suspending producer");
        }
        this.sendBlockedTickets.incrementAndGet();
        this.sendBlocked = true;
        this.channel.suspend();
        this._admgr.suspendMsgQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume(int tickets) {
        int tickets_post_decr = 0;
        while (tickets-- > 0) {
            tickets_post_decr = this.sendBlockedTickets.decrementAndGet();
        }
        if (tickets_post_decr <= 0) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Resuming producer");
            }
            this.sendBlocked = false;
            this.channel.resume();
            Object object = this.sendWaitLock;
            synchronized (object) {
                this.sendWaitLock.notifyAll();
            }
            this._admgr.resumeMsgQueue();
            this.sendBlockedTickets.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume() {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Resuming producer");
        }
        this.sendBlocked = false;
        this.channel.resume();
        Object object = this.sendWaitLock;
        synchronized (object) {
            this.sendWaitLock.notifyAll();
        }
        this._admgr.resumeMsgQueue();
        this.sendBlockedTickets.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnSpinlockSendBlockedWithThrow() throws JCSMPInterruptedException {
        while (this.sendBlocked) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Producer is in suspended for new message, wait...");
            }
            Object object = this.sendWaitLock;
            synchronized (object) {
                try {
                    this.sendWaitLock.wait(3000L);
                }
                catch (InterruptedException e) {
                    throw new JCSMPInterruptedException("Interrupted", e);
                }
            }
        }
    }

    public void waitOnSpinlockSendBlocked() {
        try {
            this.waitOnSpinlockSendBlockedWithThrow();
        }
        catch (JCSMPInterruptedException jCSMPInterruptedException) {
            // empty catch block
        }
    }

    public void scheduleRetransmitTask(long lastIdSent, int remainingWindow) {
        ExecutorService retransmit_service = this.context.getRetransmitService();
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("scheduleRetransmitTask: lastIdSend " + lastIdSent + " window=" + remainingWindow);
        }
        Callable<Object> retransmit_task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JCSMPXMLMessageProducer.this.handleRetransmitAdMsgsRequest();
                return null;
            }
        };
        this.addResendTask(retransmit_service.submit(retransmit_task));
        this.cleanUpResendTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleRetransmitAdMsgsRequest() {
        JCSMPXMLMessage msg = null;
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("handleRetransmitAdMsgsRequest");
        }
        boolean msgSent = false;
        try {
            while ((msg = this._admgr.getNextADMsgForRetransmit()) != null) {
                msgSent = true;
                long curTstamp = System.currentTimeMillis();
                msg.setSafeToRetransmit(true);
                msg.setSafeToRetransmitTstamp(curTstamp);
                try {
                    this.doRetransmitAdMsgs(msg);
                    this._admgr.setLastIdSent(msg.getMessageIdLong());
                }
                finally {
                    msg.setRetransmitting(false);
                    if (!msg.isSafeToRelease()) continue;
                    msg.callout_ad_release_opportunity();
                }
            }
            return;
        }
        catch (Throwable e) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("handleRetransmitAdMsgsRequest exception", e);
            }
            this._admgr.startADTimer();
            return;
        }
        finally {
            if (msg != null) {
                msg.setRetransmitting(false);
                if (msg.isSafeToRelease()) {
                    msg.callout_ad_release_opportunity();
                }
            }
            if (!msgSent) {
                try {
                    this._admgr.handleRetransmitDone();
                }
                catch (JCSMPException e) {
                    if (this.Trace.isErrorEnabled()) {
                        this.Trace.error("handleRetransmitDone exception", e);
                    }
                    this._admgr.startADTimer();
                }
            }
        }
    }

    private void doRetransmitAdMsgs(JCSMPXMLMessage msg) throws JCSMPException {
        this._admgr.clearADTimer();
        Integer channelTag = ((TcpClientChannel)this.channel).getConnCounterTag();
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("Resend message: " + msg.toString(), new Object[0]));
        }
        this.sendMsgOnce(new JCSMPXMLMessage[]{msg}, 0, 1, false, false, false, true, channelTag, false, false, null);
    }

    @Override
    public JCSMPStreamingPublishEventHandler getStreamingCallbackHandler() throws JCSMPException {
        if (!this.opened && !this.reconnectFailed) {
            this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
        }
        return this.getStreamingCallbackHandlerInternal();
    }

    public JCSMPStreamingPublishEventHandler getStreamingCallbackHandlerInternal() {
        if (this.hasStreamingCallback()) {
            return this.streamCallback;
        }
        return null;
    }

    public BaseTransactedSessionImpl getTransactedSession() {
        return this.transactedSession;
    }

    public boolean isTransacted() {
        return this.getTransactedSession() != null;
    }

    @Override
    public void setStreamingCallbackHandler(JCSMPStreamingPublishEventHandler callback) throws JCSMPException {
    }

    public JCSMPSessionStats getSessionStats() {
        return this.sessionStats;
    }

    @Override
    public TextXMLMessage createTextXMLMessage() throws JCSMPException {
        this.contextOpCheck.check();
        if (!this.opened) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Try to acquire a message on a closed producer");
            }
            this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
        }
        JCSMPGenericXMLMessage textMessage = this.pool.getGenericMessageThrows();
        Topic p2pinbox = (Topic)this.session.getProperty("p2pinbox_in_use");
        textMessage.reset(true);
        textMessage.setDeliveryMode(this.channel.getDefaultDeliveryMode());
        textMessage.setInternalProducerId(this._producerId);
        textMessage.setInternalP2pTopicDescriptionBase(p2pinbox.getName());
        return textMessage;
    }

    @Override
    public TextXMLMessage createTextXMLMessage(String text) throws JCSMPException {
        this.contextOpCheck.check();
        if (!this.opened) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Try to acquire a message on a closed producer");
            }
            this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
        }
        JCSMPGenericXMLMessage textMessage = this.pool.getGenericMessageThrows();
        Topic p2pinbox = (Topic)this.session.getProperty("p2pinbox_in_use");
        textMessage.reset(true);
        textMessage.setDeliveryMode(this.channel.getDefaultDeliveryMode());
        textMessage.setText(text);
        textMessage.setInternalProducerId(this._producerId);
        textMessage.setInternalP2pTopicDescriptionBase(p2pinbox.getName());
        return textMessage;
    }

    @Override
    public BytesXMLMessage createBytesXMLMessage() throws JCSMPException {
        this.contextOpCheck.check();
        if (!this.opened) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Try to acquire a message on a closed producer");
            }
            this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
        }
        JCSMPGenericXMLMessage bytesMessage = this.pool.getGenericMessageThrows();
        Topic p2pinbox = (Topic)this.session.getProperty("p2pinbox_in_use");
        bytesMessage.reset(true);
        bytesMessage.setDeliveryMode(this.channel.getDefaultDeliveryMode());
        bytesMessage.setInternalProducerId(this._producerId);
        bytesMessage.setInternalP2pTopicDescriptionBase(p2pinbox.getName());
        return bytesMessage;
    }

    @Override
    public BytesXMLMessage createBytesXMLMessage(byte[] value) throws JCSMPException {
        this.contextOpCheck.check();
        if (!this.opened) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Try to acquire a message on a closed producer");
            }
            this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
        }
        JCSMPGenericXMLMessage bytesMessage = this.pool.getGenericMessageThrows();
        Topic p2pinbox = (Topic)this.session.getProperty("p2pinbox_in_use");
        bytesMessage.reset(true);
        bytesMessage.setDeliveryMode(this.channel.getDefaultDeliveryMode());
        bytesMessage.writeBytes(value);
        bytesMessage.setInternalProducerId(this._producerId);
        bytesMessage.setInternalP2pTopicDescriptionBase(p2pinbox.getName());
        return bytesMessage;
    }

    @Override
    public StreamXMLMessage createStreamXMLMessage() throws JCSMPException {
        this.contextOpCheck.check();
        if (!this.opened) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Try to acquire a message on a closed producer");
            }
            this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
        }
        JCSMPGenericXMLMessage streamMessage = this.pool.getGenericMessageThrows();
        Topic p2pinbox = (Topic)this.session.getProperty("p2pinbox_in_use");
        streamMessage.reset(true);
        streamMessage.setDeliveryMode(this.channel.getDefaultDeliveryMode());
        streamMessage.setInternalProducerId(this._producerId);
        streamMessage.setInternalP2pTopicDescriptionBase(p2pinbox.getName());
        return streamMessage;
    }

    @Override
    public StreamXMLMessage createStreamXMLMessage(InputStream stream) throws IOException, JCSMPException {
        this.contextOpCheck.check();
        if (!this.opened) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Try to acquire a message on a closed producer");
            }
            this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageProducer.triedToPerformOpOnClosedMsgProducer"));
        }
        JCSMPGenericXMLMessage streamMessage = this.pool.getGenericMessageThrows();
        Topic p2pinbox = (Topic)this.session.getProperty("p2pinbox_in_use");
        streamMessage.reset(true);
        streamMessage.setDeliveryMode(this.channel.getDefaultDeliveryMode());
        streamMessage.setStream(stream);
        streamMessage.setInternalProducerId(this._producerId);
        streamMessage.setInternalP2pTopicDescriptionBase(p2pinbox.getName());
        return streamMessage;
    }

    @Override
    public SDTMap createMap() {
        return new MapImpl();
    }

    @Override
    public SDTStream createStream() {
        return new StreamImpl();
    }

    @Override
    public BytesMessage createBytesMessage() throws JCSMPException {
        return new BytesMessageImpl(this.createBytesXMLMessage());
    }

    @Override
    public XMLContentMessage createXMLContentMessage() throws JCSMPException {
        return new XMLContentMessageImpl(this.createBytesXMLMessage());
    }

    @Override
    public MapMessage createMapMessage() throws JCSMPException {
        return new MapMessageImpl(this.createBytesXMLMessage());
    }

    @Override
    public StreamMessage createStreamMessage() throws JCSMPException {
        return new StreamMessageImpl(this.createBytesXMLMessage());
    }

    @Override
    public TextMessage createTextMessage() throws JCSMPException {
        return new TextMessageImpl(this.createBytesXMLMessage());
    }

    @Override
    public void buildDispatchProducerList(List<JCSMPXMLMessageProducer> toNotify) {
    }

    @Override
    public void handleException(MsgIdInfo msgId, JCSMPException e, long producerId, boolean forceNotifyIfClosed, List<JCSMPXMLMessageProducer> toNotify) {
        this.handleException(msgId, e, producerId, forceNotifyIfClosed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(MsgIdInfo msgInfo, JCSMPException e, long producerId, boolean forceNotifyIfClosed) {
        if ((msgInfo == null || msgInfo.getMsgId() == null) && e instanceof JCSMPTransportException) {
            this.Trace.info("[" + this.sessionId + "] Transport exception occurred when message Id is not available", e);
        }
        this.lastException = e;
        if (!this.hasStreamingCallback()) {
            this.close(e);
            WaitLock waitLock = this.waitLock;
            synchronized (waitLock) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("Notify blocking publisher about exception");
                }
                this.waitLock.setRespReceived(true);
                this.waitLock.setBlockingException(e);
                this.waitLock.notifyAll();
            }
        } else {
            JCSMPException ex = e;
            JCSMPStreamingPublishEventHandler existingHandler = this.streamCallback;
            this.close(e);
            if (ex != null) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("notify stream publisher about exception");
                }
                this.getProducerNotifDsp().enqueueNotification(new ProducerErrorNotification(existingHandler, msgInfo, ex, System.currentTimeMillis(), this, true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePubMsgResponse(WireMessage resp) {
        boolean acked = true;
        JCSMPException responseEx = null;
        try {
            acked = this.getAndProcessResponse(resp);
        }
        catch (JCSMPException e) {
            if (!this.hasStreamingCallback()) {
                responseEx = e;
            } else {
                this.Trace.error("[" + this.sessionId + "] Unrecoverable exception occurred during streaming publish", e);
            }
        }
        catch (InterruptedException e) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Thread interupted", e);
            }
        }
        finally {
            if (!this.hasStreamingCallback()) {
                WaitLock e = this.waitLock;
                synchronized (e) {
                    this.waitLock.setBlockingException(responseEx);
                    if (acked) {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug("Notify blocking publisher");
                        }
                        this.waitLock.setRespReceived(true);
                        this.waitLock.notifyAll();
                    }
                }
            }
        }
    }

    @Override
    public void handleAsyncCloseFlow(WireMessage message) {
        SMFHeaderBean smfHdr = message.getSmfHeader();
        int respCode = smfHdr.getPm_respcode();
        String respPhrase = smfHdr.getPm_respstr();
        JCSMPTransportException ex = new JCSMPTransportException(String.format("Received unsolicited CloseFlow for producer (%s:%s).", respCode, respPhrase));
        if (this.isTransacted()) {
            this.getTransactedSession().setRollbackOnly(this);
            this.clearMessageQueue();
        }
        this.handleException(new MsgIdInfo(null, null), ex, 0L, false);
    }

    public void clearMessageQueue() {
        block2: {
            this._admgr.clearMessageQueue(false);
            try {
                this._admgr.handleRetransmitDone();
            }
            catch (JCSMPException e) {
                if (!this.Trace.isDebugEnabled()) break block2;
                this.Trace.debug("got exception: ", e);
            }
        }
    }

    @Override
    public void notifyReconnected() {
    }

    @Override
    public void notifyPreReconnect() {
        this._admgr.handlePreReconnect();
    }

    public void notifyPubFlowResumed() {
        block2: {
            try {
                this._admgr.handlePubFlowResumed();
            }
            catch (JCSMPException e) {
                if (!this.Trace.isDebugEnabled()) break block2;
                this.Trace.debug("got exception: ", e);
            }
        }
    }

    @Override
    public void handlePubMsgSent(JCSMPXMLMessage xmlMsg, JCSMPXMLMessageProducer prod) {
        if (JCSMPUtils.isAdMessage(xmlMsg)) {
            if (this.isTransacted()) {
                if (this.getTransactedSession().isTransportAckExpected()) {
                    this._admgr.startADTimer();
                } else if (!this.getTransactedSession().isXA()) {
                    xmlMsg.returnMessageToPool();
                }
            } else {
                this._admgr.startADTimer();
            }
        } else if (this.hasStreamingCallback()) {
            xmlMsg.returnMessageToPool();
        }
    }

    private void purgeNotifications(JCSMPStreamingPublishEventHandler handler) {
        if (handler == null) {
            return;
        }
        ArrayList<Notification> removed = new ArrayList<Notification>();
        this.getProducerNotifDsp().purgeNotifications(handler, removed);
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("Purged %s publish message responses", removed.size()));
        }
    }

    private void returnMessagesToPool(List<JCSMPXMLMessage> msgs) {
        if (msgs == null) {
            return;
        }
        Iterator<JCSMPXMLMessage> it = msgs.iterator();
        while (it.hasNext()) {
            it.next().returnMessageToPool();
        }
    }

    private ProducerNotificationDispatcher getProducerNotifDsp() {
        if (this.prdNotifDsp == null) {
            this.prdNotifDsp = this.context.getProducerDispatcher();
        }
        return this.prdNotifDsp;
    }

    private final JCSMPXMLMessage unwrapMessage(XMLMessage msg) {
        if (msg instanceof BytesXMLMessageWrapper) {
            return (JCSMPXMLMessage)((Object)((BytesXMLMessageWrapper)((Object)msg)).getWrappedMessage());
        }
        if (msg instanceof EventMessage) {
            throw new UnsupportedOperationException("Unsupported Operation on an EventMessage");
        }
        return (JCSMPXMLMessage)msg;
    }

    public boolean isDirectPermitted() {
        return this.directPermitted;
    }

    public void setDirectPermitted(boolean directPermitted) {
        this.directPermitted = directPermitted;
    }

    public String getDbgFlowName() {
        return this._admgr.flow_Name.substring(0, 8);
    }

    @Override
    public void handleError(String messageID, JCSMPException cause, long timestamp) {
    }

    @Override
    public void responseReceived(String messageID) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseReceivedEx(Object key) {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Intercept response received for " + key);
        }
        if (key instanceof PubMsgInfo) {
            PubMsgInfo msgInfo = (PubMsgInfo)key;
            ControlPubMsgInfo notifyMsgInfo = null;
            Object object = this.pubMsgInfoLock;
            synchronized (object) {
                Iterator it = this.pubMsgInfoList.iterator();
                while (it.hasNext()) {
                    ControlPubMsgInfo outstandingMsgInfo = (ControlPubMsgInfo)it.next();
                    if (outstandingMsgInfo.getMsgId() == msgInfo.getMsgId()) {
                        it.remove();
                        notifyMsgInfo = outstandingMsgInfo;
                        break;
                    }
                    if (outstandingMsgInfo.getMsgId() == -1L || outstandingMsgInfo.getMsgId() >= msgInfo.getMsgId()) break;
                    it.remove();
                }
            }
            if (notifyMsgInfo != null && this.appStreamCallback != null) {
                if (notifyMsgInfo.getFirstEx() == null) {
                    if (this.appStreamCallback instanceof JCSMPStreamingPublishCorrelatingEventHandler) {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug(String.format("Notify pub response received for msgId=%s, correlationKey=%s", msgInfo.getMsgId(), msgInfo.getCorrelationKey()));
                        }
                        ((JCSMPStreamingPublishCorrelatingEventHandler)this.appStreamCallback).responseReceivedEx(msgInfo.getCorrelationKey());
                    } else {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug(String.format("Notify pub response received for msgId=%s", msgInfo.getMsgId()));
                        }
                        this.appStreamCallback.responseReceived(msgInfo.getMsgId() + "");
                    }
                } else {
                    long timestamp = System.currentTimeMillis();
                    if (this.appStreamCallback instanceof JCSMPStreamingPublishCorrelatingEventHandler) {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug(String.format("Notify pub exception received for msgId=%s, correlationKey=%s, timestamp=%s, ex=%s", msgInfo == null ? null : Long.valueOf(msgInfo.getMsgId()), msgInfo == null ? null : msgInfo.getCorrelationKey(), timestamp, notifyMsgInfo.getFirstEx()));
                        }
                        ((JCSMPStreamingPublishCorrelatingEventHandler)this.appStreamCallback).handleErrorEx(msgInfo == null ? null : msgInfo.getCorrelationKey(), notifyMsgInfo.getFirstEx(), timestamp);
                    } else {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug(String.format("Notify pub exception received for msgId=%s, timestamp=%s, ex=%s", msgInfo == null ? 0L : msgInfo.getMsgId(), timestamp, notifyMsgInfo.getFirstEx()));
                        }
                        this.appStreamCallback.handleError(msgInfo == null ? "0" : msgInfo.getMsgId() + "", notifyMsgInfo.getFirstEx(), timestamp);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleErrorEx(Object key, JCSMPException cause, long timestamp) {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("Intercept exception received for %s, timestamp=%s, ex=%s", key, timestamp, cause));
        }
        if (key != null) {
            PubMsgInfo msgInfo = (PubMsgInfo)key;
            ControlPubMsgInfo failedControlMsgInfo = null;
            Object object = this.pubMsgInfoLock;
            synchronized (object) {
                Iterator it = this.pubMsgInfoList.iterator();
                while (it.hasNext()) {
                    ControlPubMsgInfo outstandingMsgInfo = (ControlPubMsgInfo)it.next();
                    if (outstandingMsgInfo.getMsgId() != -1L && outstandingMsgInfo.getMsgId() < msgInfo.getMsgId()) {
                        it.remove();
                        continue;
                    }
                    if (outstandingMsgInfo.getMsgId() == msgInfo.getMsgId()) {
                        if (msgInfo.getLgmMsgId() != null && msgInfo.getLgmMsgId().equals(outstandingMsgInfo.getLgmMsgId())) {
                            outstandingMsgInfo.addFailedReason(msgInfo.getMsgId() + "", cause);
                            failedControlMsgInfo = outstandingMsgInfo;
                        }
                        it.remove();
                        break;
                    }
                    if (msgInfo.getLgmMsgId() == null || !msgInfo.getLgmMsgId().equals(outstandingMsgInfo.getLgmMsgId())) break;
                    outstandingMsgInfo.addFailedReason(msgInfo.getMsgId() + "", cause);
                    return;
                }
            }
            if (this.appStreamCallback != null) {
                if (failedControlMsgInfo != null) {
                    cause = failedControlMsgInfo.getFirstEx();
                    cause.setExtraInfo(failedControlMsgInfo.getExtraExInfo().toString());
                }
                if (this.appStreamCallback instanceof JCSMPStreamingPublishCorrelatingEventHandler) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug(String.format("Notify pub exception received for msgId=%s, correlationKey=%s, timestamp=%s, ex=%s", msgInfo == null ? null : Long.valueOf(msgInfo.getMsgId()), msgInfo == null ? null : msgInfo.getCorrelationKey(), timestamp, cause));
                    }
                    ((JCSMPStreamingPublishCorrelatingEventHandler)this.appStreamCallback).handleErrorEx(msgInfo == null ? null : msgInfo.getCorrelationKey(), cause, timestamp);
                } else {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug(String.format("Notify pub exception received for msgId=%s, timestamp=%s, ex=%s", msgInfo == null ? 0L : msgInfo.getMsgId(), timestamp, cause));
                    }
                    this.appStreamCallback.handleError(msgInfo == null ? "0" : msgInfo.getMsgId() + "", cause, timestamp);
                }
            }
        } else if (this.appStreamCallback != null) {
            if (this.appStreamCallback instanceof JCSMPStreamingPublishCorrelatingEventHandler) {
                ((JCSMPStreamingPublishCorrelatingEventHandler)this.appStreamCallback).handleErrorEx(key, cause, timestamp);
            } else {
                this.appStreamCallback.handleError("0", cause, timestamp);
            }
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int prior) {
        if (prior < 0 || prior > 255) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.invalidPriority"));
        }
        this.priority = prior;
    }

    private static class ControlPubMsgInfo
    extends PubMsgInfo {
        private JCSMPException firstEx;
        private StringBuilder extraExInfo = new StringBuilder("Error occurred while sending message: ");

        public ControlPubMsgInfo(String uuid) {
            super(uuid);
        }

        public void addFailedReason(String msgId, JCSMPException e) {
            if (this.firstEx == null) {
                this.firstEx = e;
            }
            this.extraExInfo.append("[msgId ").append(msgId).append(" - ").append(e.getMessage()).append("];");
        }

        public JCSMPException getFirstEx() {
            return this.firstEx;
        }

        public StringBuilder getExtraExInfo() {
            return this.extraExInfo;
        }
    }

    private static class PubMsgInfo {
        private String lgmMsgId;
        private long msgId = -1L;
        private Object correlationKey;
        private int segId;
        private int numSegments;

        public PubMsgInfo(String uuid) {
            this.lgmMsgId = uuid;
        }

        public String getLgmMsgId() {
            return this.lgmMsgId;
        }

        public long getMsgId() {
            return this.msgId;
        }

        public int getSegId() {
            return this.segId;
        }

        public void setSegId(int segId) {
            this.segId = segId;
        }

        public void setMsgId(long msgId) {
            this.msgId = msgId;
        }

        public Object getCorrelationKey() {
            return this.correlationKey;
        }

        public void setCorrelationKey(Object correlationKey) {
            this.correlationKey = correlationKey;
        }

        public int getNumSegments() {
            return this.numSegments;
        }

        public void setNumSegments(int numSegments) {
            this.numSegments = numSegments;
        }

        public String toString() {
            String str = String.format("msgId=%s, lgmMsgId=%s, segId=%s, numSegments=%s", this.getMsgId(), this.getLgmMsgId(), this.getSegId(), this.getNumSegments());
            return str;
        }
    }

    private static class WaitLock {
        private boolean respReceived = false;
        private ArrayBlockingQueue<JCSMPException> blockingEx = new ArrayBlockingQueue(1);

        private WaitLock() {
        }

        public boolean isRespReceived() {
            return this.respReceived;
        }

        public void setRespReceived(boolean respReceived) {
            this.respReceived = respReceived;
        }

        public JCSMPException getBlockingException() {
            return this.blockingEx.peek();
        }

        public void setBlockingException(JCSMPException blockingException) {
            if (blockingException == null) {
                return;
            }
            if (!this.blockingEx.offer(blockingException)) {
                // empty if block
            }
        }

        public void clearBlockingException() {
            this.blockingEx.clear();
        }
    }
}

