/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solacesystems.common.HostInfo;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFatalErrorException;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.VersionNotSupportException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimer;
import com.solacesystems.jcsmp.protocol.CSMPChannel;
import com.solacesystems.jcsmp.protocol.JCSMPConstants;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.KeepaliveTimeoutHandler;
import com.solacesystems.jcsmp.protocol.impl.SmfUhUtil;
import com.solacesystems.jcsmp.protocol.nio.impl.SyncEventDispatcherReactor;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SimpleSmfClient;
import com.solacesystems.jcsmp.protocol.smf.SimpleSmfClientFactory;
import com.solacesystems.jcsmp.secure.SecureProperties;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TcpChannel
implements CSMPChannel,
JCSMPConstants {
    private static final Log Trace = LogFactory.getLog(TcpChannel.class);
    private final List<String> channels_no_compression = Arrays.asList("subscriber_data_channel", "publisher_data_channel", "control_channel");
    protected JCSMPChannelProperties properties;
    protected JCSMPProperties sessionProperties;
    protected String localIP;
    protected String clientUsername;
    protected SimpleSmfClient _smfClient;
    protected SimpleSmfClient _smfNonSecureClient;
    protected SimpleSmfClient _smfSecureClient;
    protected JCSMPSessionStats sessionStats;
    private long capabilities = 0L;
    private KeepaliveTimeoutHandler _kaHandler = null;
    private JCSMPTimer _kaTimerRef = null;
    private int _keepAlivesSent = 0;
    public ContextImpl _context = null;
    protected final List<HostInfo> _hostList;
    protected final int reconnectCount;
    protected final int attemptsPerHost;

    public TcpChannel(JCSMPProperties props, SecureProperties secureProps, String channel, JCSMPSessionStats stats, ContextImpl context) {
        this.sessionProperties = props;
        this.properties = (JCSMPChannelProperties)props.getProperty(channel);
        this._context = context;
        this.sessionStats = stats;
        this.reconnectCount = this.properties.getReconnectRetries() == -1 ? Integer.MAX_VALUE : this.properties.getReconnectRetries();
        this.attemptsPerHost = this.properties.getConnectRetriesPerHost();
        String routerHostString = props.getStringProperty("host");
        this._hostList = HostInfo.toHostInfoList(routerHostString);
        this.clientUsername = props.getStringProperty("username");
        this.localIP = props.getStringProperty("localhost");
        try {
            if (System.getenv("JCSMP_LOCALHOST") != null) {
                this.localIP = System.getenv("JCSMP_LOCALHOST");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setDefaultCapabilities();
        if (this.channels_no_compression.contains(channel)) {
            this.properties.setCompressionLevel(0);
        }
        this._smfSecureClient = null;
        this._smfNonSecureClient = null;
        for (int i = 0; i < this._hostList.size(); ++i) {
            if (this._hostList.get(i).isSecure() && this._smfSecureClient == null) {
                this._smfSecureClient = SimpleSmfClientFactory.constructAndInit(props, this.properties, secureProps, this._hostList.get(i), stats, context);
                continue;
            }
            if (this._hostList.get(i).isSecure() || this._smfNonSecureClient != null) continue;
            this._smfNonSecureClient = SimpleSmfClientFactory.constructAndInit(props, this.properties, secureProps, this._hostList.get(i), stats, context);
        }
        this._smfClient = this._hostList.get(0).isSecure() ? this._smfSecureClient : this._smfNonSecureClient;
        this._keepAlivesSent = 0;
        try {
            if (this.localIP != null && this.localIP.trim().length() > 0 && this._smfClient != null) {
                this._smfClient.setLocalAddress(InetAddress.getByName(this.localIP));
            }
        }
        catch (UnknownHostException e) {
            Trace.warn((Object)e);
        }
    }

    public int getRequestMaxRetries() {
        return Math.max(this.reconnectCount + 1, 1);
    }

    public SimpleSmfClient getSmfClient() {
        return this._smfClient;
    }

    public int getLocalPort() {
        return this._smfClient.getLocalPort();
    }

    public int getRemotePort() {
        return this._smfClient.getRemotePort();
    }

    public String getRemoteAddr() {
        return this._smfClient.getRemoteHost();
    }

    public String getNetworkInfoString() {
        String infoString = "";
        String clientName = this.sessionProperties.getStringProperty("client_name");
        infoString = infoString + "(Client name: ";
        infoString = clientName != null ? infoString + clientName : infoString + "no client name";
        infoString = infoString + "   ";
        if (this._smfClient != null) {
            infoString = infoString + this._smfClient.getNetworkInfoString();
        }
        return infoString + ") - ";
    }

    @Override
    public JCSMPChannelProperties getChannelProperties() {
        return this.properties;
    }

    protected WireMessage executePostOnce(WireMessage postMsg, boolean addAuth) throws JCSMPException {
        try {
            WireMessage response = new WireMessage();
            this._smfClient.doPost(postMsg, response, addAuth);
            postMsg.setSentFlag(true);
            SMFHeaderBean smfResponseHeader = response.getSmfHeader();
            int result = smfResponseHeader.getPm_respcode();
            String respText = smfResponseHeader.getPm_respstr();
            if (result == 200) {
                return response;
            }
            if (result == 501) {
                throw new VersionNotSupportException(this.getNetworkInfoString() + JCSMPRB.BUNDLE.getStringSafely("TcpChannel.routerVersionNotSupported"));
            }
            String strBody = "";
            byte[] body = response.getPayload();
            if (body != null && body.length > 0) {
                strBody = new String(body, Charset.forName("UTF-8"));
            }
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)(this.getNetworkInfoString() + "Error Response (" + result + ") - " + respText));
            }
            if (result == 400 && respText.equals("Unsupported SSL downgrade value")) {
                throw new JCSMPErrorResponseException(403, "Compressed SSL Is Not Supported", strBody, this.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            }
            throw new JCSMPErrorResponseException(result, respText, strBody, this.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
        }
        catch (JCSMPException e) {
            e.setExtraInfo(this.getNetworkInfoString());
            throw e;
        }
        catch (SocketTimeoutException e) {
            throw new JCSMPTransportException(this.getNetworkInfoString() + JCSMPRB.BUNDLE.getStringSafely("TcpChannel.timeoutWhenReadingResponseFromRouter"), e);
        }
        catch (SSLHandshakeException e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (!(t instanceof CertificateException)) continue;
                throw new JCSMPTransportException(t.getClass().getSimpleName() + " - " + t.getMessage(), t);
            }
            throw new JCSMPTransportException(this.getNetworkInfoString() + JCSMPRB.BUNDLE.getStringSafely("TcpChannel.errorCommWithRouter"), e);
        }
        catch (IOException e) {
            throw new JCSMPTransportException(this.getNetworkInfoString() + JCSMPRB.BUNDLE.getStringSafely("TcpChannel.errorCommWithRouter"), e);
        }
        catch (IllegalStateException e) {
            throw new JCSMPTransportException(this.getNetworkInfoString() + JCSMPRB.BUNDLE.getStringSafely("TcpChannel.errorCommWithRouter"), e);
        }
        catch (Exception e) {
            if (Trace.isErrorEnabled()) {
                Trace.error((Object)(this.getNetworkInfoString() + JCSMPRB.BUNDLE.getStringSafely("TcpChannel.unexpectedError")), (Throwable)e);
            }
            throw new JCSMPFatalErrorException(this.getNetworkInfoString() + JCSMPRB.BUNDLE.getStringSafely("TcpChannel.unexpectedError"), e);
        }
        catch (NoClassDefFoundError e) {
            if (Trace.isErrorEnabled()) {
                Trace.error((Object)(this.getNetworkInfoString() + JCSMPRB.BUNDLE.getStringSafely("TcpChannel.unexpectedError")), (Throwable)e);
            }
            throw new JCSMPFatalErrorException(this.getNetworkInfoString() + "Are Java 7 JCE Unlimited Strength Jurisdiction policy files being used with Java 6?", e);
        }
        catch (ExceptionInInitializerError e) {
            if (Trace.isErrorEnabled()) {
                Trace.error((Object)(this.getNetworkInfoString() + JCSMPRB.BUNDLE.getStringSafely("TcpChannel.unexpectedError")), (Throwable)e);
            }
            throw new JCSMPFatalErrorException(this.getNetworkInfoString() + "Are Java 6 JCE Unlimited Strength Jurisdiction policy files being used with Java 7?", e);
        }
        catch (Throwable t) {
            if (Trace.isErrorEnabled()) {
                Trace.error((Object)(this.getNetworkInfoString() + JCSMPRB.BUNDLE.getStringSafely("TcpChannel.unexpectedError")), t);
            }
            throw new JCSMPFatalErrorException(this.getNetworkInfoString() + JCSMPRB.BUNDLE.getStringSafely("TcpChannel.unexpectedError"), t);
        }
    }

    protected WireMessage validateUH(WireMessage msg) {
        return SmfUhUtil.validateUH(msg, this.sessionStats);
    }

    protected void startKATimer() {
        int interval = this.properties.getKeepAliveIntervalInMillis();
        if (this._kaHandler == null) {
            this._kaHandler = new KeepaliveTimeoutHandler(this, interval);
        }
        if (!(interval <= 0 || this._kaTimerRef != null && this._kaTimerRef.isActive())) {
            SyncEventDispatcherReactor tq = this._context.getIOReactor();
            this._kaTimerRef = tq.schedule_relative(interval, this._kaHandler);
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)("Scheduling KA timer in " + interval + "ms"));
            }
        }
    }

    protected void stopKATimer() {
        if (this._kaTimerRef != null) {
            SyncEventDispatcherReactor tq = this._context.getIOReactor();
            tq.cancelTimer(this._kaTimerRef);
        }
        this.resetKeepAlivesSent();
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Canceled KA timer");
        }
    }

    protected abstract KeepaliveWriteResult writeKAMessage(WireMessage var1) throws JCSMPException, IOException;

    @Override
    public void open() throws JCSMPException {
    }

    @Override
    public void close() {
        this.closeConnection();
    }

    protected void closeConnection() {
        if (this._smfClient != null) {
            try {
                this._smfClient.close();
            }
            catch (IOException e) {
                Trace.warn((Object)e);
            }
        }
    }

    @Override
    public boolean connected() {
        if (this._smfClient != null) {
            return this._smfClient.connected();
        }
        return false;
    }

    public String getLocalIPUsed() {
        return this.localIP;
    }

    protected boolean checkCapability(long capability) {
        return (this.capabilities & capability) != 0L;
    }

    protected void enableCapability(long capability) {
        this.capabilities |= capability;
    }

    protected void disableCapability(long capability) {
        this.capabilities &= capability ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private void setDefaultCapabilities() {
        this.enableCapability(4L);
        this.enableCapability(8L);
        this.enableCapability(1L);
        this.disableCapability(2L);
    }

    protected void resetKeepAlivesSent() {
        this._keepAlivesSent = 0;
    }

    protected void incKeepAlivesSent(int n) {
        this._keepAlivesSent += n;
    }

    protected int getKeepAlivesSent() {
        return this._keepAlivesSent;
    }

    protected int getKeepAliveLimit() {
        return this.properties.getKeepAliveLimit();
    }

    abstract void handleKeepaliveException(Exception var1);

    protected final void updateRxStats(int bytes, JCSMPXMLMessage xmlMessage) {
        if (JCSMPSessionStats.isDisableStats()) {
            return;
        }
        this.sessionStats.incStat(StatType.RELIABLE_BYTES_RECVED, bytes);
        this.sessionStats.incStat(StatType.TOTAL_BYTES_RECVED, bytes);
        this.sessionStats.incStat(StatType.RELIABLE_MSGS_RECVED);
        this.sessionStats.incStat(StatType.TOTAL_MSGS_RECVED);
        if (xmlMessage.getDiscardIndication()) {
            this.sessionStats.incStat(StatType.ROUTER_DISCARD_NOTIFICATIONS);
        }
        if (xmlMessage.getDeliveryMode() == DeliveryMode.PERSISTENT) {
            this.sessionStats.incStat(StatType.RELIABLE_PERSISTENT_BYTES_RECVED, bytes);
            this.sessionStats.incStat(StatType.RELIABLE_PERSISTENT_MSGS_RECVED);
        } else if (xmlMessage.getDeliveryMode() == DeliveryMode.NON_PERSISTENT) {
            this.sessionStats.incStat(StatType.RELIABLE_NONPERSISTENT_BYTES_RECVED, bytes);
            this.sessionStats.incStat(StatType.RELIABLE_NONPERSISTENT_MSGS_RECVED);
        } else if (xmlMessage.getDeliveryMode() == DeliveryMode.DIRECT) {
            this.sessionStats.incStat(StatType.RELIABLE_DIRECT_BYTES_RECVED, bytes);
            this.sessionStats.incStat(StatType.RELIABLE_DIRECT_MSGS_RECVED);
        }
    }

    protected final void updateTxStats(JCSMPXMLMessage message, int bytes, int msgCount) {
        if (JCSMPSessionStats.isDisableStats()) {
            return;
        }
        if (message.getSendCount() > 1) {
            if (message.getDeliveryMode() != DeliveryMode.DIRECT) {
                this.sessionStats.incStat(StatType.RELIABLE_MSGS_RESENT, msgCount);
                this.sessionStats.incStat(StatType.RELIABLE_BYTES_RESENT, bytes);
                if (message.getDeliveryMode() == DeliveryMode.PERSISTENT) {
                    this.sessionStats.incStat(StatType.RELIABLE_PERSISTENT_BYTES_RESENT, bytes);
                    this.sessionStats.incStat(StatType.RELIABLE_PERSISTENT_MSGS_RESENT, msgCount);
                } else if (message.getDeliveryMode() == DeliveryMode.NON_PERSISTENT) {
                    this.sessionStats.incStat(StatType.RELIABLE_NONPERSISTENT_BYTES_RESENT, bytes);
                    this.sessionStats.incStat(StatType.RELIABLE_NONPERSISTENT_MSGS_RESENT, msgCount);
                }
            }
        } else {
            this.sessionStats.incStat(StatType.RELIABLE_BYTES_SENT, bytes);
            this.sessionStats.incStat(StatType.RELIABLE_MSGS_SENT, msgCount);
            this.sessionStats.incStat(StatType.TOTAL_BYTES_SENT, bytes);
            this.sessionStats.incStat(StatType.TOTAL_MSGS_SENT, msgCount);
            if (message.getDeliveryMode() == DeliveryMode.PERSISTENT) {
                this.sessionStats.incStat(StatType.RELIABLE_PERSISTENT_BYTES_SENT, bytes);
                this.sessionStats.incStat(StatType.RELIABLE_PERSISTENT_MSGS_SENT, msgCount);
            } else if (message.getDeliveryMode() == DeliveryMode.NON_PERSISTENT) {
                this.sessionStats.incStat(StatType.RELIABLE_NONPERSISTENT_BYTES_SENT, bytes);
                this.sessionStats.incStat(StatType.RELIABLE_NONPERSISTENT_MSGS_SENT, msgCount);
            } else if (message.getDeliveryMode() == DeliveryMode.DIRECT) {
                this.sessionStats.incStat(StatType.RELIABLE_DIRECT_BYTES_SENT, bytes);
                this.sessionStats.incStat(StatType.RELIABLE_DIRECT_MSGS_SENT, msgCount);
            }
        }
    }

    @Override
    public void cleanupBuffers() {
    }

    public static final class KeepaliveWriteResult {
        public final long bytesWritten;
        public final boolean writeCompleted;

        public KeepaliveWriteResult(long bWritten, boolean wCompleted) {
            this.bytesWritten = bWritten;
            this.writeCompleted = wCompleted;
        }
    }

    public static enum WriteBlockPolicy {
        DEFAULT,
        DROP_AND_IGNORE,
        DROP_AND_THROW,
        RESCHED_OK_BUT_NO_BLOCK_ON_STATE;

    }
}

