/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solace.messaging.trace.propagation.impl.TraceContextImpl;
import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.User_Cos;
import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.MessageTracingUtil;
import com.solacesystems.jcsmp.protocol.SeqNumAllocator;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;

public class PubMsgHeaderDecodingSupport {
    public static void populateMessageCommonParameters(SeqNumAllocator sequenceAllocator, SMFHeaderBean wmsg_header, JCSMPGenericXMLMessage xmlMessage) throws InvalidMessageReceivedException {
        if (wmsg_header.getPm_userdata() != null) {
            xmlMessage.setUserData(wmsg_header.getPm_userdata());
        }
        xmlMessage.setDeliveryMode(wmsg_header.getPm_deliverymode());
        xmlMessage.setAckImmediately(wmsg_header.isPm_ad_ackImmediateFlag());
        if (wmsg_header.getProtocol() == 13) {
            switch (wmsg_header.getAdf()) {
                case 0: {
                    xmlMessage.setDeliveryMode(DeliveryMode.DIRECT);
                    break;
                }
                case 1: {
                    if (!xmlMessage.getDeliveryMode().equals((Object)DeliveryMode.DIRECT)) break;
                    xmlMessage.setDeliveryMode(DeliveryMode.PERSISTENT);
                }
            }
        }
        if (wmsg_header.getPm_msg_priority() != -1) {
            xmlMessage.setPriority(wmsg_header.getPm_msg_priority());
        }
        switch (wmsg_header.getMsgPri()) {
            case 0: {
                xmlMessage.setCos(User_Cos.USER_COS_1);
                break;
            }
            case 1: {
                xmlMessage.setCos(User_Cos.USER_COS_2);
                break;
            }
            case 2: {
                xmlMessage.setCos(User_Cos.USER_COS_3);
                break;
            }
            default: {
                xmlMessage.setCos(User_Cos.USER_COS_1);
            }
        }
        int discardIndication = wmsg_header.getDi();
        xmlMessage.setDiscardIndication(discardIndication == 1);
        int elidingElig = wmsg_header.getElidingEligible();
        xmlMessage.setElidingEligible(elidingElig == 1);
        int dto = wmsg_header.getDto();
        xmlMessage.setDeliverToOne(dto == 1);
        int dmqe = wmsg_header.getDmqEligible();
        xmlMessage.setDMQEligible(dmqe == 1);
        if (wmsg_header.getPm_topicseqnum() != 0L) {
            xmlMessage.setTopicSequenceNumber(wmsg_header.getPm_topicseqnum());
        }
        if (wmsg_header.getPm_topic_offset() != -1) {
            xmlMessage.setTopicNameLocation(wmsg_header.getPm_topic_offset(), wmsg_header.getPm_topic_len());
        }
        if (wmsg_header.getPm_queue_offset() != -1) {
            xmlMessage.setQueueNameLocation(wmsg_header.getPm_queue_offset(), wmsg_header.getPm_queue_len());
        }
        if (wmsg_header.getPm_ad_ttl() != -1L) {
            xmlMessage.setTimeToLive(wmsg_header.getPm_ad_ttl());
        }
        long msgId64 = 0L;
        long prevMsgId64 = 0L;
        if (xmlMessage.getDeliveryMode() == DeliveryMode.DIRECT) {
            if (sequenceAllocator != null) {
                msgId64 = sequenceAllocator.getNext63b();
            }
        } else {
            if (wmsg_header.getPm_ad_msgid() == -1L) {
                throw new InvalidMessageReceivedException("Received an assured message without a MessageID.");
            }
            msgId64 = wmsg_header.getPm_ad_msgid();
            if (wmsg_header.getPm_ad_prevmsgid() == -1L) {
                throw new InvalidMessageReceivedException("Received an assured message without a PrevMessageID.");
            }
            prevMsgId64 = wmsg_header.getPm_ad_prevmsgid();
            xmlMessage.setDeliveryCount(wmsg_header.getPm_ad_redelivery_count());
            xmlMessage.setFlowId(wmsg_header.getPm_ad_flowid());
            xmlMessage.setAckMessageId(wmsg_header.getPm_ad_ackMsgId());
            xmlMessage.setSpoolerUniqueId(wmsg_header.getPm_ad_spoolerUniqueId());
            xmlMessage.setMateAckMessageId(wmsg_header.getPm_ad_mateAckMsgId());
        }
        xmlMessage.setMessageIdLong(msgId64);
        xmlMessage.setPrevMessageId(prevMsgId64);
        if (wmsg_header.getPm_traceSpanTransportContextBytes() != null) {
            TraceContextImpl transportContext = TraceContextImpl.from(new ByteArray(wmsg_header.getPm_traceSpanTransportContextBytes()));
            MessageTracingUtil.injectTransportContext(xmlMessage, transportContext);
        }
    }
}

