/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.solcache;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPRequestTimeoutException;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.StreamMessage;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.Request;
import com.solacesystems.jcsmp.impl.RequestListener;
import com.solacesystems.jcsmp.impl.solcache.CacheGetRequestListener;
import com.solacesystems.jcsmp.impl.solcache.CacheGetResponse;
import com.solacesystems.jcsmp.impl.solcache.CacheGetResult;
import com.solacesystems.jcsmp.impl.solcache.CacheRequestProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheGetRequest
implements RequestListener {
    private static final Log Trace = LogFactory.getLog(CacheGetRequest.class);
    public static final int GET_VERSION_SUPPORTED = 1;
    public static final int GET_VERSION = 1;
    public static final int DEFAULT_REPLY_SIZE_LIMIT = 10000000;
    public static int REPLY_SIZE_LIMIT = 10000000;
    private static int correlationIndex = 0;
    public static final Integer GET_MSG_REQUEST = 16;
    public static final Integer GET_MSG_RESPONSE = 17;
    public static final Integer GET_NEXT_MSG_REQUEST = 18;
    public static final Integer GET_NEXT_MSG_RESPONSE = 19;
    public static final Integer GET_MSG_SEQUENCE_REQUEST = 25;
    public static final Integer GET_NEXT_MSG_SEQUENCE_REQUEST = 26;
    private CacheRequestProperties mProps;
    private Topic mTopic;
    private boolean mIncClusters;
    private CacheGetRequestListener mListener;
    private CacheGetResult mResult;
    private Request mRequest;

    public CacheGetRequest(CacheRequestProperties props, Topic topic, boolean incClusters, CacheGetRequestListener listener) {
        this.mProps = props;
        this.mTopic = topic;
        this.mIncClusters = incClusters;
        this.mListener = listener;
        this.mResult = new CacheGetResult();
        this.mRequest = null;
    }

    public void send() throws JCSMPException {
        StreamMessage message = this.mProps.getMinSeqNum() != null || this.mProps.getMaxSeqNum() != null ? this.createSequencedMessage(GET_MSG_SEQUENCE_REQUEST, null, this.mProps.getSession().getProperties().getTimeout(), this.mProps.getMinSeqNum(), this.mProps.getMaxSeqNum()) : this.createMessage(GET_MSG_REQUEST, null, this.mProps.getSession().getProperties().getTimeout());
        this.mRequest = new Request(this.mProps.getSession().getJCSMPSession(), this.mProps.getProducer(), this.mProps.getLiveMessageController(), message, this.mTopic, this.mProps.getSession().getProperties().getTimeout(), this);
        this.mResult.setRequest(this.mRequest);
        this.traceRequest();
        this.mRequest.send();
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onException(JCSMPException exception) {
        this.mResult.setException(new JCSMPInterruptedException("Cache request interrupted", exception));
        this.traceResult();
        this.mListener.onResult(this.mResult);
    }

    @Override
    public void onResponse(final JCSMPXMLMessage message) {
        final CacheGetRequest me = this;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    CacheGetResponse response = new CacheGetResponse(message);
                    CacheGetRequest.this.mResult.setResponse(response);
                    CacheGetRequest.this.mResult.validateResponse();
                    CacheGetRequest.this.traceResult();
                    if (CacheGetRequest.this.mListener.onResult(CacheGetRequest.this.mResult) && response.getResponseCode().equals(CacheGetResponse.OK) && response.hasMore().booleanValue()) {
                        try {
                            CacheGetRequest.this.mResult = new CacheGetResult();
                            StreamMessage newMessage = CacheGetRequest.this.mProps.getMinSeqNum() != null || CacheGetRequest.this.mProps.getMaxSeqNum() != null ? CacheGetRequest.this.createSequencedMessage(GET_NEXT_MSG_SEQUENCE_REQUEST, response.getSessionId(), CacheGetRequest.this.mProps.getSession().getProperties().getTimeout(), CacheGetRequest.this.mProps.getMinSeqNum(), CacheGetRequest.this.mProps.getMaxSeqNum()) : CacheGetRequest.this.createMessage(GET_NEXT_MSG_REQUEST, response.getSessionId(), CacheGetRequest.this.mProps.getSession().getProperties().getTimeout());
                            CacheGetRequest.this.mRequest = new Request(CacheGetRequest.this.mProps.getSession().getJCSMPSession(), CacheGetRequest.this.mProps.getProducer(), CacheGetRequest.this.mProps.getLiveMessageController(), newMessage, message.getReplyTo(), CacheGetRequest.this.mProps.getSession().getProperties().getTimeout(), me);
                            CacheGetRequest.this.mResult.setRequest(CacheGetRequest.this.mRequest);
                            CacheGetRequest.this.traceRequest();
                            CacheGetRequest.this.mRequest.send();
                        }
                        catch (JCSMPException e) {
                            CacheGetRequest.this.mResult.setException(e);
                            CacheGetRequest.this.traceResult();
                            CacheGetRequest.this.mListener.onResult(CacheGetRequest.this.mResult);
                        }
                    }
                }
                catch (JCSMPException e) {
                    CacheGetRequest.this.mResult.setException(e);
                    CacheGetRequest.this.traceResult();
                    CacheGetRequest.this.mListener.onResult(CacheGetRequest.this.mResult);
                }
            }
        };
        this.mProps.getExecutor().submit(r);
    }

    @Override
    public void onTimeout() {
        this.mResult.setException(new JCSMPRequestTimeoutException("Timeout occurred performing cache request"));
        this.traceResult();
        this.mListener.onResult(this.mResult);
    }

    private void traceRequest() {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)("Request: " + this.mResult.getRequest()));
        }
    }

    private void traceResult() {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)("Result: " + this.mResult));
        }
    }

    private StreamMessage createMessage(int requestType, Long sessionId, int timeout) throws JCSMPException {
        StreamMessage message = this.mProps.getProducer().createStreamMessage();
        SDTStream stream = this.mProps.getProducer().createStream();
        stream.writeInteger(requestType);
        stream.writeInteger(1);
        stream.writeString(this.mProps.getTopic().getName());
        stream.writeInteger(REPLY_SIZE_LIMIT);
        if (sessionId != null) {
            stream.writeLong(sessionId);
        }
        stream.writeInteger(this.mProps.getSession().getProperties().getMaxMsgs());
        stream.writeInteger(this.mProps.getSession().getProperties().getMaxAge());
        if (requestType == GET_MSG_REQUEST) {
            stream.writeBoolean(this.mIncClusters);
        }
        stream.writeBoolean(false);
        if (requestType == GET_MSG_REQUEST) {
            stream.writeInteger((int)((double)timeout / 1000.0));
        }
        message.setStream(stream);
        message.setCorrelationId(CacheGetRequest.getCorrelationId());
        if (requestType == GET_MSG_REQUEST) {
            message.setDeliverToOne(true);
        } else {
            message.setDeliverToOne(false);
        }
        Topic replyToTopic = (Topic)this.mProps.getSession().getJCSMPSession().getProperty("p2pinbox_in_use");
        if (replyToTopic == null) {
            throw new JCSMPException("Error getting cache replyTo Topic");
        }
        message.setReplyTo(replyToTopic);
        return message;
    }

    private StreamMessage createSequencedMessage(int requestType, Long sessionId, int timeout, Long minSeqNum, Long maxSeqNum) throws JCSMPException {
        StreamMessage message = this.mProps.getProducer().createStreamMessage();
        SDTStream stream = this.mProps.getProducer().createStream();
        stream.writeInteger(requestType);
        stream.writeInteger(1);
        stream.writeString(this.mProps.getTopic().getName());
        stream.writeInteger(REPLY_SIZE_LIMIT);
        if (sessionId != null) {
            stream.writeLong(sessionId);
        }
        stream.writeLong(minSeqNum);
        stream.writeLong(maxSeqNum);
        if (requestType == GET_MSG_SEQUENCE_REQUEST) {
            stream.writeBoolean(this.mIncClusters);
        }
        stream.writeBoolean(false);
        if (requestType == GET_MSG_SEQUENCE_REQUEST) {
            stream.writeInteger((int)((double)timeout / 1000.0));
        }
        message.setStream(stream);
        message.setCorrelationId(CacheGetRequest.getCorrelationId());
        if (requestType == GET_MSG_SEQUENCE_REQUEST) {
            message.setDeliverToOne(true);
        } else {
            message.setDeliverToOne(false);
        }
        Topic replyToTopic = (Topic)this.mProps.getSession().getJCSMPSession().getProperty("p2pinbox_in_use");
        if (replyToTopic == null) {
            throw new JCSMPException("Error getting cache replyTo Topic");
        }
        message.setReplyTo(replyToTopic);
        return message;
    }

    private static synchronized String getCorrelationId() {
        return "#CRQ" + correlationIndex++;
    }
}

