/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.ReplayStartLocationImpl;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderParameters;
import com.solacesystems.jcsmp.protocol.smf.SmfADTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactory;
import java.io.UnsupportedEncodingException;

public class TlvParameterFactoryAssuredCtrl
extends TlvParameterFactory {
    private static TlvParameterFactoryAssuredCtrl _self = new TlvParameterFactoryAssuredCtrl();

    private TlvParameterFactoryAssuredCtrl() {
    }

    public static TlvParameterFactoryAssuredCtrl instance() {
        return _self;
    }

    public SmfADTLVParameter getLastMsgIdSent(long id) {
        return new SmfADTLVParameter(2, 1, NetworkByteOrderNumberUtil.intToEightByte(id));
    }

    public void addLastMsgIdSent(AssuredCtrlHeaderBean h, long id) {
        h.addParamFastEnc(2, 1, NetworkByteOrderNumberUtil.intToEightByte(id));
    }

    public SmfADTLVParameter getLastMsgIdAcked(long id) {
        return new SmfADTLVParameter(2, 2, NetworkByteOrderNumberUtil.intToEightByte(id));
    }

    public void addLastMsgIdAcked(AssuredCtrlHeaderBean h, long id) {
        h.addParamFastEnc(2, 2, NetworkByteOrderNumberUtil.intToEightByte(id));
    }

    public SmfADTLVParameter getWindowSize(int sz) {
        if (sz < 0 || sz > 255) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("TlvParameterFactoryAssuredCtrl.windowSzMustBeInRange"));
        }
        return new SmfADTLVParameter(2, 3, new byte[]{NetworkByteOrderNumberUtil.intToOneByte(sz)});
    }

    public SmfADTLVParameter getTransportWindowSize(int sz) {
        if (sz < 0 || sz > 255) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("TlvParameterFactoryAssuredCtrl.windowSzMustBeInRange"));
        }
        return new SmfADTLVParameter(0, 14, NetworkByteOrderNumberUtil.intToFourByte(sz));
    }

    public void addWindowSize(AssuredCtrlHeaderBean h, int sz) {
        if (sz < 0 || sz > 255) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("TlvParameterFactoryAssuredCtrl.windowSzMustBeInRange"));
        }
        h.addParamFastEnc(2, 3, new byte[]{NetworkByteOrderNumberUtil.intToOneByte(sz)});
    }

    public void addTransportWindowSize(AssuredCtrlHeaderBean h, int sz) {
        if (sz < 0 || sz > 255) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("TlvParameterFactoryAssuredCtrl.windowSzMustBeInRange"));
        }
        h.addParamFastEnc(0, 14, NetworkByteOrderNumberUtil.intToFourByte(sz));
    }

    public SmfADTLVParameter getApplicationAck(long minAppAck, long maxAppAck) {
        byte[] encValue = new byte[16];
        NetworkByteOrderNumberUtil.intToEightByte(minAppAck, encValue, 0);
        NetworkByteOrderNumberUtil.intToEightByte(maxAppAck, encValue, 8);
        return new SmfADTLVParameter(2, 5, encValue);
    }

    public void addApplicationAck(AssuredCtrlHeaderBean h, long minAppAck, long maxAppAck) {
        byte[] encValue = new byte[16];
        NetworkByteOrderNumberUtil.intToEightByte(minAppAck, encValue, 0);
        NetworkByteOrderNumberUtil.intToEightByte(maxAppAck, encValue, 8);
        h.addParamFastEnc(2, 5, encValue);
    }

    public void addApplicationAck(AssuredCtrlHeaderBean h, long minAppAck, long maxAppAck, XMLMessage.Outcome out) {
        byte[] encValue = new byte[17];
        NetworkByteOrderNumberUtil.intToEightByte(minAppAck, encValue, 0);
        NetworkByteOrderNumberUtil.intToEightByte(maxAppAck, encValue, 8);
        encValue[16] = NetworkByteOrderNumberUtil.intToOneByte(out.getValue());
        h.addParamFastEnc(2, 5, encValue);
    }

    public SmfADTLVParameter getFlowId(long flowId) {
        return new SmfADTLVParameter(2, 6, NetworkByteOrderNumberUtil.intToFourByte(flowId));
    }

    public void addFlowId(AssuredCtrlHeaderBean h, long flowId) {
        h.addParamFastEnc(2, 6, NetworkByteOrderNumberUtil.intToFourByte(flowId));
    }

    public SmfADTLVParameter getUnbindLinger() {
        return new SmfADTLVParameter(0, 15, new byte[0]);
    }

    public SmfADTLVParameter getLastMsgIdRecved(long id) {
        return new SmfADTLVParameter(0, 16, NetworkByteOrderNumberUtil.intToEightByte(id));
    }

    public SmfADTLVParameter getQueueName(String queueName) {
        try {
            byte[] encBytes = queueName.getBytes("UTF-8");
            byte[] nullTermEncBytes = new byte[encBytes.length + 1];
            System.arraycopy(encBytes, 0, nullTermEncBytes, 0, encBytes.length);
            return new SmfADTLVParameter(2, 7, nullTermEncBytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public SmfADTLVParameter getDurableTopicEndpointName(String dteName) {
        byte[] nullTermEncBytes = TlvCoderUtil.toNullTermAscii(dteName);
        return new SmfADTLVParameter(2, 8, nullTermEncBytes);
    }

    public SmfADTLVParameter getTopicName(String topic) {
        byte[] nullTermEncBytes = TlvCoderUtil.toNullTermAscii(topic);
        return new SmfADTLVParameter(2, 9, nullTermEncBytes);
    }

    public SmfADTLVParameter getDurability(AssuredCtrlEnums.EndpointDurability dur) {
        byte[] encBytes = new byte[]{NetworkByteOrderNumberUtil.intToOneByte(dur.smfEnc())};
        return new SmfADTLVParameter(0, 11, encBytes);
    }

    public SmfADTLVParameter getFlowName(String flowName) {
        byte[] nullTermEncBytes = TlvCoderUtil.toNullTermUtf8(flowName);
        return new SmfADTLVParameter(0, 10, nullTermEncBytes);
    }

    public SmfADTLVParameter getMessageSelector(String selector) {
        byte[] nullTermEncBytes = TlvCoderUtil.toNullTermUtf8(selector);
        return new SmfADTLVParameter(0, 13, nullTermEncBytes);
    }

    public SmfADTLVParameter getAllOthersPermissions(Integer permissionType) {
        int permFlags = 0;
        switch (permissionType) {
            case 0: {
                break;
            }
            case 1: {
                permFlags = 1;
                break;
            }
            case 2: {
                permFlags = 3;
                break;
            }
            case 3: {
                permFlags = 7;
                break;
            }
            case 4: {
                permFlags = 15;
            }
        }
        return new SmfADTLVParameter(0, 17, NetworkByteOrderNumberUtil.intToFourByte(permFlags));
    }

    public SmfADTLVParameter getFlowType(AssuredCtrlEnums.FlowType ft) {
        return new SmfADTLVParameter(2, 18, new byte[]{NetworkByteOrderNumberUtil.intToOneByte(ft.smfEnc())});
    }

    public SmfADTLVParameter getEndpointQuotaMB(int quotaMB) {
        return new SmfADTLVParameter(0, 19, NetworkByteOrderNumberUtil.intToFourByte(quotaMB));
    }

    public SmfADTLVParameter getEndpointMaxMessageSize(int maxMsgSize) {
        return new SmfADTLVParameter(0, 20, NetworkByteOrderNumberUtil.intToFourByte(maxMsgSize));
    }

    public SmfADTLVParameter getAccessType(AssuredCtrlEnums.QueueAccessType accessType) {
        return new SmfADTLVParameter(0, 12, new byte[]{NetworkByteOrderNumberUtil.intToOneByte(accessType.smfEnc())});
    }

    public SmfADTLVParameter getRespectTTL(boolean respectTTL) {
        return new SmfADTLVParameter(0, 22, new byte[]{NetworkByteOrderNumberUtil.intToOneByte(respectTTL ? 1 : 0)});
    }

    public SmfADTLVParameter getTransactionCtrlMessageType(AssuredCtrlEnums.TransactionCtrlMessageType type) {
        return new SmfADTLVParameter(2, 23, new byte[]{NetworkByteOrderNumberUtil.intToOneByte(type.smfEnc())});
    }

    public SmfADTLVParameter getTransactedSessionId(long transactedSessionId) {
        return new SmfADTLVParameter(2, 24, NetworkByteOrderNumberUtil.intToFourByte(transactedSessionId));
    }

    public SmfADTLVParameter getTransactedSessionState(AssuredCtrlEnums.TransactedSessionState tss) {
        return new SmfADTLVParameter(2, 27, new byte[]{(byte)tss.smfEnc()});
    }

    public SmfADTLVParameter getTransactedSessionName(String transactedSessionName) {
        byte[] nullTermEncBytes = TlvCoderUtil.toNullTermAscii(transactedSessionName);
        return new SmfADTLVParameter(2, 25, nullTermEncBytes);
    }

    public SmfADTLVParameter getTransactionGetStateAndTid() {
        return new SmfADTLVParameter(0, 55, new byte[0]);
    }

    public SmfADTLVParameter getTransactionId(AssuredCtrlHeaderParameters.ParamTransactionId tid) {
        return new SmfADTLVParameter(2, 26, tid.valueToBytes());
    }

    public SmfADTLVParameter getTransactionFDPubNotify(AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify p) {
        return new SmfADTLVParameter(2, 28, p.valueToBytes());
    }

    public SmfADTLVParameter getTransactionFDPubAck(AssuredCtrlHeaderParameters.ParamTransactionFDPubAck p) {
        return new SmfADTLVParameter(2, 29, p.valueToBytes());
    }

    public SmfADTLVParameter getTransactionFDSubAck(AssuredCtrlHeaderParameters.ParamTransactionFDSubAck p) {
        return new SmfADTLVParameter(2, 30, p.valueToBytes());
    }

    public SmfADTLVParameter getOpenXASessionMessageType(byte xaVersion) {
        return new SmfADTLVParameter(2, 43, new byte[]{NetworkByteOrderNumberUtil.intToOneByte(AssuredCtrlEnums.XACtrlMessageType.OPEN_XA_SESSION_REQUEST.smfEnc()), xaVersion});
    }

    public SmfADTLVParameter getResumeXASessionMessageType(byte xaVersion, String transactedSessionName) {
        byte[] nullTermEncBytes = TlvCoderUtil.toNullTermAscii(transactedSessionName);
        byte[] paramBytes = new byte[3 + nullTermEncBytes.length];
        paramBytes[0] = NetworkByteOrderNumberUtil.intToOneByte(AssuredCtrlEnums.XACtrlMessageType.RESUME_XA_SESSION_REQUEST.smfEnc());
        paramBytes[1] = xaVersion;
        paramBytes[2] = (byte)(nullTermEncBytes.length + 1);
        System.arraycopy(nullTermEncBytes, 0, paramBytes, 3, nullTermEncBytes.length);
        return new SmfADTLVParameter(2, 43, paramBytes);
    }

    public SmfADTLVParameter getCloseXASessionMessageType(String transactedSessionName) {
        byte[] nullTermEncBytes = TlvCoderUtil.toNullTermAscii(transactedSessionName);
        byte[] paramBytes = new byte[2 + nullTermEncBytes.length];
        paramBytes[0] = NetworkByteOrderNumberUtil.intToOneByte(AssuredCtrlEnums.XACtrlMessageType.CLOSE_XA_SESSION_REQUEST.smfEnc());
        paramBytes[1] = (byte)(nullTermEncBytes.length + 1);
        System.arraycopy(nullTermEncBytes, 0, paramBytes, 2, nullTermEncBytes.length);
        return new SmfADTLVParameter(2, 43, paramBytes);
    }

    public SmfADTLVParameter getXAStartMessageType(byte flags, int transactedSessionId, int transactionTimeout, byte[] xid) {
        byte[] paramBytes = new byte[10 + xid.length];
        byte[] txIdEnc = NetworkByteOrderNumberUtil.intToFourByte(transactedSessionId);
        byte[] txToEnc = NetworkByteOrderNumberUtil.intToFourByte(transactionTimeout);
        paramBytes[0] = NetworkByteOrderNumberUtil.intToOneByte(AssuredCtrlEnums.XACtrlMessageType.XA_START_REQUEST.smfEnc());
        paramBytes[1] = flags;
        System.arraycopy(txIdEnc, 0, paramBytes, 2, txIdEnc.length);
        System.arraycopy(txToEnc, 0, paramBytes, 2 + txIdEnc.length, txToEnc.length);
        System.arraycopy(xid, 0, paramBytes, 2 + txIdEnc.length + txToEnc.length, xid.length);
        return new SmfADTLVParameter(2, 43, paramBytes);
    }

    public SmfADTLVParameter getXAEndMessageType(byte flags, int reqTransactedSessionId, int recvTransactedSessionId, byte[] xid, long lastPubMsgId, byte[] data) {
        byte[] paramBytes = new byte[6 + xid.length + 8 + 4 + data.length];
        byte[] reqTxIdEnc = NetworkByteOrderNumberUtil.intToFourByte(reqTransactedSessionId);
        byte[] recvTxIdEnc = NetworkByteOrderNumberUtil.intToFourByte(recvTransactedSessionId);
        byte[] lastPubIdEnc = NetworkByteOrderNumberUtil.intToEightByte(lastPubMsgId);
        paramBytes[0] = NetworkByteOrderNumberUtil.intToOneByte(AssuredCtrlEnums.XACtrlMessageType.XA_END_REQUEST.smfEnc());
        paramBytes[1] = flags;
        System.arraycopy(reqTxIdEnc, 0, paramBytes, 2, reqTxIdEnc.length);
        System.arraycopy(xid, 0, paramBytes, 2 + reqTxIdEnc.length, xid.length);
        System.arraycopy(lastPubIdEnc, 0, paramBytes, 2 + reqTxIdEnc.length + xid.length, lastPubIdEnc.length);
        System.arraycopy(recvTxIdEnc, 0, paramBytes, 2 + reqTxIdEnc.length + xid.length + lastPubIdEnc.length, recvTxIdEnc.length);
        System.arraycopy(data, 0, paramBytes, 2 + reqTxIdEnc.length + xid.length + lastPubIdEnc.length + recvTxIdEnc.length, data.length);
        return new SmfADTLVParameter(2, 43, paramBytes);
    }

    public SmfADTLVParameter getXAPrepareMessageType(byte flags, int transactedSessionId, byte[] xid) {
        byte[] paramBytes = new byte[6 + xid.length];
        byte[] txIdEnc = NetworkByteOrderNumberUtil.intToFourByte(transactedSessionId);
        paramBytes[0] = NetworkByteOrderNumberUtil.intToOneByte(AssuredCtrlEnums.XACtrlMessageType.XA_PREPARE_REQUEST.smfEnc());
        paramBytes[1] = flags;
        System.arraycopy(txIdEnc, 0, paramBytes, 2, txIdEnc.length);
        System.arraycopy(xid, 0, paramBytes, 2 + txIdEnc.length, xid.length);
        return new SmfADTLVParameter(2, 43, paramBytes);
    }

    public SmfADTLVParameter getXACommitMessageType(byte flags, int transactedSessionId, byte[] xid) {
        byte[] paramBytes = new byte[6 + xid.length];
        byte[] txIdEnc = NetworkByteOrderNumberUtil.intToFourByte(transactedSessionId);
        paramBytes[0] = NetworkByteOrderNumberUtil.intToOneByte(AssuredCtrlEnums.XACtrlMessageType.XA_COMMIT_REQUEST.smfEnc());
        paramBytes[1] = flags;
        System.arraycopy(txIdEnc, 0, paramBytes, 2, txIdEnc.length);
        System.arraycopy(xid, 0, paramBytes, 2 + txIdEnc.length, xid.length);
        return new SmfADTLVParameter(2, 43, paramBytes);
    }

    public SmfADTLVParameter getXARollbackMessageType(byte flags, int transactedSessionId, byte[] xid) {
        byte[] paramBytes = new byte[6 + xid.length];
        byte[] txIdEnc = NetworkByteOrderNumberUtil.intToFourByte(transactedSessionId);
        paramBytes[0] = NetworkByteOrderNumberUtil.intToOneByte(AssuredCtrlEnums.XACtrlMessageType.XA_ROLLBACK_REQUEST.smfEnc());
        paramBytes[1] = flags;
        System.arraycopy(txIdEnc, 0, paramBytes, 2, txIdEnc.length);
        System.arraycopy(xid, 0, paramBytes, 2 + txIdEnc.length, xid.length);
        return new SmfADTLVParameter(2, 43, paramBytes);
    }

    public SmfADTLVParameter getXAForgetMessageType(byte flags, int transactedSessionId, byte[] xid) {
        byte[] paramBytes = new byte[6 + xid.length];
        byte[] txIdEnc = NetworkByteOrderNumberUtil.intToFourByte(transactedSessionId);
        paramBytes[0] = NetworkByteOrderNumberUtil.intToOneByte(AssuredCtrlEnums.XACtrlMessageType.XA_FORGET_REQUEST.smfEnc());
        paramBytes[1] = flags;
        System.arraycopy(txIdEnc, 0, paramBytes, 2, txIdEnc.length);
        System.arraycopy(xid, 0, paramBytes, 2 + txIdEnc.length, xid.length);
        return new SmfADTLVParameter(2, 43, paramBytes);
    }

    public SmfADTLVParameter getXARecoverMessageType(byte flags, int maxNumXids, byte[] scanCursor) {
        int length = 0;
        length = scanCursor == null ? 6 : 10 + scanCursor.length;
        byte[] paramBytes = new byte[length];
        byte[] maxIdsEnc = NetworkByteOrderNumberUtil.intToFourByte(maxNumXids);
        paramBytes[0] = NetworkByteOrderNumberUtil.intToOneByte(AssuredCtrlEnums.XACtrlMessageType.XA_RECOVER_REQUEST.smfEnc());
        paramBytes[1] = flags;
        System.arraycopy(maxIdsEnc, 0, paramBytes, 2, maxIdsEnc.length);
        if (scanCursor != null) {
            byte[] scanCursorLengthEnc = NetworkByteOrderNumberUtil.intToFourByte(scanCursor.length);
            System.arraycopy(scanCursorLengthEnc, 0, paramBytes, 2 + maxIdsEnc.length, scanCursorLengthEnc.length);
            System.arraycopy(scanCursor, 0, paramBytes, 2 + maxIdsEnc.length + scanCursorLengthEnc.length, scanCursor.length);
        }
        return new SmfADTLVParameter(2, 43, paramBytes);
    }

    public SmfADTLVParameter getNoLocal() {
        return new SmfADTLVParameter(0, 31, new byte[0]);
    }

    public SmfADTLVParameter getActiveFlowIndication(boolean activeFlowIndication) {
        return new SmfADTLVParameter(0, 32, new byte[]{NetworkByteOrderNumberUtil.intToOneByte(activeFlowIndication ? 1 : 0)});
    }

    public SmfADTLVParameter getWantFlowChangeUpdate(boolean wantFlowChangeUpdate) {
        return new SmfADTLVParameter(0, 33, new byte[]{NetworkByteOrderNumberUtil.intToOneByte(wantFlowChangeUpdate ? 1 : 0)});
    }

    public SmfADTLVParameter getQEndpointBehaviour(Integer cutthrough, Integer notifysender) {
        int v_cutthrough = cutthrough == null ? 0 : cutthrough;
        int v_notifysender = notifysender == null ? 0 : notifysender;
        int val = (v_cutthrough & 3) << 14 | (v_notifysender & 3) << 12;
        return new SmfADTLVParameter(0, 34, NetworkByteOrderNumberUtil.intToTwoByte(val));
    }

    public SmfADTLVParameter getMaxMsgRedelivery(int maxMsgRedelivery) {
        return new SmfADTLVParameter(0, 42, new byte[]{NetworkByteOrderNumberUtil.intToOneByte(maxMsgRedelivery)});
    }

    public SmfADTLVParameter getStartLocation(ReplayStartLocationImpl startLocation) {
        return new SmfADTLVParameter(2, 51, startLocation.getEncodedBytes());
    }

    public SmfADTLVParameter getEndpointErrorId(long id) {
        return new SmfADTLVParameter(0, 52, NetworkByteOrderNumberUtil.intToEightByte(id));
    }
}

