/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeepaliveTimeoutHandler
implements JCSMPTimeoutHandler {
    TcpChannel _channel;
    long lastBytesWritten = 0L;
    static final Log Trace = LogFactory.getLog(KeepaliveTimeoutHandler.class);

    public KeepaliveTimeoutHandler(TcpChannel channel, int intervalMillis) {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Created new KA timer handler");
        }
        this._channel = channel;
    }

    @Override
    public void handleTimeout() {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Keepalive Timeout expired.");
        }
        if (!this._channel.connected()) {
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)"Connection closed. Stop keep-alive monitor");
            }
            return;
        }
        this._channel.incKeepAlivesSent(1);
        if (this._channel.getKeepAlivesSent() > this._channel.getKeepAliveLimit()) {
            JCSMPTransportException ex = new JCSMPTransportException(JCSMPRB.BUNDLE.getStringSafely("TcpChannel.errorCommWithRouter") + " (KeepAlive)");
            this._channel.handleKeepaliveException(ex);
            return;
        }
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)String.format("Sending keepalive message (%s/%s)", this._channel.getKeepAlivesSent(), this._channel.getKeepAliveLimit()));
        }
        try {
            WireMessage msg = WireMessageFactory.createWith(new SMFHeaderBean().setProtocol(11).setTtl(1).setUh(2));
            TcpChannel.KeepaliveWriteResult ka_result = this._channel.writeKAMessage(msg);
            if (!ka_result.writeCompleted && this.lastBytesWritten != ka_result.bytesWritten) {
                this._channel.incKeepAlivesSent(-1);
            }
            this.lastBytesWritten = ka_result.bytesWritten;
        }
        catch (Exception e) {
            this._channel.handleKeepaliveException(e);
            return;
        }
        this._channel.startKATimer();
    }
}

