/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction.xa;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.SessionEvent;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.InternalConnectEvent;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.PubADManager;
import com.solacesystems.jcsmp.impl.SessionEventArgsImpl;
import com.solacesystems.jcsmp.impl.transaction.xa.XAResourceImpl;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionImpl;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterParser;
import com.solacesystems.jcsmp.transaction.xa.XASession;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XASessionManager {
    private final LogWrapper Trace = new LogWrapper(XASessionManager.class);
    private JCSMPBasicSession _session;
    private TcpClientChannel _subChannel = null;
    private Set<XASessionImpl> _managedTransactions = null;
    private Map<Long, XASessionImpl> _activeTransactions = null;
    public ContextImpl _context;

    public XASessionManager(JCSMPBasicSession session, ContextImpl context) {
        this._session = session;
        this._context = context;
        this._managedTransactions = new HashSet<XASessionImpl>();
        this._activeTransactions = new HashMap<Long, XASessionImpl>();
        this.Trace.setContextInfo(this.getLogContextInfo());
    }

    public LogWrapper getTrace() {
        return this.Trace;
    }

    public JCSMPBasicSession getJCSMPSession() {
        return this._session;
    }

    public String getLogContextInfo() {
        return this.getJCSMPSession().getLogContextInfo();
    }

    public String getNetworkInfoString() {
        String networkInfo = "";
        if (this._subChannel != null) {
            networkInfo = this._subChannel.getNetworkInfoString();
        }
        return networkInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyVridChange() {
        Set<XASessionImpl> managedCpy;
        Set<XASessionImpl> set = this._managedTransactions;
        synchronized (set) {
            managedCpy = XASessionManager.copySet(this._managedTransactions);
        }
        for (XASessionImpl ts : managedCpy) {
            ts.notifyVridChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageIdRenumbering(PubADManager adMgr) {
        Set<XASessionImpl> managedCpy;
        Set<XASessionImpl> set = this._managedTransactions;
        synchronized (set) {
            managedCpy = XASessionManager.copySet(this._managedTransactions);
        }
        for (XASessionImpl ts : managedCpy) {
            ts.messageIdRenumbering(adMgr);
        }
    }

    public void setSubChannel(TcpClientChannel channel) {
        this._subChannel = channel;
        if (channel != null) {
            channel.setXASessionMgr(this);
        }
    }

    public TcpClientChannel getSubChannel() {
        return this._subChannel;
    }

    public XASession createXASession() throws JCSMPException {
        XASessionImpl ts = new XASessionImpl(this, this.getSubChannel().getChannelProperties());
        ts.doOpenXASession(false);
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedTransactedSession(XASessionImpl ts) {
        Set<XASessionImpl> set = this._managedTransactions;
        synchronized (set) {
            this._managedTransactions.add(ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAdCtrlVersionChange(boolean downgrade) {
        Set<XASessionImpl> managedCpy;
        Set<XASessionImpl> set = this._managedTransactions;
        synchronized (set) {
            managedCpy = XASessionManager.copySet(this._managedTransactions);
        }
        for (XASessionImpl ts : managedCpy) {
            ts.notifyAdCtrlVersionChange(downgrade);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedTransactedSession(XASessionImpl ts) {
        Set<XASessionImpl> set = this._managedTransactions;
        synchronized (set) {
            this._managedTransactions.remove(ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveTransaction(long corrId, XASessionImpl ts) {
        Map<Long, XASessionImpl> map = this._activeTransactions;
        synchronized (map) {
            this._activeTransactions.put(corrId, ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveTransaction(long corrId) {
        Map<Long, XASessionImpl> map = this._activeTransactions;
        synchronized (map) {
            this._activeTransactions.remove(corrId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XASessionImpl getActiveTransaction(long corrId) {
        Map<Long, XASessionImpl> map = this._activeTransactions;
        synchronized (map) {
            return this._activeTransactions.get(corrId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConnectEvent(InternalConnectEvent ev) throws JCSMPException {
        this.Trace.debug(String.format("Got connect event: %s", ev));
        switch (ev.type) {
            case PRE_RECONNECT: {
                Set<XASessionImpl> managedCpy;
                Set<XASessionImpl> set = this._managedTransactions;
                synchronized (set) {
                    managedCpy = XASessionManager.copySet(this._managedTransactions);
                }
                for (XASessionImpl ts : managedCpy) {
                    ts.notifyPreReconnect();
                }
                break;
            }
            case POST_RECONNECT: {
                Set<XASessionImpl> sessionsToRebind;
                Set<XASessionImpl> ts = this._managedTransactions;
                synchronized (ts) {
                    sessionsToRebind = XASessionManager.copySet(this._managedTransactions);
                }
                for (XASessionImpl ts2 : sessionsToRebind) {
                    try {
                        if (ts2.getName() == null) {
                            ts2.recreateXASession();
                            continue;
                        }
                        ts2.doResumeXASession();
                    }
                    catch (JCSMPErrorResponseException respEx) {
                        if (respEx.getResponseCode() != 400 || respEx.getSubcodeEx() != 64 || !this._session.getGdReconnectFailAction().equals("gd_reconnect_fail_action_auto_retry")) continue;
                        ts2.notifyUnknownName();
                        ts2.recreateXASession();
                    }
                }
                break;
            }
            case FLOWS_REBOUND: {
                Set<XASessionImpl> sessionsToNotify;
                if (this._session.getAssuredCtrlFactory().getVersion() >= 4) break;
                Set<XASessionImpl> ts2 = this._managedTransactions;
                synchronized (ts2) {
                    sessionsToNotify = XASessionManager.copySet(this._managedTransactions);
                }
                for (XASessionImpl ts : sessionsToNotify) {
                    ts.handleLegacyRetransmit();
                }
                break;
            }
            case FLOW_REBIND_FINISHED: {
                Set<XASessionImpl> sessionsToNotify;
                Set<XASessionImpl> ts2 = this._managedTransactions;
                synchronized (ts2) {
                    sessionsToNotify = XASessionManager.copySet(this._managedTransactions);
                }
                for (XASessionImpl ts : sessionsToNotify) {
                    ts.notifyFlowRebindFinished();
                }
                break;
            }
            case ABORT_RECONNECT: {
                Set<XASessionImpl> sessions;
                Set<XASessionImpl> set = this._managedTransactions;
                synchronized (set) {
                    sessions = XASessionManager.copySet(this._managedTransactions);
                }
                for (XASessionImpl ts : sessions) {
                    ((XAResourceImpl)ts.getXAResource()).handleReconnectAbort(ev.getException());
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LinkedList<XASessionImpl> to_close = new LinkedList<XASessionImpl>();
        Set<XASessionImpl> set = this._managedTransactions;
        synchronized (set) {
            to_close.addAll(this._managedTransactions);
        }
        for (XASessionImpl s : to_close) {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildDispatchTransactionsList(List<XASessionImpl> to_close) {
        Set<XASessionImpl> set = this._managedTransactions;
        synchronized (set) {
            to_close.addAll(this._managedTransactions);
        }
    }

    private static <E> Set<E> copySet(Collection<E> s) {
        HashSet<E> newset = new HashSet<E>();
        newset.addAll(s);
        return newset;
    }

    public void dispatchChannelException(JCSMPException ex, List<XASessionImpl> to_close) {
        JCSMPErrorResponseException erex;
        for (XASessionImpl s : to_close) {
            s.handleUnrecoverableException(ex);
        }
        if (ex != null && ex.getCause() != null && ex.getCause() instanceof JCSMPErrorResponseException && (erex = (JCSMPErrorResponseException)ex.getCause()).getSubcodeEx() == 64) {
            SessionEventArgsImpl ev = new SessionEventArgsImpl(SessionEvent.UNKNOWN_TRANSACTED_SESSION_NAME, erex.getResponsePhrase(), erex, erex.getResponseCode());
            this._session.handleSessionEvent(ev);
        }
    }

    public void handleAsyncAssuredCtrlMessage(WireMessage wmsg) {
        try {
            assert (wmsg.getHeaderBean() instanceof AssuredCtrlHeaderBean);
            AssuredCtrlHeaderBean adctrl = (AssuredCtrlHeaderBean)wmsg.getHeaderBean();
            int resp_corrtag = wmsg.getSmfHeader().getPm_corrtag();
            SmfTLVParameter param = (SmfTLVParameter)adctrl.findFirstParameter(43);
            if (param == null) {
                throw new InvalidMessageReceivedException("Invalid transaction control message.");
            }
            AssuredCtrlEnums.XACtrlMessageType mtype = TlvParameterParser.getAssuredXACtrlMessageType(param);
            this.Trace.debug("Got xa transaction control type: " + (Object)((Object)mtype));
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(String.format("Handling assuredCtrl message %s with correlation id %d", mtype.toString(), resp_corrtag));
            }
            switch (mtype) {
                case CLOSE_XA_SESSION_RESPONSE: {
                    break;
                }
                case OPEN_XA_SESSION_RESPONSE: 
                case RESUME_XA_SESSION_RESPONSE: {
                    if (this.Trace.isInfoEnabled()) {
                        this.Trace.info("received stale open/resume response with correlation id " + resp_corrtag);
                    }
                    break;
                }
                case XA_RECOVER_RESPONSE: 
                case XA_RESPONSE: {
                    XASessionImpl xaSession = this.getActiveTransaction(resp_corrtag);
                    if (xaSession == null) {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug("received stale response with correlation id " + resp_corrtag);
                        }
                        break;
                    }
                    ((XAResourceImpl)xaSession.getXAResource()).handleAsyncAssuredCtrlMessage(wmsg);
                    break;
                }
                default: {
                    if (this.Trace.isErrorEnabled() && this.Trace.isErrorEnabled()) {
                        this.Trace.error("received unknown response with correlation id " + resp_corrtag);
                    }
                    break;
                }
            }
        }
        catch (JCSMPException e) {
            this.Trace.info("Error handling async assuredctrl message, dropped.", e);
        }
    }
}

