/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import java.io.PrintStream;

public class ThreadUtil {
    private ThreadUtil() {
    }

    public static void printMyStackTrace() {
        ThreadUtil.printMyStackTrace(System.out);
    }

    public static void printMyStackTrace(PrintStream out) {
        out.print(ThreadUtil.getMyStackTrace());
    }

    public static String getMyStackTrace() {
        return ThreadUtil.getStackTrace("\n");
    }

    public static String getMyStackTraceOneLine() {
        return ThreadUtil.getStackTrace(" ");
    }

    private static String getStackTrace(String separator) {
        StackTraceElement[] ste_arr = ThreadUtil.dumpFilteredStack();
        StringBuilder sb = new StringBuilder();
        sb.append(ThreadUtil.getHeader()).append(separator);
        for (StackTraceElement stackTraceElement : ste_arr) {
            sb.append("\t" + stackTraceElement + separator);
        }
        return sb.toString();
    }

    private static StackTraceElement[] dumpFilteredStack() {
        String cc;
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        int i = 0;
        for (i = 0; i < ste.length && ((cc = ste[i].getClassName()).equals("java.lang.Thread") || cc.equals(ThreadUtil.class.getCanonicalName())); ++i) {
        }
        StackTraceElement[] ste2 = new StackTraceElement[ste.length - i];
        System.arraycopy(ste, i, ste2, 0, ste2.length);
        return ste2;
    }

    private static String getHeader() {
        Thread ct = Thread.currentThread();
        return String.format("Thread: \"%s\" %s id=%s, prio=%s:", ct.getName(), ct.isDaemon() ? "daemon " : "", ct.getId(), ct.getPriority());
    }
}

