/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremobility.utilities;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;

public class MultiPartUtility {
    private final String boundary;
    private static final String LINE_END = "\r\n";
    private HttpURLConnection httpConn;
    private String charset;
    private OutputStream outputStream;
    private PrintWriter writer;

    public MultiPartUtility(HttpURLConnection httpConn, String charset) throws IOException {
        this.charset = charset;
        this.boundary = "******";
        this.httpConn = httpConn;
        httpConn.setUseCaches(false);
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.outputStream = httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public void addTextPart(String name, String value) {
        this.writer.append("--").append(this.boundary).append(LINE_END).append("Content-Disposition: form-data; name=\"").append(name).append("\"").append(LINE_END).append("Content-Type: text/plain; charset=").append(this.charset).append(LINE_END);
        this.writer.append(LINE_END);
        this.writer.append(value).append(LINE_END);
        this.writer.flush();
    }

    public void addPhoto(String fieldName, byte[] fileBytes) throws IOException {
        int bytesRead;
        this.writer.append("--").append(this.boundary).append(LINE_END).append("Content-Disposition: form-data; name=\"").append(fieldName).append("\"; filename=\"").append("imagen1.jpg").append("\"").append(LINE_END).append("Content-Type: image/jpeg").append(LINE_END).append("Content-Transfer-Encoding: BINARY").append(LINE_END).append(LINE_END);
        this.writer.flush();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBytes);
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.outputStream.write(buffer, 0, bytesRead);
        }
        this.outputStream.flush();
        inputStream.close();
        this.writer.append(LINE_END);
        this.writer.flush();
    }

    public HttpURLConnection finish() throws IOException {
        this.writer.append(LINE_END).flush();
        this.writer.append("--").append(this.boundary).append("--").append(LINE_END).close();
        return this.httpConn;
    }
}

