/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremobility.simplehttp;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.util.Log;
import com.softwaremobility.network.Connection;
import java.util.Map;
import org.json.JSONObject;

public class NetworkConnection
implements Connection.ConnectionListener {
    @SuppressLint(value={"StaticFieldLeak"})
    private static NetworkConnection ourInstance = null;
    private static final String TAG = NetworkConnection.class.getSimpleName();
    private ResponseListener responseListener = null;
    private String PRODUCTION_PATH = null;
    private String TEST_PATH = null;
    private Context context;
    private boolean isDecodedUrl = false;

    private NetworkConnection() {
    }

    private static synchronized void createInstance() {
        if (ourInstance == null) {
            ourInstance = new NetworkConnection();
        }
    }

    private static NetworkConnection getInstance() {
        if (ourInstance == null) {
            NetworkConnection.createInstance();
        }
        return ourInstance;
    }

    public static NetworkConnection with(Context c) {
        NetworkConnection.getInstance().setContext(c);
        return NetworkConnection.getInstance();
    }

    public NetworkConnection withListener(ResponseListener listener) {
        NetworkConnection.getInstance().setResponseListener(listener);
        return NetworkConnection.getInstance();
    }

    public static NetworkConnection useDecodedUTFInUrl(boolean value) {
        NetworkConnection.getInstance().isDecodedUrl = value;
        return NetworkConnection.getInstance();
    }

    public void doRequest(Connection.REQUEST method, Uri uri, @Nullable Map<String, String> params, @Nullable Map<String, String> headers, @Nullable JSONObject jsonObject) {
        Connection connection = new Connection(this.context, uri.toString(), method, params, headers, jsonObject);
        connection.setDecodedUrlInUTF(this.isDecodedUrl);
        connection.setListener(this);
        connection.execute(new Void[0]);
    }

    public void doRequest(Connection.REQUEST method, Uri uri, @Nullable Map<String, String> params, @Nullable Map<String, String> headers, @Nullable JSONObject jsonObject, @Nullable byte[] image) {
        Connection connection = new Connection(this.context, uri.toString(), method, params, headers, jsonObject, image);
        connection.setDecodedUrlInUTF(this.isDecodedUrl);
        connection.setListener(this);
        connection.execute(new Void[0]);
    }

    private void setContext(Context context) {
        this.context = context;
    }

    private void setResponseListener(ResponseListener responseListener) {
        this.responseListener = responseListener;
    }

    public static String getProductionPath() {
        return NetworkConnection.getInstance().PRODUCTION_PATH;
    }

    public static NetworkConnection productionPath(String productionPath) {
        NetworkConnection.getInstance().PRODUCTION_PATH = productionPath;
        return NetworkConnection.getInstance();
    }

    public static String getTestPath() {
        return NetworkConnection.getInstance().TEST_PATH;
    }

    public static NetworkConnection testPath(String testPath) {
        NetworkConnection.getInstance().TEST_PATH = testPath;
        return NetworkConnection.getInstance();
    }

    @Override
    public void successfullyResponse(String JSONStr) {
        if (this.responseListener != null) {
            this.responseListener.onSuccessfullyResponse(JSONStr);
        } else {
            Log.e((String)TAG, (String)"Error: No listener for the response");
        }
    }

    @Override
    public void errorResponse(String error, String message, int codeError) {
        if (this.responseListener != null) {
            this.responseListener.onErrorResponse(error, message, codeError);
        } else {
            Log.e((String)TAG, (String)"Error: No listener for the response");
        }
    }

    public static interface ResponseListener {
        public void onSuccessfullyResponse(String var1);

        public void onErrorResponse(String var1, String var2, int var3);
    }
}

