/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremobility.network;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.support.annotation.Nullable;
import android.util.Log;
import com.softwaremobility.simplehttp.NetworkConnection;
import com.softwaremobility.utilities.MultiPartUtility;
import com.softwaremobility.utilities.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import org.json.JSONObject;

public class Connection
extends AsyncTask<Void, Void, Boolean> {
    private final String LOG_TAG = Connection.class.getSimpleName();
    private String JSONString;
    private String endpoint;
    private Map<String, String> params;
    private Map<String, String> headers;
    private JSONObject object;
    private REQUEST requestType;
    private ConnectionListener listener;
    private Context context;
    private int code;
    private String message;
    private String error;
    private byte[] image;
    private String charset = "UTF-8";
    private boolean decodedUrlInUTF = false;

    public Connection(Context context, String endpoint, REQUEST requestType, @Nullable Map<String, String> params, @Nullable Map<String, String> headers, @Nullable JSONObject object) {
        this.endpoint = endpoint;
        this.requestType = requestType;
        if (params != null) {
            this.params = params;
        }
        if (headers != null) {
            this.headers = headers;
        }
        if (object != null) {
            this.object = object;
        }
        this.context = context;
    }

    public Connection(Context context, String endpoint, REQUEST requestType, @Nullable Map<String, String> params, @Nullable Map<String, String> headers, @Nullable JSONObject object, @Nullable byte[] image) {
        this.endpoint = endpoint;
        this.requestType = requestType;
        if (params != null) {
            this.params = params;
        }
        if (headers != null) {
            this.headers = headers;
        }
        if (object != null) {
            this.object = object;
        }
        if (image != null) {
            this.image = image;
        }
        this.context = context;
    }

    public void setListener(ConnectionListener listener) {
        this.listener = listener;
    }

    public void setDecodedUrlInUTF(boolean decodedUrlInUTF) {
        this.decodedUrlInUTF = decodedUrlInUTF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doInBackground(Void ... par) {
        Boolean bl;
        HttpURLConnection urlConnection = null;
        BufferedReader reader = null;
        this.JSONString = null;
        try {
            String line;
            urlConnection = this.getStructuredRequest(this.endpoint, this.requestType, this.params, this.headers, this.object, this.image);
            assert (urlConnection != null);
            InputStream is = urlConnection.getInputStream();
            StringBuilder buffer = new StringBuilder();
            if (is == null) {
                Boolean bl2 = null;
                return bl2;
            }
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                buffer.append(line + "\n");
            }
            if (buffer.length() == 0) {
                Boolean bl3 = null;
                return bl3;
            }
            this.JSONString = buffer.toString();
            Log.d((String)this.LOG_TAG, (String)("Server Response: " + this.JSONString));
            Boolean bl4 = true;
            return bl4;
        }
        catch (FileNotFoundException e) {
            this.manageError(e, urlConnection);
            bl = false;
            return bl;
        }
        catch (IOException e) {
            this.manageError(e, urlConnection);
            bl = false;
            return bl;
        }
        catch (Exception e) {
            this.manageError(e, urlConnection);
            bl = false;
            return bl;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Log.e((String)this.LOG_TAG, (String)"Error Closing Stream", (Throwable)e);
                }
            }
        }
    }

    protected void onPostExecute(Boolean result) {
        if (result.booleanValue()) {
            if (this.listener != null) {
                this.listener.successfullyResponse(this.JSONString);
            }
        } else if (this.listener != null) {
            this.listener.errorResponse(this.error, this.message, this.code);
        }
    }

    private HttpURLConnection getStructuredRequest(String endpoint, REQUEST type, @Nullable Map<String, String> params, @Nullable Map<String, String> headers, @Nullable JSONObject object, @Nullable byte[] image) throws Exception {
        HttpURLConnection urlConnection = null;
        URL url = null;
        boolean isTest = 0 != (this.context.getApplicationInfo().flags &= 2);
        Uri.Builder builderPath = Uri.parse((String)"").buildUpon();
        if (NetworkConnection.getTestPath() != null && !NetworkConnection.getTestPath().equalsIgnoreCase("")) {
            if (isTest) {
                builderPath = Uri.parse((String)NetworkConnection.getTestPath()).buildUpon();
            } else {
                Log.e((String)this.LOG_TAG, (String)"No testing url was set");
            }
        }
        if (NetworkConnection.getProductionPath() != null && !NetworkConnection.getProductionPath().equalsIgnoreCase("")) {
            if (!isTest) {
                builderPath = Uri.parse((String)NetworkConnection.getProductionPath()).buildUpon();
            } else {
                Log.e((String)this.LOG_TAG, (String)"No production url was set");
            }
        }
        builderPath.appendPath(endpoint);
        if (type == REQUEST.GET) {
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    if (this.decodedUrlInUTF) {
                        String decode = entry.getValue();
                        decode = decode.replace(" ", "%20");
                        builderPath.appendQueryParameter(entry.getKey(), decode);
                        continue;
                    }
                    builderPath.appendQueryParameter(entry.getKey(), entry.getValue());
                }
            }
            url = new URL(this.getCompletePath(builderPath.build().toString()));
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod(type.name());
            urlConnection = this.setHeaders(urlConnection, headers);
            urlConnection.connect();
        } else if (type == REQUEST.POST) {
            url = new URL(this.getCompletePath(builderPath.build().toString()));
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod(type.name());
            urlConnection = this.setHeaders(urlConnection, headers);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            if (object != null) {
                urlConnection.connect();
                DataOutputStream dataOutputStream = new DataOutputStream(urlConnection.getOutputStream());
                dataOutputStream.write(object.toString().getBytes());
                dataOutputStream.flush();
                dataOutputStream.close();
            } else {
                Uri.Builder builder = new Uri.Builder();
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        builder.appendQueryParameter(entry.getKey(), entry.getValue());
                    }
                    String query = builder.build().getEncodedQuery();
                    OutputStream os = urlConnection.getOutputStream();
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, this.charset));
                    writer.write(query);
                    writer.flush();
                    writer.close();
                    urlConnection.connect();
                }
                if (image != null) {
                    MultiPartUtility multipart = new MultiPartUtility(urlConnection, this.charset);
                    multipart.addPhoto("image1", image);
                    urlConnection = multipart.finish();
                }
            }
        } else if (type == REQUEST.PUT) {
            url = new URL(this.getCompletePath(builderPath.build().toString()));
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod(type.name());
            urlConnection = this.setHeaders(urlConnection, headers);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            if (object != null) {
                urlConnection.connect();
                DataOutputStream dataOutputStream = new DataOutputStream(urlConnection.getOutputStream());
                dataOutputStream.write(object.toString().getBytes());
                dataOutputStream.flush();
                dataOutputStream.close();
            } else {
                Uri.Builder builder = new Uri.Builder();
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        builder.appendQueryParameter(entry.getKey(), entry.getValue());
                    }
                    String query = builder.build().getEncodedQuery();
                    OutputStream os = urlConnection.getOutputStream();
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, this.charset));
                    writer.write(query);
                    writer.flush();
                    writer.close();
                    urlConnection.connect();
                }
            }
        } else if (type == REQUEST.PATCH) {
            url = new URL(this.getCompletePath(builderPath.build().toString()));
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod(type.name());
            urlConnection = this.setHeaders(urlConnection, headers);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            if (object != null) {
                urlConnection.connect();
                DataOutputStream dataOutputStream = new DataOutputStream(urlConnection.getOutputStream());
                dataOutputStream.write(object.toString().getBytes());
                dataOutputStream.flush();
                dataOutputStream.close();
            } else {
                Uri.Builder builder = new Uri.Builder();
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        builder.appendQueryParameter(entry.getKey(), entry.getValue());
                    }
                    String query = builder.build().getEncodedQuery();
                    OutputStream os = urlConnection.getOutputStream();
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, this.charset));
                    writer.write(query);
                    writer.flush();
                    writer.close();
                    urlConnection.connect();
                }
            }
        } else if (type == REQUEST.DELETE) {
            url = new URL(this.getCompletePath(builderPath.build().toString()));
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod(type.name());
            urlConnection = this.setHeaders(urlConnection, headers);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            if (object != null) {
                urlConnection.connect();
                DataOutputStream dataOutputStream = new DataOutputStream(urlConnection.getOutputStream());
                dataOutputStream.write(object.toString().getBytes());
                dataOutputStream.flush();
                dataOutputStream.close();
            }
        }
        Log.d((String)this.LOG_TAG, (String)url.toString());
        return urlConnection;
    }

    private String getCompletePath(String path) throws UnsupportedEncodingException {
        return this.decodedUrlInUTF ? URLDecoder.decode(path, this.charset) : path;
    }

    private HttpURLConnection setHeaders(HttpURLConnection urlConnection, @Nullable Map<String, String> headers) {
        if (headers != null && urlConnection != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return urlConnection;
    }

    private void manageError(Exception e, HttpURLConnection urlConnection) {
        if (Utils.isNetworkAvailable(this.context)) {
            if (urlConnection != null) {
                try {
                    this.code = urlConnection.getResponseCode();
                    if (urlConnection.getErrorStream() != null) {
                        String line;
                        InputStream is = urlConnection.getErrorStream();
                        StringBuilder buffer = new StringBuilder();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                        while ((line = reader.readLine()) != null) {
                            buffer.append(line + "\n");
                        }
                        this.message = buffer.toString();
                    } else {
                        this.message = urlConnection.getResponseMessage();
                    }
                    this.error = urlConnection.getErrorStream().toString();
                    Log.e((String)this.LOG_TAG, (String)("Error: " + this.message + ", code: " + this.code));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    Log.e((String)this.LOG_TAG, (String)"Error");
                }
            } else {
                this.code = 105;
                this.message = "Error: No internet connection";
                Log.e((String)this.LOG_TAG, (String)("code: " + this.code + ", " + this.message));
            }
        } else {
            this.code = 105;
            this.message = "Error: No internet connection";
            Log.e((String)this.LOG_TAG, (String)("code: " + this.code + ", " + this.message));
        }
    }

    public static enum REQUEST {
        POST,
        GET,
        PUT,
        DELETE,
        PATCH;

    }

    public static interface ConnectionListener {
        public void successfullyResponse(String var1);

        public void errorResponse(String var1, String var2, int var3);
    }
}

