/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.servlet.ssm;

import com.softwarementors.extjs.djn.StringUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WebContext {
    @NonNull
    private HttpServletRequest request;
    @NonNull
    private HttpServletResponse response;
    @NonNull
    private HttpServlet servlet;
    private boolean open;

    WebContext(@NonNull WebContext context) {
        this(context.getServlet(), context.getRequest(), context.getResponse());
    }

    WebContext(HttpServlet servlet, HttpServletRequest request, HttpServletResponse response) {
        assert (servlet != null);
        assert (request != null);
        assert (response != null);
        this.servlet = servlet;
        this.request = request;
        this.response = response;
        this.open = true;
    }

    void close() {
        assert (this.isOpen());
        this.open = false;
    }

    private boolean isOpen() {
        return this.open;
    }

    public HttpServletRequest getRequest() {
        assert (this.isOpen());
        return this.request;
    }

    public HttpServletResponse getResponse() {
        assert (this.isOpen());
        return this.response;
    }

    public HttpSession getSession() {
        assert (this.isOpen());
        return this.request.getSession();
    }

    public ServletContext getServletContext() {
        assert (this.isOpen());
        return this.servlet.getServletContext();
    }

    public ServletConfig getServletConfig() {
        assert (this.isOpen());
        return this.servlet.getServletConfig();
    }

    public HttpServlet getServlet() {
        assert (this.isOpen());
        return this.servlet;
    }

    @CheckForNull
    public Object getSessionScopedObject(String actionName) {
        assert (!StringUtils.isEmpty(actionName));
        HttpSession context = this.getSession();
        String key = WebContext.getSessionScopedActionName(actionName);
        Object result = context.getAttribute(key);
        return result;
    }

    public static String getSessionScopedActionName(String actionName) {
        assert (!StringUtils.isEmpty(actionName));
        String key = "DirectJNgine.SESSION." + actionName;
        return key;
    }

    @CheckForNull
    public Object getApplicationScopedObject(String actionName) {
        assert (!StringUtils.isEmpty(actionName));
        ServletContext context = this.getServletContext();
        String key = WebContext.getApplicationScopedActionName(actionName);
        Object result = context.getAttribute(key);
        return result;
    }

    public static String getApplicationScopedActionName(String actionName) {
        assert (!StringUtils.isEmpty(actionName));
        String key = "DirectJNgine.APPLICATION." + actionName;
        return key;
    }
}

