/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.servlet;

import com.softwarementors.extjs.djn.StringBuilderUtils;
import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.servlet.ServletConfigurationException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public final class ServletUtils {
    @NonNull
    private static final Logger logger = Logger.getLogger(ServletUtils.class);

    public static String getRequiredParameter(ServletConfig conf, String parameterName) {
        assert (conf != null);
        assert (!StringUtils.isEmpty(parameterName));
        String result = conf.getInitParameter(parameterName);
        assert (!StringUtils.isEmpty(result));
        return result;
    }

    @CheckForNull
    public static String getParameter(ServletConfig conf, String parameterName, String valueIfNotSpecified) {
        assert (conf != null);
        assert (!StringUtils.isEmpty(parameterName));
        String result = conf.getInitParameter(parameterName);
        if (result != null) {
            result = result.trim();
        }
        if (StringUtils.isEmpty(result)) {
            return valueIfNotSpecified;
        }
        return result;
    }

    public static boolean getBooleanParameter(ServletConfig conf, String parameterName, boolean valueIfNotSpecified) {
        assert (conf != null);
        assert (!StringUtils.isEmpty(parameterName));
        String valueIfNotSpecifiedString = "false";
        if (valueIfNotSpecified) {
            valueIfNotSpecifiedString = "true";
        }
        String valueString = ServletUtils.getParameter(conf, parameterName, valueIfNotSpecifiedString);
        assert (valueString != null);
        boolean result = valueString.equalsIgnoreCase("true") || valueString.equals("1");
        return result;
    }

    public static int getIntParameterGreaterOrEqualToValue(ServletConfig conf, String parameterName, int minValue, int valueIfNotSpecified) {
        assert (conf != null);
        assert (!StringUtils.isEmpty(parameterName));
        assert (valueIfNotSpecified >= minValue);
        String resultString = ServletUtils.getParameter(conf, parameterName, Integer.toString(valueIfNotSpecified));
        if (StringUtils.isEmpty(resultString)) {
            return valueIfNotSpecified;
        }
        try {
            int result = Integer.parseInt(resultString);
            if (result < minValue) {
                ServletConfigurationException ex = ServletConfigurationException.forParameterMustBeAnIntegerGreaterOrEqualToValue(parameterName, result, minValue);
                logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            return result;
        }
        catch (NumberFormatException e) {
            ServletConfigurationException ex = ServletConfigurationException.forParameterMustBeAValidInteger(parameterName, resultString);
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public static void checkRequiredParameters(ServletConfig conf, String ... parameterNames) {
        assert (conf != null);
        assert (parameterNames != null);
        assert (parameterNames.length > 0);
        ArrayList<String> missingParameters = new ArrayList<String>();
        for (String parameterName : parameterNames) {
            String result = conf.getInitParameter(parameterName);
            if (!StringUtils.isEmpty(result)) continue;
            missingParameters.add("'" + parameterName + "'");
        }
        if (!missingParameters.isEmpty()) {
            ServletConfigurationException ex = ServletConfigurationException.forMissingRequiredConfigurationParameter(missingParameters);
            logger.fatal((Object)ex);
            throw ex;
        }
    }

    public static String getDetailedRequestInformation(HttpServletRequest request) {
        assert (request != null);
        String contentType = request.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        String method = request.getMethod();
        StringBuilder result = new StringBuilder();
        StringBuilderUtils.appendAll(result, "RequestType=", contentType, ", Method=", method, ", ContextPath=", request.getContextPath(), ", ServletPath=", request.getServletPath(), ", PathInfo=", request.getPathInfo(), ", QueryString=", request.getQueryString(), ", CharacterEncoding=", request.getCharacterEncoding(), ", AuthType=", request.getAuthType(), ", ContentType=", request.getContentType(), ", Scheme=", request.getScheme(), ", Locale=", request.getLocale().toString(), ". ");
        result.append("Headers: ");
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            StringBuilderUtils.appendAll(result, "'", headerName, "'=");
            Enumeration headerContent = request.getHeaders(headerName);
            while (headerContent.hasMoreElements()) {
                String headerValue = (String)headerContent.nextElement();
                result.append(headerValue);
                result.append(", ");
            }
        }
        return result.toString();
    }
}

