/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.servlet;

import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.Timer;
import com.softwarementors.extjs.djn.api.Registry;
import com.softwarementors.extjs.djn.config.ApiConfiguration;
import com.softwarementors.extjs.djn.config.GlobalConfiguration;
import com.softwarementors.extjs.djn.gson.GsonBuilderConfigurator;
import com.softwarementors.extjs.djn.jscodegen.CodeFileGenerator;
import com.softwarementors.extjs.djn.router.RequestRouter;
import com.softwarementors.extjs.djn.router.RequestType;
import com.softwarementors.extjs.djn.router.dispatcher.Dispatcher;
import com.softwarementors.extjs.djn.router.dispatcher.DispatcherConfigurationException;
import com.softwarementors.extjs.djn.router.processor.RequestException;
import com.softwarementors.extjs.djn.router.processor.standard.form.upload.UploadFormPostRequestProcessor;
import com.softwarementors.extjs.djn.router.processor.standard.json.JsonRequestProcessorThread;
import com.softwarementors.extjs.djn.scanner.Scanner;
import com.softwarementors.extjs.djn.servlet.ServletConfigurationException;
import com.softwarementors.extjs.djn.servlet.ServletRegistryConfigurator;
import com.softwarementors.extjs.djn.servlet.ServletUtils;
import com.softwarementors.extjs.djn.servlet.config.RegistryConfigurationException;
import com.softwarementors.extjs.djn.servlet.ssm.SsmDispatcher;
import com.softwarementors.extjs.djn.servlet.ssm.SsmJsonRequestProcessorThread;
import com.softwarementors.extjs.djn.servlet.ssm.WebContextManager;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectJNgineServlet
extends HttpServlet {
    private static final long serialVersionUID = -5621879599626932408L;
    @NonNull
    private static final Logger logger = Logger.getLogger(DirectJNgineServlet.class);
    private static final String VALUES_SEPARATOR = ",";
    public static final String REGISTRY_CONFIGURATOR_CLASS = "registryConfiguratorClass";
    @NonNull
    private static Map<String, RequestRouter> processors = new HashMap<String, RequestRouter>();
    @NonNull
    private static Map<String, ServletFileUpload> uploaders = new HashMap<String, ServletFileUpload>();
    private static long id = 1000L;

    protected RequestRouter getProcessor() {
        assert (processors.containsKey(this.getServletName()));
        return processors.get(this.getServletName());
    }

    protected ServletFileUpload getUploader() {
        assert (uploaders.containsKey(this.getServletName()));
        return uploaders.get(this.getServletName());
    }

    private static synchronized long getUniqueRequestId() {
        return id++;
    }

    public void init(ServletConfig configuration) throws ServletException {
        assert (configuration != null);
        super.init(configuration);
        Timer timer = new Timer();
        this.createDirectJNgineRouter(configuration);
        timer.stop();
        timer.logDebugTimeInMilliseconds("Djn initialization: total DirectJNgine initialization time");
    }

    protected void createDirectJNgineRouter(ServletConfig configuration) throws ServletException {
        assert (configuration != null);
        Timer subtaskTimer = new Timer();
        GlobalConfiguration globalConfiguration = this.createGlobalConfiguration(configuration);
        String registryConfiguratorClassName = ServletUtils.getParameter(configuration, REGISTRY_CONFIGURATOR_CLASS, null);
        if (logger.isInfoEnabled()) {
            String value = registryConfiguratorClassName;
            if (value == null) {
                value = "";
            }
            logger.info((Object)("Servlet GLOBAL configuration: registryConfiguratorClass=" + value));
        }
        Class<? extends ServletRegistryConfigurator> registryConfiguratorClass = DirectJNgineServlet.getRegistryConfiguratorClass(registryConfiguratorClassName);
        List<ApiConfiguration> apiConfigurations = this.createApiConfigurationsFromServletConfigurationApi(configuration);
        subtaskTimer.stop();
        subtaskTimer.logDebugTimeInMilliseconds("Djn initialization: Servlet Configuration Load time");
        subtaskTimer.restart();
        Registry registry = new Registry(globalConfiguration);
        Scanner scanner = new Scanner(registry);
        scanner.scanAndRegisterApiConfigurations(apiConfigurations);
        subtaskTimer.stop();
        subtaskTimer.logDebugTimeInMilliseconds("Djn initialization: Standard Api processing time");
        if (registryConfiguratorClass != null) {
            subtaskTimer.restart();
            this.performCustomRegistryConfiguration(registryConfiguratorClass, registry, configuration);
            subtaskTimer.stop();
            subtaskTimer.logDebugTimeInMilliseconds("Djn initialization: Custom Registry processing time");
        }
        subtaskTimer.restart();
        try {
            CodeFileGenerator.updateSource(registry, globalConfiguration.getCreateSourceFiles());
            subtaskTimer.stop();
            subtaskTimer.logDebugTimeInMilliseconds("Djn initialization: Api Files creation time");
        }
        catch (IOException ex) {
            ServletException e = new ServletException("Unable to create DirectJNgine API files", (Throwable)ex);
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        subtaskTimer.restart();
        this.initializeRouter(globalConfiguration, registry);
        subtaskTimer.stop();
        subtaskTimer.logDebugTimeInMilliseconds("Djn initialization: Request Processor initialization time");
    }

    private void initializeRouter(GlobalConfiguration globalConfiguration, Registry registry) {
        String servletName = this.getServletName();
        uploaders.put(servletName, UploadFormPostRequestProcessor.createFileUploader());
        processors.put(servletName, this.createRequestRouter(registry, globalConfiguration));
    }

    protected RequestRouter createRequestRouter(Registry registry, GlobalConfiguration globalConfiguration) {
        assert (registry != null);
        assert (globalConfiguration != null);
        return new RequestRouter(registry, globalConfiguration, this.createDispatcher(globalConfiguration.getDispatcherClass()));
    }

    protected Dispatcher createDispatcher(Class<? extends Dispatcher> cls) {
        assert (cls != null);
        try {
            return cls.newInstance();
        }
        catch (InstantiationException e) {
            DispatcherConfigurationException ex = DispatcherConfigurationException.forUnableToInstantiateDispatcher(cls, e);
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (IllegalAccessException e) {
            DispatcherConfigurationException ex = DispatcherConfigurationException.forUnableToInstantiateDispatcher(cls, e);
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    protected void performCustomRegistryConfiguration(Class<? extends ServletRegistryConfigurator> configuratorClass, Registry registry, ServletConfig config) {
        ServletRegistryConfigurator registryConfigurator = DirectJNgineServlet.createCustomRegistryConfigurator(configuratorClass);
        registryConfigurator.configure(registry, config);
    }

    private static ServletRegistryConfigurator createCustomRegistryConfigurator(Class<? extends ServletRegistryConfigurator> configuratorClass) {
        assert (configuratorClass != null);
        try {
            return configuratorClass.newInstance();
        }
        catch (InstantiationException e) {
            RegistryConfigurationException ex = RegistryConfigurationException.forUnableToInstantiateRegistryConfigurator(configuratorClass, e);
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (IllegalAccessException e) {
            RegistryConfigurationException ex = RegistryConfigurationException.forUnableToInstantiateRegistryConfigurator(configuratorClass, e);
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    protected GlobalConfiguration createGlobalConfiguration(ServletConfig configuration) {
        assert (configuration != null);
        ServletUtils.checkRequiredParameters(configuration, "providersUrl");
        boolean isDebug = ServletUtils.getBooleanParameter(configuration, "debug", false);
        String providersUrl = ServletUtils.getRequiredParameter(configuration, "providersUrl");
        String gsonConfiguratorClassName = ServletUtils.getParameter(configuration, "gsonBuilderConfiguratorClass", GlobalConfiguration.DEFAULT_GSON_BUILDER_CONFIGURATOR_CLASS.getName());
        String dispatcherClassName = ServletUtils.getParameter(configuration, "dispatcherClass", DirectJNgineServlet.getDefaultDispatcherClass().getName());
        String jsonRequestProcessorThreadClassName = ServletUtils.getParameter(configuration, "jsonRequestProcessorThreadClass", DirectJNgineServlet.getDefaultJsonRequestProcessoThreadClass().getName());
        boolean isBatchRequestsMultithreadingEnabled = ServletUtils.getBooleanParameter(configuration, "batchRequestsMultithreadingEnabled", true);
        boolean minifyEnabled = ServletUtils.getBooleanParameter(configuration, "minify", true);
        int batchRequestsMinThreadsPoolSize = ServletUtils.getIntParameterGreaterOrEqualToValue(configuration, "batchRequestsMinThreadsPoolSize", 0, 16);
        int batchRequestsMaxThreadsPoolSize = ServletUtils.getIntParameterGreaterOrEqualToValue(configuration, "batchRequestsMaxThreadsPoolSize", 1, 80);
        int batchRequestsThreadKeepAliveSeconds = ServletUtils.getIntParameterGreaterOrEqualToValue(configuration, "batchRequestsMaxThreadKeepAliveSeconds", 0, 60);
        int batchRequestsMaxThreadsPerRequest = ServletUtils.getIntParameterGreaterOrEqualToValue(configuration, "batchRequestsMaxThreadsPerRequest", 1, 8);
        String contextPath = configuration.getInitParameter("contextPath");
        boolean createSourceFiles = ServletUtils.getBooleanParameter(configuration, "createSourceFiles", true);
        if (batchRequestsMinThreadsPoolSize > batchRequestsMaxThreadsPoolSize) {
            ServletConfigurationException ex = ServletConfigurationException.forMaxThreadPoolSizeMustBeEqualOrGreaterThanMinThreadPoolSize(batchRequestsMinThreadsPoolSize, batchRequestsMaxThreadsPoolSize);
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        if (logger.isInfoEnabled()) {
            String contextPathInfo = contextPath;
            if (contextPathInfo == null) {
                contextPathInfo = "--not specified: calculated via Javascript--";
            }
            logger.info((Object)("Servlet GLOBAL configuration: debug=" + isDebug + ", " + "providersUrl" + "=" + providersUrl + ", " + "minify" + "=" + minifyEnabled + ", " + "batchRequestsMultithreadingEnabled" + "=" + isBatchRequestsMultithreadingEnabled + ", " + "batchRequestsMinThreadsPoolSize" + "=" + batchRequestsMinThreadsPoolSize + ", " + "batchRequestsMaxThreadsPoolSize" + "=" + batchRequestsMaxThreadsPoolSize + ", " + "batchRequestsMaxThreadsPerRequest" + "=" + batchRequestsMaxThreadsPerRequest + ", " + "batchRequestsMaxThreadKeepAliveSeconds" + "=" + batchRequestsThreadKeepAliveSeconds + ", " + "gsonBuilderConfiguratorClass" + "=" + gsonConfiguratorClassName + ", " + "dispatcherClass" + "=" + dispatcherClassName + ", " + "jsonRequestProcessorThreadClass" + "=" + jsonRequestProcessorThreadClassName + ", " + "contextPath" + "=" + contextPathInfo + ", " + "createSourceFiles" + "=" + createSourceFiles));
        }
        Class<? extends GsonBuilderConfigurator> gsonConfiguratorClass = DirectJNgineServlet.getGsonBuilderConfiguratorClass(gsonConfiguratorClassName);
        Class<? extends Dispatcher> dispatcherClass = DirectJNgineServlet.getDispatcherClass(dispatcherClassName);
        Class<? extends JsonRequestProcessorThread> jsonRequestProcessorClass = DirectJNgineServlet.getJsonRequestProcessorThreadClass(jsonRequestProcessorThreadClassName);
        GlobalConfiguration result = new GlobalConfiguration(contextPath, providersUrl, isDebug, gsonConfiguratorClass, jsonRequestProcessorClass, dispatcherClass, minifyEnabled, isBatchRequestsMultithreadingEnabled, batchRequestsMinThreadsPoolSize, batchRequestsMaxThreadsPoolSize, batchRequestsThreadKeepAliveSeconds, batchRequestsMaxThreadsPerRequest, createSourceFiles);
        return result;
    }

    private static Class<? extends JsonRequestProcessorThread> getDefaultJsonRequestProcessoThreadClass() {
        return SsmJsonRequestProcessorThread.class;
    }

    private static Class<? extends Dispatcher> getDefaultDispatcherClass() {
        return SsmDispatcher.class;
    }

    private static Class<? extends GsonBuilderConfigurator> getGsonBuilderConfiguratorClass(String gsonConfiguratorClassName) {
        assert (!StringUtils.isEmpty(gsonConfiguratorClassName));
        try {
            Class<?> configuratorClass = Class.forName(gsonConfiguratorClassName);
            if (!GsonBuilderConfigurator.class.isAssignableFrom(configuratorClass)) {
                ServletConfigurationException ex = ServletConfigurationException.forGsonBuilderConfiguratorMustImplementGsonBuilderConfiguratorInterface(gsonConfiguratorClassName);
                logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            return configuratorClass;
        }
        catch (ClassNotFoundException ex) {
            ServletConfigurationException e = ServletConfigurationException.forClassNotFound(gsonConfiguratorClassName, ex);
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private static Class<? extends Dispatcher> getDispatcherClass(String dispatcherClassName) {
        assert (!StringUtils.isEmpty(dispatcherClassName));
        try {
            Class<?> configuratorClass = Class.forName(dispatcherClassName);
            if (!Dispatcher.class.isAssignableFrom(configuratorClass)) {
                ServletConfigurationException ex = ServletConfigurationException.forDispatcherMustImplementDispatcherInterface(dispatcherClassName);
                logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            return configuratorClass;
        }
        catch (ClassNotFoundException ex) {
            ServletConfigurationException e = ServletConfigurationException.forClassNotFound(dispatcherClassName, ex);
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private static Class<? extends JsonRequestProcessorThread> getJsonRequestProcessorThreadClass(String jsonRequestProcessorThreadClassName) {
        assert (!StringUtils.isEmpty(jsonRequestProcessorThreadClassName));
        try {
            Class<?> cls = Class.forName(jsonRequestProcessorThreadClassName);
            if (!JsonRequestProcessorThread.class.isAssignableFrom(cls)) {
                ServletConfigurationException ex = ServletConfigurationException.forJsonRequestProcessorThreadMustImplementJsonRequestProcessorThreadInterface(jsonRequestProcessorThreadClassName);
                logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            return cls;
        }
        catch (ClassNotFoundException ex) {
            ServletConfigurationException e = ServletConfigurationException.forClassNotFound(jsonRequestProcessorThreadClassName, ex);
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @CheckForNull
    private static Class<? extends ServletRegistryConfigurator> getRegistryConfiguratorClass(String registryConfiguratorClassName) {
        if (StringUtils.isEmpty(registryConfiguratorClassName)) {
            return null;
        }
        try {
            Class<?> configuratorClass = Class.forName(registryConfiguratorClassName);
            if (!ServletRegistryConfigurator.class.isAssignableFrom(configuratorClass)) {
                ServletConfigurationException ex = ServletConfigurationException.forRegistryConfiguratorMustImplementGsonBuilderConfiguratorInterface(registryConfiguratorClassName);
                logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            return configuratorClass;
        }
        catch (ClassNotFoundException ex) {
            ServletConfigurationException e = ServletConfigurationException.forClassNotFound(registryConfiguratorClassName, ex);
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected List<ApiConfiguration> createApiConfigurationsFromServletConfigurationApi(ServletConfig configuration) {
        assert (configuration != null);
        ArrayList<ApiConfiguration> result = new ArrayList<ApiConfiguration>();
        String apisParameter = ServletUtils.getRequiredParameter(configuration, "apis");
        List<String> apis = StringUtils.getNonBlankValues(apisParameter, VALUES_SEPARATOR);
        logger.info((Object)("Servlet APIs configuration: apis=" + apisParameter));
        for (String api : apis) {
            ApiConfiguration apiConfiguration = this.createApiConfigurationFromServletConfigurationApi(configuration, api);
            result.add(apiConfiguration);
        }
        if (result.isEmpty()) {
            logger.warn((Object)"No apis specified");
        }
        return result;
    }

    private ApiConfiguration createApiConfigurationFromServletConfigurationApi(ServletConfig configuration, String api) {
        assert (configuration != null);
        assert (!StringUtils.isEmpty(api));
        String apiFile = ServletUtils.getParameter(configuration, api + "." + "apiFile", api + "-api.js");
        String fullGeneratedApiFile = this.getServletContext().getRealPath(apiFile);
        String apiNamespace = ServletUtils.getParameter(configuration, api + "." + "apiNamespace", "");
        assert (apiNamespace != null);
        String actionsNamespace = ServletUtils.getParameter(configuration, api + "." + "actionsNamespace", "");
        if (apiNamespace.equals("")) {
            if (actionsNamespace.equals("")) {
                apiNamespace = "Djn." + api;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Using the api name, prefixed with 'Djn.' as the value for apiNamespace");
                }
            } else {
                apiNamespace = actionsNamespace;
                logger.debug((Object)"Using actionsNamespace as the value for apiNamespace");
            }
        }
        String classNames = ServletUtils.getParameter(configuration, api + "." + "classes", "");
        List<Class<?>> classes = DirectJNgineServlet.getClasses(classNames);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Servlet '" + api + "' Api configuration: " + "apiNamespace" + "=" + apiNamespace + ", " + "actionsNamespace" + "=" + actionsNamespace + ", " + "apiFile" + "=" + apiFile + " => Full api file: " + fullGeneratedApiFile + ", " + "classes" + "=" + classNames));
        }
        if (classes.isEmpty()) {
            logger.warn((Object)("There are no action classes to register for api '" + api + "'"));
        }
        ApiConfiguration apiConfiguration = new ApiConfiguration(api, apiFile, fullGeneratedApiFile, apiNamespace, actionsNamespace, classes);
        return apiConfiguration;
    }

    private static List<Class<?>> getClasses(String classes) {
        assert (classes != null);
        ArrayList result = new ArrayList();
        if (StringUtils.isEmpty(classes)) {
            return result;
        }
        List<String> classNames = StringUtils.getNonBlankValues(classes, VALUES_SEPARATOR);
        for (String className : classNames) {
            try {
                Class<?> cls = Class.forName(className);
                result.add(cls);
            }
            catch (ClassNotFoundException ex) {
                logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                ServletConfigurationException e = ServletConfigurationException.forClassNotFound(className, ex);
                throw e;
            }
        }
        return result;
    }

    private static RequestType getFromRequestContentType(HttpServletRequest request) {
        assert (request != null);
        String contentType = request.getContentType();
        String pathInfo = request.getPathInfo();
        if (!StringUtils.isEmpty(pathInfo) && pathInfo.startsWith("/poll/")) {
            return RequestType.POLL;
        }
        if (StringUtils.startsWithCaseInsensitive(contentType, "application/json")) {
            return RequestType.JSON;
        }
        if (StringUtils.startsWithCaseInsensitive(contentType, "application/x-www-form-urlencoded") && request.getMethod().equalsIgnoreCase("post")) {
            return RequestType.FORM_SIMPLE_POST;
        }
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return RequestType.FORM_UPLOAD_POST;
        }
        if (RequestRouter.isSourceRequest(pathInfo)) {
            return RequestType.SOURCE;
        }
        String requestInfo = ServletUtils.getDetailedRequestInformation(request);
        RequestException ex = RequestException.forRequestFormatNotRecognized();
        logger.error((Object)("Error during file uploader: " + ex.getMessage() + "\nAdditional request information: " + requestInfo), (Throwable)ex);
        throw ex;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        assert (request != null);
        assert (response != null);
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        assert (request != null);
        assert (response != null);
        NDC.push((String)("rid=" + Long.toString(DirectJNgineServlet.getUniqueRequestId())));
        try {
            Timer timer = new Timer();
            try {
                this.attachThreadLocalData(request, response);
                try {
                    String requestEncoding;
                    if (logger.isTraceEnabled()) {
                        String requestInfo = ServletUtils.getDetailedRequestInformation(request);
                        logger.trace((Object)("Request info: " + requestInfo));
                    }
                    if (StringUtils.isEmpty(requestEncoding = request.getCharacterEncoding())) {
                        request.setCharacterEncoding("UTF-8");
                    }
                    response.setCharacterEncoding("UTF-8");
                    RequestType type = DirectJNgineServlet.getFromRequestContentType(request);
                    this.processRequest(request, response, type);
                }
                finally {
                    this.detachThreadLocalData();
                }
            }
            finally {
                timer.stop();
                timer.logDebugTimeInMilliseconds("Total servlet processing time");
            }
        }
        finally {
            NDC.pop();
        }
    }

    @SuppressWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="Missing a 'default' branch is not a problem with enums, given the appropriate compiler settings")
    private void processRequest(HttpServletRequest request, HttpServletResponse response, RequestType type) throws IOException {
        String JSON_CONTENT_TYPE = "application/json";
        String JAVASCRIPT_CONTENT_TYPE = "text/javascript";
        String HTML_CONTENT_TYPE = "text/html";
        RequestRouter processor = this.getProcessor();
        switch (type) {
            case FORM_SIMPLE_POST: {
                response.setContentType("application/json");
                processor.processSimpleFormPostRequest(request.getReader(), response.getWriter());
                break;
            }
            case FORM_UPLOAD_POST: {
                response.setContentType("text/html");
                this.processUploadFormPost(request, response);
                break;
            }
            case JSON: {
                response.setContentType("application/json");
                processor.processJsonRequest(request.getReader(), response.getWriter());
                break;
            }
            case POLL: {
                response.setContentType("application/json");
                processor.processPollRequest(request.getReader(), response.getWriter(), request.getPathInfo());
                break;
            }
            case SOURCE: {
                response.setContentType("text/javascript");
                processor.processSourceRequest(request.getReader(), response.getWriter(), request.getPathInfo());
            }
        }
    }

    protected void attachThreadLocalData(HttpServletRequest request, HttpServletResponse response) {
        WebContextManager.initializeWebContextForCurrentThread(this, request, response);
    }

    protected void detachThreadLocalData() {
        WebContextManager.detachFromCurrentThread();
    }

    private void processUploadFormPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        assert (request != null);
        assert (response != null);
        RequestRouter router = this.getProcessor();
        UploadFormPostRequestProcessor processor = router.createUploadFromProcessor();
        try {
            router.processUploadFormPostRequest(processor, this.getFileItems(request), response.getWriter());
        }
        catch (FileUploadException e) {
            processor.handleFileUploadException(e);
        }
    }

    private List<FileItem> getFileItems(HttpServletRequest request) throws FileUploadException {
        assert (request != null);
        ServletFileUpload uploader = this.getUploader();
        return uploader.parseRequest(request);
    }

    public static class ApiParameters {
        @NonNull
        public static final String API_FILE = "apiFile";
        @NonNull
        public static final String API_NAMESPACE = "apiNamespace";
        @NonNull
        public static final String ACTIONS_NAMESPACE = "actionsNamespace";
        @NonNull
        public static final String CLASSES = "classes";
    }

    public static class GlobalParameters {
        @NonNull
        public static final String PROVIDERS_URL = "providersUrl";
        @NonNull
        public static final String DEBUG = "debug";
        @NonNull
        private static final String APIS_PARAMETER = "apis";
        @NonNull
        private static final String MINIFY = "minify";
        @NonNull
        public static final String BATCH_REQUESTS_MULTITHREADING_ENABLED = "batchRequestsMultithreadingEnabled";
        @NonNull
        public static final String BATCH_REQUESTS_MIN_THREADS_POOOL_SIZE = "batchRequestsMinThreadsPoolSize";
        @NonNull
        public static final String BATCH_REQUESTS_MAX_THREADS_POOOL_SIZE = "batchRequestsMaxThreadsPoolSize";
        @NonNull
        public static final String BATCH_REQUESTS_THREAD_KEEP_ALIVE_SECONDS = "batchRequestsMaxThreadKeepAliveSeconds";
        @NonNull
        public static final String BATCH_REQUESTS_MAX_THREADS_PER_REQUEST = "batchRequestsMaxThreadsPerRequest";
        @NonNull
        public static final String GSON_BUILDER_CONFIGURATOR_CLASS = "gsonBuilderConfiguratorClass";
        @NonNull
        public static final String DISPATCHER_CLASS = "dispatcherClass";
        @NonNull
        public static final String JSON_REQUEST_PROCESSOR_THREAD_CLASS = "jsonRequestProcessorThreadClass";
        @NonNull
        public static final String CONTEXT_PATH = "contextPath";
        @NonNull
        public static final String CREATE_SOURCE_FILES = "createSourceFiles";
    }
}

