/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.scanner;

import com.softwarementors.extjs.djn.ClassUtils;
import com.softwarementors.extjs.djn.api.RegisteredAction;
import com.softwarementors.extjs.djn.api.RegisteredApi;
import com.softwarementors.extjs.djn.api.RegisteredPollMethod;
import com.softwarementors.extjs.djn.api.RegisteredStandardMethod;
import com.softwarementors.extjs.djn.api.Registry;
import com.softwarementors.extjs.djn.config.ApiConfiguration;
import com.softwarementors.extjs.djn.config.ApiConfigurationException;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectFormPostMethod;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import com.softwarementors.extjs.djn.config.annotations.DirectPollMethod;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner {
    @NonNull
    private static final Logger logger = Logger.getLogger(Scanner.class);
    @NonNull
    private Registry registry;
    private static final String POLL_METHOD_NAME_PREFIX = "djnpoll_";
    private static final String FORM_POST_METHOD_NAME_PREFIX = "djnform_";
    private static final String STANDARD_METHOD_NAME_PREFIX = "djn_";

    public Scanner(Registry registry) {
        assert (registry != null);
        this.registry = registry;
    }

    public void scanAndRegisterApiConfigurations(List<ApiConfiguration> apiConfigurations) {
        assert (apiConfigurations != null);
        for (ApiConfiguration api : apiConfigurations) {
            this.scanAndRegisterApiConfiguration(api);
        }
    }

    void scanAndRegisterApiConfiguration(ApiConfiguration api) {
        assert (api != null);
        if (this.registry.hasApi(api.getName())) {
            ApiConfigurationException ex = ApiConfigurationException.forApiAlreadyRegistered(api.getName());
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        RegisteredApi registeredApi = this.registry.addApi(api.getName(), api.getApiFile(), api.getFullApiFileName(), api.getApiNamespace(), api.getActionsNamespace());
        List<Class<?>> actionClasses = api.getClasses();
        for (Class<?> cls : actionClasses) {
            assert (cls != null);
            this.scanAndRegisterActionClass(registeredApi, cls);
        }
    }

    public void scanAndRegisterActionClass(RegisteredApi api, Class<?> actionClass) {
        assert (api != null);
        assert (actionClass != null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scanning Java class: " + actionClass.getName()));
        }
        List<RegisteredAction> actions = this.createActionsFromJavaClass(api, actionClass);
        this.scanAndRegisterActionClass(actions);
    }

    private List<RegisteredAction> createActionsFromJavaClass(RegisteredApi api, Class<?> actionClass) {
        assert (api != null);
        assert (actionClass != null);
        DirectAction actionAnnotation = actionClass.getAnnotation(DirectAction.class);
        ArrayList<String> actionNames = new ArrayList<String>();
        if (actionAnnotation != null) {
            Collections.addAll(actionNames, actionAnnotation.action());
        }
        if (actionNames.isEmpty()) {
            actionNames.add(ClassUtils.getSimpleName(actionClass));
        }
        ArrayList<RegisteredAction> actions = new ArrayList<RegisteredAction>();
        for (String actionName : actionNames) {
            if (this.registry.hasAction(actionName)) {
                RegisteredAction existingAction = this.registry.getAction(actionName);
                ApiConfigurationException ex = ApiConfigurationException.forActionAlreadyRegistered(actionName, actionClass, existingAction.getActionClass());
                logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            RegisteredAction action = api.addAction(actionClass, actionName);
            actions.add(action);
        }
        return actions;
    }

    private void scanAndRegisterActionClass(List<RegisteredAction> actions) {
        assert (actions != null);
        assert (!actions.isEmpty());
        RegisteredAction actionTemplate = actions.get(0);
        ArrayList allMethods = new ArrayList();
        for (Class<?> cls = actionTemplate.getActionClass(); cls != null; cls = cls.getSuperclass()) {
            Method[] methods = cls.getDeclaredMethods();
            Collections.addAll(allMethods, methods);
        }
        for (Method method : allMethods) {
            ApiConfigurationException ex;
            DirectPollMethod pollMethodAnnotation;
            boolean isPollMethod;
            DirectFormPostMethod postMethodAnnotation;
            boolean isFormPostMethod;
            boolean isStandardMethod;
            DirectMethod methodAnnotation = method.getAnnotation(DirectMethod.class);
            boolean bl = isStandardMethod = methodAnnotation != null;
            if (!isStandardMethod) {
                isStandardMethod = method.getName().startsWith(STANDARD_METHOD_NAME_PREFIX);
            }
            boolean bl2 = isFormPostMethod = (postMethodAnnotation = method.getAnnotation(DirectFormPostMethod.class)) != null;
            if (!isFormPostMethod) {
                isFormPostMethod = method.getName().startsWith(FORM_POST_METHOD_NAME_PREFIX);
            }
            boolean bl3 = isPollMethod = (pollMethodAnnotation = method.getAnnotation(DirectPollMethod.class)) != null;
            if (!isPollMethod) {
                isPollMethod = method.getName().startsWith(POLL_METHOD_NAME_PREFIX);
            }
            if (isStandardMethod && isFormPostMethod) {
                ex = ApiConfigurationException.forMethodCantBeStandardAndFormPostMethodAtTheSameTime(actionTemplate, method);
                logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            if ((methodAnnotation != null || postMethodAnnotation != null) && isPollMethod) {
                ex = ApiConfigurationException.forPollMethodCantBeStandardOrFormPostMethodAtTheSameTime(actionTemplate, method);
                logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            if (isStandardMethod || isFormPostMethod) {
                ApiConfigurationException ex2;
                String methodName = "";
                methodName = isStandardMethod ? Scanner.getStandardMethodName(method, methodAnnotation) : Scanner.getFormPostMethodName(method, postMethodAnnotation);
                if (actionTemplate.hasStandardMethod(methodName)) {
                    ex2 = ApiConfigurationException.forMethodAlreadyRegisteredInAction(methodName, actionTemplate.getName());
                    logger.fatal((Object)ex2.getMessage(), (Throwable)ex2);
                    throw ex2;
                }
                if (isFormPostMethod && !RegisteredStandardMethod.isValidFormHandlingMethod(method)) {
                    ex2 = ApiConfigurationException.forMethodHasWrongParametersForAFormHandler(actionTemplate.getName(), methodName);
                    logger.fatal((Object)ex2.getMessage(), (Throwable)ex2);
                    throw ex2;
                }
                for (RegisteredAction actionToRegister : actions) {
                    actionToRegister.addStandardMethod(methodName, method, isFormPostMethod);
                }
            }
            if (!isPollMethod) continue;
            for (RegisteredAction actionToRegister : actions) {
                this.createPollMethod(actionToRegister, method, pollMethodAnnotation);
            }
        }
    }

    private static String getFormPostMethodName(Method method, DirectFormPostMethod postMethodAnnotation) {
        String methodName = "";
        if (postMethodAnnotation != null) {
            methodName = postMethodAnnotation.method();
        }
        if (methodName.equals("")) {
            methodName = method.getName();
        }
        if (methodName.startsWith(FORM_POST_METHOD_NAME_PREFIX)) {
            methodName = method.getName().substring(FORM_POST_METHOD_NAME_PREFIX.length());
        }
        return methodName;
    }

    private static String getStandardMethodName(Method method, DirectMethod methodAnnotation) {
        String methodName = "";
        if (methodAnnotation != null) {
            methodName = methodAnnotation.method();
        }
        if (methodName.equals("")) {
            methodName = method.getName();
        }
        if (methodName.startsWith(STANDARD_METHOD_NAME_PREFIX)) {
            methodName = method.getName().substring(STANDARD_METHOD_NAME_PREFIX.length());
        }
        return methodName;
    }

    private RegisteredPollMethod createPollMethod(RegisteredAction action, Method method, DirectPollMethod pollMethodAnnotation) {
        assert (action != null);
        assert (method != null);
        String eventName = Scanner.getEventName(method, pollMethodAnnotation);
        if (this.registry.hasPollMethod(eventName)) {
            ApiConfigurationException ex = ApiConfigurationException.forPollEventAlreadyRegistered(eventName);
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        if (!RegisteredPollMethod.isValidPollMethod(method)) {
            ApiConfigurationException ex = ApiConfigurationException.forMethodHasWrongParametersForAPollHandler(method);
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        RegisteredPollMethod poll = action.addPollMethod(eventName, method);
        return poll;
    }

    private static String getEventName(Method method, DirectPollMethod pollMethodAnnotation) {
        assert (method != null);
        String eventName = "";
        if (pollMethodAnnotation != null) {
            eventName = pollMethodAnnotation.event();
        }
        if (eventName.equals("")) {
            eventName = method.getName();
        }
        if (eventName.startsWith(POLL_METHOD_NAME_PREFIX)) {
            eventName = method.getName().substring(POLL_METHOD_NAME_PREFIX.length());
        }
        return eventName;
    }
}

