/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.router.processor;

import com.softwarementors.extjs.djn.ExceptionUtils;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.List;

class ServerExceptionInformation {
    ExceptionInformation rootException;
    ExceptionInformation exception;
    List<ExceptionInformation> exceptions = new ArrayList<ExceptionInformation>();

    ServerExceptionInformation(Throwable t, boolean debugOn) {
        assert (t != null);
        List<Throwable> exceptions = ExceptionUtils.getRelevantExceptions(t);
        for (Throwable e : exceptions) {
            this.exceptions.add(ExceptionInformation.create(e, debugOn));
        }
        this.exception = this.exceptions.get(0);
        this.rootException = this.exceptions.get(this.exceptions.size() - 1);
    }

    static class ExceptionInformation {
        @SuppressWarnings(value={"URF_UNREAD_FIELD"}, justification="Passed to JSON side only")
        String type;
        @SuppressWarnings(value={"URF_UNREAD_FIELD"}, justification="Passed to JSON side only")
        String message;
        @SuppressWarnings(value={"URF_UNREAD_FIELD"}, justification="Passed to JSON side only")
        String where;

        private ExceptionInformation() {
        }

        private static ExceptionInformation create(Throwable e, boolean debugOn) {
            assert (e != null);
            ExceptionInformation result = new ExceptionInformation();
            result.type = e.getClass().getName();
            result.message = e.getMessage();
            result.where = ExceptionUtils.getExceptionWhere(e, debugOn);
            return result;
        }
    }
}

