/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.router.dispatcher;

import com.softwarementors.extjs.djn.ClassUtils;
import com.softwarementors.extjs.djn.Timer;
import com.softwarementors.extjs.djn.api.RegisteredMethod;
import com.softwarementors.extjs.djn.router.dispatcher.Dispatcher;
import com.softwarementors.extjs.djn.router.dispatcher.MethodExecutionException;
import com.softwarementors.extjs.djn.router.processor.RequestException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class DispatcherBase
implements Dispatcher {
    public Object dispatch(RegisteredMethod method, Object[] parameters) {
        assert (method != null);
        assert (parameters != null);
        Method javaMethod = method.getMethod();
        int expectedArgumentCount = method.getParameterCount();
        if (parameters.length != expectedArgumentCount) {
            throw RequestException.forWrongMethodArgumentCount(method, parameters.length);
        }
        Timer timer = new Timer();
        try {
            Object actionInstance = null;
            try {
                actionInstance = this.getInvokeInstance(method);
            }
            catch (Exception e) {
                throw MethodExecutionException.forUnableToGetActionInstance(method, e);
            }
            try {
                Object result;
                Object object = result = this.invokeMethod(method, actionInstance, parameters);
                return object;
            }
            catch (Exception e) {
                throw MethodExecutionException.forJavaMethodInvocationError(method, e);
            }
        }
        finally {
            timer.stop();
            if (Timer.logger.isDebugEnabled()) {
                timer.logDebugTimeInMilliseconds("  - Java method dispatch time (" + ClassUtils.getSimpleName(javaMethod.getDeclaringClass()) + "." + method.getName() + ")");
            }
        }
    }

    @CheckForNull
    private Object getInvokeInstance(RegisteredMethod method) throws Exception {
        Object actionInstance = null;
        if (!Modifier.isStatic(method.getMethod().getModifiers())) {
            actionInstance = this.getInvokeInstanceForNonStaticMethod(method);
            assert (actionInstance != null);
        }
        return actionInstance;
    }

    protected abstract Object getInvokeInstanceForNonStaticMethod(RegisteredMethod var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createInvokeInstanceForMethodWithDefaultConstructor(RegisteredMethod method) throws Exception {
        Object methodInstance;
        assert (method != null);
        Class<?> instanceClass = method.getActionClass();
        Constructor<?> c = instanceClass.getConstructor(new Class[0]);
        boolean accessible = c.isAccessible();
        try {
            c.setAccessible(true);
            methodInstance = c.newInstance(new Object[0]);
        }
        finally {
            c.setAccessible(accessible);
        }
        return methodInstance;
    }

    protected Object invokeMethod(RegisteredMethod method, Object actionInstance, Object[] parameters) throws Exception {
        assert (method != null);
        assert (parameters != null);
        Method javaMethod = method.getMethod();
        return DispatcherBase.invokeJavaMethod(actionInstance, javaMethod, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Object invokeJavaMethod(Object instance, @NonNull Method method, @NonNull Object[] parameters) throws Exception {
        boolean accessible = method.isAccessible();
        MethodVisibilityModifier visibilityModifier = new MethodVisibilityModifier(method);
        try {
            visibilityModifier.setAccessible(true);
            AccessController.doPrivileged(visibilityModifier);
            Object object = method.invoke(instance, parameters);
            return object;
        }
        finally {
            visibilityModifier.setAccessible(accessible);
            AccessController.doPrivileged(visibilityModifier);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodVisibilityModifier
    implements PrivilegedAction<Object> {
        private boolean accessible;
        @NonNull
        private Method method;

        public MethodVisibilityModifier(@NonNull Method method) {
            assert (method != null);
            this.method = method;
        }

        @Override
        public Object run() {
            this.method.setAccessible(this.accessible);
            return null;
        }

        public void setAccessible(boolean accessible) {
            this.accessible = accessible;
        }
    }
}

