/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.jscodegen;

import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.Timer;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class Minifier {
    @NonNull
    private static final Logger logger = Logger.getLogger(Minifier.class);

    private Minifier() {
    }

    public static String getMinifiedFileName(String file) {
        assert (!StringUtils.isEmpty(file));
        String result = file.replace(".js", "-min.js");
        return result;
    }

    @CheckForNull
    public static final String minify(String input, String inputFilename, int debugCodeLength) {
        assert (input != null);
        assert (!StringUtils.isEmpty(inputFilename));
        assert (debugCodeLength > 0);
        try {
            Timer timer = new Timer();
            StringReader in = new StringReader(input);
            JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)in, new ErrorReporter(){

                public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    if (line < 0) {
                        logger.warn((Object)("Minifier Warning: " + message));
                    } else {
                        logger.warn((Object)("Minifier Warning, " + line + ':' + lineOffset + ':' + message));
                    }
                }

                public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    if (line < 0) {
                        logger.warn((Object)("Minifier Error: " + message));
                    } else {
                        logger.warn((Object)("Minifier Error, " + line + ':' + lineOffset + ':' + message));
                    }
                }

                public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    this.error(message, sourceName, line, lineSource, lineOffset);
                    return new EvaluatorException(message);
                }
            });
            ((Reader)in).close();
            try {
                StringWriter out = new StringWriter();
                boolean munge = true;
                boolean preserveAllSemiColons = false;
                boolean disableOptimizations = false;
                boolean verbose = false;
                int linebreakpos = 0;
                compressor.compress((Writer)out, linebreakpos, munge, verbose, preserveAllSemiColons, disableOptimizations);
                ((Writer)out).close();
                String result = ((Object)out).toString();
                if (logger.isDebugEnabled()) {
                    timer.stop();
                    int compressionPercentage = 100 - result.length() * 100 / debugCodeLength;
                    timer.logDebugTimeInMilliseconds("Finished minification for '" + inputFilename + "'. Debug code length: " + debugCodeLength + ", Minified length: " + result.length() + ", Compression: " + compressionPercentage + "%. Time");
                }
                return result;
            }
            catch (UnsupportedEncodingException e) {
                logger.warn((Object)("Unable to minify '" + inputFilename + "'."), (Throwable)e);
                return null;
            }
        }
        catch (IOException e) {
            logger.warn((Object)("Unable to minify '" + inputFilename + "' due to an IOException."), (Throwable)e);
            return null;
        }
        catch (EvaluatorException e) {
            logger.warn((Object)("Unable to minify '" + inputFilename + "' due to a problem with the Javascript evaluator."), (Throwable)e);
            return null;
        }
    }
}

